/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl;

import com.sap.jvm.inspector.InspectorInfo;
import com.sap.jvm.inspector.filesocket.FileSocketConnection;
import com.sap.jvm.inspector.filesocket.remote.RemoteFileSocketConnection;
import com.sap.jvm.profiling.ConnectionListener;
import com.sap.jvm.profiling.SocketConnection;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.exception.UnsupportedVersionException;
import com.sap.jvm.profiling.exception.WriteFailedException;
import com.sap.jvm.profiling.impl.CommandHandlerImpl;
import com.sap.jvm.profiling.impl.control.command.FlushCommandImpl;
import com.sap.jvm.profiling.impl.control.command.StartProfilingCommandImpl;
import com.sap.jvm.util.misc.SocketAdapter;
import com.sap.jvm.util.misc.SocketAdapterFactory;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;

public final class SocketConnectionImpl
extends InputStream
implements SocketConnection {
    private static int CONNECTION_TIMEOUT_MS = AccessController.doPrivileged(new PrivilegedAction<Integer>(){

        @Override
        public Integer run() {
            int result = 10000;
            String timeoutStr = System.getProperty("com.sap.jvm.profiling.vmexplorer.connectionTimeout");
            if (timeoutStr != null) {
                try {
                    result = Integer.parseInt(timeoutStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return result;
        }
    });
    private static final int PLAIN_FILE_ENCODING = 2;
    private ArrayList<ConnectionListener> listeners;
    private SocketAdapter socket;
    private boolean isOpen;
    private InputStream inputStream;
    private OutputStream outputStream;
    private OutputStream backupOutputStream;
    private long writtenBackupBytes;
    private String backupFileName;
    private ProfilingVersion version;
    private byte[] failedBytes;
    private byte[] singleByteBuffer = new byte[1];

    public SocketConnectionImpl(SocketAdapter socket, String backupFileName) throws IOException {
        this.socket = socket;
        this.initConnection(backupFileName);
    }

    public static SocketAdapter createJvmmondSocketConnection(String hostname, int pid, int daemonPort) throws IOException {
        SocketAdapter result = null;
        if (hostname == null || daemonPort < 0) {
            throw new IOException("Illegal arguments: hostname=" + hostname + ", daemonPort=" + daemonPort);
        }
        try {
            Registry registry = LocateRegistry.getRegistry(hostname, daemonPort);
            RemoteFileSocketConnection remoteFileSocketServer = (RemoteFileSocketConnection)registry.lookup("RemoteProfilingConnection");
            int timeoutFrac = CONNECTION_TIMEOUT_MS / 2;
            int serverPort = remoteFileSocketServer.createFileSocketConnection(pid, timeoutFrac);
            if (serverPort < 0) {
                throw new IOException("is jvmmond still running ?");
            }
            Socket clientSocket = new Socket();
            clientSocket.connect(new InetSocketAddress(hostname, serverPort), timeoutFrac);
            result = SocketAdapterFactory.getForSocket(clientSocket);
        }
        catch (RemoteException re) {
            throw new IOException(re.getMessage());
        }
        catch (NotBoundException nbe) {
            throw new IOException(nbe.getMessage());
        }
        return result;
    }

    public static SocketAdapter createFileSocketConnection(int pid, String socketIdentifier) throws IOException {
        String id = socketIdentifier;
        if (id == null) {
            id = InspectorInfo.getProfilingServerIdentifier(pid);
        }
        return FileSocketConnection.connectToSocket(id, CONNECTION_TIMEOUT_MS);
    }

    private void initConnection(String backupFileName) throws IOException {
        this.inputStream = this.socket.getInputStream();
        this.outputStream = this.socket.getOutputStream();
        this.isOpen = true;
        this.listeners = new ArrayList();
        this.backupFileName = backupFileName;
        this.failedBytes = null;
        if (backupFileName != null) {
            this.backupOutputStream = new BufferedOutputStream(new FileOutputStream(backupFileName));
        }
        this.startProfiling();
    }

    @Override
    public synchronized void close() throws IOException {
        if (!this.isOpen) {
            return;
        }
        try {
            for (ConnectionListener element : this.listeners) {
                element.closing();
            }
            this.inputStream.close();
            this.outputStream.close();
            if (this.socket != null) {
                this.socket.close();
            }
        }
        finally {
            this.isOpen = false;
        }
        if (this.backupOutputStream != null) {
            this.backupOutputStream.close();
        }
        for (ConnectionListener element : this.listeners) {
            element.closed();
        }
    }

    @Override
    public boolean isOpen() {
        return this.isOpen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] packet) throws IOException {
        OutputStream outputStream = this.outputStream;
        synchronized (outputStream) {
            this.outputStream.write(packet);
            this.outputStream.flush();
        }
    }

    @Override
    public void writeProfilingPacket(byte[] profilingPacket) throws IOException {
        this.write(profilingPacket);
    }

    @Override
    public void addListener(ConnectionListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void flushBackupFile() throws IOException {
        if (this.backupOutputStream != null) {
            this.backupOutputStream.flush();
        }
    }

    @Override
    public long getBackupFileLength() {
        if (this.backupOutputStream == null) {
            return 0L;
        }
        return this.writtenBackupBytes;
    }

    @Override
    public String getBackupFileName() {
        return this.backupFileName;
    }

    @Override
    public ProfilingVersion getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startProfiling() throws IOException {
        DataInputStream dis = new DataInputStream(this.inputStream);
        int profilingServerMajorVersion = dis.readUnsignedShort();
        int profilingServerMinorVersion = dis.readUnsignedShort();
        if (profilingServerMajorVersion != 1) {
            ProfilingVersion profilingServerVersion = new ProfilingVersion(profilingServerMajorVersion, profilingServerMinorVersion, 0);
            throw new UnsupportedVersionException("Profiling Server Version is not supported: " + profilingServerMajorVersion, profilingServerVersion);
        }
        OutputStream profilingServerVersion = this.outputStream;
        synchronized (profilingServerVersion) {
            CommandHandlerImpl commandHandler = new CommandHandlerImpl(this);
            StartProfilingCommandImpl startCommand = new StartProfilingCommandImpl();
            commandHandler.sendCommand(startCommand);
            FlushCommandImpl flushCommand = new FlushCommandImpl();
            commandHandler.sendCommand(flushCommand);
        }
        int majorVersion = dis.readUnsignedShort();
        int minorVersion = dis.readUnsignedShort();
        int microVersion = dis.readUnsignedShort();
        this.version = new ProfilingVersion(majorVersion, minorVersion, microVersion);
        if (this.version == null) {
            throw new IOException("No version information available.");
        }
        if (!this.version.isCompatible(1, 6, 0)) {
            throw new UnsupportedVersionException("Version is not supported: " + this.version.toString(), this.version);
        }
    }

    private void backupBytes(byte[] bytes, int off, int len) throws WriteFailedException {
        if (this.backupOutputStream == null) {
            return;
        }
        try {
            if (this.writtenBackupBytes == 0L) {
                this.backupOutputStream.write(2);
                ++this.writtenBackupBytes;
            }
            this.backupOutputStream.write(bytes, off, len);
            this.writtenBackupBytes += (long)len;
        }
        catch (IOException ex) {
            if (bytes != this.failedBytes) {
                this.failedBytes = new byte[len];
                System.arraycopy(bytes, off, this.failedBytes, 0, len);
            }
            throw new WriteFailedException("Write operation to profiling backup file failed.", ex);
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int num_read;
        if (this.failedBytes != null) {
            this.backupBytes(this.failedBytes, 0, this.failedBytes.length);
            this.failedBytes = null;
        }
        if ((num_read = this.inputStream.read(b, off, len)) > 0) {
            this.backupBytes(b, off, num_read);
        }
        return num_read == 0 ? -1 : num_read;
    }

    @Override
    public int read() throws IOException {
        return this.read(this.singleByteBuffer, 0, this.singleByteBuffer.length);
    }

    @Override
    public InputStream getProfilingInputStream() {
        return this;
    }
}

