/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.alert.event;

import com.sap.jvm.profiling.alert.event.AlertEventBase;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.EOFException;
import java.io.IOException;

public abstract class AlertEventBaseImpl
extends ProfilingPacketImpl
implements AlertEventBase {
    private final short packetTag;
    private final long timeStamp;
    private final long id;

    protected AlertEventBaseImpl(ResourceReader reader, short profilingEventErrorOccuredTag, long id) throws EOFException {
        this.packetTag = profilingEventErrorOccuredTag;
        this.timeStamp = reader.readInt64();
        this.id = id > 0L ? id : reader.readInt64();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALERT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.formatln("package tag " + this.packetTag, new Object[0]);
        stream.formatln("Timestamp             : %*t", this.timeStamp);
        stream.formatln("ID                    : " + this.id, new Object[0]);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        this.writeWithoutFinalizer(writer);
        writer.finalizePacket();
    }

    public void writeWithoutFinalizer(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.packetTag);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.id);
    }
}

