/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.alert.event;

import com.sap.jvm.profiling.alert.event.AlertEventWithExceptionStack;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.alert.event.AlertEventBaseImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class AlertEventImpl
extends AlertEventBaseImpl
implements AlertEventWithExceptionStack {
    private final char threadIndex;
    private final NonArrayClassObjectImpl exceptionClass;
    private final int throwStackTraceIndex;
    private final int exceptionStackTraceIndex;
    private final UTF8String message;
    private final UTF8String emptyString;
    private final int nrOfCauses;
    private final NonArrayClassObjectImpl[] causeClasses;
    private final int[] causeStackTraceIndices;
    private final UTF8String[] causeMessages;

    protected AlertEventImpl(ResourceReader reader, short profilingEventErrorOccuredTag, long id) throws IOException {
        super(reader, profilingEventErrorOccuredTag, id);
        this.threadIndex = reader.readUint16();
        this.throwStackTraceIndex = reader.readStackTraceIndex();
        this.exceptionClass = (NonArrayClassObjectImpl)reader.readClassObject();
        this.message = reader.readUTF();
        this.exceptionStackTraceIndex = reader.readStackTraceIndex();
        this.nrOfCauses = reader.readInt8();
        this.emptyString = reader.getSession().getStringManager().getEmptyString();
        if (this.nrOfCauses == 0) {
            this.causeClasses = null;
            this.causeMessages = null;
            this.causeStackTraceIndices = null;
        } else {
            this.causeClasses = new NonArrayClassObjectImpl[this.nrOfCauses];
            this.causeMessages = new UTF8String[this.nrOfCauses];
            this.causeStackTraceIndices = new int[this.nrOfCauses];
            for (int i = 0; i < this.nrOfCauses; ++i) {
                this.causeClasses[i] = (NonArrayClassObjectImpl)reader.readClassObject();
                this.causeMessages[i] = reader.readUTF();
                this.causeStackTraceIndices[i] = reader.readStackTraceIndex();
            }
        }
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getThrowStackTraceIndex() {
        return this.throwStackTraceIndex;
    }

    @Override
    public ClassObject getExceptionClass() {
        return this.exceptionClass;
    }

    @Override
    public UTF8String getExceptionMessage() {
        return this.message;
    }

    @Override
    public int getExceptionStackTraceIndex() {
        return this.exceptionStackTraceIndex;
    }

    @Override
    public int getNrOfCauses() {
        return this.causeClasses == null ? 0 : this.causeClasses.length;
    }

    @Override
    public ClassObject getCauseClass(int index) {
        return this.causeClasses[index];
    }

    @Override
    public UTF8String getCauseMessage(int index) {
        if (this.causeMessages == null) {
            return this.emptyString;
        }
        return this.causeMessages[index];
    }

    @Override
    public int getCauseStackTraceIndex(int index) {
        return this.causeStackTraceIndices[index];
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        super.print(stream);
        stream.formatln("Thread                : %*T", Character.valueOf(this.threadIndex));
        stream.formatln("Exception             : %*C", this.exceptionClass);
        stream.formatln("Message               : %s", this.message.toString());
        if (this.throwStackTraceIndex == this.exceptionStackTraceIndex) {
            stream.formatln("Stack trace           : %*S", this.exceptionStackTraceIndex);
        } else {
            stream.formatln("Throw Stack trace     : %*S", this.exceptionStackTraceIndex);
            stream.formatln("Exception Stack trace : %*S", this.exceptionStackTraceIndex);
        }
        for (int i = 0; i < this.getNrOfCauses(); ++i) {
            stream.formatln("  Caused by", new Object[0]);
            stream.formatln("    Exception         : %*C", this.causeClasses[i]);
            stream.formatln("    Message           : %s", this.causeMessages[i].toString());
            stream.formatln("    Stack trace       : %*S", this.causeStackTraceIndices[i]);
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.writeWithoutFinalizer(writer);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.throwStackTraceIndex);
        writer.writeClassObject(this.exceptionClass);
        writer.writeUTF(this.message);
        writer.writeInt32(this.exceptionStackTraceIndex);
        writer.writeInt8(this.nrOfCauses);
        if (this.nrOfCauses != 0) {
            for (int i = 0; i < this.nrOfCauses; ++i) {
                writer.writeClassObject(this.causeClasses[i]);
                writer.writeUTF(this.causeMessages[i]);
                writer.writeInt32(this.causeStackTraceIndices[i]);
            }
        }
        writer.finalizePacket();
    }
}

