/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.alert.event;

import com.sap.jvm.profiling.alert.event.ProfilingBaseEvent;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class ProfilingBaseEventImpl
extends ProfilingPacketImpl
implements ProfilingBaseEvent {
    private final short packetTag;
    private final long timeStamp;
    private final long id;
    private final short bufferBaseTyp;
    private final int stackTraceId;
    private final char threadIndex;
    private final UTF8String bufferBaseInformation;
    private final long profilingSessionId;
    private final boolean replayedEvent;

    protected ProfilingBaseEventImpl(ResourceReader reader, short packetTag, long id) throws IOException {
        this.packetTag = packetTag;
        this.timeStamp = reader.readInt64();
        this.profilingSessionId = reader.readInt64();
        this.id = id > 0L ? id : reader.readInt64();
        this.bufferBaseTyp = reader.readInt16();
        this.bufferBaseInformation = reader.readUTF();
        this.threadIndex = reader.readUint16();
        this.stackTraceId = reader.readStackTraceIndex();
        this.replayedEvent = reader.readBoolean();
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getStackTraceIndex() {
        return this.stackTraceId;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public short getOutputBufferTyp() {
        return this.bufferBaseTyp;
    }

    @Override
    public UTF8String getClientIdentifier() {
        return this.bufferBaseInformation;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALERT_EVENT;
    }

    public boolean wasSessionAlreadyActive() {
        return this.replayedEvent;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp              : %*t", this.timeStamp * 1000L);
        stream.formatln("SessionID              : " + this.profilingSessionId, new Object[0]);
        stream.formatln("ID                     : " + this.id, new Object[0]);
        stream.formatln("Buffer base typ        : " + this.bufferBaseTyp, new Object[0]);
        stream.formatln("Buffer base information: " + this.bufferBaseInformation, new Object[0]);
        stream.formatln("Thread                 : " + this.getStackTraceIndex(), new Object[0]);
        stream.formatln("Stack Trace ID         : %*T", Character.valueOf(this.getThreadIndex()));
        stream.formatln("Replayed               : " + this.wasSessionAlreadyActive(), new Object[0]);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.packetTag);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.profilingSessionId);
        writer.writeInt64(this.id);
        writer.writeInt16(this.bufferBaseTyp);
        writer.writeUTF(this.bufferBaseInformation);
        writer.writeInt32(this.stackTraceId);
        writer.writeUint16(this.threadIndex);
        writer.writeBoolean(this.replayedEvent);
        writer.finalizePacket();
    }

    @Override
    public long getSessionId() {
        return this.profilingSessionId;
    }
}

