/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.alert.event;

import com.sap.jvm.profiling.alert.event.AlertEventHandler;
import com.sap.jvm.profiling.alert.event.StorableAlert;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class StorableAlertImpl
extends ProfilingPacketImpl
implements StorableAlert {
    private static String[] severitiesToString = new String[]{"<unknown severity>", "DEBUG", "INFO", "WARNING", "ERROR"};
    private static int[] severities = new int[]{3, 4, 3, 4, 2, 2, 2, 2, 4, 2, 4, 4, 3, 3, 3, 3, 4, -1};
    private static String[] descriptions = new String[]{I18n._s("Spurious wakeup"), I18n._s("OutOfMemoryError"), I18n._s("Thread.stop()"), I18n._s("StackOverflowError"), I18n._s("Profiling started"), I18n._s("Profiling stopped"), I18n._s("Debugging started"), I18n._s("Debugging stopped"), I18n._s("Rainy Day Fund used"), I18n._s("UnsatisfiedLinkError"), I18n._s("Java assert"), I18n._s("InternalError"), I18n._s("JIT stopped"), I18n._s("JIT restarted"), I18n._s("Code cache flushing"), I18n._s("Code cache is full"), I18n._s("Native thread creation failed"), I18n._s("<invalid alert type>")};
    private static String[] toolTips = new String[]{I18n._s("Spurious wakeup from Object.wait() occurred"), I18n._s("OutOfMemoryError was thrown by the VM"), I18n._s("Thread.stop() was called"), I18n._s("StackOverflowError was thrown by the VM"), I18n._s("Profiling was started"), I18n._s("Profiling was stopped"), I18n._s("Debugging was started"), I18n._s("Debugging was stopped"), I18n._s("The Rainy Day Fund was used"), I18n._s("An UnsatisfiedLinkError occurred"), I18n._s("A Java assertion was triggered"), I18n._s("An InternalError was thrown"), I18n._s("The JIT Compiler was stopped"), I18n._s("The JIT Compiler was restarted"), I18n._s("Code cache flushing was initiated"), I18n._s("The Code cache was full"), I18n._s("Native thread creation failed"), I18n._s("<invalid alert type>")};
    private final long timeStamp;
    private final long id;
    private final int alertType;
    private final String message;

    public static StorableAlertImpl read(ResourceReader reader, AlertEventHandler[] handlers, PacketResourceWriter writer, long id) throws IOException {
        StorableAlertImpl event = new StorableAlertImpl(reader, id);
        for (AlertEventHandler handler : handlers) {
            handler.handle(event);
        }
        if (writer != null) {
            event.write(writer);
        }
        return event;
    }

    private StorableAlertImpl(ResourceReader reader, long suggestedId) throws IOException {
        this.timeStamp = reader.readInt64();
        long readId = reader.readInt64();
        this.id = readId != -1L ? readId : suggestedId;
        this.alertType = reader.readInt32();
        this.message = reader.readString();
    }

    @Override
    public String getPacketName() {
        return "storable alert event";
    }

    @Override
    public int getAlertType() {
        return this.alertType;
    }

    public static int getSeverityForType(int type) {
        if (type >= severities.length) {
            return 0;
        }
        return severities[type];
    }

    @Override
    public int getSeverity() {
        return StorableAlertImpl.getSeverityForType(this.alertType);
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public static String getDescriptionForType(int type) {
        if (type >= descriptions.length) {
            return "<unknown alert type>";
        }
        return descriptions[type];
    }

    public static String getToolTipForType(int type) {
        if (type >= toolTips.length) {
            return "<unknown alert type>";
        }
        return toolTips[type];
    }

    @Override
    public String getDescription() {
        return StorableAlertImpl.getDescriptionForType(this.alertType);
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Type                  : %s", this.getDescription());
        stream.formatln("Severity              : %s", severitiesToString[this.getSeverity()]);
        stream.formatln("Timestamp             : %*A", this.timeStamp);
        stream.formatln("Id                    : %d", this.id);
        stream.formatln("Message               : %s", this.getMessage());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)760);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.id);
        writer.writeInt32(this.alertType);
        writer.writeString(this.message);
        writer.finalizePacket();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALERT_EVENT;
    }
}

