/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.alert.event;

import com.sap.jvm.profiling.alert.event.TraceEventBase;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class TraceEventBaseImpl
extends ProfilingPacketImpl
implements TraceEventBase {
    private final short packetTag;
    private final long timeStamp;
    private final long id;
    private final char threadIndex;
    private final UTF8String message;
    private final int stackTraceId;

    protected TraceEventBaseImpl(ResourceReader reader, short packetTag, long id) throws IOException {
        this.packetTag = packetTag;
        this.timeStamp = reader.readInt64();
        this.id = id > 0L ? id : reader.readInt64();
        this.threadIndex = reader.readUint16();
        this.stackTraceId = reader.readStackTraceIndex();
        this.message = reader.readUTF();
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ALERT_EVENT;
    }

    @Override
    public UTF8String getMessage() {
        return this.message;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getStackTraceIndex() {
        return this.stackTraceId;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp             : %*t", this.timeStamp * 1000L);
        stream.formatln("ID                    : " + this.id, new Object[0]);
        stream.formatln("Thread                : " + this.getStackTraceIndex(), new Object[0]);
        stream.formatln("Stack Trace ID        : %*T", Character.valueOf(this.getThreadIndex()));
        stream.formatln("Message               : %s", this.message.toString());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket(this.packetTag);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.id);
        writer.writeInt32(this.stackTraceId);
        writer.writeUint16(this.threadIndex);
        writer.writeUTF(this.message);
        writer.finalizePacket();
    }
}

