/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.control.response;

import com.sap.jvm.profiling.control.response.ProfilingTraceInfoResponse;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.command.ProfilingSessionType;
import com.sap.jvm.profiling.impl.control.response.ResponsePacketReaderImpl;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public final class ProfilingTraceInfoResponseImpl
extends ResponseImpl
implements ProfilingTraceInfoResponse {
    private Map<ProfilingSessionType, Response[]> responses = new TreeMap<ProfilingSessionType, Response[]>();
    private Response[] myResponses = new Response[0];
    private List<ProfilingSessionResponses> rawResponses = new LinkedList<ProfilingSessionResponses>();

    @Override
    public Response[] getStartTraceResponses(ProfilingSessionType type) {
        return this.responses.get((Object)type);
    }

    @Override
    public Response[] getMyStartTraceResponses() {
        return this.myResponses;
    }

    public ProfilingTraceInfoResponseImpl(ResourceReader reader) throws IOException {
        super("Profiling trace info", reader);
        Response[] emptyResponse = new Response[]{};
        this.myResponses = emptyResponse;
        for (ProfilingSessionType sessionType : ProfilingSessionType.values()) {
            this.responses.put(sessionType, emptyResponse);
        }
        while (reader.hasNext()) {
            Response[] typesResponses;
            ProfilingSessionType sessionType;
            ProfilingSessionResponses rawSessionResponses = new ProfilingSessionResponses(reader);
            this.rawResponses.add(rawSessionResponses);
            try {
                sessionType = ProfilingSessionType.getProfilingTraceType(rawSessionResponses.controlType);
            }
            catch (IndexOutOfBoundsException e) {
                sessionType = ProfilingSessionType.TYPE_SILENCE_COMPILER;
            }
            Response[] startTraceResponses = new Response[rawSessionResponses.numberResponses];
            BufferedInputStream responseStream = new BufferedInputStream(new ByteArrayInputStream(rawSessionResponses.responseBytes));
            ResponsePacketReaderImpl responseReader = new ResponsePacketReaderImpl(responseStream, (AbstractProfilingSessionImpl)reader.getSession());
            for (int i = 0; i < rawSessionResponses.numberResponses; ++i) {
                ProfilingPacketImpl profilingPacket = responseReader.nextPacket();
                if (profilingPacket == null || !(profilingPacket instanceof Response)) continue;
                startTraceResponses[i] = (Response)((Object)profilingPacket);
            }
            if (rawSessionResponses.myConnection) {
                assert (this.myResponses == emptyResponse);
                this.myResponses = startTraceResponses;
            }
            if ((typesResponses = this.responses.get((Object)sessionType)) != null) {
                Response[] totalResponses = new Response[typesResponses.length + startTraceResponses.length];
                System.arraycopy(typesResponses, 0, totalResponses, 0, typesResponses.length);
                System.arraycopy(startTraceResponses, 0, totalResponses, typesResponses.length, startTraceResponses.length);
                startTraceResponses = totalResponses;
            }
            this.responses.put(sessionType, startTraceResponses);
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PROFILING_INFO_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1061);
        this.writeInternal(writer);
        for (ProfilingSessionResponses rawResponse : this.rawResponses) {
            rawResponse.write(writer);
        }
        writer.finalizePacket();
    }

    private class ProfilingSessionResponses {
        boolean myConnection;
        int controlType;
        int numberResponses;
        int totalResponsesSize;
        byte[] responseBytes = new byte[0];

        public ProfilingSessionResponses(ResourceReader reader) throws EOFException {
            this.myConnection = reader.readBoolean();
            this.controlType = reader.readUint8();
            this.numberResponses = reader.readInt32();
            this.totalResponsesSize = reader.readInt32();
            if (this.totalResponsesSize > 0) {
                this.responseBytes = new byte[this.totalResponsesSize];
                reader.readBytes(this.responseBytes);
            }
        }

        public void write(PacketResourceWriter writer) throws IOException {
            writer.writeBoolean(this.myConnection);
            writer.writeInt8(this.controlType);
            writer.writeInt32(this.numberResponses);
            writer.writeInt32(this.totalResponsesSize);
            writer.writeBytes(this.responseBytes);
        }
    }
}

