/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import java.util.HashMap;

public class JRubyBoundMethodOracleImpl {
    private HashMap<ClassName, HashMap<UTF8String, UTF8String[]>> boundMethods;
    private final MappingInformation mapInfo;

    public JRubyBoundMethodOracleImpl(MappingInformation mapInfo) {
        this.mapInfo = mapInfo;
        this.boundMethods = new HashMap();
        this.fillInBoundMethods();
    }

    public UTF8String[] getBoundMethods(ClassObject clazz, UTF8String methodName) {
        ClassName name = new ClassName(clazz);
        HashMap<UTF8String, UTF8String[]> mapping = this.boundMethods.get(name);
        if (mapping == null) {
            return null;
        }
        return mapping.get(methodName);
    }

    private void add(String method, String boundName) {
        UTF8String[] boundMethodNames;
        int pos = method.lastIndexOf(46);
        String classPart = method.substring(0, pos);
        UTF8String methodName = this.mapInfo.intern(method.substring(pos + 1, method.length()));
        pos = classPart.lastIndexOf(46);
        String packageName = pos > 0 ? classPart.substring(0, pos) : "";
        String name = pos > 0 ? classPart.substring(pos + 1, classPart.length()) : classPart;
        ClassName className = new ClassName(this.mapInfo.intern(packageName), this.mapInfo.intern(name));
        HashMap<UTF8String, Object> classMapping = this.boundMethods.get(className);
        if (classMapping == null) {
            classMapping = new HashMap();
            this.boundMethods.put(className, classMapping);
        }
        if ((boundMethodNames = classMapping.get(methodName)) == null) {
            boundMethodNames = new UTF8String[]{this.mapInfo.intern(boundName)};
            classMapping.put(methodName, boundMethodNames);
        } else {
            UTF8String[] newBoundMethods = new UTF8String[boundMethodNames.length + 1];
            System.arraycopy(boundMethodNames, 0, newBoundMethods, 1, boundMethodNames.length);
            newBoundMethods[0] = this.mapInfo.intern(boundName);
            classMapping.put(methodName, newBoundMethods);
        }
    }

    private void fillInBoundMethods() {
        this.add("org.jruby.JRubyApplet.RubyMethods.on_destroy", "on_destroy");
        this.add("org.jruby.JRubyApplet.RubyMethods.on_paint", "on_paint");
        this.add("org.jruby.JRubyApplet.RubyMethods.on_start", "on_start");
        this.add("org.jruby.JRubyApplet.RubyMethods.on_stop", "on_stop");
        this.add("org.jruby.NativeException.cause", "cause");
        this.add("org.jruby.RubyArgsFile.binmode", "binmode");
        this.add("org.jruby.RubyArgsFile.bytes", "bytes");
        this.add("org.jruby.RubyArgsFile.chars", "chars");
        this.add("org.jruby.RubyArgsFile.close", "close");
        this.add("org.jruby.RubyArgsFile.closed_p", "closed?");
        this.add("org.jruby.RubyArgsFile.each19", "each");
        this.add("org.jruby.RubyArgsFile.each_byte", "each_byte");
        this.add("org.jruby.RubyArgsFile.each_char", "each_char");
        this.add("org.jruby.RubyArgsFile.each_line", "each_line");
        this.add("org.jruby.RubyArgsFile.each_line19", "each_line");
        this.add("org.jruby.RubyArgsFile.eof", "eof");
        this.add("org.jruby.RubyArgsFile.eof_p", "eof?");
        this.add("org.jruby.RubyArgsFile.file", "file");
        this.add("org.jruby.RubyArgsFile.filename", "filename");
        this.add("org.jruby.RubyArgsFile.fileno", "fileno");
        this.add("org.jruby.RubyArgsFile.getc", "getc");
        this.add("org.jruby.RubyArgsFile.gets", "gets");
        this.add("org.jruby.RubyArgsFile.lineno", "lineno");
        this.add("org.jruby.RubyArgsFile.lineno_set", "lineno=");
        this.add("org.jruby.RubyArgsFile.op_binmode", "binmode?");
        this.add("org.jruby.RubyArgsFile.read", "read");
        this.add("org.jruby.RubyArgsFile.readchar", "readchar");
        this.add("org.jruby.RubyArgsFile.readline", "readline");
        this.add("org.jruby.RubyArgsFile.readlines", "readlines");
        this.add("org.jruby.RubyArgsFile.rewind", "rewind");
        this.add("org.jruby.RubyArgsFile.seek", "seek");
        this.add("org.jruby.RubyArgsFile.set_pos", "pos=");
        this.add("org.jruby.RubyArgsFile.skip", "skip");
        this.add("org.jruby.RubyArgsFile.tell", "tell");
        this.add("org.jruby.RubyArgsFile.to_a", "to_a");
        this.add("org.jruby.RubyArgsFile.to_io", "to_io");
        this.add("org.jruby.RubyArgsFile.to_s", "to_s");
        this.add("org.jruby.RubyArray.append", "<<");
        this.add("org.jruby.RubyArray.aref", "[]");
        this.add("org.jruby.RubyArray.aref19", "[]");
        this.add("org.jruby.RubyArray.aset", "[]=");
        this.add("org.jruby.RubyArray.aset19", "[]=");
        this.add("org.jruby.RubyArray.assoc", "assoc");
        this.add("org.jruby.RubyArray.at", "at");
        this.add("org.jruby.RubyArray.choice", "choice");
        this.add("org.jruby.RubyArray.collect", "collect");
        this.add("org.jruby.RubyArray.collect19", "collect");
        this.add("org.jruby.RubyArray.collect_bang", "collect!");
        this.add("org.jruby.RubyArray.combination", "combination");
        this.add("org.jruby.RubyArray.compact", "compact");
        this.add("org.jruby.RubyArray.compact_bang", "compact!");
        this.add("org.jruby.RubyArray.concat", "concat");
        this.add("org.jruby.RubyArray.concat19", "concat");
        this.add("org.jruby.RubyArray.count", "count");
        this.add("org.jruby.RubyArray.create", "[]");
        this.add("org.jruby.RubyArray.cycle", "cycle");
        this.add("org.jruby.RubyArray.delete", "delete");
        this.add("org.jruby.RubyArray.delete_at", "delete_at");
        this.add("org.jruby.RubyArray.delete_if", "delete_if");
        this.add("org.jruby.RubyArray.drop", "drop");
        this.add("org.jruby.RubyArray.drop_while", "drop_while");
        this.add("org.jruby.RubyArray.each", "each");
        this.add("org.jruby.RubyArray.each_index", "each_index");
        this.add("org.jruby.RubyArray.each_slice", "each_slice");
        this.add("org.jruby.RubyArray.empty_p", "empty?");
        this.add("org.jruby.RubyArray.eql", "eql?");
        this.add("org.jruby.RubyArray.fetch", "fetch");
        this.add("org.jruby.RubyArray.fill", "fill");
        this.add("org.jruby.RubyArray.first", "first");
        this.add("org.jruby.RubyArray.flatten", "flatten");
        this.add("org.jruby.RubyArray.flatten19", "flatten");
        this.add("org.jruby.RubyArray.flatten_bang", "flatten!");
        this.add("org.jruby.RubyArray.flatten_bang19", "flatten!");
        this.add("org.jruby.RubyArray.frozen_p", "frozen?");
        this.add("org.jruby.RubyArray.hash", "hash");
        this.add("org.jruby.RubyArray.hash19", "hash");
        this.add("org.jruby.RubyArray.include_p", "include?");
        this.add("org.jruby.RubyArray.index", "index");
        this.add("org.jruby.RubyArray.indexes", "indexes");
        this.add("org.jruby.RubyArray.initialize", "initialize");
        this.add("org.jruby.RubyArray.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyArray.insert", "insert");
        this.add("org.jruby.RubyArray.insert19", "insert");
        this.add("org.jruby.RubyArray.inspect", "inspect");
        this.add("org.jruby.RubyArray.join", "join");
        this.add("org.jruby.RubyArray.join19", "join");
        this.add("org.jruby.RubyArray.keep_if", "keep_if");
        this.add("org.jruby.RubyArray.last", "last");
        this.add("org.jruby.RubyArray.length", "length");
        this.add("org.jruby.RubyArray.map_bang", "map!");
        this.add("org.jruby.RubyArray.nitems", "nitems");
        this.add("org.jruby.RubyArray.op_and", "&");
        this.add("org.jruby.RubyArray.op_cmp", "<=>");
        this.add("org.jruby.RubyArray.op_diff", "-");
        this.add("org.jruby.RubyArray.op_equal", "==");
        this.add("org.jruby.RubyArray.op_or", "|");
        this.add("org.jruby.RubyArray.op_plus", "+");
        this.add("org.jruby.RubyArray.op_times", "*");
        this.add("org.jruby.RubyArray.op_times19", "*");
        this.add("org.jruby.RubyArray.pack", "pack");
        this.add("org.jruby.RubyArray.pack19", "pack");
        this.add("org.jruby.RubyArray.permutation", "permutation");
        this.add("org.jruby.RubyArray.pop", "pop");
        this.add("org.jruby.RubyArray.product", "product");
        this.add("org.jruby.RubyArray.product19", "product");
        this.add("org.jruby.RubyArray.push_m", "push");
        this.add("org.jruby.RubyArray.push_m19", "push");
        this.add("org.jruby.RubyArray.rassoc", "rassoc");
        this.add("org.jruby.RubyArray.rb_clear", "clear");
        this.add("org.jruby.RubyArray.reject", "reject");
        this.add("org.jruby.RubyArray.reject_bang", "reject!");
        this.add("org.jruby.RubyArray.repeatedCombination", "repeated_combination");
        this.add("org.jruby.RubyArray.repeated_permutation", "repeated_permutation");
        this.add("org.jruby.RubyArray.replace", "replace");
        this.add("org.jruby.RubyArray.reverse", "reverse");
        this.add("org.jruby.RubyArray.reverse_bang", "reverse!");
        this.add("org.jruby.RubyArray.reverse_each", "reverse_each");
        this.add("org.jruby.RubyArray.rindex", "rindex");
        this.add("org.jruby.RubyArray.rotate", "rotate");
        this.add("org.jruby.RubyArray.rotate_bang", "rotate!");
        this.add("org.jruby.RubyArray.sample", "sample");
        this.add("org.jruby.RubyArray.select", "select");
        this.add("org.jruby.RubyArray.select_bang", "select!");
        this.add("org.jruby.RubyArray.shift", "shift");
        this.add("org.jruby.RubyArray.shuffle", "shuffle");
        this.add("org.jruby.RubyArray.shuffle_bang", "shuffle!");
        this.add("org.jruby.RubyArray.slice_bang", "slice!");
        this.add("org.jruby.RubyArray.sort", "sort");
        this.add("org.jruby.RubyArray.sort19", "sort");
        this.add("org.jruby.RubyArray.sort_bang", "sort!");
        this.add("org.jruby.RubyArray.sort_bang19", "sort!");
        this.add("org.jruby.RubyArray.sort_by_bang", "sort_by!");
        this.add("org.jruby.RubyArray.take", "take");
        this.add("org.jruby.RubyArray.take_while", "take_while");
        this.add("org.jruby.RubyArray.to_a", "to_a");
        this.add("org.jruby.RubyArray.to_ary", "to_ary");
        this.add("org.jruby.RubyArray.to_s", "to_s");
        this.add("org.jruby.RubyArray.transpose", "transpose");
        this.add("org.jruby.RubyArray.try_convert", "try_convert");
        this.add("org.jruby.RubyArray.uniq", "uniq");
        this.add("org.jruby.RubyArray.uniq19", "uniq");
        this.add("org.jruby.RubyArray.uniq_bang", "uniq!");
        this.add("org.jruby.RubyArray.uniq_bang19", "uniq!");
        this.add("org.jruby.RubyArray.unshift", "unshift");
        this.add("org.jruby.RubyArray.unshift19", "unshift");
        this.add("org.jruby.RubyArray.values_at", "values_at");
        this.add("org.jruby.RubyArray.zip", "zip");
        this.add("org.jruby.RubyBasicObject.equal_p19", "equal?");
        this.add("org.jruby.RubyBasicObject.initialize19", "initialize");
        this.add("org.jruby.RubyBasicObject.instance_eval19", "instance_eval");
        this.add("org.jruby.RubyBasicObject.instance_exec19", "instance_exec");
        this.add("org.jruby.RubyBasicObject.method_missing19", "method_missing");
        this.add("org.jruby.RubyBasicObject.op_equal_19", "==");
        this.add("org.jruby.RubyBasicObject.op_not", "!");
        this.add("org.jruby.RubyBasicObject.op_not_equal", "!=");
        this.add("org.jruby.RubyBasicObject.send19", "__send__");
        this.add("org.jruby.RubyBasicObject.singleton_method_added19", "singleton_method_added");
        this.add("org.jruby.RubyBasicObject.singleton_method_removed19", "singleton_method_removed");
        this.add("org.jruby.RubyBasicObject.singleton_method_undefined19", "singleton_method_undefined");
        this.add("org.jruby.RubyBigDecimal.BigDecimalKernelMethods.newBigDecimal", "BigDecimal");
        this.add("org.jruby.RubyBigDecimal.abs", "abs");
        this.add("org.jruby.RubyBigDecimal.add2", "add");
        this.add("org.jruby.RubyBigDecimal.ceil", "ceil");
        this.add("org.jruby.RubyBigDecimal.ceil19", "ceil");
        this.add("org.jruby.RubyBigDecimal.coerce", "coerce");
        this.add("org.jruby.RubyBigDecimal.divmod", "divmod");
        this.add("org.jruby.RubyBigDecimal.divmod19", "divmod");
        this.add("org.jruby.RubyBigDecimal.double_fig", "double_fig");
        this.add("org.jruby.RubyBigDecimal.dump", "_dump");
        this.add("org.jruby.RubyBigDecimal.eql_p", "eql?");
        this.add("org.jruby.RubyBigDecimal.exponent", "exponent");
        this.add("org.jruby.RubyBigDecimal.finite_p", "finite?");
        this.add("org.jruby.RubyBigDecimal.fix", "fix");
        this.add("org.jruby.RubyBigDecimal.floor", "floor");
        this.add("org.jruby.RubyBigDecimal.floor19", "floor");
        this.add("org.jruby.RubyBigDecimal.frac", "frac");
        this.add("org.jruby.RubyBigDecimal.hash", "hash");
        this.add("org.jruby.RubyBigDecimal.induced_from", "induced_from");
        this.add("org.jruby.RubyBigDecimal.infinite_p", "infinite?");
        this.add("org.jruby.RubyBigDecimal.inspect", "inspect");
        this.add("org.jruby.RubyBigDecimal.limit", "limit");
        this.add("org.jruby.RubyBigDecimal.load", "_load");
        this.add("org.jruby.RubyBigDecimal.mode", "mode");
        this.add("org.jruby.RubyBigDecimal.mult2", "mult");
        this.add("org.jruby.RubyBigDecimal.nan_p", "nan?");
        this.add("org.jruby.RubyBigDecimal.newInstance", "new");
        this.add("org.jruby.RubyBigDecimal.nonzero_p", "nonzero?");
        this.add("org.jruby.RubyBigDecimal.op_cmp", "<=>");
        this.add("org.jruby.RubyBigDecimal.op_div", "div");
        this.add("org.jruby.RubyBigDecimal.op_div19", "div");
        this.add("org.jruby.RubyBigDecimal.op_ge", ">=");
        this.add("org.jruby.RubyBigDecimal.op_gt", ">");
        this.add("org.jruby.RubyBigDecimal.op_le", "<=");
        this.add("org.jruby.RubyBigDecimal.op_lt", "<");
        this.add("org.jruby.RubyBigDecimal.op_minus", "-");
        this.add("org.jruby.RubyBigDecimal.op_mod", "%");
        this.add("org.jruby.RubyBigDecimal.op_mul", "*");
        this.add("org.jruby.RubyBigDecimal.op_plus", "+");
        this.add("org.jruby.RubyBigDecimal.op_pow", "**");
        this.add("org.jruby.RubyBigDecimal.op_quo", "/");
        this.add("org.jruby.RubyBigDecimal.op_uminus", "-@");
        this.add("org.jruby.RubyBigDecimal.op_uplus", "+@");
        this.add("org.jruby.RubyBigDecimal.precs", "precs");
        this.add("org.jruby.RubyBigDecimal.remainder", "remainder");
        this.add("org.jruby.RubyBigDecimal.round", "round");
        this.add("org.jruby.RubyBigDecimal.sign", "sign");
        this.add("org.jruby.RubyBigDecimal.split", "split");
        this.add("org.jruby.RubyBigDecimal.sqrt", "sqrt");
        this.add("org.jruby.RubyBigDecimal.sub2", "sub");
        this.add("org.jruby.RubyBigDecimal.to_f", "to_f");
        this.add("org.jruby.RubyBigDecimal.to_int", "to_i");
        this.add("org.jruby.RubyBigDecimal.to_int19", "to_i");
        this.add("org.jruby.RubyBigDecimal.to_s", "to_s");
        this.add("org.jruby.RubyBigDecimal.truncate", "truncate");
        this.add("org.jruby.RubyBigDecimal.ver", "ver");
        this.add("org.jruby.RubyBigDecimal.zero_p", "zero?");
        this.add("org.jruby.RubyBignum.abs", "abs");
        this.add("org.jruby.RubyBignum.coerce", "coerce");
        this.add("org.jruby.RubyBignum.divmod", "divmod");
        this.add("org.jruby.RubyBignum.divmod19", "divmod");
        this.add("org.jruby.RubyBignum.eql_p", "eql?");
        this.add("org.jruby.RubyBignum.hash", "hash");
        this.add("org.jruby.RubyBignum.op_and", "&");
        this.add("org.jruby.RubyBignum.op_and19", "&");
        this.add("org.jruby.RubyBignum.op_aref", "[]");
        this.add("org.jruby.RubyBignum.op_cmp", "<=>");
        this.add("org.jruby.RubyBignum.op_div", "/");
        this.add("org.jruby.RubyBignum.op_equal", "==");
        this.add("org.jruby.RubyBignum.op_idiv", "div");
        this.add("org.jruby.RubyBignum.op_lshift", "<<");
        this.add("org.jruby.RubyBignum.op_minus", "-");
        this.add("org.jruby.RubyBignum.op_mod", "%");
        this.add("org.jruby.RubyBignum.op_mod19", "%");
        this.add("org.jruby.RubyBignum.op_mul", "*");
        this.add("org.jruby.RubyBignum.op_mul19", "*");
        this.add("org.jruby.RubyBignum.op_neg", "~");
        this.add("org.jruby.RubyBignum.op_or", "|");
        this.add("org.jruby.RubyBignum.op_or19", "|");
        this.add("org.jruby.RubyBignum.op_plus", "+");
        this.add("org.jruby.RubyBignum.op_pow", "**");
        this.add("org.jruby.RubyBignum.op_pow19", "**");
        this.add("org.jruby.RubyBignum.op_rshift", ">>");
        this.add("org.jruby.RubyBignum.op_uminus", "-@");
        this.add("org.jruby.RubyBignum.op_xor", "^");
        this.add("org.jruby.RubyBignum.op_xor19", "^");
        this.add("org.jruby.RubyBignum.quo", "quo");
        this.add("org.jruby.RubyBignum.quo19", "quo");
        this.add("org.jruby.RubyBignum.remainder", "remainder");
        this.add("org.jruby.RubyBignum.remainder19", "remainder");
        this.add("org.jruby.RubyBignum.size", "size");
        this.add("org.jruby.RubyBignum.to_f", "to_f");
        this.add("org.jruby.RubyBignum.to_s", "to_s");
        this.add("org.jruby.RubyBinding.eval", "eval");
        this.add("org.jruby.RubyBinding.initialize", "initialize");
        this.add("org.jruby.RubyBinding.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyBoolean.False.false_and", "&");
        this.add("org.jruby.RubyBoolean.False.false_or", "|");
        this.add("org.jruby.RubyBoolean.False.false_to_s", "to_s");
        this.add("org.jruby.RubyBoolean.False.false_xor", "^");
        this.add("org.jruby.RubyBoolean.True.true_and", "&");
        this.add("org.jruby.RubyBoolean.True.true_or", "|");
        this.add("org.jruby.RubyBoolean.True.true_to_s", "to_s");
        this.add("org.jruby.RubyBoolean.True.true_xor", "^");
        this.add("org.jruby.RubyClass.allocate", "allocate");
        this.add("org.jruby.RubyClass.inherited", "inherited");
        this.add("org.jruby.RubyClass.initialize", "initialize");
        this.add("org.jruby.RubyClass.initialize19", "initialize");
        this.add("org.jruby.RubyClass.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyClass.superclass", "superclass");
        this.add("org.jruby.RubyClassPathVariable.append", "append");
        this.add("org.jruby.RubyClassPathVariable.each", "each");
        this.add("org.jruby.RubyClassPathVariable.inspect", "inspect");
        this.add("org.jruby.RubyClassPathVariable.size", "size");
        this.add("org.jruby.RubyClassPathVariable.to_s", "to_s");
        this.add("org.jruby.RubyComparable.between_p", "between?");
        this.add("org.jruby.RubyComparable.op_equal", "==");
        this.add("org.jruby.RubyComparable.op_equal19", "==");
        this.add("org.jruby.RubyComparable.op_ge", ">=");
        this.add("org.jruby.RubyComparable.op_gt", ">");
        this.add("org.jruby.RubyComparable.op_le", "<=");
        this.add("org.jruby.RubyComparable.op_lt", "<");
        this.add("org.jruby.RubyComplex.abs", "abs");
        this.add("org.jruby.RubyComplex.abs2", "abs2");
        this.add("org.jruby.RubyComplex.arg", "arg");
        this.add("org.jruby.RubyComplex.coerce", "coerce");
        this.add("org.jruby.RubyComplex.conjugate", "conjugate");
        this.add("org.jruby.RubyComplex.convert", "convert");
        this.add("org.jruby.RubyComplex.demoninator", "denominator");
        this.add("org.jruby.RubyComplex.eql_p", "eql?");
        this.add("org.jruby.RubyComplex.fdiv", "fdiv");
        this.add("org.jruby.RubyComplex.hash", "hash");
        this.add("org.jruby.RubyComplex.image", "imaginary");
        this.add("org.jruby.RubyComplex.inspect", "inspect");
        this.add("org.jruby.RubyComplex.marshal_dump", "marshal_dump");
        this.add("org.jruby.RubyComplex.marshal_load", "marshal_load");
        this.add("org.jruby.RubyComplex.negate", "-@");
        this.add("org.jruby.RubyComplex.newInstance", "rect");
        this.add("org.jruby.RubyComplex.newInstanceBang", "new!");
        this.add("org.jruby.RubyComplex.numerator", "numerator");
        this.add("org.jruby.RubyComplex.op_add", "+");
        this.add("org.jruby.RubyComplex.op_div", "/");
        this.add("org.jruby.RubyComplex.op_equal", "==");
        this.add("org.jruby.RubyComplex.op_expt", "**");
        this.add("org.jruby.RubyComplex.op_mul", "*");
        this.add("org.jruby.RubyComplex.op_sub", "-");
        this.add("org.jruby.RubyComplex.polar", "polar");
        this.add("org.jruby.RubyComplex.polar19", "polar");
        this.add("org.jruby.RubyComplex.rationalize", "rationalize");
        this.add("org.jruby.RubyComplex.real", "real");
        this.add("org.jruby.RubyComplex.real_p", "real?");
        this.add("org.jruby.RubyComplex.rect", "rectangular");
        this.add("org.jruby.RubyComplex.to_f", "to_f");
        this.add("org.jruby.RubyComplex.to_i", "to_i");
        this.add("org.jruby.RubyComplex.to_r", "to_r");
        this.add("org.jruby.RubyComplex.to_s", "to_s");
        this.add("org.jruby.RubyContinuation.call", "call");
        this.add("org.jruby.RubyConverter.convpath", "convpath");
        this.add("org.jruby.RubyDigest.DigestBase.block_length", "block_length");
        this.add("org.jruby.RubyDigest.DigestBase.digest_length", "digest_length");
        this.add("org.jruby.RubyDigest.DigestBase.finish", "finish");
        this.add("org.jruby.RubyDigest.DigestBase.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyDigest.DigestBase.reset", "reset");
        this.add("org.jruby.RubyDigest.DigestBase.update", "update");
        this.add("org.jruby.RubyDigest.DigestClass.s_digest", "digest");
        this.add("org.jruby.RubyDigest.DigestClass.s_hexdigest", "hexdigest");
        this.add("org.jruby.RubyDigest.DigestInstance.block_length", "block_length");
        this.add("org.jruby.RubyDigest.DigestInstance.digest", "digest");
        this.add("org.jruby.RubyDigest.DigestInstance.digest_bang", "digest!");
        this.add("org.jruby.RubyDigest.DigestInstance.digest_length", "digest_length");
        this.add("org.jruby.RubyDigest.DigestInstance.finish", "finish");
        this.add("org.jruby.RubyDigest.DigestInstance.hexdigest", "hexdigest");
        this.add("org.jruby.RubyDigest.DigestInstance.hexdigest_bang", "hexdigest!");
        this.add("org.jruby.RubyDigest.DigestInstance.inspect", "inspect");
        this.add("org.jruby.RubyDigest.DigestInstance.length", "length");
        this.add("org.jruby.RubyDigest.DigestInstance.newObject", "new");
        this.add("org.jruby.RubyDigest.DigestInstance.op_equal", "==");
        this.add("org.jruby.RubyDigest.DigestInstance.reset", "reset");
        this.add("org.jruby.RubyDigest.DigestInstance.to_s", "to_s");
        this.add("org.jruby.RubyDigest.DigestInstance.update", "update");
        this.add("org.jruby.RubyDigest.s_hexencode", "hexencode");
        this.add("org.jruby.RubyDir.aref", "[]");
        this.add("org.jruby.RubyDir.chdir", "chdir");
        this.add("org.jruby.RubyDir.chroot", "chroot");
        this.add("org.jruby.RubyDir.close", "close");
        this.add("org.jruby.RubyDir.each19", "each");
        this.add("org.jruby.RubyDir.entries", "entries");
        this.add("org.jruby.RubyDir.entries19", "entries");
        this.add("org.jruby.RubyDir.exist", "exists?");
        this.add("org.jruby.RubyDir.foreach", "foreach");
        this.add("org.jruby.RubyDir.foreach19", "foreach");
        this.add("org.jruby.RubyDir.getwd", "getwd");
        this.add("org.jruby.RubyDir.glob", "glob");
        this.add("org.jruby.RubyDir.home", "home");
        this.add("org.jruby.RubyDir.initialize", "initialize");
        this.add("org.jruby.RubyDir.initialize19", "initialize");
        this.add("org.jruby.RubyDir.inspect", "inspect");
        this.add("org.jruby.RubyDir.mkdir", "mkdir");
        this.add("org.jruby.RubyDir.mkdir19", "mkdir");
        this.add("org.jruby.RubyDir.open", "open");
        this.add("org.jruby.RubyDir.open19", "open");
        this.add("org.jruby.RubyDir.path", "path");
        this.add("org.jruby.RubyDir.read", "read");
        this.add("org.jruby.RubyDir.rewind", "rewind");
        this.add("org.jruby.RubyDir.rmdir", "rmdir");
        this.add("org.jruby.RubyDir.rmdir19", "rmdir");
        this.add("org.jruby.RubyDir.seek", "seek");
        this.add("org.jruby.RubyDir.set_pos", "pos=");
        this.add("org.jruby.RubyDir.tell", "tell");
        this.add("org.jruby.RubyEncoding._dump", "_dump");
        this.add("org.jruby.RubyEncoding._load", "_load");
        this.add("org.jruby.RubyEncoding.aliases", "aliases");
        this.add("org.jruby.RubyEncoding.asciiCompatible_p", "ascii_compatible?");
        this.add("org.jruby.RubyEncoding.compatible_p", "compatible?");
        this.add("org.jruby.RubyEncoding.dummy_p", "dummy?");
        this.add("org.jruby.RubyEncoding.find", "find");
        this.add("org.jruby.RubyEncoding.getDefaultExternal", "default_external");
        this.add("org.jruby.RubyEncoding.getDefaultInternal", "default_internal");
        this.add("org.jruby.RubyEncoding.inspect", "inspect");
        this.add("org.jruby.RubyEncoding.list", "list");
        this.add("org.jruby.RubyEncoding.locale_charmap", "locale_charmap");
        this.add("org.jruby.RubyEncoding.name_list", "name_list");
        this.add("org.jruby.RubyEncoding.names", "names");
        this.add("org.jruby.RubyEncoding.setDefaultExternal", "default_external=");
        this.add("org.jruby.RubyEncoding.setDefaultInternal", "default_internal=");
        this.add("org.jruby.RubyEncoding.to_s", "to_s");
        this.add("org.jruby.RubyEnumerable.all_p", "all?");
        this.add("org.jruby.RubyEnumerable.any_p", "any?");
        this.add("org.jruby.RubyEnumerable.chunk", "chunk");
        this.add("org.jruby.RubyEnumerable.collect", "collect");
        this.add("org.jruby.RubyEnumerable.collect19", "collect");
        this.add("org.jruby.RubyEnumerable.collect_concat19", "collect_concat");
        this.add("org.jruby.RubyEnumerable.count", "count");
        this.add("org.jruby.RubyEnumerable.cycle", "cycle");
        this.add("org.jruby.RubyEnumerable.detect", "detect");
        this.add("org.jruby.RubyEnumerable.drop", "drop");
        this.add("org.jruby.RubyEnumerable.drop_while", "drop_while");
        this.add("org.jruby.RubyEnumerable.each_entry", "each_entry");
        this.add("org.jruby.RubyEnumerable.each_with", "each_with_object");
        this.add("org.jruby.RubyEnumerable.each_with_index", "each_with_index");
        this.add("org.jruby.RubyEnumerable.each_with_index19", "each_with_index");
        this.add("org.jruby.RubyEnumerable.enum_with_index", "enum_with_index");
        this.add("org.jruby.RubyEnumerable.find", "find");
        this.add("org.jruby.RubyEnumerable.find_all", "find_all");
        this.add("org.jruby.RubyEnumerable.find_index", "find_index");
        this.add("org.jruby.RubyEnumerable.first", "first");
        this.add("org.jruby.RubyEnumerable.flat_map19", "flat_map");
        this.add("org.jruby.RubyEnumerable.grep", "grep");
        this.add("org.jruby.RubyEnumerable.group_by", "group_by");
        this.add("org.jruby.RubyEnumerable.include_p", "include?");
        this.add("org.jruby.RubyEnumerable.inject", "inject");
        this.add("org.jruby.RubyEnumerable.join", "join");
        this.add("org.jruby.RubyEnumerable.map19", "map");
        this.add("org.jruby.RubyEnumerable.max", "max");
        this.add("org.jruby.RubyEnumerable.max_by", "max_by");
        this.add("org.jruby.RubyEnumerable.min", "min");
        this.add("org.jruby.RubyEnumerable.min_by", "min_by");
        this.add("org.jruby.RubyEnumerable.minmax", "minmax");
        this.add("org.jruby.RubyEnumerable.minmax_by", "minmax_by");
        this.add("org.jruby.RubyEnumerable.none_p", "none?");
        this.add("org.jruby.RubyEnumerable.one_p", "one?");
        this.add("org.jruby.RubyEnumerable.partition", "partition");
        this.add("org.jruby.RubyEnumerable.reject", "reject");
        this.add("org.jruby.RubyEnumerable.reverse_each", "reverse_each");
        this.add("org.jruby.RubyEnumerable.select", "select");
        this.add("org.jruby.RubyEnumerable.sort", "sort");
        this.add("org.jruby.RubyEnumerable.sort_by", "sort_by");
        this.add("org.jruby.RubyEnumerable.take", "take");
        this.add("org.jruby.RubyEnumerable.take_while", "take_while");
        this.add("org.jruby.RubyEnumerable.to_a", "to_a");
        this.add("org.jruby.RubyEnumerable.to_a19", "to_a");
        this.add("org.jruby.RubyEnumerable.zip", "zip");
        this.add("org.jruby.RubyEnumerable.zip19", "zip");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.each_cons19", "each_cons");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.each_slice19", "each_slice");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.each_with_object", "each_with_object");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.enum_cons19", "enum_cons");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.enum_slice19", "enum_slice");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorEnumerable.with_object", "with_object");
        this.add("org.jruby.RubyEnumerator.RubyEnumeratorKernel.obj_to_enum", "to_enum");
        this.add("org.jruby.RubyEnumerator.dup", "dup");
        this.add("org.jruby.RubyEnumerator.each", "each");
        this.add("org.jruby.RubyEnumerator.each_with_index", "each_with_index");
        this.add("org.jruby.RubyEnumerator.initialize", "initialize");
        this.add("org.jruby.RubyEnumerator.initialize19", "initialize");
        this.add("org.jruby.RubyEnumerator.inspect19", "inspect");
        this.add("org.jruby.RubyEnumerator.next", "next");
        this.add("org.jruby.RubyEnumerator.peek", "peek");
        this.add("org.jruby.RubyEnumerator.rewind", "rewind");
        this.add("org.jruby.RubyEnumerator.with_index", "with_index");
        this.add("org.jruby.RubyEnumerator.with_index19", "with_index");
        this.add("org.jruby.RubyEtc.endgrent", "endgrent");
        this.add("org.jruby.RubyEtc.endpwent", "endpwent");
        this.add("org.jruby.RubyEtc.getgrent", "getgrent");
        this.add("org.jruby.RubyEtc.getgrgid", "getgrgid");
        this.add("org.jruby.RubyEtc.getgrnam", "getgrnam");
        this.add("org.jruby.RubyEtc.getlogin", "getlogin");
        this.add("org.jruby.RubyEtc.getpwent", "getpwent");
        this.add("org.jruby.RubyEtc.getpwnam", "getpwnam");
        this.add("org.jruby.RubyEtc.getpwuid", "getpwuid");
        this.add("org.jruby.RubyEtc.group", "group");
        this.add("org.jruby.RubyEtc.passwd", "passwd");
        this.add("org.jruby.RubyEtc.setgrent", "setgrent");
        this.add("org.jruby.RubyEtc.setpwent", "setpwent");
        this.add("org.jruby.RubyException.backtrace", "backtrace");
        this.add("org.jruby.RubyException.exception", "exception");
        this.add("org.jruby.RubyException.initialize", "initialize");
        this.add("org.jruby.RubyException.inspect", "inspect");
        this.add("org.jruby.RubyException.message", "message");
        this.add("org.jruby.RubyException.op_eqq", "===");
        this.add("org.jruby.RubyException.op_equal", "==");
        this.add("org.jruby.RubyException.set_backtrace", "set_backtrace");
        this.add("org.jruby.RubyException.to_s", "to_s");
        this.add("org.jruby.RubyException.to_str", "to_str");
        this.add("org.jruby.RubyFile.absolute_path", "absolute_path");
        this.add("org.jruby.RubyFile.atime", "atime");
        this.add("org.jruby.RubyFile.basename", "basename");
        this.add("org.jruby.RubyFile.chmod", "chmod");
        this.add("org.jruby.RubyFile.chown", "chown");
        this.add("org.jruby.RubyFile.close", "close");
        this.add("org.jruby.RubyFile.ctime", "ctime");
        this.add("org.jruby.RubyFile.dirname", "dirname");
        this.add("org.jruby.RubyFile.expand_path", "expand_path");
        this.add("org.jruby.RubyFile.expand_path19", "expand_path");
        this.add("org.jruby.RubyFile.extname", "extname");
        this.add("org.jruby.RubyFile.flock", "flock");
        this.add("org.jruby.RubyFile.fnmatch", "fnmatch");
        this.add("org.jruby.RubyFile.ftype", "ftype");
        this.add("org.jruby.RubyFile.initialize", "initialize");
        this.add("org.jruby.RubyFile.initialize19", "initialize");
        this.add("org.jruby.RubyFile.inspect", "inspect");
        this.add("org.jruby.RubyFile.join", "join");
        this.add("org.jruby.RubyFile.lchmod", "lchmod");
        this.add("org.jruby.RubyFile.lchown", "lchown");
        this.add("org.jruby.RubyFile.link", "link");
        this.add("org.jruby.RubyFile.lstat", "lstat");
        this.add("org.jruby.RubyFile.mtime", "mtime");
        this.add("org.jruby.RubyFile.path", "path");
        this.add("org.jruby.RubyFile.readlink", "readlink");
        this.add("org.jruby.RubyFile.realdirpath", "realdirpath");
        this.add("org.jruby.RubyFile.realpath", "realpath");
        this.add("org.jruby.RubyFile.rename", "rename");
        this.add("org.jruby.RubyFile.size", "size");
        this.add("org.jruby.RubyFile.split", "split");
        this.add("org.jruby.RubyFile.stat", "stat");
        this.add("org.jruby.RubyFile.symlink", "symlink");
        this.add("org.jruby.RubyFile.truncate", "truncate");
        this.add("org.jruby.RubyFile.truncate19", "truncate");
        this.add("org.jruby.RubyFile.umask", "umask");
        this.add("org.jruby.RubyFile.unlink", "unlink");
        this.add("org.jruby.RubyFile.utime", "utime");
        this.add("org.jruby.RubyFileStat.atime", "atime");
        this.add("org.jruby.RubyFileStat.blksize", "blksize");
        this.add("org.jruby.RubyFileStat.blockdev_p", "blockdev?");
        this.add("org.jruby.RubyFileStat.blocks", "blocks");
        this.add("org.jruby.RubyFileStat.chardev_p", "chardev?");
        this.add("org.jruby.RubyFileStat.cmp", "<=>");
        this.add("org.jruby.RubyFileStat.ctime", "ctime");
        this.add("org.jruby.RubyFileStat.dev", "dev");
        this.add("org.jruby.RubyFileStat.devMajor", "dev_major");
        this.add("org.jruby.RubyFileStat.devMinor", "dev_minor");
        this.add("org.jruby.RubyFileStat.directory_p", "directory?");
        this.add("org.jruby.RubyFileStat.executableReal_p", "executable_real?");
        this.add("org.jruby.RubyFileStat.executable_p", "executable?");
        this.add("org.jruby.RubyFileStat.file_p", "file?");
        this.add("org.jruby.RubyFileStat.ftype", "ftype");
        this.add("org.jruby.RubyFileStat.gid", "gid");
        this.add("org.jruby.RubyFileStat.group_owned_p", "grpowned?");
        this.add("org.jruby.RubyFileStat.initialize", "initialize");
        this.add("org.jruby.RubyFileStat.initialize19", "initialize");
        this.add("org.jruby.RubyFileStat.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyFileStat.ino", "ino");
        this.add("org.jruby.RubyFileStat.inspect", "inspect");
        this.add("org.jruby.RubyFileStat.mode", "mode");
        this.add("org.jruby.RubyFileStat.mtime", "mtime");
        this.add("org.jruby.RubyFileStat.nlink", "nlink");
        this.add("org.jruby.RubyFileStat.owned_p", "owned?");
        this.add("org.jruby.RubyFileStat.pipe_p", "pipe?");
        this.add("org.jruby.RubyFileStat.rdev", "rdev");
        this.add("org.jruby.RubyFileStat.rdevMajor", "rdev_major");
        this.add("org.jruby.RubyFileStat.rdevMinor", "rdev_minor");
        this.add("org.jruby.RubyFileStat.readableReal_p", "readable_real?");
        this.add("org.jruby.RubyFileStat.readable_p", "readable?");
        this.add("org.jruby.RubyFileStat.setgid_p", "setgid?");
        this.add("org.jruby.RubyFileStat.setuid_p", "setuid?");
        this.add("org.jruby.RubyFileStat.size", "size");
        this.add("org.jruby.RubyFileStat.size_p", "size?");
        this.add("org.jruby.RubyFileStat.socket_p", "socket?");
        this.add("org.jruby.RubyFileStat.sticky_p", "sticky?");
        this.add("org.jruby.RubyFileStat.symlink_p", "symlink?");
        this.add("org.jruby.RubyFileStat.uid", "uid");
        this.add("org.jruby.RubyFileStat.worldReadable", "world_readable?");
        this.add("org.jruby.RubyFileStat.worldWritable", "world_writable?");
        this.add("org.jruby.RubyFileStat.writableReal_p", "writable_real?");
        this.add("org.jruby.RubyFileStat.writable_p", "writable?");
        this.add("org.jruby.RubyFileStat.zero_p", "zero?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.blockdev_p", "blockdev?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.chardev_p", "chardev?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.directory_p", "directory?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.executable_p", "executable?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.executable_real_p", "executable_real?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.exist_p", "exist?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.file_p", "file?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.grpowned_p", "grpowned?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.identical_p", "identical?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.owned_p", "owned?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.pipe_p", "pipe?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.readable_p", "readable?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.setgid_p", "setgid?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.setuid_p", "setuid?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.size", "size");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.size_p", "size?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.socket_p", "socket?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.sticky_p", "sticky?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.symlink_p", "symlink?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.worldReadable", "world_readable?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.worldWritable", "world_writable?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.writable_p", "writable?");
        this.add("org.jruby.RubyFileTest.FileTestFileMethods.zero_p", "zero?");
        this.add("org.jruby.RubyFileTest.blockdev_p", "blockdev?");
        this.add("org.jruby.RubyFileTest.chardev_p", "chardev?");
        this.add("org.jruby.RubyFileTest.directory_p", "directory?");
        this.add("org.jruby.RubyFileTest.executable_p", "executable?");
        this.add("org.jruby.RubyFileTest.executable_real_p", "executable_real?");
        this.add("org.jruby.RubyFileTest.exist_p", "exist?");
        this.add("org.jruby.RubyFileTest.file_p", "file?");
        this.add("org.jruby.RubyFileTest.grpowned_p", "grpowned?");
        this.add("org.jruby.RubyFileTest.identical_p", "identical?");
        this.add("org.jruby.RubyFileTest.owned_p", "owned?");
        this.add("org.jruby.RubyFileTest.pipe_p", "pipe?");
        this.add("org.jruby.RubyFileTest.readable_p", "readable?");
        this.add("org.jruby.RubyFileTest.setgid_p", "setgid?");
        this.add("org.jruby.RubyFileTest.setuid_p", "setuid?");
        this.add("org.jruby.RubyFileTest.size", "size");
        this.add("org.jruby.RubyFileTest.size_p", "size?");
        this.add("org.jruby.RubyFileTest.socket_p", "socket?");
        this.add("org.jruby.RubyFileTest.sticky_p", "sticky?");
        this.add("org.jruby.RubyFileTest.symlink_p", "symlink?");
        this.add("org.jruby.RubyFileTest.worldReadable", "world_readable?");
        this.add("org.jruby.RubyFileTest.worldWritable", "world_writable?");
        this.add("org.jruby.RubyFileTest.writable_p", "writable?");
        this.add("org.jruby.RubyFileTest.zero_p", "zero?");
        this.add("org.jruby.RubyFixnum.abs", "abs");
        this.add("org.jruby.RubyFixnum.div_div", "div");
        this.add("org.jruby.RubyFixnum.div_div19", "div");
        this.add("org.jruby.RubyFixnum.divmod", "divmod");
        this.add("org.jruby.RubyFixnum.divmod19", "divmod");
        this.add("org.jruby.RubyFixnum.even_p", "even?");
        this.add("org.jruby.RubyFixnum.id", "id");
        this.add("org.jruby.RubyFixnum.id2name", "id2name");
        this.add("org.jruby.RubyFixnum.induced_from", "induced_from");
        this.add("org.jruby.RubyFixnum.magnitude", "magnitude");
        this.add("org.jruby.RubyFixnum.odd_p", "odd?");
        this.add("org.jruby.RubyFixnum.op_and", "&");
        this.add("org.jruby.RubyFixnum.op_aref", "[]");
        this.add("org.jruby.RubyFixnum.op_cmp", "<=>");
        this.add("org.jruby.RubyFixnum.op_cmp19", "<=>");
        this.add("org.jruby.RubyFixnum.op_div", "/");
        this.add("org.jruby.RubyFixnum.op_equal", "==");
        this.add("org.jruby.RubyFixnum.op_equal19", "==");
        this.add("org.jruby.RubyFixnum.op_ge", ">=");
        this.add("org.jruby.RubyFixnum.op_ge19", ">=");
        this.add("org.jruby.RubyFixnum.op_gt", ">");
        this.add("org.jruby.RubyFixnum.op_gt19", ">");
        this.add("org.jruby.RubyFixnum.op_le", "<=");
        this.add("org.jruby.RubyFixnum.op_le19", "<=");
        this.add("org.jruby.RubyFixnum.op_lshift", "<<");
        this.add("org.jruby.RubyFixnum.op_lt", "<");
        this.add("org.jruby.RubyFixnum.op_lt19", "<");
        this.add("org.jruby.RubyFixnum.op_minus", "-");
        this.add("org.jruby.RubyFixnum.op_mod", "%");
        this.add("org.jruby.RubyFixnum.op_mod19", "%");
        this.add("org.jruby.RubyFixnum.op_mul", "*");
        this.add("org.jruby.RubyFixnum.op_neg", "~");
        this.add("org.jruby.RubyFixnum.op_or", "|");
        this.add("org.jruby.RubyFixnum.op_plus", "+");
        this.add("org.jruby.RubyFixnum.op_pow", "**");
        this.add("org.jruby.RubyFixnum.op_pow_19", "**");
        this.add("org.jruby.RubyFixnum.op_rshift", ">>");
        this.add("org.jruby.RubyFixnum.op_uminus", "-@");
        this.add("org.jruby.RubyFixnum.op_xor", "^");
        this.add("org.jruby.RubyFixnum.pred", "pred");
        this.add("org.jruby.RubyFixnum.quo", "quo");
        this.add("org.jruby.RubyFixnum.size", "size");
        this.add("org.jruby.RubyFixnum.times", "times");
        this.add("org.jruby.RubyFixnum.to_f", "to_f");
        this.add("org.jruby.RubyFixnum.to_s", "to_s");
        this.add("org.jruby.RubyFixnum.to_sym", "to_sym");
        this.add("org.jruby.RubyFixnum.zero_p", "zero?");
        this.add("org.jruby.RubyFloat.abs", "abs");
        this.add("org.jruby.RubyFloat.ceil", "ceil");
        this.add("org.jruby.RubyFloat.coerce", "coerce");
        this.add("org.jruby.RubyFloat.denominator", "denominator");
        this.add("org.jruby.RubyFloat.divmod", "divmod");
        this.add("org.jruby.RubyFloat.divmod19", "divmod");
        this.add("org.jruby.RubyFloat.eql_p", "eql?");
        this.add("org.jruby.RubyFloat.finite_p", "finite?");
        this.add("org.jruby.RubyFloat.floor", "floor");
        this.add("org.jruby.RubyFloat.hash", "hash");
        this.add("org.jruby.RubyFloat.induced_from", "induced_from");
        this.add("org.jruby.RubyFloat.infinite_p", "infinite?");
        this.add("org.jruby.RubyFloat.magnitude", "magnitude");
        this.add("org.jruby.RubyFloat.magnitude", "quo");
        this.add("org.jruby.RubyFloat.nan_p", "nan?");
        this.add("org.jruby.RubyFloat.numerator", "numerator");
        this.add("org.jruby.RubyFloat.op_cmp", "<=>");
        this.add("org.jruby.RubyFloat.op_equal", "==");
        this.add("org.jruby.RubyFloat.op_fdiv", "/");
        this.add("org.jruby.RubyFloat.op_ge", ">=");
        this.add("org.jruby.RubyFloat.op_gt", ">");
        this.add("org.jruby.RubyFloat.op_le", "<=");
        this.add("org.jruby.RubyFloat.op_lt", "<");
        this.add("org.jruby.RubyFloat.op_minus", "-");
        this.add("org.jruby.RubyFloat.op_mod", "%");
        this.add("org.jruby.RubyFloat.op_mod19", "%");
        this.add("org.jruby.RubyFloat.op_mul", "*");
        this.add("org.jruby.RubyFloat.op_plus", "+");
        this.add("org.jruby.RubyFloat.op_pow", "**");
        this.add("org.jruby.RubyFloat.op_pow19", "**");
        this.add("org.jruby.RubyFloat.op_uminus", "-@");
        this.add("org.jruby.RubyFloat.rationalize", "rationalize");
        this.add("org.jruby.RubyFloat.round", "round");
        this.add("org.jruby.RubyFloat.to_f", "to_f");
        this.add("org.jruby.RubyFloat.to_r", "to_r");
        this.add("org.jruby.RubyFloat.to_s", "to_s");
        this.add("org.jruby.RubyFloat.truncate", "truncate");
        this.add("org.jruby.RubyFloat.zero_p", "zero?");
        this.add("org.jruby.RubyGC.count", "count");
        this.add("org.jruby.RubyGC.disable", "disable");
        this.add("org.jruby.RubyGC.enable", "enable");
        this.add("org.jruby.RubyGC.garbage_collect", "garbage_collect");
        this.add("org.jruby.RubyGC.start", "start");
        this.add("org.jruby.RubyGC.stress", "stress");
        this.add("org.jruby.RubyGC.stress_set", "stress=");
        this.add("org.jruby.RubyGlobal.CaseInsensitiveStringOnlyRubyHash.to_s", "to_s");
        this.add("org.jruby.RubyHash.assoc", "assoc");
        this.add("org.jruby.RubyHash.create", "[]");
        this.add("org.jruby.RubyHash.default_proc", "default_proc");
        this.add("org.jruby.RubyHash.default_value_get", "default");
        this.add("org.jruby.RubyHash.default_value_set", "default=");
        this.add("org.jruby.RubyHash.delete", "delete");
        this.add("org.jruby.RubyHash.delete_if", "delete_if");
        this.add("org.jruby.RubyHash.dup", "dup");
        this.add("org.jruby.RubyHash.each", "each");
        this.add("org.jruby.RubyHash.each19", "each");
        this.add("org.jruby.RubyHash.each_key", "each_key");
        this.add("org.jruby.RubyHash.each_pair", "each_pair");
        this.add("org.jruby.RubyHash.each_value", "each_value");
        this.add("org.jruby.RubyHash.empty_p", "empty?");
        this.add("org.jruby.RubyHash.fetch", "fetch");
        this.add("org.jruby.RubyHash.flatten", "flatten");
        this.add("org.jruby.RubyHash.getCompareByIdentity", "compare_by_identity");
        this.add("org.jruby.RubyHash.getCompareByIdentity_p", "compare_by_identity?");
        this.add("org.jruby.RubyHash.has_key_p", "has_key?");
        this.add("org.jruby.RubyHash.has_value_p", "has_value?");
        this.add("org.jruby.RubyHash.hash", "hash");
        this.add("org.jruby.RubyHash.hash19", "hash");
        this.add("org.jruby.RubyHash.index", "index");
        this.add("org.jruby.RubyHash.index19", "index");
        this.add("org.jruby.RubyHash.indices", "indexes");
        this.add("org.jruby.RubyHash.initialize", "initialize");
        this.add("org.jruby.RubyHash.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyHash.initialize_copy19", "initialize_copy");
        this.add("org.jruby.RubyHash.inspect", "inspect");
        this.add("org.jruby.RubyHash.invert", "invert");
        this.add("org.jruby.RubyHash.keep_if", "keep_if");
        this.add("org.jruby.RubyHash.key", "key");
        this.add("org.jruby.RubyHash.keys", "keys");
        this.add("org.jruby.RubyHash.merge", "merge");
        this.add("org.jruby.RubyHash.merge_bang", "merge!");
        this.add("org.jruby.RubyHash.merge_bang19", "merge!");
        this.add("org.jruby.RubyHash.op_aref", "[]");
        this.add("org.jruby.RubyHash.op_aset", "[]=");
        this.add("org.jruby.RubyHash.op_aset19", "[]=");
        this.add("org.jruby.RubyHash.op_eql19", "eql?");
        this.add("org.jruby.RubyHash.op_equal", "==");
        this.add("org.jruby.RubyHash.rassoc", "rassoc");
        this.add("org.jruby.RubyHash.rbClone", "clone");
        this.add("org.jruby.RubyHash.rb_clear", "clear");
        this.add("org.jruby.RubyHash.rb_size", "size");
        this.add("org.jruby.RubyHash.rb_values", "values");
        this.add("org.jruby.RubyHash.rehash", "rehash");
        this.add("org.jruby.RubyHash.reject", "reject");
        this.add("org.jruby.RubyHash.reject_bang", "reject!");
        this.add("org.jruby.RubyHash.replace", "replace");
        this.add("org.jruby.RubyHash.replace19", "replace");
        this.add("org.jruby.RubyHash.select", "select");
        this.add("org.jruby.RubyHash.select19", "select");
        this.add("org.jruby.RubyHash.select_bang", "select!");
        this.add("org.jruby.RubyHash.set_default_proc", "default_proc=");
        this.add("org.jruby.RubyHash.shift", "shift");
        this.add("org.jruby.RubyHash.sort", "sort");
        this.add("org.jruby.RubyHash.to_a", "to_a");
        this.add("org.jruby.RubyHash.to_hash", "to_hash");
        this.add("org.jruby.RubyHash.to_s", "to_s");
        this.add("org.jruby.RubyHash.to_s19", "to_s");
        this.add("org.jruby.RubyHash.try_convert", "try_convert");
        this.add("org.jruby.RubyHash.values_at", "values_at");
        this.add("org.jruby.RubyIO.autoclose", "autoclose");
        this.add("org.jruby.RubyIO.autoclose_set", "autoclose=");
        this.add("org.jruby.RubyIO.binmode", "binmode");
        this.add("org.jruby.RubyIO.binread", "binread");
        this.add("org.jruby.RubyIO.bytes", "bytes");
        this.add("org.jruby.RubyIO.chars", "chars");
        this.add("org.jruby.RubyIO.close", "close");
        this.add("org.jruby.RubyIO.close_read", "close_read");
        this.add("org.jruby.RubyIO.close_write", "close_write");
        this.add("org.jruby.RubyIO.closed_p", "closed?");
        this.add("org.jruby.RubyIO.codepoints", "codepoints");
        this.add("org.jruby.RubyIO.copy_stream", "copy_stream");
        this.add("org.jruby.RubyIO.each", "each");
        this.add("org.jruby.RubyIO.each_byte", "each_byte");
        this.add("org.jruby.RubyIO.each_char", "each_char");
        this.add("org.jruby.RubyIO.each_codepoint", "each_codepoint");
        this.add("org.jruby.RubyIO.each_line", "each_line");
        this.add("org.jruby.RubyIO.eof_p", "eof?");
        this.add("org.jruby.RubyIO.external_encoding", "external_encoding");
        this.add("org.jruby.RubyIO.fcntl", "fcntl");
        this.add("org.jruby.RubyIO.fileno", "fileno");
        this.add("org.jruby.RubyIO.flush", "flush");
        this.add("org.jruby.RubyIO.foreach", "foreach");
        this.add("org.jruby.RubyIO.foreach19", "foreach");
        this.add("org.jruby.RubyIO.fsync", "fsync");
        this.add("org.jruby.RubyIO.getbyte19", "getbyte");
        this.add("org.jruby.RubyIO.getc", "getc");
        this.add("org.jruby.RubyIO.getc19", "getc");
        this.add("org.jruby.RubyIO.gets", "gets");
        this.add("org.jruby.RubyIO.gets19", "gets");
        this.add("org.jruby.RubyIO.initialize", "initialize");
        this.add("org.jruby.RubyIO.initialize19", "initialize");
        this.add("org.jruby.RubyIO.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyIO.internal_encoding", "internal_encoding");
        this.add("org.jruby.RubyIO.ioctl", "ioctl");
        this.add("org.jruby.RubyIO.lineno", "lineno");
        this.add("org.jruby.RubyIO.lineno_set", "lineno=");
        this.add("org.jruby.RubyIO.lines", "lines");
        this.add("org.jruby.RubyIO.lines19", "lines");
        this.add("org.jruby.RubyIO.newInstance", "new");
        this.add("org.jruby.RubyIO.op_append", "<<");
        this.add("org.jruby.RubyIO.op_binmode", "binmode?");
        this.add("org.jruby.RubyIO.open", "open");
        this.add("org.jruby.RubyIO.pid", "pid");
        this.add("org.jruby.RubyIO.pipe", "pipe");
        this.add("org.jruby.RubyIO.popen", "popen");
        this.add("org.jruby.RubyIO.popen19", "popen");
        this.add("org.jruby.RubyIO.popen3", "popen3");
        this.add("org.jruby.RubyIO.popen4", "popen4");
        this.add("org.jruby.RubyIO.pos", "pos");
        this.add("org.jruby.RubyIO.pos_set", "pos=");
        this.add("org.jruby.RubyIO.print", "print");
        this.add("org.jruby.RubyIO.printf", "printf");
        this.add("org.jruby.RubyIO.putc", "putc");
        this.add("org.jruby.RubyIO.puts", "puts");
        this.add("org.jruby.RubyIO.read", "read");
        this.add("org.jruby.RubyIO.read19", "read");
        this.add("org.jruby.RubyIO.readStatic", "read");
        this.add("org.jruby.RubyIO.read_nonblock", "read_nonblock");
        this.add("org.jruby.RubyIO.readbyte", "readbyte");
        this.add("org.jruby.RubyIO.readchar", "readchar");
        this.add("org.jruby.RubyIO.readchar19", "readchar");
        this.add("org.jruby.RubyIO.readline", "readline");
        this.add("org.jruby.RubyIO.readlines", "readlines");
        this.add("org.jruby.RubyIO.readpartial", "readpartial");
        this.add("org.jruby.RubyIO.reopen", "reopen");
        this.add("org.jruby.RubyIO.rewind", "rewind");
        this.add("org.jruby.RubyIO.seek", "seek");
        this.add("org.jruby.RubyIO.select", "select");
        this.add("org.jruby.RubyIO.set_encoding", "set_encoding");
        this.add("org.jruby.RubyIO.stat", "stat");
        this.add("org.jruby.RubyIO.sync", "sync");
        this.add("org.jruby.RubyIO.sync_set", "sync=");
        this.add("org.jruby.RubyIO.sysopen", "sysopen");
        this.add("org.jruby.RubyIO.sysopen19", "sysopen");
        this.add("org.jruby.RubyIO.sysread", "sysread");
        this.add("org.jruby.RubyIO.sysseek", "sysseek");
        this.add("org.jruby.RubyIO.syswrite", "syswrite");
        this.add("org.jruby.RubyIO.to_io", "to_io");
        this.add("org.jruby.RubyIO.tryConvert", "try_convert");
        this.add("org.jruby.RubyIO.tty_p", "tty?");
        this.add("org.jruby.RubyIO.ungetc", "ungetc");
        this.add("org.jruby.RubyIO.ungetc19", "ungetc");
        this.add("org.jruby.RubyIO.write", "write");
        this.add("org.jruby.RubyIO.write_nonblock", "write_nonblock");
        this.add("org.jruby.RubyIconv.RubyFailure.failed", "failed");
        this.add("org.jruby.RubyIconv.RubyFailure.initialize", "initialize");
        this.add("org.jruby.RubyIconv.RubyFailure.inspect", "inspect");
        this.add("org.jruby.RubyIconv.RubyFailure.success", "success");
        this.add("org.jruby.RubyIconv.charset_map_get", "charset_map");
        this.add("org.jruby.RubyIconv.close", "close");
        this.add("org.jruby.RubyIconv.conv", "conv");
        this.add("org.jruby.RubyIconv.iconv", "iconv");
        this.add("org.jruby.RubyIconv.initialize", "initialize");
        this.add("org.jruby.RubyIconv.open", "open");
        this.add("org.jruby.RubyInteger.chr", "chr");
        this.add("org.jruby.RubyInteger.chr19", "chr");
        this.add("org.jruby.RubyInteger.denominator", "denominator");
        this.add("org.jruby.RubyInteger.downto", "downto");
        this.add("org.jruby.RubyInteger.even_p", "even?");
        this.add("org.jruby.RubyInteger.gcd", "gcd");
        this.add("org.jruby.RubyInteger.gcdlcm", "gcdlcm");
        this.add("org.jruby.RubyInteger.induced_from", "induced_from");
        this.add("org.jruby.RubyInteger.integer_p", "integer?");
        this.add("org.jruby.RubyInteger.lcm", "lcm");
        this.add("org.jruby.RubyInteger.numerator", "numerator");
        this.add("org.jruby.RubyInteger.odd_p", "odd?");
        this.add("org.jruby.RubyInteger.ord", "ord");
        this.add("org.jruby.RubyInteger.pred", "pred");
        this.add("org.jruby.RubyInteger.rationalize", "rationalize");
        this.add("org.jruby.RubyInteger.round", "round");
        this.add("org.jruby.RubyInteger.round19", "round");
        this.add("org.jruby.RubyInteger.succ", "succ");
        this.add("org.jruby.RubyInteger.times", "times");
        this.add("org.jruby.RubyInteger.to_i", "to_i");
        this.add("org.jruby.RubyInteger.to_r", "to_r");
        this.add("org.jruby.RubyInteger.upto", "upto");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.add_class_annotation", "add_class_annotation");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.add_method_annotation", "add_method_annotation");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.add_method_signature", "add_method_signature");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.add_parameter_annotations", "add_parameter_annotations");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.become_java_bang", "become_java!");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.java_class", "java_class");
        this.add("org.jruby.RubyJRuby.JRubyClassExtensions.subclasses", "subclasses");
        this.add("org.jruby.RubyJRuby.JRubyCompiledScript.compiled_script_inspect", "inspect");
        this.add("org.jruby.RubyJRuby.JRubyCompiledScript.compiled_script_inspect_bytecode", "inspect_bytecode");
        this.add("org.jruby.RubyJRuby.JRubyCompiledScript.compiled_script_to_s", "to_s");
        this.add("org.jruby.RubyJRuby.JRubyExecutionContextLocal.getDefault", "default");
        this.add("org.jruby.RubyJRuby.JRubyExecutionContextLocal.getDefaultProc", "default_proc");
        this.add("org.jruby.RubyJRuby.JRubyExecutionContextLocal.getValue", "value");
        this.add("org.jruby.RubyJRuby.JRubyExecutionContextLocal.rubyInitialize", "initialize");
        this.add("org.jruby.RubyJRuby.JRubyExecutionContextLocal.setValue", "value=");
        this.add("org.jruby.RubyJRuby.JRubyExtensions.steal_method", "steal_method");
        this.add("org.jruby.RubyJRuby.JRubyExtensions.steal_methods", "steal_methods");
        this.add("org.jruby.RubyJRuby.JRubyFiberLocal.withValue", "with_value");
        this.add("org.jruby.RubyJRuby.JRubyStringExtensions.alloc", "alloc");
        this.add("org.jruby.RubyJRuby.JRubySynchronizedMeta.append_features", "append_features");
        this.add("org.jruby.RubyJRuby.JRubySynchronizedMeta.extend_object", "extend_object");
        this.add("org.jruby.RubyJRuby.JRubyThreadExtensions.times", "times");
        this.add("org.jruby.RubyJRuby.MethodExtensions.methodArgs", "args");
        this.add("org.jruby.RubyJRuby.compile", "compile");
        this.add("org.jruby.RubyJRuby.dereference", "dereference");
        this.add("org.jruby.RubyJRuby.parse", "parse");
        this.add("org.jruby.RubyJRuby.reference", "reference");
        this.add("org.jruby.RubyJRuby.runtime", "runtime");
        this.add("org.jruby.RubyJRuby.with_current_runtime_as_global", "with_current_runtime_as_global");
        this.add("org.jruby.RubyKernel._exec_internal", "_exec_internal");
        this.add("org.jruby.RubyKernel.abort", "abort");
        this.add("org.jruby.RubyKernel.at_exit", "at_exit");
        this.add("org.jruby.RubyKernel.autoload", "autoload");
        this.add("org.jruby.RubyKernel.autoload_p", "autoload?");
        this.add("org.jruby.RubyKernel.backquote", "`");
        this.add("org.jruby.RubyKernel.binding", "binding");
        this.add("org.jruby.RubyKernel.binding19", "binding");
        this.add("org.jruby.RubyKernel.block_given_p", "block_given?");
        this.add("org.jruby.RubyKernel.callcc", "callcc");
        this.add("org.jruby.RubyKernel.chomp", "chomp");
        this.add("org.jruby.RubyKernel.chomp_bang", "chomp!");
        this.add("org.jruby.RubyKernel.chop", "chop");
        this.add("org.jruby.RubyKernel.chop_bang", "chop!");
        this.add("org.jruby.RubyKernel.define_singleton_method", "define_singleton_method");
        this.add("org.jruby.RubyKernel.display", "display");
        this.add("org.jruby.RubyKernel.dup", "dup");
        this.add("org.jruby.RubyKernel.eql_p", "eql?");
        this.add("org.jruby.RubyKernel.equal_p", "equal?");
        this.add("org.jruby.RubyKernel.eval", "eval");
        this.add("org.jruby.RubyKernel.eval19", "eval");
        this.add("org.jruby.RubyKernel.exec", "exec");
        this.add("org.jruby.RubyKernel.exit", "exit");
        this.add("org.jruby.RubyKernel.exit_bang", "exit!");
        this.add("org.jruby.RubyKernel.extend", "extend");
        this.add("org.jruby.RubyKernel.fork", "fork");
        this.add("org.jruby.RubyKernel.fork19", "fork");
        this.add("org.jruby.RubyKernel.freeze", "freeze");
        this.add("org.jruby.RubyKernel.frozen_p", "frozen?");
        this.add("org.jruby.RubyKernel.getc", "getc");
        this.add("org.jruby.RubyKernel.gets", "gets");
        this.add("org.jruby.RubyKernel.global_variables", "global_variables");
        this.add("org.jruby.RubyKernel.global_variables19", "global_variables");
        this.add("org.jruby.RubyKernel.gsub", "gsub");
        this.add("org.jruby.RubyKernel.gsub_bang", "gsub!");
        this.add("org.jruby.RubyKernel.hash", "hash");
        this.add("org.jruby.RubyKernel.id", "object_id");
        this.add("org.jruby.RubyKernel.id_deprecated", "id");
        this.add("org.jruby.RubyKernel.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyKernel.inspect", "inspect");
        this.add("org.jruby.RubyKernel.instance_eval", "instance_eval");
        this.add("org.jruby.RubyKernel.instance_exec", "instance_exec");
        this.add("org.jruby.RubyKernel.instance_of_p", "instance_of?");
        this.add("org.jruby.RubyKernel.instance_variable_defined_p", "instance_variable_defined?");
        this.add("org.jruby.RubyKernel.instance_variable_get", "instance_variable_get");
        this.add("org.jruby.RubyKernel.instance_variable_set", "instance_variable_set");
        this.add("org.jruby.RubyKernel.instance_variables", "instance_variables");
        this.add("org.jruby.RubyKernel.instance_variables19", "instance_variables");
        this.add("org.jruby.RubyKernel.kind_of_p", "kind_of?");
        this.add("org.jruby.RubyKernel.lambda", "lambda");
        this.add("org.jruby.RubyKernel.load", "load");
        this.add("org.jruby.RubyKernel.load19", "load");
        this.add("org.jruby.RubyKernel.local_variables", "local_variables");
        this.add("org.jruby.RubyKernel.local_variables19", "local_variables");
        this.add("org.jruby.RubyKernel.loop", "loop");
        this.add("org.jruby.RubyKernel.method", "method");
        this.add("org.jruby.RubyKernel.method19", "method");
        this.add("org.jruby.RubyKernel.method_missing", "method_missing");
        this.add("org.jruby.RubyKernel.methods", "methods");
        this.add("org.jruby.RubyKernel.methods19", "methods");
        this.add("org.jruby.RubyKernel.new_array", "Array");
        this.add("org.jruby.RubyKernel.new_complex", "Complex");
        this.add("org.jruby.RubyKernel.new_float", "Float");
        this.add("org.jruby.RubyKernel.new_float19", "Float");
        this.add("org.jruby.RubyKernel.new_integer", "Integer");
        this.add("org.jruby.RubyKernel.new_integer19", "Integer");
        this.add("org.jruby.RubyKernel.new_rational", "Rational");
        this.add("org.jruby.RubyKernel.new_string", "String");
        this.add("org.jruby.RubyKernel.new_string19", "String");
        this.add("org.jruby.RubyKernel.nil_p", "nil?");
        this.add("org.jruby.RubyKernel.op_cmp", "<=>");
        this.add("org.jruby.RubyKernel.op_eqq", "===");
        this.add("org.jruby.RubyKernel.op_equal", "==");
        this.add("org.jruby.RubyKernel.op_match", "=~");
        this.add("org.jruby.RubyKernel.op_match19", "=~");
        this.add("org.jruby.RubyKernel.op_not_match", "!~");
        this.add("org.jruby.RubyKernel.open", "open");
        this.add("org.jruby.RubyKernel.open19", "open");
        this.add("org.jruby.RubyKernel.p", "p");
        this.add("org.jruby.RubyKernel.print", "print");
        this.add("org.jruby.RubyKernel.printf", "printf");
        this.add("org.jruby.RubyKernel.private_methods", "private_methods");
        this.add("org.jruby.RubyKernel.private_methods19", "private_methods");
        this.add("org.jruby.RubyKernel.proc", "proc");
        this.add("org.jruby.RubyKernel.proc_1_9", "proc");
        this.add("org.jruby.RubyKernel.protected_methods", "protected_methods");
        this.add("org.jruby.RubyKernel.protected_methods19", "protected_methods");
        this.add("org.jruby.RubyKernel.public_method", "public_method");
        this.add("org.jruby.RubyKernel.public_methods", "public_methods");
        this.add("org.jruby.RubyKernel.public_methods19", "public_methods");
        this.add("org.jruby.RubyKernel.public_send", "public_send");
        this.add("org.jruby.RubyKernel.putc", "putc");
        this.add("org.jruby.RubyKernel.puts", "puts");
        this.add("org.jruby.RubyKernel.rand", "rand");
        this.add("org.jruby.RubyKernel.rand19", "rand");
        this.add("org.jruby.RubyKernel.rbCatch", "catch");
        this.add("org.jruby.RubyKernel.rbCatch19", "catch");
        this.add("org.jruby.RubyKernel.rbClone", "clone");
        this.add("org.jruby.RubyKernel.rbThrow", "throw");
        this.add("org.jruby.RubyKernel.rbThrow19", "throw");
        this.add("org.jruby.RubyKernel.readline", "readline");
        this.add("org.jruby.RubyKernel.readlines", "readlines");
        this.add("org.jruby.RubyKernel.remove_instance_variable", "remove_instance_variable");
        this.add("org.jruby.RubyKernel.require", "require");
        this.add("org.jruby.RubyKernel.require19", "require");
        this.add("org.jruby.RubyKernel.respond_to_missing_p", "respond_to_missing?");
        this.add("org.jruby.RubyKernel.respond_to_p", "respond_to?");
        this.add("org.jruby.RubyKernel.respond_to_p19", "respond_to?");
        this.add("org.jruby.RubyKernel.scan", "scan");
        this.add("org.jruby.RubyKernel.select", "select");
        this.add("org.jruby.RubyKernel.send", "send");
        this.add("org.jruby.RubyKernel.send19", "send");
        this.add("org.jruby.RubyKernel.set_trace_func", "set_trace_func");
        this.add("org.jruby.RubyKernel.singleton_class", "singleton_class");
        this.add("org.jruby.RubyKernel.singleton_method_added", "singleton_method_added");
        this.add("org.jruby.RubyKernel.singleton_method_removed", "singleton_method_removed");
        this.add("org.jruby.RubyKernel.singleton_method_undefined", "singleton_method_undefined");
        this.add("org.jruby.RubyKernel.singleton_methods", "singleton_methods");
        this.add("org.jruby.RubyKernel.singleton_methods19", "singleton_methods");
        this.add("org.jruby.RubyKernel.sleep", "sleep");
        this.add("org.jruby.RubyKernel.split", "split");
        this.add("org.jruby.RubyKernel.sprintf", "sprintf");
        this.add("org.jruby.RubyKernel.srand", "srand");
        this.add("org.jruby.RubyKernel.srand19", "srand");
        this.add("org.jruby.RubyKernel.sub", "sub");
        this.add("org.jruby.RubyKernel.sub_bang", "sub!");
        this.add("org.jruby.RubyKernel.syscall", "syscall");
        this.add("org.jruby.RubyKernel.system", "system");
        this.add("org.jruby.RubyKernel.system19", "system");
        this.add("org.jruby.RubyKernel.taint", "taint");
        this.add("org.jruby.RubyKernel.tainted_p", "tainted?");
        this.add("org.jruby.RubyKernel.tap", "tap");
        this.add("org.jruby.RubyKernel.test", "test");
        this.add("org.jruby.RubyKernel.to_a", "to_a");
        this.add("org.jruby.RubyKernel.to_enum", "to_enum");
        this.add("org.jruby.RubyKernel.to_s", "to_s");
        this.add("org.jruby.RubyKernel.trace_var", "trace_var");
        this.add("org.jruby.RubyKernel.trap", "trap");
        this.add("org.jruby.RubyKernel.trust", "trust");
        this.add("org.jruby.RubyKernel.type", "class");
        this.add("org.jruby.RubyKernel.type_deprecated", "type");
        this.add("org.jruby.RubyKernel.untaint", "untaint");
        this.add("org.jruby.RubyKernel.untrace_var", "untrace_var");
        this.add("org.jruby.RubyKernel.untrust", "untrust");
        this.add("org.jruby.RubyKernel.untrusted_p", "untrusted?");
        this.add("org.jruby.RubyKernel.warn", "warn");
        this.add("org.jruby.RubyLocalJumpError.exit_value", "exit_value");
        this.add("org.jruby.RubyLocalJumpError.reason", "reason");
        this.add("org.jruby.RubyMarshal.dump", "dump");
        this.add("org.jruby.RubyMarshal.load", "load");
        this.add("org.jruby.RubyMatchData.begin", "begin");
        this.add("org.jruby.RubyMatchData.begin19", "begin");
        this.add("org.jruby.RubyMatchData.captures", "captures");
        this.add("org.jruby.RubyMatchData.end", "end");
        this.add("org.jruby.RubyMatchData.end19", "end");
        this.add("org.jruby.RubyMatchData.eql_p", "eql?");
        this.add("org.jruby.RubyMatchData.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyMatchData.inspect", "inspect");
        this.add("org.jruby.RubyMatchData.names", "names");
        this.add("org.jruby.RubyMatchData.offset", "offset");
        this.add("org.jruby.RubyMatchData.offset19", "offset");
        this.add("org.jruby.RubyMatchData.op_aref", "[]");
        this.add("org.jruby.RubyMatchData.op_aref19", "[]");
        this.add("org.jruby.RubyMatchData.post_match", "post_match");
        this.add("org.jruby.RubyMatchData.pre_match", "pre_match");
        this.add("org.jruby.RubyMatchData.regexp", "regexp");
        this.add("org.jruby.RubyMatchData.select", "select");
        this.add("org.jruby.RubyMatchData.size", "size");
        this.add("org.jruby.RubyMatchData.string", "string");
        this.add("org.jruby.RubyMatchData.to_a", "to_a");
        this.add("org.jruby.RubyMatchData.to_s", "to_s");
        this.add("org.jruby.RubyMatchData.values_at", "values_at");
        this.add("org.jruby.RubyMath.acos", "acos");
        this.add("org.jruby.RubyMath.acos19", "acos");
        this.add("org.jruby.RubyMath.acosh", "acosh");
        this.add("org.jruby.RubyMath.acosh19", "acosh");
        this.add("org.jruby.RubyMath.asin", "asin");
        this.add("org.jruby.RubyMath.asin19", "asin");
        this.add("org.jruby.RubyMath.asinh", "asinh");
        this.add("org.jruby.RubyMath.asinh19", "asinh");
        this.add("org.jruby.RubyMath.atan", "atan");
        this.add("org.jruby.RubyMath.atan19", "atan");
        this.add("org.jruby.RubyMath.atan2", "atan2");
        this.add("org.jruby.RubyMath.atan219", "atan2");
        this.add("org.jruby.RubyMath.atanh", "atanh");
        this.add("org.jruby.RubyMath.atanh_19", "atanh");
        this.add("org.jruby.RubyMath.cbrt", "cbrt");
        this.add("org.jruby.RubyMath.cos", "cos");
        this.add("org.jruby.RubyMath.cos19", "cos");
        this.add("org.jruby.RubyMath.cosh", "cosh");
        this.add("org.jruby.RubyMath.cosh19", "cosh");
        this.add("org.jruby.RubyMath.erf", "erf");
        this.add("org.jruby.RubyMath.erf19", "erf");
        this.add("org.jruby.RubyMath.erfc", "erfc");
        this.add("org.jruby.RubyMath.erfc19", "erfc");
        this.add("org.jruby.RubyMath.exp", "exp");
        this.add("org.jruby.RubyMath.exp19", "exp");
        this.add("org.jruby.RubyMath.frexp", "frexp");
        this.add("org.jruby.RubyMath.frexp19", "frexp");
        this.add("org.jruby.RubyMath.gamma", "gamma");
        this.add("org.jruby.RubyMath.hypot", "hypot");
        this.add("org.jruby.RubyMath.hypot19", "hypot");
        this.add("org.jruby.RubyMath.ldexp", "ldexp");
        this.add("org.jruby.RubyMath.ldexp19", "ldexp");
        this.add("org.jruby.RubyMath.lgamma", "lgamma");
        this.add("org.jruby.RubyMath.log", "log");
        this.add("org.jruby.RubyMath.log10", "log10");
        this.add("org.jruby.RubyMath.log10_19", "log10");
        this.add("org.jruby.RubyMath.log2", "log2");
        this.add("org.jruby.RubyMath.log2_19", "log2");
        this.add("org.jruby.RubyMath.log_19", "log");
        this.add("org.jruby.RubyMath.sin", "sin");
        this.add("org.jruby.RubyMath.sin19", "sin");
        this.add("org.jruby.RubyMath.sinh", "sinh");
        this.add("org.jruby.RubyMath.sinh19", "sinh");
        this.add("org.jruby.RubyMath.sqrt", "sqrt");
        this.add("org.jruby.RubyMath.sqrt19", "sqrt");
        this.add("org.jruby.RubyMath.tan", "tan");
        this.add("org.jruby.RubyMath.tan19", "tan");
        this.add("org.jruby.RubyMath.tanh", "tanh");
        this.add("org.jruby.RubyMath.tanh19", "tanh");
        this.add("org.jruby.RubyMethod.arity", "arity");
        this.add("org.jruby.RubyMethod.call", "call");
        this.add("org.jruby.RubyMethod.inspect", "inspect");
        this.add("org.jruby.RubyMethod.name", "name");
        this.add("org.jruby.RubyMethod.name19", "name");
        this.add("org.jruby.RubyMethod.op_eql19", "eql?");
        this.add("org.jruby.RubyMethod.op_equal", "==");
        this.add("org.jruby.RubyMethod.owner", "owner");
        this.add("org.jruby.RubyMethod.parameters", "parameters");
        this.add("org.jruby.RubyMethod.rbClone", "clone");
        this.add("org.jruby.RubyMethod.receiver", "receiver");
        this.add("org.jruby.RubyMethod.source_location", "source_location");
        this.add("org.jruby.RubyMethod.to_proc", "to_proc");
        this.add("org.jruby.RubyMethod.unbind", "unbind");
        this.add("org.jruby.RubyModule.ModuleKernelMethods.autoload", "autoload");
        this.add("org.jruby.RubyModule.ModuleKernelMethods.autoload_p", "autoload?");
        this.add("org.jruby.RubyModule.alias_method", "alias_method");
        this.add("org.jruby.RubyModule.ancestors", "ancestors");
        this.add("org.jruby.RubyModule.append_features", "append_features");
        this.add("org.jruby.RubyModule.attr", "attr");
        this.add("org.jruby.RubyModule.attr19", "attr");
        this.add("org.jruby.RubyModule.attr_accessor", "attr_accessor");
        this.add("org.jruby.RubyModule.attr_reader", "attr_reader");
        this.add("org.jruby.RubyModule.attr_writer", "attr_writer");
        this.add("org.jruby.RubyModule.class_variable_defined_p", "class_variable_defined?");
        this.add("org.jruby.RubyModule.class_variable_get", "class_variable_get");
        this.add("org.jruby.RubyModule.class_variable_get19", "class_variable_get");
        this.add("org.jruby.RubyModule.class_variable_set", "class_variable_set");
        this.add("org.jruby.RubyModule.class_variable_set19", "class_variable_set");
        this.add("org.jruby.RubyModule.class_variables", "class_variables");
        this.add("org.jruby.RubyModule.class_variables19", "class_variables");
        this.add("org.jruby.RubyModule.const_defined_p", "const_defined?");
        this.add("org.jruby.RubyModule.const_defined_p19", "const_defined?");
        this.add("org.jruby.RubyModule.const_get", "const_get");
        this.add("org.jruby.RubyModule.const_missing", "const_missing");
        this.add("org.jruby.RubyModule.const_set", "const_set");
        this.add("org.jruby.RubyModule.constants", "constants");
        this.add("org.jruby.RubyModule.constants19", "constants");
        this.add("org.jruby.RubyModule.define_method", "define_method");
        this.add("org.jruby.RubyModule.extend_object", "extend_object");
        this.add("org.jruby.RubyModule.extended", "extended");
        this.add("org.jruby.RubyModule.freeze", "freeze");
        this.add("org.jruby.RubyModule.hash", "hash");
        this.add("org.jruby.RubyModule.include", "include");
        this.add("org.jruby.RubyModule.include_p", "include?");
        this.add("org.jruby.RubyModule.included", "included");
        this.add("org.jruby.RubyModule.included_modules", "included_modules");
        this.add("org.jruby.RubyModule.initialize", "initialize");
        this.add("org.jruby.RubyModule.initialize19", "initialize");
        this.add("org.jruby.RubyModule.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyModule.instance_method", "instance_method");
        this.add("org.jruby.RubyModule.instance_methods", "instance_methods");
        this.add("org.jruby.RubyModule.instance_methods19", "instance_methods");
        this.add("org.jruby.RubyModule.method_added", "method_added");
        this.add("org.jruby.RubyModule.method_defined_p", "method_defined?");
        this.add("org.jruby.RubyModule.method_removed", "method_removed");
        this.add("org.jruby.RubyModule.method_undefined", "method_undefined");
        this.add("org.jruby.RubyModule.module_eval", "module_eval");
        this.add("org.jruby.RubyModule.module_exec", "module_exec");
        this.add("org.jruby.RubyModule.module_function", "module_function");
        this.add("org.jruby.RubyModule.name", "name");
        this.add("org.jruby.RubyModule.name19", "name");
        this.add("org.jruby.RubyModule.nesting", "nesting");
        this.add("org.jruby.RubyModule.op_cmp", "<=>");
        this.add("org.jruby.RubyModule.op_eqq", "===");
        this.add("org.jruby.RubyModule.op_equal", "==");
        this.add("org.jruby.RubyModule.op_ge", ">=");
        this.add("org.jruby.RubyModule.op_gt", ">");
        this.add("org.jruby.RubyModule.op_le", "<=");
        this.add("org.jruby.RubyModule.op_lt", "<");
        this.add("org.jruby.RubyModule.private_class_method", "private_class_method");
        this.add("org.jruby.RubyModule.private_instance_methods", "private_instance_methods");
        this.add("org.jruby.RubyModule.private_instance_methods19", "private_instance_methods");
        this.add("org.jruby.RubyModule.private_method_defined", "private_method_defined?");
        this.add("org.jruby.RubyModule.protected_instance_methods", "protected_instance_methods");
        this.add("org.jruby.RubyModule.protected_instance_methods19", "protected_instance_methods");
        this.add("org.jruby.RubyModule.protected_method_defined", "protected_method_defined?");
        this.add("org.jruby.RubyModule.public_class_method", "public_class_method");
        this.add("org.jruby.RubyModule.public_instance_methods", "public_instance_methods");
        this.add("org.jruby.RubyModule.public_instance_methods19", "public_instance_methods");
        this.add("org.jruby.RubyModule.public_method_defined", "public_method_defined?");
        this.add("org.jruby.RubyModule.rbPrivate", "private");
        this.add("org.jruby.RubyModule.rbProtected", "protected");
        this.add("org.jruby.RubyModule.rbPublic", "public");
        this.add("org.jruby.RubyModule.remove_class_variable", "remove_class_variable");
        this.add("org.jruby.RubyModule.remove_class_variable19", "remove_class_variable");
        this.add("org.jruby.RubyModule.remove_const", "remove_const");
        this.add("org.jruby.RubyModule.remove_method", "remove_method");
        this.add("org.jruby.RubyModule.to_s", "to_s");
        this.add("org.jruby.RubyModule.undef_method", "undef_method");
        this.add("org.jruby.RubyNKF.guess", "guess");
        this.add("org.jruby.RubyNKF.guess1", "guess1");
        this.add("org.jruby.RubyNKF.guess2", "guess2");
        this.add("org.jruby.RubyNKF.nkf", "nkf");
        this.add("org.jruby.RubyNameError.RubyNameErrorMessage.dump", "_dump");
        this.add("org.jruby.RubyNameError.RubyNameErrorMessage.load", "_load");
        this.add("org.jruby.RubyNameError.RubyNameErrorMessage.to_str", "to_str");
        this.add("org.jruby.RubyNameError.initialize", "initialize");
        this.add("org.jruby.RubyNameError.name", "name");
        this.add("org.jruby.RubyNameError.newRubyNameError", "exception");
        this.add("org.jruby.RubyNameError.to_s", "to_s");
        this.add("org.jruby.RubyNil.inspect", "inspect");
        this.add("org.jruby.RubyNil.nil_p", "nil?");
        this.add("org.jruby.RubyNil.op_and", "&");
        this.add("org.jruby.RubyNil.op_or", "|");
        this.add("org.jruby.RubyNil.op_xor", "^");
        this.add("org.jruby.RubyNil.rationalize", "rationalize");
        this.add("org.jruby.RubyNil.to_a", "to_a");
        this.add("org.jruby.RubyNil.to_c", "to_c");
        this.add("org.jruby.RubyNil.to_f", "to_f");
        this.add("org.jruby.RubyNil.to_i", "to_i");
        this.add("org.jruby.RubyNil.to_r", "to_r");
        this.add("org.jruby.RubyNil.to_s", "to_s");
        this.add("org.jruby.RubyNil.type", "type");
        this.add("org.jruby.RubyNoMethodError.args", "args");
        this.add("org.jruby.RubyNoMethodError.initialize", "initialize");
        this.add("org.jruby.RubyNumeric.abs", "abs");
        this.add("org.jruby.RubyNumeric.abs2", "abs2");
        this.add("org.jruby.RubyNumeric.arg", "arg");
        this.add("org.jruby.RubyNumeric.ceil", "ceil");
        this.add("org.jruby.RubyNumeric.coerce", "coerce");
        this.add("org.jruby.RubyNumeric.conjugate", "conjugate");
        this.add("org.jruby.RubyNumeric.denominator", "denominator");
        this.add("org.jruby.RubyNumeric.div", "div");
        this.add("org.jruby.RubyNumeric.div19", "div");
        this.add("org.jruby.RubyNumeric.divmod", "divmod");
        this.add("org.jruby.RubyNumeric.divmod19", "divmod");
        this.add("org.jruby.RubyNumeric.eql_p", "eql?");
        this.add("org.jruby.RubyNumeric.fdiv", "fdiv");
        this.add("org.jruby.RubyNumeric.floor", "floor");
        this.add("org.jruby.RubyNumeric.image", "imaginary");
        this.add("org.jruby.RubyNumeric.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyNumeric.integer_p", "integer?");
        this.add("org.jruby.RubyNumeric.magnitude", "magnitude");
        this.add("org.jruby.RubyNumeric.modulo", "modulo");
        this.add("org.jruby.RubyNumeric.modulo19", "modulo");
        this.add("org.jruby.RubyNumeric.nonzero_p", "nonzero?");
        this.add("org.jruby.RubyNumeric.num_imaginary", "i");
        this.add("org.jruby.RubyNumeric.numerator", "numerator");
        this.add("org.jruby.RubyNumeric.op_cmp", "<=>");
        this.add("org.jruby.RubyNumeric.op_uminus", "-@");
        this.add("org.jruby.RubyNumeric.op_uplus", "+@");
        this.add("org.jruby.RubyNumeric.polar", "polar");
        this.add("org.jruby.RubyNumeric.quo", "quo");
        this.add("org.jruby.RubyNumeric.quo_19", "quo");
        this.add("org.jruby.RubyNumeric.real", "real");
        this.add("org.jruby.RubyNumeric.rect", "rectangular");
        this.add("org.jruby.RubyNumeric.remainder", "remainder");
        this.add("org.jruby.RubyNumeric.round", "round");
        this.add("org.jruby.RubyNumeric.sadded", "singleton_method_added");
        this.add("org.jruby.RubyNumeric.scalar_p", "real?");
        this.add("org.jruby.RubyNumeric.step", "step");
        this.add("org.jruby.RubyNumeric.to_c", "to_c");
        this.add("org.jruby.RubyNumeric.to_int", "to_int");
        this.add("org.jruby.RubyNumeric.truncate", "truncate");
        this.add("org.jruby.RubyNumeric.zero_p", "zero?");
        this.add("org.jruby.RubyObject.initialize", "initialize");
        this.add("org.jruby.RubyObjectSpace.define_finalizer", "define_finalizer");
        this.add("org.jruby.RubyObjectSpace.each_object", "each_object");
        this.add("org.jruby.RubyObjectSpace.garbage_collect", "garbage_collect");
        this.add("org.jruby.RubyObjectSpace.id2ref", "_id2ref");
        this.add("org.jruby.RubyObjectSpace.undefine_finalizer", "undefine_finalizer");
        this.add("org.jruby.RubyPrecision.append_features", "append_features");
        this.add("org.jruby.RubyPrecision.prec", "prec");
        this.add("org.jruby.RubyPrecision.prec_f", "prec_f");
        this.add("org.jruby.RubyPrecision.prec_i", "prec_i");
        this.add("org.jruby.RubyProc.arity", "arity");
        this.add("org.jruby.RubyProc.binding", "binding");
        this.add("org.jruby.RubyProc.call", "call");
        this.add("org.jruby.RubyProc.call19", "call");
        this.add("org.jruby.RubyProc.dup", "dup");
        this.add("org.jruby.RubyProc.lambda_p", "lambda?");
        this.add("org.jruby.RubyProc.newInstance", "new");
        this.add("org.jruby.RubyProc.op_equal", "==");
        this.add("org.jruby.RubyProc.parameters", "parameters");
        this.add("org.jruby.RubyProc.rbClone", "clone");
        this.add("org.jruby.RubyProc.source_location", "source_location");
        this.add("org.jruby.RubyProc.to_proc", "to_proc");
        this.add("org.jruby.RubyProc.to_s", "to_s");
        this.add("org.jruby.RubyProc.to_s19", "to_s");
        this.add("org.jruby.RubyProcess.GroupID.change_privilege", "change_privilege");
        this.add("org.jruby.RubyProcess.GroupID.eid", "eid");
        this.add("org.jruby.RubyProcess.GroupID.eid", "eid=");
        this.add("org.jruby.RubyProcess.GroupID.grant_privilege", "grant_privilege");
        this.add("org.jruby.RubyProcess.GroupID.re_exchange", "re_exchange");
        this.add("org.jruby.RubyProcess.GroupID.re_exchangeable_p", "re_exchangeable?");
        this.add("org.jruby.RubyProcess.GroupID.rid", "rid");
        this.add("org.jruby.RubyProcess.GroupID.sid_available_p", "sid_available?");
        this.add("org.jruby.RubyProcess.GroupID.switch_rb", "switch");
        this.add("org.jruby.RubyProcess.RubyStatus.coredump_p", "coredump?");
        this.add("org.jruby.RubyProcess.RubyStatus.exitstatus", "exitstatus");
        this.add("org.jruby.RubyProcess.RubyStatus.inspect", "inspect");
        this.add("org.jruby.RubyProcess.RubyStatus.not_implemented", "to_int");
        this.add("org.jruby.RubyProcess.RubyStatus.not_implemented1", "&");
        this.add("org.jruby.RubyProcess.RubyStatus.op_equal", "==");
        this.add("org.jruby.RubyProcess.RubyStatus.op_rshift", ">>");
        this.add("org.jruby.RubyProcess.RubyStatus.pid", "pid");
        this.add("org.jruby.RubyProcess.RubyStatus.success_p", "success?");
        this.add("org.jruby.RubyProcess.RubyStatus.to_i", "to_i");
        this.add("org.jruby.RubyProcess.RubyStatus.to_s", "to_s");
        this.add("org.jruby.RubyProcess.Sys.getegid", "getegid");
        this.add("org.jruby.RubyProcess.Sys.geteuid", "geteuid");
        this.add("org.jruby.RubyProcess.Sys.getgid", "getgid");
        this.add("org.jruby.RubyProcess.Sys.getuid", "getuid");
        this.add("org.jruby.RubyProcess.Sys.setegid", "setegid");
        this.add("org.jruby.RubyProcess.Sys.seteuid", "seteuid");
        this.add("org.jruby.RubyProcess.Sys.setgid", "setgid");
        this.add("org.jruby.RubyProcess.Sys.setuid", "setuid");
        this.add("org.jruby.RubyProcess.UserID.change_privilege", "change_privilege");
        this.add("org.jruby.RubyProcess.UserID.eid", "eid");
        this.add("org.jruby.RubyProcess.UserID.eid", "eid=");
        this.add("org.jruby.RubyProcess.UserID.grant_privilege", "grant_privilege");
        this.add("org.jruby.RubyProcess.UserID.re_exchange", "re_exchange");
        this.add("org.jruby.RubyProcess.UserID.re_exchangeable_p", "re_exchangeable?");
        this.add("org.jruby.RubyProcess.UserID.rid", "rid");
        this.add("org.jruby.RubyProcess.UserID.sid_available_p", "sid_available?");
        this.add("org.jruby.RubyProcess.UserID.switch_rb", "switch");
        this.add("org.jruby.RubyProcess._spawn_internal", "_spawn_internal");
        this.add("org.jruby.RubyProcess.abort", "abort");
        this.add("org.jruby.RubyProcess.detach", "detach");
        this.add("org.jruby.RubyProcess.egid", "egid");
        this.add("org.jruby.RubyProcess.egid_set", "egid=");
        this.add("org.jruby.RubyProcess.euid", "euid");
        this.add("org.jruby.RubyProcess.euid_set", "euid=");
        this.add("org.jruby.RubyProcess.exit", "exit");
        this.add("org.jruby.RubyProcess.exit_bang", "exit!");
        this.add("org.jruby.RubyProcess.fork", "fork");
        this.add("org.jruby.RubyProcess.fork19", "fork");
        this.add("org.jruby.RubyProcess.getpgid", "getpgid");
        this.add("org.jruby.RubyProcess.getpgrp", "getpgrp");
        this.add("org.jruby.RubyProcess.getpriority", "getpriority");
        this.add("org.jruby.RubyProcess.getrlimit", "getrlimit");
        this.add("org.jruby.RubyProcess.gid", "gid");
        this.add("org.jruby.RubyProcess.gid_set", "gid=");
        this.add("org.jruby.RubyProcess.groups", "groups");
        this.add("org.jruby.RubyProcess.groups_set", "groups=");
        this.add("org.jruby.RubyProcess.initgroups", "initgroups");
        this.add("org.jruby.RubyProcess.kill", "kill");
        this.add("org.jruby.RubyProcess.maxgroups", "maxgroups");
        this.add("org.jruby.RubyProcess.maxgroups_set", "maxgroups=");
        this.add("org.jruby.RubyProcess.pid", "pid");
        this.add("org.jruby.RubyProcess.ppid", "ppid");
        this.add("org.jruby.RubyProcess.setpgid", "setpgid");
        this.add("org.jruby.RubyProcess.setpgrp", "setpgrp");
        this.add("org.jruby.RubyProcess.setpriority", "setpriority");
        this.add("org.jruby.RubyProcess.setrlimit", "setrlimit");
        this.add("org.jruby.RubyProcess.setsid", "setsid");
        this.add("org.jruby.RubyProcess.times", "times");
        this.add("org.jruby.RubyProcess.uid", "uid");
        this.add("org.jruby.RubyProcess.uid_set", "uid=");
        this.add("org.jruby.RubyProcess.wait", "wait");
        this.add("org.jruby.RubyProcess.wait2", "wait2");
        this.add("org.jruby.RubyProcess.waitall", "waitall");
        this.add("org.jruby.RubyProcess.waitpid", "waitpid");
        this.add("org.jruby.RubyProcess.waitpid2", "waitpid2");
        this.add("org.jruby.RubyRandom.bytes", "bytes");
        this.add("org.jruby.RubyRandom.initialize", "initialize");
        this.add("org.jruby.RubyRandom.marshal_dump", "marshal_dump");
        this.add("org.jruby.RubyRandom.marshal_load", "marshal_load");
        this.add("org.jruby.RubyRandom.newSeed", "new_seed");
        this.add("org.jruby.RubyRandom.op_equal_19", "==");
        this.add("org.jruby.RubyRandom.rand", "rand");
        this.add("org.jruby.RubyRandom.randObj", "rand");
        this.add("org.jruby.RubyRandom.seed", "seed");
        this.add("org.jruby.RubyRandom.srand", "srand");
        this.add("org.jruby.RubyRange.cover_p", "cover?");
        this.add("org.jruby.RubyRange.each", "each");
        this.add("org.jruby.RubyRange.each19", "each");
        this.add("org.jruby.RubyRange.eql_p", "eql?");
        this.add("org.jruby.RubyRange.eqq_p19", "===");
        this.add("org.jruby.RubyRange.exclude_end_p", "exclude_end?");
        this.add("org.jruby.RubyRange.first", "first");
        this.add("org.jruby.RubyRange.hash", "hash");
        this.add("org.jruby.RubyRange.include_p", "include?");
        this.add("org.jruby.RubyRange.include_p19", "include?");
        this.add("org.jruby.RubyRange.initialize", "initialize");
        this.add("org.jruby.RubyRange.inspect", "inspect");
        this.add("org.jruby.RubyRange.last", "last");
        this.add("org.jruby.RubyRange.max", "max");
        this.add("org.jruby.RubyRange.min", "min");
        this.add("org.jruby.RubyRange.op_equal", "==");
        this.add("org.jruby.RubyRange.step", "step");
        this.add("org.jruby.RubyRange.step19", "step");
        this.add("org.jruby.RubyRange.to_a", "to_a");
        this.add("org.jruby.RubyRange.to_s", "to_s");
        this.add("org.jruby.RubyRational.convert", "convert");
        this.add("org.jruby.RubyRational.denominator", "denominator");
        this.add("org.jruby.RubyRational.hash", "hash");
        this.add("org.jruby.RubyRational.inspect", "inspect");
        this.add("org.jruby.RubyRational.marshal_dump", "marshal_dump");
        this.add("org.jruby.RubyRational.marshal_load", "marshal_load");
        this.add("org.jruby.RubyRational.newInstanceBang", "new!");
        this.add("org.jruby.RubyRational.numerator", "numerator");
        this.add("org.jruby.RubyRational.op_abs", "abs");
        this.add("org.jruby.RubyRational.op_add", "+");
        this.add("org.jruby.RubyRational.op_ceil", "ceil");
        this.add("org.jruby.RubyRational.op_cmp", "<=>");
        this.add("org.jruby.RubyRational.op_coerce", "coerce");
        this.add("org.jruby.RubyRational.op_div", "/");
        this.add("org.jruby.RubyRational.op_divmod", "divmod");
        this.add("org.jruby.RubyRational.op_divmod19", "divmod");
        this.add("org.jruby.RubyRational.op_equal", "==");
        this.add("org.jruby.RubyRational.op_expt", "**");
        this.add("org.jruby.RubyRational.op_fdiv", "fdiv");
        this.add("org.jruby.RubyRational.op_floor", "floor");
        this.add("org.jruby.RubyRational.op_idiv", "div");
        this.add("org.jruby.RubyRational.op_idiv19", "div");
        this.add("org.jruby.RubyRational.op_mod", "modulo");
        this.add("org.jruby.RubyRational.op_mod19", "modulo");
        this.add("org.jruby.RubyRational.op_mul", "*");
        this.add("org.jruby.RubyRational.op_rem", "remainder");
        this.add("org.jruby.RubyRational.op_round", "round");
        this.add("org.jruby.RubyRational.op_sub", "-");
        this.add("org.jruby.RubyRational.op_truncate", "truncate");
        this.add("org.jruby.RubyRational.rationalize", "rationalize");
        this.add("org.jruby.RubyRational.to_f", "to_f");
        this.add("org.jruby.RubyRational.to_i", "to_i");
        this.add("org.jruby.RubyRational.to_r", "to_r");
        this.add("org.jruby.RubyRational.to_s", "to_s");
        this.add("org.jruby.RubyRegexp.casefold_p", "casefold?");
        this.add("org.jruby.RubyRegexp.encoding", "encoding");
        this.add("org.jruby.RubyRegexp.eqq", "===");
        this.add("org.jruby.RubyRegexp.eqq19", "===");
        this.add("org.jruby.RubyRegexp.fixed_encoding_p", "fixed_encoding?");
        this.add("org.jruby.RubyRegexp.hash", "hash");
        this.add("org.jruby.RubyRegexp.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyRegexp.initialize_m", "initialize");
        this.add("org.jruby.RubyRegexp.initialize_m19", "initialize");
        this.add("org.jruby.RubyRegexp.inspect", "inspect");
        this.add("org.jruby.RubyRegexp.inspect19", "inspect");
        this.add("org.jruby.RubyRegexp.kcode", "kcode");
        this.add("org.jruby.RubyRegexp.last_match_s", "last_match");
        this.add("org.jruby.RubyRegexp.match_m", "match");
        this.add("org.jruby.RubyRegexp.match_m19", "match");
        this.add("org.jruby.RubyRegexp.named_captures", "named_captures");
        this.add("org.jruby.RubyRegexp.names", "names");
        this.add("org.jruby.RubyRegexp.newInstance", "new");
        this.add("org.jruby.RubyRegexp.op_equal", "==");
        this.add("org.jruby.RubyRegexp.op_match", "=~");
        this.add("org.jruby.RubyRegexp.op_match19", "=~");
        this.add("org.jruby.RubyRegexp.op_match2", "~");
        this.add("org.jruby.RubyRegexp.op_match2_19", "~");
        this.add("org.jruby.RubyRegexp.options", "options");
        this.add("org.jruby.RubyRegexp.quote", "quote");
        this.add("org.jruby.RubyRegexp.quote19", "quote");
        this.add("org.jruby.RubyRegexp.source", "source");
        this.add("org.jruby.RubyRegexp.to_s", "to_s");
        this.add("org.jruby.RubyRegexp.try_convert", "try_convert");
        this.add("org.jruby.RubyRegexp.union", "union");
        this.add("org.jruby.RubyRegexp.union19", "union");
        this.add("org.jruby.RubySignal.__jtrap_kernel", "__jtrap_kernel");
        this.add("org.jruby.RubySignal.list", "list");
        this.add("org.jruby.RubySignal.trap", "trap");
        this.add("org.jruby.RubyString.ascii_only_p", "ascii_only?");
        this.add("org.jruby.RubyString.bytes", "bytes");
        this.add("org.jruby.RubyString.bytesize", "bytesize");
        this.add("org.jruby.RubyString.capitalize", "capitalize");
        this.add("org.jruby.RubyString.capitalize19", "capitalize");
        this.add("org.jruby.RubyString.capitalize_bang", "capitalize!");
        this.add("org.jruby.RubyString.capitalize_bang19", "capitalize!");
        this.add("org.jruby.RubyString.casecmp", "casecmp");
        this.add("org.jruby.RubyString.casecmp19", "casecmp");
        this.add("org.jruby.RubyString.center", "center");
        this.add("org.jruby.RubyString.center19", "center");
        this.add("org.jruby.RubyString.chars18", "chars");
        this.add("org.jruby.RubyString.chars19", "chars");
        this.add("org.jruby.RubyString.chomp", "chomp");
        this.add("org.jruby.RubyString.chomp19", "chomp");
        this.add("org.jruby.RubyString.chomp_bang", "chomp!");
        this.add("org.jruby.RubyString.chomp_bang19", "chomp!");
        this.add("org.jruby.RubyString.chop", "chop");
        this.add("org.jruby.RubyString.chop19", "chop");
        this.add("org.jruby.RubyString.chop_bang", "chop!");
        this.add("org.jruby.RubyString.chop_bang19", "chop!");
        this.add("org.jruby.RubyString.chr", "chr");
        this.add("org.jruby.RubyString.clear", "clear");
        this.add("org.jruby.RubyString.codepoints", "codepoints");
        this.add("org.jruby.RubyString.concat", "concat");
        this.add("org.jruby.RubyString.concat19", "concat");
        this.add("org.jruby.RubyString.count", "count");
        this.add("org.jruby.RubyString.count19", "count");
        this.add("org.jruby.RubyString.crypt", "crypt");
        this.add("org.jruby.RubyString.delete", "delete");
        this.add("org.jruby.RubyString.delete19", "delete");
        this.add("org.jruby.RubyString.delete_bang", "delete!");
        this.add("org.jruby.RubyString.delete_bang19", "delete!");
        this.add("org.jruby.RubyString.downcase", "downcase");
        this.add("org.jruby.RubyString.downcase19", "downcase");
        this.add("org.jruby.RubyString.downcase_bang", "downcase!");
        this.add("org.jruby.RubyString.downcase_bang19", "downcase!");
        this.add("org.jruby.RubyString.dump", "dump");
        this.add("org.jruby.RubyString.dump19", "dump");
        this.add("org.jruby.RubyString.each18", "each");
        this.add("org.jruby.RubyString.each_byte19", "each_byte");
        this.add("org.jruby.RubyString.each_char18", "each_char");
        this.add("org.jruby.RubyString.each_char19", "each_char");
        this.add("org.jruby.RubyString.each_codepoint", "each_codepoint");
        this.add("org.jruby.RubyString.each_line18", "each_line");
        this.add("org.jruby.RubyString.each_line19", "each_line");
        this.add("org.jruby.RubyString.empty_p", "empty?");
        this.add("org.jruby.RubyString.encode", "encode");
        this.add("org.jruby.RubyString.encode_bang", "encode!");
        this.add("org.jruby.RubyString.encoding", "encoding");
        this.add("org.jruby.RubyString.end_with_p", "end_with?");
        this.add("org.jruby.RubyString.force_encoding", "force_encoding");
        this.add("org.jruby.RubyString.getbyte", "getbyte");
        this.add("org.jruby.RubyString.gsub", "gsub");
        this.add("org.jruby.RubyString.gsub19", "gsub");
        this.add("org.jruby.RubyString.gsub_bang", "gsub!");
        this.add("org.jruby.RubyString.gsub_bang19", "gsub!");
        this.add("org.jruby.RubyString.hash", "hash");
        this.add("org.jruby.RubyString.hex", "hex");
        this.add("org.jruby.RubyString.hex19", "hex");
        this.add("org.jruby.RubyString.include_p", "include?");
        this.add("org.jruby.RubyString.include_p19", "include?");
        this.add("org.jruby.RubyString.index", "index");
        this.add("org.jruby.RubyString.index19", "index");
        this.add("org.jruby.RubyString.initialize", "initialize");
        this.add("org.jruby.RubyString.initialize19", "initialize");
        this.add("org.jruby.RubyString.insert", "insert");
        this.add("org.jruby.RubyString.insert19", "insert");
        this.add("org.jruby.RubyString.inspect", "inspect");
        this.add("org.jruby.RubyString.inspect19", "inspect");
        this.add("org.jruby.RubyString.intern", "to_sym");
        this.add("org.jruby.RubyString.intern19", "to_sym");
        this.add("org.jruby.RubyString.length", "length");
        this.add("org.jruby.RubyString.length19", "length");
        this.add("org.jruby.RubyString.lines", "lines");
        this.add("org.jruby.RubyString.lines18", "lines");
        this.add("org.jruby.RubyString.ljust", "ljust");
        this.add("org.jruby.RubyString.ljust19", "ljust");
        this.add("org.jruby.RubyString.lstrip", "lstrip");
        this.add("org.jruby.RubyString.lstrip19", "lstrip");
        this.add("org.jruby.RubyString.lstrip_bang", "lstrip!");
        this.add("org.jruby.RubyString.lstrip_bang19", "lstrip!");
        this.add("org.jruby.RubyString.match", "match");
        this.add("org.jruby.RubyString.match19", "match");
        this.add("org.jruby.RubyString.oct", "oct");
        this.add("org.jruby.RubyString.oct19", "oct");
        this.add("org.jruby.RubyString.op_aref", "[]");
        this.add("org.jruby.RubyString.op_aref19", "[]");
        this.add("org.jruby.RubyString.op_aset", "[]=");
        this.add("org.jruby.RubyString.op_aset19", "[]=");
        this.add("org.jruby.RubyString.op_cmp", "<=>");
        this.add("org.jruby.RubyString.op_cmp19", "<=>");
        this.add("org.jruby.RubyString.op_equal", "==");
        this.add("org.jruby.RubyString.op_equal19", "==");
        this.add("org.jruby.RubyString.op_format", "%");
        this.add("org.jruby.RubyString.op_ge", ">=");
        this.add("org.jruby.RubyString.op_ge19", ">=");
        this.add("org.jruby.RubyString.op_gt", ">");
        this.add("org.jruby.RubyString.op_gt19", ">");
        this.add("org.jruby.RubyString.op_le", "<=");
        this.add("org.jruby.RubyString.op_le19", "<=");
        this.add("org.jruby.RubyString.op_lt", "<");
        this.add("org.jruby.RubyString.op_lt19", "<");
        this.add("org.jruby.RubyString.op_match", "=~");
        this.add("org.jruby.RubyString.op_match19", "=~");
        this.add("org.jruby.RubyString.op_mul", "*");
        this.add("org.jruby.RubyString.op_mul19", "*");
        this.add("org.jruby.RubyString.op_plus", "+");
        this.add("org.jruby.RubyString.op_plus19", "+");
        this.add("org.jruby.RubyString.ord", "ord");
        this.add("org.jruby.RubyString.partition", "partition");
        this.add("org.jruby.RubyString.replace", "replace");
        this.add("org.jruby.RubyString.replace19", "replace");
        this.add("org.jruby.RubyString.reverse", "reverse");
        this.add("org.jruby.RubyString.reverse19", "reverse");
        this.add("org.jruby.RubyString.reverse_bang", "reverse!");
        this.add("org.jruby.RubyString.reverse_bang19", "reverse!");
        this.add("org.jruby.RubyString.rindex", "rindex");
        this.add("org.jruby.RubyString.rindex19", "rindex");
        this.add("org.jruby.RubyString.rjust", "rjust");
        this.add("org.jruby.RubyString.rjust19", "rjust");
        this.add("org.jruby.RubyString.rpartition", "rpartition");
        this.add("org.jruby.RubyString.rstrip", "rstrip");
        this.add("org.jruby.RubyString.rstrip19", "rstrip");
        this.add("org.jruby.RubyString.rstrip_bang", "rstrip!");
        this.add("org.jruby.RubyString.rstrip_bang19", "rstrip!");
        this.add("org.jruby.RubyString.scan", "scan");
        this.add("org.jruby.RubyString.scan19", "scan");
        this.add("org.jruby.RubyString.setbyte", "setbyte");
        this.add("org.jruby.RubyString.slice_bang", "slice!");
        this.add("org.jruby.RubyString.slice_bang19", "slice!");
        this.add("org.jruby.RubyString.split", "split");
        this.add("org.jruby.RubyString.split19", "split");
        this.add("org.jruby.RubyString.squeeze", "squeeze");
        this.add("org.jruby.RubyString.squeeze19", "squeeze");
        this.add("org.jruby.RubyString.squeeze_bang", "squeeze!");
        this.add("org.jruby.RubyString.squeeze_bang19", "squeeze!");
        this.add("org.jruby.RubyString.start_with_p", "start_with?");
        this.add("org.jruby.RubyString.str_eql_p", "eql?");
        this.add("org.jruby.RubyString.str_eql_p19", "eql?");
        this.add("org.jruby.RubyString.strip", "strip");
        this.add("org.jruby.RubyString.strip19", "strip");
        this.add("org.jruby.RubyString.strip_bang", "strip!");
        this.add("org.jruby.RubyString.strip_bang19", "strip!");
        this.add("org.jruby.RubyString.sub", "sub");
        this.add("org.jruby.RubyString.sub19", "sub");
        this.add("org.jruby.RubyString.sub_bang", "sub!");
        this.add("org.jruby.RubyString.sub_bang19", "sub!");
        this.add("org.jruby.RubyString.succ", "succ");
        this.add("org.jruby.RubyString.succ19", "succ");
        this.add("org.jruby.RubyString.succ_bang", "succ!");
        this.add("org.jruby.RubyString.succ_bang19", "succ!");
        this.add("org.jruby.RubyString.sum", "sum");
        this.add("org.jruby.RubyString.swapcase", "swapcase");
        this.add("org.jruby.RubyString.swapcase19", "swapcase");
        this.add("org.jruby.RubyString.swapcase_bang", "swapcase!");
        this.add("org.jruby.RubyString.swapcase_bang19", "swapcase!");
        this.add("org.jruby.RubyString.to_c", "to_c");
        this.add("org.jruby.RubyString.to_f", "to_f");
        this.add("org.jruby.RubyString.to_f19", "to_f");
        this.add("org.jruby.RubyString.to_i", "to_i");
        this.add("org.jruby.RubyString.to_i19", "to_i");
        this.add("org.jruby.RubyString.to_r", "to_r");
        this.add("org.jruby.RubyString.to_s", "to_s");
        this.add("org.jruby.RubyString.tr", "tr");
        this.add("org.jruby.RubyString.tr19", "tr");
        this.add("org.jruby.RubyString.tr_bang", "tr!");
        this.add("org.jruby.RubyString.tr_bang19", "tr!");
        this.add("org.jruby.RubyString.tr_s", "tr_s");
        this.add("org.jruby.RubyString.tr_s19", "tr_s");
        this.add("org.jruby.RubyString.tr_s_bang", "tr_s!");
        this.add("org.jruby.RubyString.tr_s_bang19", "tr_s!");
        this.add("org.jruby.RubyString.try_convert", "try_convert");
        this.add("org.jruby.RubyString.unpack", "unpack");
        this.add("org.jruby.RubyString.upcase", "upcase");
        this.add("org.jruby.RubyString.upcase19", "upcase");
        this.add("org.jruby.RubyString.upcase_bang", "upcase!");
        this.add("org.jruby.RubyString.upcase_bang19", "upcase!");
        this.add("org.jruby.RubyString.upto18", "upto");
        this.add("org.jruby.RubyString.upto19", "upto");
        this.add("org.jruby.RubyString.valid_encoding_p", "valid_encoding?");
        this.add("org.jruby.RubyStringIO.append", "<<");
        this.add("org.jruby.RubyStringIO.binmode", "binmode");
        this.add("org.jruby.RubyStringIO.bytes", "bytes");
        this.add("org.jruby.RubyStringIO.chars", "chars");
        this.add("org.jruby.RubyStringIO.close", "close");
        this.add("org.jruby.RubyStringIO.close_read", "close_read");
        this.add("org.jruby.RubyStringIO.close_write", "close_write");
        this.add("org.jruby.RubyStringIO.closed_p", "closed?");
        this.add("org.jruby.RubyStringIO.closed_read_p", "closed_read?");
        this.add("org.jruby.RubyStringIO.closed_write_p", "closed_write?");
        this.add("org.jruby.RubyStringIO.each", "each");
        this.add("org.jruby.RubyStringIO.each_byte19", "each_byte");
        this.add("org.jruby.RubyStringIO.each_char", "each_char");
        this.add("org.jruby.RubyStringIO.each_line", "each_line");
        this.add("org.jruby.RubyStringIO.eof", "eof");
        this.add("org.jruby.RubyStringIO.external_encoding", "external_encoding");
        this.add("org.jruby.RubyStringIO.fcntl", "fcntl");
        this.add("org.jruby.RubyStringIO.fileno", "fileno");
        this.add("org.jruby.RubyStringIO.flush", "flush");
        this.add("org.jruby.RubyStringIO.fsync", "fsync");
        this.add("org.jruby.RubyStringIO.getc", "getc");
        this.add("org.jruby.RubyStringIO.getc19", "getc");
        this.add("org.jruby.RubyStringIO.gets", "gets");
        this.add("org.jruby.RubyStringIO.gets19", "gets");
        this.add("org.jruby.RubyStringIO.initialize", "initialize");
        this.add("org.jruby.RubyStringIO.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyStringIO.internal_encoding", "internal_encoding");
        this.add("org.jruby.RubyStringIO.isatty", "tty?");
        this.add("org.jruby.RubyStringIO.length", "length");
        this.add("org.jruby.RubyStringIO.lineno", "lineno");
        this.add("org.jruby.RubyStringIO.lines", "lines");
        this.add("org.jruby.RubyStringIO.open", "open");
        this.add("org.jruby.RubyStringIO.path", "path");
        this.add("org.jruby.RubyStringIO.pid", "pid");
        this.add("org.jruby.RubyStringIO.pos", "pos");
        this.add("org.jruby.RubyStringIO.print", "print");
        this.add("org.jruby.RubyStringIO.print19", "print");
        this.add("org.jruby.RubyStringIO.printf", "printf");
        this.add("org.jruby.RubyStringIO.putc", "putc");
        this.add("org.jruby.RubyStringIO.puts", "puts");
        this.add("org.jruby.RubyStringIO.read", "read");
        this.add("org.jruby.RubyStringIO.read_nonblock", "read_nonblock");
        this.add("org.jruby.RubyStringIO.readchar", "readchar");
        this.add("org.jruby.RubyStringIO.readchar19", "readchar");
        this.add("org.jruby.RubyStringIO.readline", "readline");
        this.add("org.jruby.RubyStringIO.readlines", "readlines");
        this.add("org.jruby.RubyStringIO.readpartial", "readpartial");
        this.add("org.jruby.RubyStringIO.reopen", "reopen");
        this.add("org.jruby.RubyStringIO.rewind", "rewind");
        this.add("org.jruby.RubyStringIO.seek", "seek");
        this.add("org.jruby.RubyStringIO.set_encoding", "set_encoding");
        this.add("org.jruby.RubyStringIO.set_lineno", "lineno=");
        this.add("org.jruby.RubyStringIO.set_pos", "pos=");
        this.add("org.jruby.RubyStringIO.set_string", "string=");
        this.add("org.jruby.RubyStringIO.set_sync", "sync=");
        this.add("org.jruby.RubyStringIO.string", "string");
        this.add("org.jruby.RubyStringIO.sync", "sync");
        this.add("org.jruby.RubyStringIO.sysread", "sysread");
        this.add("org.jruby.RubyStringIO.truncate", "truncate");
        this.add("org.jruby.RubyStringIO.ungetc", "ungetc");
        this.add("org.jruby.RubyStringIO.ungetc19", "ungetc");
        this.add("org.jruby.RubyStringIO.write", "write");
        this.add("org.jruby.RubyStringScanner.bol_p", "beginning_of_line?");
        this.add("org.jruby.RubyStringScanner.check", "check");
        this.add("org.jruby.RubyStringScanner.check_until", "check_until");
        this.add("org.jruby.RubyStringScanner.clear", "clear");
        this.add("org.jruby.RubyStringScanner.concat", "concat");
        this.add("org.jruby.RubyStringScanner.empty_p", "empty?");
        this.add("org.jruby.RubyStringScanner.eos_p", "eos?");
        this.add("org.jruby.RubyStringScanner.exist_p", "exist?");
        this.add("org.jruby.RubyStringScanner.get_byte", "get_byte");
        this.add("org.jruby.RubyStringScanner.getbyte", "getbyte");
        this.add("org.jruby.RubyStringScanner.getch", "getch");
        this.add("org.jruby.RubyStringScanner.getch19", "getch");
        this.add("org.jruby.RubyStringScanner.initialize", "initialize");
        this.add("org.jruby.RubyStringScanner.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyStringScanner.inspect", "inspect");
        this.add("org.jruby.RubyStringScanner.match_p", "match?");
        this.add("org.jruby.RubyStringScanner.matched", "matched");
        this.add("org.jruby.RubyStringScanner.matched_p", "matched?");
        this.add("org.jruby.RubyStringScanner.matched_size", "matched_size");
        this.add("org.jruby.RubyStringScanner.matchedsize", "matchedsize");
        this.add("org.jruby.RubyStringScanner.mustCversion", "must_C_version");
        this.add("org.jruby.RubyStringScanner.op_aref", "[]");
        this.add("org.jruby.RubyStringScanner.peek", "peek");
        this.add("org.jruby.RubyStringScanner.peep", "peep");
        this.add("org.jruby.RubyStringScanner.pos", "pos");
        this.add("org.jruby.RubyStringScanner.post_match", "post_match");
        this.add("org.jruby.RubyStringScanner.pre_match", "pre_match");
        this.add("org.jruby.RubyStringScanner.reset", "reset");
        this.add("org.jruby.RubyStringScanner.rest", "rest");
        this.add("org.jruby.RubyStringScanner.rest_p", "rest?");
        this.add("org.jruby.RubyStringScanner.rest_size", "rest_size");
        this.add("org.jruby.RubyStringScanner.restsize", "restsize");
        this.add("org.jruby.RubyStringScanner.scan", "scan");
        this.add("org.jruby.RubyStringScanner.scan_full", "scan_full");
        this.add("org.jruby.RubyStringScanner.scan_until", "scan_until");
        this.add("org.jruby.RubyStringScanner.search_full", "search_full");
        this.add("org.jruby.RubyStringScanner.set_pos", "pos=");
        this.add("org.jruby.RubyStringScanner.set_string", "string=");
        this.add("org.jruby.RubyStringScanner.skip", "skip");
        this.add("org.jruby.RubyStringScanner.skip_until", "skip_until");
        this.add("org.jruby.RubyStringScanner.string", "string");
        this.add("org.jruby.RubyStringScanner.terminate", "terminate");
        this.add("org.jruby.RubyStringScanner.unscan", "unscan");
        this.add("org.jruby.RubyStruct.StructMethods.members", "members");
        this.add("org.jruby.RubyStruct.StructMethods.members19", "members");
        this.add("org.jruby.RubyStruct.StructMethods.newStruct", "new");
        this.add("org.jruby.RubyStruct.aref", "[]");
        this.add("org.jruby.RubyStruct.aset", "[]=");
        this.add("org.jruby.RubyStruct.each", "each");
        this.add("org.jruby.RubyStruct.each_pair", "each_pair");
        this.add("org.jruby.RubyStruct.eql_p", "eql?");
        this.add("org.jruby.RubyStruct.hash", "hash");
        this.add("org.jruby.RubyStruct.initialize", "initialize");
        this.add("org.jruby.RubyStruct.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyStruct.inspect", "inspect");
        this.add("org.jruby.RubyStruct.members", "members");
        this.add("org.jruby.RubyStruct.members19", "members");
        this.add("org.jruby.RubyStruct.newInstance", "new");
        this.add("org.jruby.RubyStruct.op_equal", "==");
        this.add("org.jruby.RubyStruct.select", "select");
        this.add("org.jruby.RubyStruct.size", "size");
        this.add("org.jruby.RubyStruct.to_a", "to_a");
        this.add("org.jruby.RubyStruct.values_at", "values_at");
        this.add("org.jruby.RubySymbol.all_symbols", "all_symbols");
        this.add("org.jruby.RubySymbol.capitalize", "capitalize");
        this.add("org.jruby.RubySymbol.casecmp", "casecmp");
        this.add("org.jruby.RubySymbol.downcase", "downcase");
        this.add("org.jruby.RubySymbol.empty_p", "empty?");
        this.add("org.jruby.RubySymbol.encoding", "encoding");
        this.add("org.jruby.RubySymbol.hash", "hash");
        this.add("org.jruby.RubySymbol.id2name", "id2name");
        this.add("org.jruby.RubySymbol.inspect", "inspect");
        this.add("org.jruby.RubySymbol.inspect19", "inspect");
        this.add("org.jruby.RubySymbol.length", "length");
        this.add("org.jruby.RubySymbol.op_aref", "[]");
        this.add("org.jruby.RubySymbol.op_cmp", "<=>");
        this.add("org.jruby.RubySymbol.op_eqq", "===");
        this.add("org.jruby.RubySymbol.op_match19", "=~");
        this.add("org.jruby.RubySymbol.succ", "succ");
        this.add("org.jruby.RubySymbol.swapcase", "swapcase");
        this.add("org.jruby.RubySymbol.to_i", "to_i");
        this.add("org.jruby.RubySymbol.to_int", "to_int");
        this.add("org.jruby.RubySymbol.to_proc", "to_proc");
        this.add("org.jruby.RubySymbol.to_s", "to_s");
        this.add("org.jruby.RubySymbol.to_sym", "to_sym");
        this.add("org.jruby.RubySymbol.to_sym19", "intern");
        this.add("org.jruby.RubySymbol.upcase", "upcase");
        this.add("org.jruby.RubySystemCallError.errno", "errno");
        this.add("org.jruby.RubySystemCallError.initialize", "initialize");
        this.add("org.jruby.RubySystemExit.initialize", "initialize");
        this.add("org.jruby.RubySystemExit.status", "status");
        this.add("org.jruby.RubySystemExit.success_p", "success?");
        this.add("org.jruby.RubyTempfile._close", "_close");
        this.add("org.jruby.RubyTempfile.close", "close");
        this.add("org.jruby.RubyTempfile.close_bang", "close!");
        this.add("org.jruby.RubyTempfile.initialize", "initialize");
        this.add("org.jruby.RubyTempfile.make_tmpname", "make_tmpname");
        this.add("org.jruby.RubyTempfile.open", "open");
        this.add("org.jruby.RubyTempfile.open19", "open19");
        this.add("org.jruby.RubyTempfile.size", "size");
        this.add("org.jruby.RubyTempfile.unlink", "unlink");
        this.add("org.jruby.RubyThread.abort_on_exception", "abort_on_exception");
        this.add("org.jruby.RubyThread.abort_on_exception_set", "abort_on_exception=");
        this.add("org.jruby.RubyThread.abort_on_exception_set_x", "abort_on_exception=");
        this.add("org.jruby.RubyThread.abort_on_exception_x", "abort_on_exception");
        this.add("org.jruby.RubyThread.alive_p", "alive?");
        this.add("org.jruby.RubyThread.backtrace", "backtrace");
        this.add("org.jruby.RubyThread.critical", "critical");
        this.add("org.jruby.RubyThread.critical_set", "critical=");
        this.add("org.jruby.RubyThread.current", "current");
        this.add("org.jruby.RubyThread.group", "group");
        this.add("org.jruby.RubyThread.initialize", "initialize");
        this.add("org.jruby.RubyThread.inspect", "inspect");
        this.add("org.jruby.RubyThread.join", "join");
        this.add("org.jruby.RubyThread.key_p", "key?");
        this.add("org.jruby.RubyThread.keys", "keys");
        this.add("org.jruby.RubyThread.kill", "kill");
        this.add("org.jruby.RubyThread.kill_bang", "kill!");
        this.add("org.jruby.RubyThread.list", "list");
        this.add("org.jruby.RubyThread.main", "main");
        this.add("org.jruby.RubyThread.newInstance", "new");
        this.add("org.jruby.RubyThread.op_aref", "[]");
        this.add("org.jruby.RubyThread.op_aset", "[]=");
        this.add("org.jruby.RubyThread.pass", "pass");
        this.add("org.jruby.RubyThread.priority", "priority");
        this.add("org.jruby.RubyThread.priority_set", "priority=");
        this.add("org.jruby.RubyThread.raise", "raise");
        this.add("org.jruby.RubyThread.run", "run");
        this.add("org.jruby.RubyThread.s_exit", "s_exit");
        this.add("org.jruby.RubyThread.safe_level", "safe_level");
        this.add("org.jruby.RubyThread.start", "start");
        this.add("org.jruby.RubyThread.status", "status");
        this.add("org.jruby.RubyThread.stop", "stop");
        this.add("org.jruby.RubyThread.stop_p", "stop?");
        this.add("org.jruby.RubyThread.value", "value");
        this.add("org.jruby.RubyThread.wakeup", "wakeup");
        this.add("org.jruby.RubyThreadGroup.add", "add");
        this.add("org.jruby.RubyThreadGroup.enclose", "enclose");
        this.add("org.jruby.RubyThreadGroup.enclosed_p", "enclosed?");
        this.add("org.jruby.RubyThreadGroup.list", "list");
        this.add("org.jruby.RubyThreadGroup.newInstance", "new");
        this.add("org.jruby.RubyTime.asctime", "asctime");
        this.add("org.jruby.RubyTime.at", "at");
        this.add("org.jruby.RubyTime.dump", "_dump");
        this.add("org.jruby.RubyTime.eql_p", "eql?");
        this.add("org.jruby.RubyTime.getgm", "getgm");
        this.add("org.jruby.RubyTime.getlocal", "getlocal");
        this.add("org.jruby.RubyTime.gmt", "gmt?");
        this.add("org.jruby.RubyTime.gmt_offset", "gmt_offset");
        this.add("org.jruby.RubyTime.gmtime", "gmtime");
        this.add("org.jruby.RubyTime.hash", "hash");
        this.add("org.jruby.RubyTime.hour", "hour");
        this.add("org.jruby.RubyTime.initialize", "initialize");
        this.add("org.jruby.RubyTime.initialize_copy", "initialize_copy");
        this.add("org.jruby.RubyTime.isdst", "isdst");
        this.add("org.jruby.RubyTime.load", "_load");
        this.add("org.jruby.RubyTime.localtime", "localtime");
        this.add("org.jruby.RubyTime.localtime19", "localtime");
        this.add("org.jruby.RubyTime.mday", "mday");
        this.add("org.jruby.RubyTime.min", "min");
        this.add("org.jruby.RubyTime.month", "month");
        this.add("org.jruby.RubyTime.new19", "new");
        this.add("org.jruby.RubyTime.newInstance", "now");
        this.add("org.jruby.RubyTime.new_local", "local");
        this.add("org.jruby.RubyTime.new_utc", "utc");
        this.add("org.jruby.RubyTime.nsec", "nsec");
        this.add("org.jruby.RubyTime.op_cmp", "<=>");
        this.add("org.jruby.RubyTime.op_eqq", "===");
        this.add("org.jruby.RubyTime.op_equal", "==");
        this.add("org.jruby.RubyTime.op_ge", ">=");
        this.add("org.jruby.RubyTime.op_gt", ">");
        this.add("org.jruby.RubyTime.op_le", "<=");
        this.add("org.jruby.RubyTime.op_lt", "<");
        this.add("org.jruby.RubyTime.op_minus", "-");
        this.add("org.jruby.RubyTime.op_minus19", "-");
        this.add("org.jruby.RubyTime.op_plus", "+");
        this.add("org.jruby.RubyTime.op_plus19", "+");
        this.add("org.jruby.RubyTime.sec", "sec");
        this.add("org.jruby.RubyTime.strftime", "strftime");
        this.add("org.jruby.RubyTime.subsec", "subsec");
        this.add("org.jruby.RubyTime.succ", "succ");
        this.add("org.jruby.RubyTime.times", "times");
        this.add("org.jruby.RubyTime.to_a", "to_a");
        this.add("org.jruby.RubyTime.to_f", "to_f");
        this.add("org.jruby.RubyTime.to_i", "to_i");
        this.add("org.jruby.RubyTime.to_r", "to_r");
        this.add("org.jruby.RubyTime.to_s", "to_s");
        this.add("org.jruby.RubyTime.to_s19", "to_s");
        this.add("org.jruby.RubyTime.usec", "usec");
        this.add("org.jruby.RubyTime.wday", "wday");
        this.add("org.jruby.RubyTime.yday", "yday");
        this.add("org.jruby.RubyTime.year", "year");
        this.add("org.jruby.RubyTime.zone", "zone");
        this.add("org.jruby.RubyUnboundMethod.bind", "bind");
        this.add("org.jruby.RubyUnboundMethod.call", "call");
        this.add("org.jruby.RubyUnboundMethod.name", "name");
        this.add("org.jruby.RubyUnboundMethod.name19", "name");
        this.add("org.jruby.RubyUnboundMethod.owner", "owner");
        this.add("org.jruby.RubyUnboundMethod.rbClone", "clone");
        this.add("org.jruby.RubyUnboundMethod.to_proc", "to_proc");
        this.add("org.jruby.RubyUnboundMethod.unbind", "unbind");
        this.add("org.jruby.RubyYielder.initialize", "initialize");
        this.add("org.jruby.RubyYielder.op_lshift", "<<");
        this.add("org.jruby.RubyYielder.yield", "yield");
        this.add("org.jruby.demo.ext.MethodMissing.method_missing", "method_missing");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.__getobj__", "__getobj__");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.initialize", "initialize");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.marshal_dump", "marshal_dump");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.marshal_load", "marshal_load");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.method", "method");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.method_missing", "method_missing");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.repond_to_p", "respond_to?");
        this.add("org.jruby.ext.DelegateLibrary.Delegator.send", "send");
        this.add("org.jruby.ext.NetProtocolBufferedIO.NativeImpl.rbuf_fill", "rbuf_fill");
        this.add("org.jruby.ext.NetProtocolBufferedIO.initialize", "initialize");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_delete_at", "delete_at");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_each", "each");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_empty_p", "empty?");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_get", "[]");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_length", "length");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_set", "[]=");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_shift", "shift");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_to_a", "to_a");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_hist_to_s", "to_s");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_pop", "pop");
        this.add("org.jruby.ext.Readline.HistoryMethods.s_push", "push");
        this.add("org.jruby.ext.Readline.s_get_basic_word_break_character", "basic_word_break_characters");
        this.add("org.jruby.ext.Readline.s_get_completion_case_fold", "completion_case_fold");
        this.add("org.jruby.ext.Readline.s_get_line_buffer", "line_buffer");
        this.add("org.jruby.ext.Readline.s_get_point", "point");
        this.add("org.jruby.ext.Readline.s_get_screen_size", "get_screen_size");
        this.add("org.jruby.ext.Readline.s_readline", "readline");
        this.add("org.jruby.ext.Readline.s_refresh_line", "refresh_line");
        this.add("org.jruby.ext.Readline.s_set_basic_word_break_character", "basic_word_break_characters=");
        this.add("org.jruby.ext.Readline.s_set_completion_append_character", "completion_append_character=");
        this.add("org.jruby.ext.Readline.s_set_completion_case_fold", "completion_case_fold=");
        this.add("org.jruby.ext.Readline.s_set_completion_proc", "completion_proc=");
        this.add("org.jruby.ext.Readline.setInput", "input=");
        this.add("org.jruby.ext.Readline.setOutput", "output=");
        this.add("org.jruby.ext.Readline.unimplemented", "basic_quote_characters");
        this.add("org.jruby.ext.Readline.unimplemented19", "basic_quote_characters");
        this.add("org.jruby.ext.Timeout.TimeoutToplevel.timeout", "timeout");
        this.add("org.jruby.ext.Timeout.timeout", "timeout");
        this.add("org.jruby.ext.WeakRef.getobj", "__getobj__");
        this.add("org.jruby.ext.WeakRef.initialize", "initialize");
        this.add("org.jruby.ext.WeakRef.newInstance", "new");
        this.add("org.jruby.ext.WeakRef.setobj", "__setobj__");
        this.add("org.jruby.ext.WeakRef.weakref_alive_p", "weakref_alive?");
        this.add("org.jruby.ext.coverage.CoverageModule.result", "result");
        this.add("org.jruby.ext.coverage.CoverageModule.start", "start");
        this.add("org.jruby.ext.ffi.AbstractInvoker.attach", "attach");
        this.add("org.jruby.ext.ffi.AbstractMemory.aref", "[]");
        this.add("org.jruby.ext.ffi.AbstractMemory.clear", "clear");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_float", "get_array_of_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_float64", "get_array_of_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_int16", "get_array_of_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_int32", "get_array_of_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_int64", "get_array_of_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_int8", "get_array_of_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_long", "get_array_of_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_pointer", "get_array_of_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_string", "get_array_of_string");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_uint16", "get_array_of_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_uint32", "get_array_of_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_uint64", "get_array_of_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_uint8", "get_array_of_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_array_of_ulong", "get_array_of_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_bytes", "get_bytes");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_float32", "get_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_float64", "get_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_int16", "get_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_int32", "get_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_int64", "get_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_int8", "get_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_long", "get_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_pointer", "get_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_string", "get_string");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_uint16", "get_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_uint32", "get_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_uint64", "get_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_uint8", "get_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.get_ulong", "get_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.hash", "hash");
        this.add("org.jruby.ext.ffi.AbstractMemory.op_equal", "==");
        this.add("org.jruby.ext.ffi.AbstractMemory.op_plus", "+");
        this.add("org.jruby.ext.ffi.AbstractMemory.order", "order");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_float", "put_array_of_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_float64", "put_array_of_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_int16", "put_array_of_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_int32", "put_array_of_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_int64", "put_array_of_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_int8", "put_array_of_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_long", "put_array_of_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_pointer", "put_array_of_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_uint16", "put_array_of_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_uint32", "put_array_of_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_uint64", "put_array_of_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_uint8", "put_array_of_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_array_of_ulong", "put_array_of_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_bytes", "put_bytes");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_callback", "put_callback");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_float32", "put_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_float64", "put_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_int16", "put_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_int32", "put_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_int64", "put_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_int8", "put_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_long", "put_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_pointer", "put_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_string", "put_string");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_uint16", "put_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_uint32", "put_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_uint64", "put_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_uint8", "put_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.put_ulong", "put_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_float", "read_array_of_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_float64", "read_array_of_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_int16", "read_array_of_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_int32", "read_array_of_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_int64", "read_array_of_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_int8", "read_array_of_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_long", "read_array_of_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_pointer", "read_array_of_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_string", "read_array_of_string");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_uint16", "read_array_of_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_uint32", "read_array_of_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_uint64", "read_array_of_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_uint8", "read_array_of_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_array_of_ulong", "read_array_of_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_char", "read_char");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_double", "read_double");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_float", "read_float");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_int", "read_int");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_long", "read_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_long_long", "read_long_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_pointer", "read_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_short", "read_short");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_string", "read_string");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_uchar", "read_uchar");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_uint", "read_uint");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_ulong", "read_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_ulong_long", "read_ulong_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.read_ushort", "read_ushort");
        this.add("org.jruby.ext.ffi.AbstractMemory.to_s", "to_s");
        this.add("org.jruby.ext.ffi.AbstractMemory.total", "total");
        this.add("org.jruby.ext.ffi.AbstractMemory.type_size", "type_size");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_float", "write_array_of_float32");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_float64", "write_array_of_float64");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_int16", "write_array_of_int16");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_int32", "write_array_of_int32");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_int64", "write_array_of_int64");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_int8", "write_array_of_int8");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_long", "write_array_of_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_pointer", "write_array_of_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_uint16", "write_array_of_uint16");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_uint32", "write_array_of_uint32");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_uint64", "write_array_of_uint64");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_uint8", "write_array_of_uint8");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_array_of_ulong", "write_array_of_ulong");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_char", "write_char");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_double", "write_double");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_float", "write_float");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_int", "write_int");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_long", "write_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_long_long", "write_long_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_pointer", "write_pointer");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_short", "write_short");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_uchar", "write_uchar");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_uint", "write_uint");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_ulong_long", "write_ulong_long");
        this.add("org.jruby.ext.ffi.AbstractMemory.write_ushort", "write_ushort");
        this.add("org.jruby.ext.ffi.AutoPointer.autorelease", "autorelease=");
        this.add("org.jruby.ext.ffi.AutoPointer.free", "free");
        this.add("org.jruby.ext.ffi.AutoPointer.from_native", "from_native");
        this.add("org.jruby.ext.ffi.AutoPointer.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Buffer.allocateInOut", "alloc_inout");
        this.add("org.jruby.ext.ffi.Buffer.allocateInput", "new_in");
        this.add("org.jruby.ext.ffi.Buffer.allocateOutput", "new_out");
        this.add("org.jruby.ext.ffi.Buffer.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Buffer.initialize_copy", "initialize_copy");
        this.add("org.jruby.ext.ffi.Buffer.inspect", "inspect");
        this.add("org.jruby.ext.ffi.CallbackInfo.newCallbackInfo", "new");
        this.add("org.jruby.ext.ffi.CallbackInfo.param_types", "param_types");
        this.add("org.jruby.ext.ffi.CallbackInfo.result_type", "result_type");
        this.add("org.jruby.ext.ffi.CallbackInfo.to_s", "to_s");
        this.add("org.jruby.ext.ffi.DataConverter.from_native", "from_native");
        this.add("org.jruby.ext.ffi.DataConverter.native_type", "native_type");
        this.add("org.jruby.ext.ffi.DataConverter.to_native", "to_native");
        this.add("org.jruby.ext.ffi.Enum.find", "[]");
        this.add("org.jruby.ext.ffi.Enum.from_native", "from_native");
        this.add("org.jruby.ext.ffi.Enum.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Enum.native_type", "native_type");
        this.add("org.jruby.ext.ffi.Enum.symbol_map", "symbol_map");
        this.add("org.jruby.ext.ffi.Enum.symbols", "symbols");
        this.add("org.jruby.ext.ffi.Enum.tag", "tag");
        this.add("org.jruby.ext.ffi.Enum.to_native", "to_native");
        this.add("org.jruby.ext.ffi.IOModule.native_read", "native_read");
        this.add("org.jruby.ext.ffi.MappedType.from_native", "from_native");
        this.add("org.jruby.ext.ffi.MappedType.native_type", "native_type");
        this.add("org.jruby.ext.ffi.MappedType.newMappedType", "new");
        this.add("org.jruby.ext.ffi.MappedType.to_native", "to_native");
        this.add("org.jruby.ext.ffi.MemoryPointer.autorelease", "autorelease=");
        this.add("org.jruby.ext.ffi.MemoryPointer.free", "free");
        this.add("org.jruby.ext.ffi.MemoryPointer.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Platform.bsd_p", "bsd?");
        this.add("org.jruby.ext.ffi.Platform.linux_p", "linux?");
        this.add("org.jruby.ext.ffi.Platform.mac_p", "mac?");
        this.add("org.jruby.ext.ffi.Platform.solaris_p", "solaris?");
        this.add("org.jruby.ext.ffi.Platform.unix_p", "unix?");
        this.add("org.jruby.ext.ffi.Platform.windows_p", "windows?");
        this.add("org.jruby.ext.ffi.Pointer.address", "address");
        this.add("org.jruby.ext.ffi.Pointer.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Pointer.initialize_copy", "initialize_copy");
        this.add("org.jruby.ext.ffi.Pointer.null_p", "null?");
        this.add("org.jruby.ext.ffi.Pointer.to_s", "to_s");
        this.add("org.jruby.ext.ffi.Struct.allocateIn", "new_in");
        this.add("org.jruby.ext.ffi.Struct.allocateInOut", "new_inout");
        this.add("org.jruby.ext.ffi.Struct.allocateOut", "new_out");
        this.add("org.jruby.ext.ffi.Struct.getFieldValue", "[]");
        this.add("org.jruby.ext.ffi.Struct.getLayout", "cspec");
        this.add("org.jruby.ext.ffi.Struct.initialize", "initialize");
        this.add("org.jruby.ext.ffi.Struct.initialize_copy", "initialize_copy");
        this.add("org.jruby.ext.ffi.Struct.members", "members");
        this.add("org.jruby.ext.ffi.Struct.null_p", "null?");
        this.add("org.jruby.ext.ffi.Struct.order", "order");
        this.add("org.jruby.ext.ffi.Struct.pointer", "pointer");
        this.add("org.jruby.ext.ffi.Struct.setFieldValue", "[]=");
        this.add("org.jruby.ext.ffi.StructByReference.from_native", "from_native");
        this.add("org.jruby.ext.ffi.StructByReference.layout", "layout");
        this.add("org.jruby.ext.ffi.StructByReference.native_type", "native_type");
        this.add("org.jruby.ext.ffi.StructByReference.newStructByReference", "new");
        this.add("org.jruby.ext.ffi.StructByReference.struct_class", "struct_class");
        this.add("org.jruby.ext.ffi.StructByReference.to_native", "to_native");
        this.add("org.jruby.ext.ffi.StructByReference.to_s", "to_s");
        this.add("org.jruby.ext.ffi.StructByValue.layout", "layout");
        this.add("org.jruby.ext.ffi.StructByValue.newStructByValue", "new");
        this.add("org.jruby.ext.ffi.StructByValue.struct_class", "struct_class");
        this.add("org.jruby.ext.ffi.StructByValue.to_s", "to_s");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayField.initialize", "initialize");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.each", "each");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.get", "[]");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.get", "to_a");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.put", "[]=");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.size", "size");
        this.add("org.jruby.ext.ffi.StructLayout.ArrayProxy.to_ptr", "to_ptr");
        this.add("org.jruby.ext.ffi.StructLayout.CharArrayProxy.to_s", "to_s");
        this.add("org.jruby.ext.ffi.StructLayout.Field.alignment", "alignment");
        this.add("org.jruby.ext.ffi.StructLayout.Field.initialize", "initialize");
        this.add("org.jruby.ext.ffi.StructLayout.Field.name", "name");
        this.add("org.jruby.ext.ffi.StructLayout.Field.offset", "offset");
        this.add("org.jruby.ext.ffi.StructLayout.Field.size", "size");
        this.add("org.jruby.ext.ffi.StructLayout.Field.type", "type");
        this.add("org.jruby.ext.ffi.StructLayout.FunctionField.initialize", "initialize");
        this.add("org.jruby.ext.ffi.StructLayout.InnerStructField.initialize", "initialize");
        this.add("org.jruby.ext.ffi.StructLayout.MappedField.initialize", "initialize");
        this.add("org.jruby.ext.ffi.StructLayout.aref", "[]");
        this.add("org.jruby.ext.ffi.StructLayout.fields", "fields");
        this.add("org.jruby.ext.ffi.StructLayout.get", "get");
        this.add("org.jruby.ext.ffi.StructLayout.members", "members");
        this.add("org.jruby.ext.ffi.StructLayout.newStructLayout", "new");
        this.add("org.jruby.ext.ffi.StructLayout.offsets", "offsets");
        this.add("org.jruby.ext.ffi.StructLayout.put", "put");
        this.add("org.jruby.ext.ffi.Type.Array.elem_type", "elem_type");
        this.add("org.jruby.ext.ffi.Type.Array.length", "length");
        this.add("org.jruby.ext.ffi.Type.Array.newInstance", "new");
        this.add("org.jruby.ext.ffi.Type.Builtin.eql_p", "eql?");
        this.add("org.jruby.ext.ffi.Type.Builtin.equal_p", "equal?");
        this.add("org.jruby.ext.ffi.Type.Builtin.op_equal", "==");
        this.add("org.jruby.ext.ffi.Type.Builtin.to_s", "to_s");
        this.add("org.jruby.ext.ffi.Type.Builtin.to_sym", "to_sym");
        this.add("org.jruby.ext.ffi.Type.alignment", "alignment");
        this.add("org.jruby.ext.ffi.Type.size", "size");
        this.add("org.jruby.ext.ffi.io.FileDescriptorIO.newInstance", "new");
        this.add("org.jruby.ext.ffi.io.FileDescriptorIO.wrap", "wrap");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.Symbol.inspect", "inspect");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.Symbol.library", "library");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.Symbol.to_s", "to_s");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.findFunction", "find_function");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.findVariable", "find_variable");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.name", "name");
        this.add("org.jruby.ext.ffi.jffi.DynamicLibrary.open", "open");
        this.add("org.jruby.ext.ffi.jffi.Factory.LastError.error", "error");
        this.add("org.jruby.ext.ffi.jffi.Factory.LastError.error_set", "error=");
        this.add("org.jruby.ext.ffi.jffi.Function.autorelease", "autorelease=");
        this.add("org.jruby.ext.ffi.jffi.Function.autorelease_p", "autorelease?");
        this.add("org.jruby.ext.ffi.jffi.Function.free", "free");
        this.add("org.jruby.ext.ffi.jffi.Function.newInstance", "new");
        this.add("org.jruby.ext.ffi.jffi.JFFIInvoker.newInstance", "new");
        this.add("org.jruby.ext.ffi.jffi.VariadicInvoker.invoke", "invoke");
        this.add("org.jruby.ext.ffi.jffi.VariadicInvoker.newInvoker", "__new");
        this.add("org.jruby.ext.fiber.Fiber.initialize", "initialize");
        this.add("org.jruby.ext.fiber.Fiber.resume", "resume");
        this.add("org.jruby.ext.fiber.Fiber.transfer", "transfer");
        this.add("org.jruby.ext.fiber.FiberExtLibrary.FiberExtMeta.alive_p", "alive?");
        this.add("org.jruby.ext.fiber.FiberExtLibrary.FiberExtMeta.current", "current");
        this.add("org.jruby.ext.fiber.FiberMeta.yield", "yield");
        this.add("org.jruby.ext.jruby.JRubyTypeLibrary.coerce_to", "coerce_to");
        this.add("org.jruby.ext.jruby.JRubyUtilLibrary.gc", "gc");
        this.add("org.jruby.ext.jruby.JRubyUtilLibrary.getClassLoaderResources", "classloader_resources");
        this.add("org.jruby.ext.jruby.JRubyUtilLibrary.getObjectSpaceEnabled", "objectspace");
        this.add("org.jruby.ext.jruby.JRubyUtilLibrary.setObjectSpaceEnabled", "objectspace=");
        this.add("org.jruby.ext.psych.PsychEmitter.alias", "alias");
        this.add("org.jruby.ext.psych.PsychEmitter.canonical", "canonical");
        this.add("org.jruby.ext.psych.PsychEmitter.canonical_set", "canonical=");
        this.add("org.jruby.ext.psych.PsychEmitter.end_document", "end_document");
        this.add("org.jruby.ext.psych.PsychEmitter.end_mapping", "end_mapping");
        this.add("org.jruby.ext.psych.PsychEmitter.end_sequence", "end_sequence");
        this.add("org.jruby.ext.psych.PsychEmitter.end_stream", "end_stream");
        this.add("org.jruby.ext.psych.PsychEmitter.indentation", "indentation");
        this.add("org.jruby.ext.psych.PsychEmitter.indentation_set", "indentation=");
        this.add("org.jruby.ext.psych.PsychEmitter.initialize", "initialize");
        this.add("org.jruby.ext.psych.PsychEmitter.scalar", "scalar");
        this.add("org.jruby.ext.psych.PsychEmitter.start_document", "start_document");
        this.add("org.jruby.ext.psych.PsychEmitter.start_mapping", "start_mapping");
        this.add("org.jruby.ext.psych.PsychEmitter.start_sequence", "start_sequence");
        this.add("org.jruby.ext.psych.PsychEmitter.start_stream", "start_stream");
        this.add("org.jruby.ext.psych.PsychParser.external_encoding_set", "external_encoding=");
        this.add("org.jruby.ext.psych.PsychParser.parse", "parse");
        this.add("org.jruby.ext.psych.PsychToRuby.build_exception", "build_exception");
        this.add("org.jruby.ext.psych.PsychToRuby.path2class", "path2class");
        this.add("org.jruby.ext.psych.PsychYamlTree.private_iv_get", "private_iv_get");
        this.add("org.jruby.ext.socket.RubyBasicSocket.do_not_reverse_lookup", "do_not_reverse_lookup");
        this.add("org.jruby.ext.socket.RubyBasicSocket.do_not_reverse_lookup19", "do_not_reverse_lookup19");
        this.add("org.jruby.ext.socket.RubyBasicSocket.getpeername", "getpeername");
        this.add("org.jruby.ext.socket.RubyBasicSocket.getsockname", "getsockname");
        this.add("org.jruby.ext.socket.RubyBasicSocket.getsockname_u", "__getsockname");
        this.add("org.jruby.ext.socket.RubyBasicSocket.getsockopt", "getsockopt");
        this.add("org.jruby.ext.socket.RubyBasicSocket.recv", "recv");
        this.add("org.jruby.ext.socket.RubyBasicSocket.set_do_not_reverse_lookup", "do_not_reverse_lookup=");
        this.add("org.jruby.ext.socket.RubyBasicSocket.set_do_not_reverse_lookup19", "do_not_reverse_lookup=");
        this.add("org.jruby.ext.socket.RubyBasicSocket.setsockopt", "setsockopt");
        this.add("org.jruby.ext.socket.RubyBasicSocket.shutdown", "shutdown");
        this.add("org.jruby.ext.socket.RubyBasicSocket.write_send", "send");
        this.add("org.jruby.ext.socket.RubyIPSocket.addr", "addr");
        this.add("org.jruby.ext.socket.RubyIPSocket.addr19", "addr");
        this.add("org.jruby.ext.socket.RubyIPSocket.getaddress", "getaddress");
        this.add("org.jruby.ext.socket.RubyIPSocket.peeraddr", "peeraddr");
        this.add("org.jruby.ext.socket.RubyIPSocket.peeraddr19", "peeraddr");
        this.add("org.jruby.ext.socket.RubyIPSocket.recvfrom", "recvfrom");
        this.add("org.jruby.ext.socket.RubySocket.bind", "bind");
        this.add("org.jruby.ext.socket.RubySocket.connect", "connect");
        this.add("org.jruby.ext.socket.RubySocket.connect_nonblock", "connect_nonblock");
        this.add("org.jruby.ext.socket.RubySocket.for_fd", "for_fd");
        this.add("org.jruby.ext.socket.RubySocket.getaddrinfo", "getaddrinfo");
        this.add("org.jruby.ext.socket.RubySocket.gethostbyaddr", "gethostbyaddr");
        this.add("org.jruby.ext.socket.RubySocket.gethostbyname", "gethostbyname");
        this.add("org.jruby.ext.socket.RubySocket.gethostname", "gethostname");
        this.add("org.jruby.ext.socket.RubySocket.getnameinfo", "getnameinfo");
        this.add("org.jruby.ext.socket.RubySocket.getservbyname", "getservbyname");
        this.add("org.jruby.ext.socket.RubySocket.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubySocket.listen", "listen");
        this.add("org.jruby.ext.socket.RubySocket.pack_sockaddr_in", "pack_sockaddr_in");
        this.add("org.jruby.ext.socket.RubySocket.pack_sockaddr_un", "pack_sockaddr_un");
        this.add("org.jruby.ext.socket.RubySocket.unpack_sockaddr_in", "unpack_sockaddr_in");
        this.add("org.jruby.ext.socket.RubyTCPServer.accept", "accept");
        this.add("org.jruby.ext.socket.RubyTCPServer.accept_nonblock", "accept_nonblock");
        this.add("org.jruby.ext.socket.RubyTCPServer.getpeername", "getpeername");
        this.add("org.jruby.ext.socket.RubyTCPServer.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubyTCPServer.listen", "listen");
        this.add("org.jruby.ext.socket.RubyTCPServer.open", "open");
        this.add("org.jruby.ext.socket.RubyTCPServer.peeraddr", "peeraddr");
        this.add("org.jruby.ext.socket.RubyTCPSocket.gethostbyname", "gethostbyname");
        this.add("org.jruby.ext.socket.RubyTCPSocket.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubyTCPSocket.open", "open");
        this.add("org.jruby.ext.socket.RubyUDPSocket.bind", "bind");
        this.add("org.jruby.ext.socket.RubyUDPSocket.connect", "connect");
        this.add("org.jruby.ext.socket.RubyUDPSocket.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubyUDPSocket.open", "open");
        this.add("org.jruby.ext.socket.RubyUDPSocket.recvfrom", "recvfrom");
        this.add("org.jruby.ext.socket.RubyUDPSocket.send", "send");
        this.add("org.jruby.ext.socket.RubyUNIXServer.accept", "accept");
        this.add("org.jruby.ext.socket.RubyUNIXServer.accept_nonblock", "accept_nonblock");
        this.add("org.jruby.ext.socket.RubyUNIXServer.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubyUNIXServer.listen", "listen");
        this.add("org.jruby.ext.socket.RubyUNIXServer.sysaccept", "sysaccept");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.addr", "addr");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.initialize", "initialize");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.open", "open");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.path", "path");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.peeraddr", "peeraddr");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.recv_io", "recv_io");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.recvfrom", "recvfrom");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.send_io", "send_io");
        this.add("org.jruby.ext.socket.RubyUNIXSocket.socketpair", "socketpair");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate._initialize", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.append", "<<");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.deflate", "deflate");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.flush", "flush");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.initialize_copy", "initialize_copy");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.params", "params");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.s_deflate", "deflate");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibDeflate.set_dictionary", "set_dictionary");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate._initialize", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.append", "<<");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.flush_next_out", "flush_next_out");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.inflate", "inflate");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.s_inflate", "inflate");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.set_dictionary", "set_dictionary");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.sync", "sync");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibInflate.sync_point_p", "sync_point?");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.close", "close");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.comment", "comment");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.crc", "crc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.each", "each");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.each_byte", "each_byte");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.each_line", "each_line");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.eof", "eof");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.eof_p", "eof?");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.getbyte", "getbyte");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.getc", "getc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.getc_19", "getc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.gets", "gets");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.gets_18", "gets");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.initialize", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.initialize19", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.lineno", "lineno");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.newInstance", "new");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.open18", "open");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.open19", "open");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.orig_name", "orig_name");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.os_code", "os_code");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.pos", "pos");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.read", "read");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.readchar", "readchar");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.readline", "readline");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.readlines", "readlines");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.readpartial", "readpartial");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.rewind", "rewind");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.set_lineno", "lineno=");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.ungetc", "ungetc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipReader.unused", "unused");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.append", "append");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.close", "close");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.crc", "crc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.flush", "flush");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.initialize", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.initialize19", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.newInstance", "new");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.open18", "open");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.open19", "open");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.pos", "pos");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.print", "print");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.printf", "printf");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.putc", "putc");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.puts", "puts");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.set_comment", "comment=");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.set_mtime", "mtime=");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.set_orig_name", "orig_name=");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.set_sync", "set_sync");
        this.add("org.jruby.ext.zlib.RubyZlib.JZlibRubyGzipWriter.write", "write");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.close", "close");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.closed_p", "closed?");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.comment", "comment");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.crc", "crc");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.finish", "finish");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.level", "level");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.mtime", "mtime");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.newInstance", "new");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.orig_name", "orig_name");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.os_code", "os_code");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.set_sync", "sync=");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.sync", "sync");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.to_io", "to_io");
        this.add("org.jruby.ext.zlib.RubyZlib.RubyGzipFile.wrap", "wrap");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.adler", "adler");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.avail_in", "avail_in");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.avail_out", "avail_out");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.close", "close");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.closed_p", "closed?");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.data_type", "data_type");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.finish", "finish");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.finished_p", "finished?");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.flush_next_in", "flush_next_in");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.flush_next_out", "flush_next_out");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.initialize", "initialize");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.reset", "reset");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.set_avail_out", "avail_out=");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.stream_end_p", "stream_end?");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.total_in", "total_in");
        this.add("org.jruby.ext.zlib.RubyZlib.ZStream.total_out", "total_out");
        this.add("org.jruby.ext.zlib.RubyZlib.adler32", "adler32");
        this.add("org.jruby.ext.zlib.RubyZlib.adler32_combine", "adler32_combine");
        this.add("org.jruby.ext.zlib.RubyZlib.crc32", "crc32");
        this.add("org.jruby.ext.zlib.RubyZlib.crc32_combine", "crc32_combine");
        this.add("org.jruby.ext.zlib.RubyZlib.crc_table", "crc_table");
        this.add("org.jruby.ext.zlib.RubyZlib.zlib_version", "zlib_version");
        this.add("org.jruby.java.addons.ArrayJavaAddons.copy_data", "copy_data");
        this.add("org.jruby.java.addons.ArrayJavaAddons.copy_data_simple", "copy_data_simple");
        this.add("org.jruby.java.addons.ArrayJavaAddons.dimensions", "dimensions");
        this.add("org.jruby.java.addons.IOJavaAddons.AnyIO.any_to_channel", "to_channel");
        this.add("org.jruby.java.addons.IOJavaAddons.AnyIO.any_to_inputstream", "to_inputstream");
        this.add("org.jruby.java.addons.IOJavaAddons.AnyIO.any_to_outputstream", "to_outputstream");
        this.add("org.jruby.java.addons.IOJavaAddons.to_channel", "to_channel");
        this.add("org.jruby.java.addons.IOJavaAddons.to_inputstream", "to_inputstream");
        this.add("org.jruby.java.addons.IOJavaAddons.to_outputstream", "to_outputstream");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_annotation", "java_annotation");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_implements", "java_implements");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_name", "java_name");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_package", "java_package");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_require", "java_require");
        this.add("org.jruby.java.addons.KernelJavaAddons.java_signature", "java_signature");
        this.add("org.jruby.java.addons.KernelJavaAddons.to_java", "to_java");
        this.add("org.jruby.java.addons.StringJavaAddons.from_java_bytes", "from_java_bytes");
        this.add("org.jruby.java.addons.StringJavaAddons.to_java_bytes", "to_java_bytes");
        this.add("org.jruby.java.addons.StringJavaAddons.to_java_string", "to_java_string");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.at", "at");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.each", "each");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.empty", "empty?");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.length", "length");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.op_aref", "[]");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.op_aset", "[]=");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.op_plus", "+");
        this.add("org.jruby.java.proxies.ArrayJavaProxy.to_a", "to_a");
        this.add("org.jruby.java.proxies.ArrayJavaProxyCreator._new", "new");
        this.add("org.jruby.java.proxies.ArrayJavaProxyCreator.op_aref", "op_aref");
        this.add("org.jruby.java.proxies.InterfaceJavaProxy.JavaInterfaceExtender.extend_proxy", "extend_proxy");
        this.add("org.jruby.java.proxies.InterfaceJavaProxy.JavaInterfaceExtender.initialize", "initialize");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.append_features", "append_features");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.extended", "extended");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.impl", "impl");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.implement", "implement");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.op_aref", "[]");
        this.add("org.jruby.java.proxies.JavaInterfaceTemplate.rbNew", "new");
        this.add("org.jruby.java.proxies.JavaProxy.equal_p", "equal?");
        this.add("org.jruby.java.proxies.JavaProxy.field_accessor", "field_accessor");
        this.add("org.jruby.java.proxies.JavaProxy.field_reader", "field_reader");
        this.add("org.jruby.java.proxies.JavaProxy.field_writer", "field_writer");
        this.add("org.jruby.java.proxies.JavaProxy.inherited", "inherited");
        this.add("org.jruby.java.proxies.JavaProxy.java_method", "java_method");
        this.add("org.jruby.java.proxies.JavaProxy.java_send", "java_send");
        this.add("org.jruby.java.proxies.JavaProxy.marshal_dump", "marshal_dump");
        this.add("org.jruby.java.proxies.JavaProxy.marshal_load", "marshal_load");
        this.add("org.jruby.java.proxies.JavaProxy.op_aref", "[]");
        this.add("org.jruby.java.proxies.JavaProxy.singleton_class", "singleton_class");
        this.add("org.jruby.java.proxies.MapJavaProxy.assoc", "assoc");
        this.add("org.jruby.java.proxies.MapJavaProxy.default_proc", "default_proc");
        this.add("org.jruby.java.proxies.MapJavaProxy.default_value_get", "default");
        this.add("org.jruby.java.proxies.MapJavaProxy.default_value_set", "default=");
        this.add("org.jruby.java.proxies.MapJavaProxy.delete", "delete");
        this.add("org.jruby.java.proxies.MapJavaProxy.delete_if", "delete_if");
        this.add("org.jruby.java.proxies.MapJavaProxy.each", "each");
        this.add("org.jruby.java.proxies.MapJavaProxy.each19", "each");
        this.add("org.jruby.java.proxies.MapJavaProxy.each_key", "each_key");
        this.add("org.jruby.java.proxies.MapJavaProxy.each_pair", "each_pair");
        this.add("org.jruby.java.proxies.MapJavaProxy.each_value", "each_value");
        this.add("org.jruby.java.proxies.MapJavaProxy.empty_p", "empty?");
        this.add("org.jruby.java.proxies.MapJavaProxy.fetch", "fetch");
        this.add("org.jruby.java.proxies.MapJavaProxy.flatten", "flatten");
        this.add("org.jruby.java.proxies.MapJavaProxy.getCompareByIdentity", "compare_by_identity");
        this.add("org.jruby.java.proxies.MapJavaProxy.getCompareByIdentity_p", "compare_by_identity?");
        this.add("org.jruby.java.proxies.MapJavaProxy.has_key_p", "has_key?");
        this.add("org.jruby.java.proxies.MapJavaProxy.has_value_p", "has_value?");
        this.add("org.jruby.java.proxies.MapJavaProxy.hash", "hash");
        this.add("org.jruby.java.proxies.MapJavaProxy.hash19", "hash");
        this.add("org.jruby.java.proxies.MapJavaProxy.index", "index");
        this.add("org.jruby.java.proxies.MapJavaProxy.index19", "index");
        this.add("org.jruby.java.proxies.MapJavaProxy.indices", "indexes");
        this.add("org.jruby.java.proxies.MapJavaProxy.initialize_copy", "initialize_copy");
        this.add("org.jruby.java.proxies.MapJavaProxy.initialize_copy19", "initialize_copy");
        this.add("org.jruby.java.proxies.MapJavaProxy.inspect", "inspect");
        this.add("org.jruby.java.proxies.MapJavaProxy.invert", "invert");
        this.add("org.jruby.java.proxies.MapJavaProxy.keep_if", "keep_if");
        this.add("org.jruby.java.proxies.MapJavaProxy.key", "key");
        this.add("org.jruby.java.proxies.MapJavaProxy.keys", "keys");
        this.add("org.jruby.java.proxies.MapJavaProxy.merge", "merge");
        this.add("org.jruby.java.proxies.MapJavaProxy.merge_bang", "merge!");
        this.add("org.jruby.java.proxies.MapJavaProxy.merge_bang19", "merge!");
        this.add("org.jruby.java.proxies.MapJavaProxy.op_aref", "[]");
        this.add("org.jruby.java.proxies.MapJavaProxy.op_aset", "[]=");
        this.add("org.jruby.java.proxies.MapJavaProxy.op_aset19", "[]=");
        this.add("org.jruby.java.proxies.MapJavaProxy.op_eql19", "eql?");
        this.add("org.jruby.java.proxies.MapJavaProxy.op_equal", "==");
        this.add("org.jruby.java.proxies.MapJavaProxy.rassoc", "rassoc");
        this.add("org.jruby.java.proxies.MapJavaProxy.rb_clear", "clear");
        this.add("org.jruby.java.proxies.MapJavaProxy.rb_size", "size");
        this.add("org.jruby.java.proxies.MapJavaProxy.rb_values", "values");
        this.add("org.jruby.java.proxies.MapJavaProxy.rehash", "rehash");
        this.add("org.jruby.java.proxies.MapJavaProxy.reject", "reject");
        this.add("org.jruby.java.proxies.MapJavaProxy.reject_bang", "reject!");
        this.add("org.jruby.java.proxies.MapJavaProxy.replace", "replace");
        this.add("org.jruby.java.proxies.MapJavaProxy.replace19", "replace");
        this.add("org.jruby.java.proxies.MapJavaProxy.select", "select");
        this.add("org.jruby.java.proxies.MapJavaProxy.select19", "select");
        this.add("org.jruby.java.proxies.MapJavaProxy.select_bang", "select!");
        this.add("org.jruby.java.proxies.MapJavaProxy.set_default_proc", "default_proc=");
        this.add("org.jruby.java.proxies.MapJavaProxy.shift", "shift");
        this.add("org.jruby.java.proxies.MapJavaProxy.sort", "sort");
        this.add("org.jruby.java.proxies.MapJavaProxy.to_a", "to_a");
        this.add("org.jruby.java.proxies.MapJavaProxy.to_hash", "to_hash");
        this.add("org.jruby.java.proxies.MapJavaProxy.to_s", "to_s");
        this.add("org.jruby.java.proxies.MapJavaProxy.to_s19", "to_s");
        this.add("org.jruby.java.proxies.MapJavaProxy.values_at", "values_at");
        this.add("org.jruby.javasupport.Java.JavaProxyClassMethods.java_alias", "java_alias");
        this.add("org.jruby.javasupport.Java.JavaProxyClassMethods.java_method", "java_method");
        this.add("org.jruby.javasupport.Java.JavaProxyClassMethods.java_send", "java_send");
        this.add("org.jruby.javasupport.Java.NewStyleExtensionInherited.inherited", "inherited");
        this.add("org.jruby.javasupport.Java.OldStyleExtensionInherited.inherited", "inherited");
        this.add("org.jruby.javasupport.Java.java_to_primitive", "java_to_primitive");
        this.add("org.jruby.javasupport.Java.java_to_ruby", "java_to_ruby");
        this.add("org.jruby.javasupport.Java.new_proxy_instance2", "new_proxy_instance2");
        this.add("org.jruby.javasupport.Java.ruby_to_java", "ruby_to_java");
        this.add("org.jruby.javasupport.JavaAccessibleObject.annotation", "annotation");
        this.add("org.jruby.javasupport.JavaAccessibleObject.annotation_present_p", "annotation_present?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.annotations", "annotations");
        this.add("org.jruby.javasupport.JavaAccessibleObject.annotations_p", "annotations?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.declared_annotations", "declared_annotations");
        this.add("org.jruby.javasupport.JavaAccessibleObject.declared_annotations_p", "declared_annotations?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.declaring_class", "declaring_class");
        this.add("org.jruby.javasupport.JavaAccessibleObject.hash", "hash");
        this.add("org.jruby.javasupport.JavaAccessibleObject.isAccessible", "accessible?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.modifiers", "modifiers");
        this.add("org.jruby.javasupport.JavaAccessibleObject.name", "name");
        this.add("org.jruby.javasupport.JavaAccessibleObject.op_equal", "==");
        this.add("org.jruby.javasupport.JavaAccessibleObject.same", "equal?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.setAccessible", "accessible=");
        this.add("org.jruby.javasupport.JavaAccessibleObject.synthetic_p", "synthetic?");
        this.add("org.jruby.javasupport.JavaAccessibleObject.to_string", "to_s");
        this.add("org.jruby.javasupport.JavaArrayUtilities.bytes_to_ruby_string", "bytes_to_ruby_string");
        this.add("org.jruby.javasupport.JavaArrayUtilities.java_to_ruby", "java_to_ruby");
        this.add("org.jruby.javasupport.JavaArrayUtilities.ruby_string_to_bytes", "ruby_string_to_bytes");
        this.add("org.jruby.javasupport.JavaCallable.argument_types", "argument_types");
        this.add("org.jruby.javasupport.JavaCallable.arity", "arity");
        this.add("org.jruby.javasupport.JavaCallable.exception_types", "exception_types");
        this.add("org.jruby.javasupport.JavaCallable.generic_exception_types", "generic_exception_types");
        this.add("org.jruby.javasupport.JavaCallable.generic_parameter_types", "generic_parameter_types");
        this.add("org.jruby.javasupport.JavaCallable.inspect", "inspect");
        this.add("org.jruby.javasupport.JavaCallable.parameter_annotations", "parameter_annotations");
        this.add("org.jruby.javasupport.JavaCallable.parameter_types", "parameter_types");
        this.add("org.jruby.javasupport.JavaCallable.public_p", "public?");
        this.add("org.jruby.javasupport.JavaCallable.to_generic_string", "to_generic_string");
        this.add("org.jruby.javasupport.JavaCallable.varargs_p", "varargs?");
        this.add("org.jruby.javasupport.JavaClass.annotation", "annotation");
        this.add("org.jruby.javasupport.JavaClass.annotation_p", "annotation?");
        this.add("org.jruby.javasupport.JavaClass.annotation_present_p", "annotation_present?");
        this.add("org.jruby.javasupport.JavaClass.annotations", "annotations");
        this.add("org.jruby.javasupport.JavaClass.annotations_p", "annotations?");
        this.add("org.jruby.javasupport.JavaClass.anonymous_class_p", "anonymous_class?");
        this.add("org.jruby.javasupport.JavaClass.array_class", "array_class");
        this.add("org.jruby.javasupport.JavaClass.array_p", "array?");
        this.add("org.jruby.javasupport.JavaClass.assignable_from_p", "assignable_from?");
        this.add("org.jruby.javasupport.JavaClass.canonical_name", "canonical_name");
        this.add("org.jruby.javasupport.JavaClass.class_loader", "class_loader");
        this.add("org.jruby.javasupport.JavaClass.classes", "classes");
        this.add("org.jruby.javasupport.JavaClass.component_type", "component_type");
        this.add("org.jruby.javasupport.JavaClass.constructor", "constructor");
        this.add("org.jruby.javasupport.JavaClass.constructors", "constructors");
        this.add("org.jruby.javasupport.JavaClass.declared_annotations", "declared_annotations");
        this.add("org.jruby.javasupport.JavaClass.declared_annotations_p", "declared_annotations?");
        this.add("org.jruby.javasupport.JavaClass.declared_class_methods", "declared_class_methods");
        this.add("org.jruby.javasupport.JavaClass.declared_classes", "declared_classes");
        this.add("org.jruby.javasupport.JavaClass.declared_constructor", "declared_constructor");
        this.add("org.jruby.javasupport.JavaClass.declared_constructors", "declared_constructors");
        this.add("org.jruby.javasupport.JavaClass.declared_field", "declared_field");
        this.add("org.jruby.javasupport.JavaClass.declared_fields", "declared_fields");
        this.add("org.jruby.javasupport.JavaClass.declared_instance_methods", "declared_instance_methods");
        this.add("org.jruby.javasupport.JavaClass.declared_method", "declared_method");
        this.add("org.jruby.javasupport.JavaClass.declared_method_smart", "declared_method_smart");
        this.add("org.jruby.javasupport.JavaClass.declaring_class", "declaring_class");
        this.add("org.jruby.javasupport.JavaClass.enclosing_class", "enclosing_class");
        this.add("org.jruby.javasupport.JavaClass.enclosing_constructor", "enclosing_constructor");
        this.add("org.jruby.javasupport.JavaClass.enclosing_method", "enclosing_method");
        this.add("org.jruby.javasupport.JavaClass.enum_constants", "enum_constants");
        this.add("org.jruby.javasupport.JavaClass.enum_p", "enum?");
        this.add("org.jruby.javasupport.JavaClass.extend_proxy", "extend_proxy");
        this.add("org.jruby.javasupport.JavaClass.field", "field");
        this.add("org.jruby.javasupport.JavaClass.fields", "fields");
        this.add("org.jruby.javasupport.JavaClass.final_p", "final?");
        this.add("org.jruby.javasupport.JavaClass.for_name", "for_name");
        this.add("org.jruby.javasupport.JavaClass.generic_interfaces", "generic_interfaces");
        this.add("org.jruby.javasupport.JavaClass.generic_superclass", "generic_superclass");
        this.add("org.jruby.javasupport.JavaClass.get_package", "package");
        this.add("org.jruby.javasupport.JavaClass.inspect", "inspect");
        this.add("org.jruby.javasupport.JavaClass.interface_p", "interface?");
        this.add("org.jruby.javasupport.JavaClass.interfaces", "interfaces");
        this.add("org.jruby.javasupport.JavaClass.java_class_methods", "java_class_methods");
        this.add("org.jruby.javasupport.JavaClass.java_instance_methods", "java_instance_methods");
        this.add("org.jruby.javasupport.JavaClass.java_method", "java_method");
        this.add("org.jruby.javasupport.JavaClass.local_class_p", "local_class?");
        this.add("org.jruby.javasupport.JavaClass.member_class_p", "member_class?");
        this.add("org.jruby.javasupport.JavaClass.modifiers", "modifiers");
        this.add("org.jruby.javasupport.JavaClass.name", "name");
        this.add("org.jruby.javasupport.JavaClass.new_array", "new_array");
        this.add("org.jruby.javasupport.JavaClass.op_cmp", "<=>");
        this.add("org.jruby.javasupport.JavaClass.primitive_p", "primitive?");
        this.add("org.jruby.javasupport.JavaClass.private_p", "private?");
        this.add("org.jruby.javasupport.JavaClass.protected_p", "protected?");
        this.add("org.jruby.javasupport.JavaClass.protection_domain", "protection_domain");
        this.add("org.jruby.javasupport.JavaClass.public_p", "public?");
        this.add("org.jruby.javasupport.JavaClass.resource", "resource");
        this.add("org.jruby.javasupport.JavaClass.resource_as_stream", "resource_as_stream");
        this.add("org.jruby.javasupport.JavaClass.resource_as_string", "resource_as_string");
        this.add("org.jruby.javasupport.JavaClass.ruby_class", "ruby_class");
        this.add("org.jruby.javasupport.JavaClass.signers", "signers");
        this.add("org.jruby.javasupport.JavaClass.simple_name", "simple_name");
        this.add("org.jruby.javasupport.JavaClass.superclass", "superclass");
        this.add("org.jruby.javasupport.JavaClass.synthetic_p", "synthetic?");
        this.add("org.jruby.javasupport.JavaClass.type_parameters", "type_parameters");
        this.add("org.jruby.javasupport.JavaConstructor.new_instance", "new_instance");
        this.add("org.jruby.javasupport.JavaConstructor.return_type", "return_type");
        this.add("org.jruby.javasupport.JavaConstructor.type_parameters", "type_parameters");
        this.add("org.jruby.javasupport.JavaField.enum_constant_p", "enum_constant?");
        this.add("org.jruby.javasupport.JavaField.field_type", "type");
        this.add("org.jruby.javasupport.JavaField.final_p", "final?");
        this.add("org.jruby.javasupport.JavaField.name", "name");
        this.add("org.jruby.javasupport.JavaField.op_equal", "==");
        this.add("org.jruby.javasupport.JavaField.public_p", "public?");
        this.add("org.jruby.javasupport.JavaField.set_static_value", "set_static_value");
        this.add("org.jruby.javasupport.JavaField.set_value", "set_value");
        this.add("org.jruby.javasupport.JavaField.static_p", "static?");
        this.add("org.jruby.javasupport.JavaField.static_value", "static_value");
        this.add("org.jruby.javasupport.JavaField.to_generic_string", "to_generic_string");
        this.add("org.jruby.javasupport.JavaField.value", "value");
        this.add("org.jruby.javasupport.JavaField.value_type", "value_type");
        this.add("org.jruby.javasupport.JavaMethod.final_p", "final?");
        this.add("org.jruby.javasupport.JavaMethod.invoke", "invoke");
        this.add("org.jruby.javasupport.JavaMethod.invoke_static", "invoke_static");
        this.add("org.jruby.javasupport.JavaMethod.name", "name");
        this.add("org.jruby.javasupport.JavaMethod.public_p", "public?");
        this.add("org.jruby.javasupport.JavaMethod.return_type", "return_type");
        this.add("org.jruby.javasupport.JavaMethod.static_p", "static?");
        this.add("org.jruby.javasupport.JavaMethod.type_parameters", "type_parameters");
        this.add("org.jruby.javasupport.JavaObject.afill", "fill");
        this.add("org.jruby.javasupport.JavaObject.aref", "[]");
        this.add("org.jruby.javasupport.JavaObject.aset", "[]=");
        this.add("org.jruby.javasupport.JavaObject.hash", "hash");
        this.add("org.jruby.javasupport.JavaObject.is_java_proxy", "java_proxy?");
        this.add("org.jruby.javasupport.JavaObject.java_class", "java_class");
        this.add("org.jruby.javasupport.JavaObject.java_type", "java_type");
        this.add("org.jruby.javasupport.JavaObject.length", "length");
        this.add("org.jruby.javasupport.JavaObject.marshal_dump", "marshal_dump");
        this.add("org.jruby.javasupport.JavaObject.marshal_load", "marshal_load");
        this.add("org.jruby.javasupport.JavaObject.op_equal", "==");
        this.add("org.jruby.javasupport.JavaObject.ruby_synchronized", "synchronized");
        this.add("org.jruby.javasupport.JavaObject.same", "equal?");
        this.add("org.jruby.javasupport.JavaObject.to_s", "to_s");
        this.add("org.jruby.javasupport.JavaObject.wrap", "wrap");
        this.add("org.jruby.javasupport.JavaProxyMethods.hash", "hash");
        this.add("org.jruby.javasupport.JavaProxyMethods.inspect", "inspect");
        this.add("org.jruby.javasupport.JavaProxyMethods.java_class", "java_class");
        this.add("org.jruby.javasupport.JavaProxyMethods.java_object", "java_object");
        this.add("org.jruby.javasupport.JavaProxyMethods.java_object_set", "java_object=");
        this.add("org.jruby.javasupport.JavaProxyMethods.op_eql", "eql?");
        this.add("org.jruby.javasupport.JavaProxyMethods.op_equal", "==");
        this.add("org.jruby.javasupport.JavaProxyMethods.rbSynchronized", "synchronized");
        this.add("org.jruby.javasupport.JavaProxyMethods.to_java_object", "to_java_object");
        this.add("org.jruby.javasupport.JavaProxyMethods.to_s", "to_s");
        this.add("org.jruby.javasupport.JavaUtilities.create_proxy_class", "create_proxy_class");
        this.add("org.jruby.javasupport.JavaUtilities.get_interface_module", "get_interface_module");
        this.add("org.jruby.javasupport.JavaUtilities.get_java_class", "get_java_class");
        this.add("org.jruby.javasupport.JavaUtilities.get_package_module", "get_package_module");
        this.add("org.jruby.javasupport.JavaUtilities.get_package_module_dot_format", "get_package_module_dot_format");
        this.add("org.jruby.javasupport.JavaUtilities.get_proxy_class", "get_proxy_class");
        this.add("org.jruby.javasupport.JavaUtilities.get_proxy_or_package_under_package", "get_proxy_or_package_under_package");
        this.add("org.jruby.javasupport.JavaUtilities.get_top_level_proxy_or_package", "get_top_level_proxy_or_package");
        this.add("org.jruby.javasupport.JavaUtilities.set_java_object", "set_java_object");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.argument_types", "argument_types");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.arity", "arity");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.do_invoke", "invoke");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.getDeclaringClass", "declaring_class");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.inspect", "inspect");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.ProxyMethodImpl.super_p", "super?");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.constructors", "constructors");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.get", "get");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.get_with_class", "get_with_class");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.interfaces", "interfaces");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.methods", "methods");
        this.add("org.jruby.javasupport.proxy.JavaProxyClass.superclass", "superclass");
        this.add("org.jruby.javasupport.proxy.JavaProxyConstructor.argument_types", "argument_types");
        this.add("org.jruby.javasupport.proxy.JavaProxyConstructor.arity", "arity");
        this.add("org.jruby.javasupport.proxy.JavaProxyConstructor.getDeclaringClass", "declaring_class");
        this.add("org.jruby.javasupport.proxy.JavaProxyConstructor.new_instance", "new_instance");
        this.add("org.jruby.javasupport.proxy.JavaProxyConstructor.new_instance2", "new_instance2");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.aref", "[]");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.aset", "[]=");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.hash", "hash");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.is_java_proxy", "java_proxy?");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.java_class", "java_class");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.java_type", "java_type");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.length", "length");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.op_equal", "==");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.same", "equal?");
        this.add("org.jruby.javasupport.proxy.JavaProxyReflectionObject.to_s", "to_s");
        this.add("org.jruby.libraries.IOWaitLibrary.io_wait", "io_wait");
        this.add("org.jruby.libraries.IOWaitLibrary.ready", "ready?");
        this.add("org.jruby.libraries.RbConfigLibrary.ruby", "ruby");
        this.add("org.jruby.libraries.ThreadLibrary.ConditionVariable.broadcast", "broadcast");
        this.add("org.jruby.libraries.ThreadLibrary.ConditionVariable.newInstance", "new");
        this.add("org.jruby.libraries.ThreadLibrary.ConditionVariable.signal", "signal");
        this.add("org.jruby.libraries.ThreadLibrary.ConditionVariable.wait_ruby", "wait");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.lock", "lock");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.locked_p", "locked?");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.newInstance", "new");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.sleep", "sleep");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.synchronize", "synchronize");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.try_lock", "try_lock");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.unlock", "unlock");
        this.add("org.jruby.libraries.ThreadLibrary.Mutex.unlock19", "unlock");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.clear", "clear");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.empty_p", "empty?");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.length", "length");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.newInstance", "new");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.num_waiting", "num_waiting");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.pop", "pop");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.push", "push");
        this.add("org.jruby.libraries.ThreadLibrary.Queue.shutdown", "shutdown!");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.clear", "clear");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.max", "max");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.max_set", "max=");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.newInstance", "new");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.pop", "pop");
        this.add("org.jruby.libraries.ThreadLibrary.SizedQueue.push", "push");
        this.add("org.jruby.libraries.ThreadLibrary.ThreadMethods.exclusive", "exclusive");
        this.add("org.jruby.util.io.JRubyObjectInputStream.close", "close");
        this.add("org.jruby.util.io.JRubyObjectInputStream.initialize", "initialize");
        this.add("org.jruby.util.io.JRubyObjectInputStream.newInstance", "new");
        this.add("org.jruby.util.io.JRubyObjectInputStream.readObject", "read_object");
    }

    private static final class ClassName {
        private final UTF8String packageName;
        private final UTF8String name;

        public ClassName(UTF8String packageName, UTF8String name) {
            this.packageName = packageName;
            this.name = name;
        }

        public ClassName(ClassObject clazz) {
            this(clazz.getPackageNameUTF(), clazz.getNameUTF());
        }

        public boolean equals(Object other) {
            if (other instanceof ClassName) {
                ClassName obj = (ClassName)other;
                return obj.name.equals(this.name) && obj.packageName.equals(this.packageName);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.packageName.hashCode();
        }
    }
}

