/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.JRubyMethodCategorizer;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.util.AbstractBooleanByIndexCache;

public class JRubyMethodCategorizerImpl
extends AbstractBooleanByIndexCache
implements JRubyMethodCategorizer {
    private final AbstractProfilingSessionImpl session;
    private final UTF8String __FILE__STRING;
    private final UTF8String DS_RUBY_DS_STRING;
    private final UTF8String DOT_RB_STRING;
    private final UTF8String RUBY_JIT_STRING;
    private final UTF8String DASH_E_STRING;
    private final UTF8String ABSTRACT_SCRIPT_STRING;

    public JRubyMethodCategorizerImpl(AbstractProfilingSessionImpl session) {
        this.session = session;
        this.__FILE__STRING = session.getStringManager().intern("__file__");
        this.DS_RUBY_DS_STRING = session.getStringManager().intern("$RUBY$");
        this.DOT_RB_STRING = session.getStringManager().intern(".rb");
        this.RUBY_JIT_STRING = session.getStringManager().intern("rubyjit");
        this.DASH_E_STRING = session.getStringManager().intern("-e");
        this.ABSTRACT_SCRIPT_STRING = session.getStringManager().intern("AbstractScript.java");
    }

    @Override
    public boolean isCompiledJRuby(MethodObject method) {
        return this.getBoolean(method.getIndex());
    }

    @Override
    public boolean isInterpretedJRuby(MethodObject method) {
        return method.getMethodClass().isSyntheticJRubyClass();
    }

    @Override
    protected boolean getBooleanImpl(int index) {
        MethodObject method = this.session.getMethodObjectManager().getMethodObject(index);
        NonArrayClassObject clazz = method.getMethodClass();
        UTF8String filename = clazz.getFilenameUTF();
        if (filename == null) {
            return false;
        }
        if (clazz.getFilenameUTF().endsWith(this.DOT_RB_STRING)) {
            return true;
        }
        UTF8String methodName = method.getNameUTF();
        if (methodName.startsWith(this.RUBY_JIT_STRING)) {
            return true;
        }
        if (methodName.equals(this.__FILE__STRING)) {
            return !filename.endsWith(this.ABSTRACT_SCRIPT_STRING);
        }
        if (filename.equals(this.DASH_E_STRING)) {
            return true;
        }
        return methodName.contains(this.DS_RUBY_DS_STRING);
    }
}

