/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UTFDataFormatException;
import java.util.zip.Deflater;

public final class ProfilingBuffer {
    public static final int BUFFER_SIZE = 0x100000;
    public static final int MAX_PACKET_SIZE = 65535;
    private static final int COMPRESSION_LEVEL = 6;
    private static final int DEFLATER_BUFFER_SIZE = 65536;
    private static final short CHUNK_HEADER_SIZE = 14;
    private byte[] rawData;
    private int packetStart;
    private int currentIndex;
    private short activePacketType;
    private int nrOfPackets;
    private byte[] deflaterBuffer;
    private RandomAccessFile file;

    public ProfilingBuffer(RandomAccessFile file) {
        this.file = file;
        this.rawData = new byte[0x100000];
        this.deflaterBuffer = new byte[65536];
    }

    public void initializePacket(short type) throws IOException {
        assert (this.activePacketType == 0);
        if (this.packetStart + 65535 >= this.rawData.length) {
            this.dump();
        }
        assert (this.packetStart == this.currentIndex);
        this.currentIndex += 4;
        this.activePacketType = type;
        ++this.nrOfPackets;
    }

    public void finalizePacket() throws IOException {
        assert (this.activePacketType > 0);
        short size = (short)(this.currentIndex - this.packetStart);
        int tmpCurrentIndex = this.currentIndex;
        this.currentIndex = this.packetStart;
        this.writeInt16(this.activePacketType);
        this.writeInt16(size);
        this.packetStart = this.currentIndex = tmpCurrentIndex;
        this.activePacketType = 0;
    }

    public void dump() throws IOException {
        if (this.currentIndex == 0) {
            return;
        }
        long chunkStartOffset = this.file.getFilePointer();
        this.file.writeShort(14);
        this.file.writeInt(this.nrOfPackets);
        this.file.writeLong(0L);
        Deflater deflater = new Deflater(6);
        deflater.setInput(this.rawData, 0, this.currentIndex);
        deflater.finish();
        int deflated = 0;
        while (!deflater.finished()) {
            deflated = deflater.deflate(this.deflaterBuffer);
            if (deflated <= 0) continue;
            this.file.write(this.deflaterBuffer, 0, deflated);
        }
        long chunkEndOffset = this.file.getFilePointer();
        this.file.seek(chunkStartOffset + 6L);
        this.file.writeLong(chunkEndOffset);
        this.file.seek(chunkEndOffset);
        this.nrOfPackets = 0;
        this.currentIndex = 0;
    }

    public void writeInt8(int value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 1) {
            // empty if block
        }
        ProfilingBuffer.writeInt8(this.rawData, this.currentIndex, value);
        ++this.currentIndex;
    }

    public void writeInt16(short value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 2) {
            byte[] tmp = new byte[2];
            ProfilingBuffer.writeInt16(tmp, 2, value);
            this.writeBytesAndInc(tmp);
        } else {
            ProfilingBuffer.writeInt16(this.rawData, this.currentIndex, value);
            this.currentIndex += 2;
        }
    }

    public void writeInt32(int value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 4) {
            byte[] data = new byte[4];
            ProfilingBuffer.writeInt32(data, 0, value);
            this.writeBytesAndInc(data);
        } else {
            ProfilingBuffer.writeInt32(this.rawData, this.currentIndex, value);
            this.currentIndex += 4;
        }
    }

    public void writeInt64(long value) throws IOException {
        if (this.getMaxBytesLeftInPacket() < 8) {
            byte[] tmp = new byte[8];
            ProfilingBuffer.writeInt64(tmp, 0, value);
            this.writeBytesAndInc(tmp);
        } else {
            ProfilingBuffer.writeInt64(this.rawData, this.currentIndex, value);
            this.currentIndex += 8;
        }
    }

    public void writeFloat(float value) throws IOException {
        this.writeInt32(Float.floatToIntBits(value));
    }

    public void writeDouble(double value) throws IOException {
        this.writeInt64(Double.doubleToLongBits(value));
    }

    public void writeString(String value) throws IOException {
        char c;
        int strlen = value.length();
        int utflen = 0;
        int count = 0;
        for (int i = 0; i < strlen; ++i) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        if (utflen > 65535) {
            throw new UTFDataFormatException("encoded string too long: " + utflen + " bytes");
        }
        byte[] bytearr = new byte[utflen + 2];
        bytearr[count++] = (byte)(utflen >>> 8 & 0xFF);
        bytearr[count++] = (byte)(utflen >>> 0 & 0xFF);
        int i = 0;
        for (i = 0; i < strlen && (c = value.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = value.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c >> 0 & 0x3F);
            }
            ++i;
        }
        this.writeBytes(bytearr);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.writeBytesAndInc(bytes);
    }

    private int getMaxBytesLeftInPacket() {
        return 65535 - (this.currentIndex - this.packetStart);
    }

    private void writeBytesAndInc(byte[] data) {
        int leftInBuffer = this.getMaxBytesLeftInPacket();
        if (leftInBuffer >= data.length) {
            for (int i = 0; i < data.length; ++i) {
                this.rawData[this.currentIndex + 1] = data[i];
            }
            this.currentIndex += data.length;
        } else {
            for (int i = 0; i < leftInBuffer; ++i) {
                this.rawData[this.currentIndex + 1] = data[i];
            }
            this.currentIndex += leftInBuffer;
        }
    }

    private static void writeInt8(byte[] data, int offset, int value) {
        data[offset] = (byte)value;
    }

    private static void writeInt16(byte[] data, int offset, short value) {
        data[offset] = (byte)(value >>> 8 & 0xFF);
        data[offset + 1] = (byte)(value >>> 0 & 0xFF);
    }

    private static void writeInt32(byte[] data, int offset, int value) {
        data[offset] = (byte)(value >>> 24 & 0xFF);
        data[offset + 1] = (byte)(value >>> 16 & 0xFF);
        data[offset + 2] = (byte)(value >>> 8 & 0xFF);
        data[offset + 3] = (byte)(value >>> 0 & 0xFF);
    }

    private static void writeInt64(byte[] data, int offset, long value) {
        data[offset] = (byte)(value >>> 56);
        data[offset + 1] = (byte)(value >>> 48);
        data[offset + 2] = (byte)(value >>> 40);
        data[offset + 3] = (byte)(value >>> 32);
        data[offset + 4] = (byte)(value >>> 24);
        data[offset + 5] = (byte)(value >>> 16);
        data[offset + 6] = (byte)(value >>> 8);
        data[offset + 7] = (byte)(value >>> 0);
    }
}

