/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.ProfilingVersion;
import com.sap.jvm.profiling.core.event.SystemInfo;

public class ProfilingCapabilitiesImpl
implements ProfilingCapabilities {
    private final ProfilingVersion version;
    private final SystemInfo systemInfo;

    public ProfilingCapabilitiesImpl(ProfilingVersion version, SystemInfo systemInfo) {
        this.version = version;
        this.systemInfo = systemInfo;
    }

    @Override
    public boolean hasClassStatistic() {
        return this.version.isAtLeast(1, 0);
    }

    @Override
    public boolean hasThreadStateSampling() {
        return this.version.isAtLeast(1, 0);
    }

    @Override
    public boolean hasThreadFilterInTimeBasedSampling() {
        return this.version.isAtLeast(1, 0);
    }

    @Override
    public boolean hasSleepingThreadSupportInTimeBasedSampling() {
        return this.version.isAtLeast(1, 0);
    }

    @Override
    public boolean hasSafepointSupportInTimeBasedSampling() {
        return this.version.isAtLeast(1, 1);
    }

    @Override
    public boolean hasAdaptiveAllocationTrace() {
        return this.version.isAtLeast(0, 3);
    }

    @Override
    public boolean hasHeartBeatTrace() {
        return this.version.isAtLeast(1, 3);
    }

    @Override
    public boolean hasSnapshotMarker() {
        return this.version.isAtLeast(1, 2);
    }

    @Override
    public boolean hasMethodParameterTrace() {
        return this.version.isAtLeast(1, 3);
    }

    @Override
    public boolean hasCreationTimeOfLoaders() {
        return this.version.isAtLeast(1, 4);
    }

    @Override
    public boolean hasInterpreterInformationInTBS() {
        return this.version.isAtLeast(1, 4);
    }

    @Override
    public boolean hasAdditionalClassAttributes() {
        return this.version.isAtLeast(1, 4);
    }

    @Override
    public boolean hasAdditionalMethodAttributes() {
        return this.version.isAtLeast(1, 4);
    }

    @Override
    public boolean hasAnnotationThreadFilter() {
        return this.version.isAtLeast(1, 4);
    }

    @Override
    public boolean hasInterpreterInformationInMPT() {
        return this.hasInterpreterInformationInTBS();
    }

    @Override
    public SystemInfo getSystemInfo() {
        return this.systemInfo;
    }
}

