/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.SimpleProfilingPrintStream;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public abstract class ProfilingPacketImpl
implements ProfilingPacket {
    public abstract void write(PacketResourceWriter var1) throws IOException;

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            PrintStream ps = new PrintStream(bos, false, "UTF-8");
            this.print(ps);
            ps.close();
            return new String(bos.toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Trace.error((Throwable)e, "No UTF-8");
            return e.getMessage();
        }
    }

    @Override
    public final void print(PrintStream stream) {
        SimpleProfilingPrintStream sps = new SimpleProfilingPrintStream(stream);
        this.print(sps);
        sps.flush();
    }
}

