/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.Response;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public abstract class ResponseImpl
extends ProfilingPacketImpl
implements Response {
    private final String name;
    private final long id;
    private final long time;
    private final boolean success;
    private final UTF8String errorMessage;

    protected ResponseImpl(String name, ResourceReader reader) throws IOException {
        this.name = name;
        this.id = reader.readInt64();
        this.time = reader.readInt64();
        this.success = reader.readBoolean();
        this.errorMessage = this.success ? null : reader.readUTF();
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage == null ? null : this.errorMessage.toString();
    }

    @Override
    public final long getTime() {
        return this.time;
    }

    @Override
    public boolean isSuccess() {
        return this.success;
    }

    @Override
    public final long getId() {
        return this.id;
    }

    protected void writeInternal(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.id);
        writer.writeInt64(this.time);
        writer.writeBoolean(this.success);
        if (!this.success) {
            writer.writeString(this.getErrorMessage());
        }
    }

    @Override
    public String getPacketName() {
        return this.name;
    }
}

