/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.ThreadAnnotation;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public final class ThreadAnnotationImpl
implements ThreadAnnotation {
    private final int slot;
    private UTF8String value;
    private final MappingInformation mapInfo;

    public ThreadAnnotationImpl(int slot, UTF8String value, MappingInformation mapInfo) {
        assert (value != null);
        this.slot = slot;
        this.value = value;
        this.mapInfo = mapInfo;
    }

    @Override
    public UTF8String getKey() {
        return this.mapInfo.getAnnotationKey(this.slot);
    }

    @Override
    public UTF8String getDescription() {
        return this.mapInfo.getAnnotationDescription(this.slot);
    }

    @Override
    public UTF8String getValue() {
        return this.value;
    }

    public int slot() {
        return this.slot;
    }

    public void setValue(UTF8String value) {
        assert (value != null);
        this.value = value;
    }

    public void save(ResourceWriter writer) throws IOException {
        writer.writeInt16((short)this.slot);
        writer.writeUTF(this.getValue());
    }
}

