/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core;

import com.sap.jvm.profiling.core.ThreadInfo;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ThreadAnnotationImpl;
import com.sap.jvm.profiling.impl.core.event.ThreadWithAnnotationsStartedImpl;
import com.sap.jvm.profiling.impl.core.type.MethodObjectImpl;
import com.sap.jvm.profiling.impl.method.event.MethodParameterEntryEventImpl;
import com.sap.jvm.profiling.impl.method.parameters.MethodParametersImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.method.event.MethodParameterEntryEvent;
import com.sap.jvm.profiling.method.event.MethodParametersDefinition;
import com.sap.jvm.profiling.method.parameters.Parameter;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Stack;

public final class ThreadInfoImpl
implements ThreadInfo {
    private final char index;
    private final long javaId;
    private long changeCount;
    private long parameterChangeCount;
    private MethodParameterEntryEventImpl[] entryEvents;
    private int entryEventsTop;
    private UTF8String name;
    private MethodParametersImpl currParams;
    private ArrayList<Parameter> exitParams;
    private ThreadAnnotationImpl[] annotations;
    private long timeStamp;
    private long cpuUserTime;
    private long cpuSystemTime;
    private int nrOfEntryEventTimes;
    private int stackTraceIndex;
    private byte type;
    private long tbsCpuTime;
    private int entryStackFixup;
    private boolean isDead = false;

    private ThreadInfoImpl(char index, long javaId, UTF8String name, Stack<MethodParameterEntryEventImpl> entryEvents, ThreadAnnotationImpl[] annotations, long initialChangeCount) {
        assert (name != null);
        this.index = index;
        this.javaId = javaId;
        this.name = name;
        this.entryEvents = new MethodParameterEntryEventImpl[32];
        this.entryEventsTop = -1;
        this.annotations = annotations;
        this.timeStamp = -1L;
        this.cpuUserTime = -1L;
        this.cpuSystemTime = -1L;
        this.tbsCpuTime = 0L;
        this.changeCount = initialChangeCount;
        this.parameterChangeCount = initialChangeCount;
    }

    public static ThreadInfoImpl createNew(char index, long javaId, UTF8String name, ThreadAnnotationImpl[] annotations, long initialChangeCount) {
        return new ThreadInfoImpl(index, javaId, name, new Stack<MethodParameterEntryEventImpl>(), annotations, initialChangeCount);
    }

    public long getTbsCpuTime() {
        return this.tbsCpuTime;
    }

    public void setTbsCpuTime(long tbsCpuTime) {
        this.tbsCpuTime = tbsCpuTime;
    }

    public void changeName(UTF8String newName) {
        this.name = newName;
        ++this.changeCount;
    }

    public void changeUser(UTF8String newUser, MappingInformation mapInfo) {
        assert (newUser != null);
        if (this.annotations == null) {
            this.annotations = new ThreadAnnotationImpl[1];
            this.annotations[0] = new ThreadAnnotationImpl(0, newUser, mapInfo);
        } else {
            this.annotations[0].setValue(newUser);
        }
        ++this.changeCount;
    }

    public void changeAnnotation(int slot, UTF8String annotation) {
        assert (annotation != null);
        this.annotations[slot].setValue(annotation);
        ++this.changeCount;
    }

    public void pushMethodParameterEntryEvent(MethodParameterEntryEventImpl event) {
        ++this.entryEventsTop;
        if (this.entryEventsTop == this.entryEvents.length) {
            MethodParameterEntryEventImpl[] newEntryEvents = new MethodParameterEntryEventImpl[this.entryEventsTop * 2];
            System.arraycopy(this.entryEvents, 0, newEntryEvents, 0, this.entryEventsTop);
            this.entryEvents = newEntryEvents;
        }
        this.entryEvents[this.entryEventsTop] = event;
        ++this.parameterChangeCount;
    }

    public void popMethodParameterEntryEvent() {
        assert (this.entryEventsTop >= 0);
        --this.entryEventsTop;
        ++this.parameterChangeCount;
    }

    @Override
    public char getIndex() {
        return this.index;
    }

    @Override
    public UTF8String getNameUTF() {
        return this.name;
    }

    @Override
    public long getThreadId() {
        return this.javaId;
    }

    @Override
    public UTF8String getUserUTF() {
        return this.annotations == null ? null : this.annotations[0].getValue();
    }

    @Override
    public UTF8String getSessionIdUTF() {
        return this.annotations == null ? null : this.annotations[1].getValue();
    }

    @Override
    public UTF8String getRequestIdUTF() {
        return this.annotations == null ? null : this.annotations[2].getValue();
    }

    @Override
    public UTF8String getApplicationNameUTF() {
        return this.annotations == null ? null : this.annotations[3].getValue();
    }

    public ThreadAnnotationImpl[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public MethodParameterEntryEventImpl getMethodParameterEntryEvent() {
        if (this.entryEventsTop >= 0) {
            return this.entryEvents[this.entryEventsTop];
        }
        return null;
    }

    @Override
    public MethodParameterEntryEvent[] getEntryEvents() {
        return this.entryEvents;
    }

    @Override
    public int getEntryEventTop() {
        return this.entryEventsTop + this.entryStackFixup;
    }

    public MethodParameterEntryEventImpl addParameter(MappingInformation mapInfo, Parameter parameter) {
        assert (this.nrOfEntryEventTimes >= 0);
        if (this.currParams == null) {
            if (this.exitParams == null) {
                this.exitParams = new ArrayList();
            }
            this.exitParams.add(parameter);
            return null;
        }
        if (this.currParams.addParameter(parameter)) {
            return this.getEntryEventIfFinished(mapInfo);
        }
        return null;
    }

    public ArrayList<Parameter> getAndRemoveExitParameters() {
        ArrayList<Parameter> result = this.exitParams;
        this.exitParams = null;
        return result;
    }

    public MethodObject getCurrentMptMethod() {
        return this.currParams.getMethod();
    }

    private MethodParameterEntryEventImpl getEntryEventIfFinished(MappingInformation mapInfo) {
        assert (this.nrOfEntryEventTimes >= 0);
        if (this.nrOfEntryEventTimes == 0) {
            MethodParametersImpl params = this.currParams;
            this.currParams = null;
            mapInfo.setThreadInfo(this.index, this);
            return new MethodParameterEntryEventImpl(mapInfo, this.index, params, this.timeStamp, this.cpuUserTime, this.cpuSystemTime, this.stackTraceIndex, this.type);
        }
        return null;
    }

    public void setParameterDefinition(MethodParametersDefinition definition, MethodObjectImpl method, int stackTraceIndex, byte type) {
        assert (this.currParams == null);
        this.currParams = new MethodParametersImpl(definition, method);
        this.stackTraceIndex = stackTraceIndex;
        this.type = type;
    }

    public void print(PrintStream stream) {
        stream.print("Thread id ");
        stream.print((int)this.getThreadId());
        stream.print(", name \"");
        stream.print(this.getNameUTF().toString());
        stream.print("\", user \"");
        stream.print(this.getUserUTF().toString());
        stream.print("\"");
    }

    public void write(PacketResourceWriter writer) throws IOException {
        ThreadWithAnnotationsStartedImpl.write(writer, this);
        for (int i = 0; i <= this.entryEventsTop; ++i) {
            if (this.entryEvents[i] == null) continue;
            this.entryEvents[i].write(writer);
        }
    }

    @Override
    public String getApplicationName() {
        return this.getApplicationNameUTF() == null ? null : this.getApplicationNameUTF().toString();
    }

    @Override
    public String getName() {
        return this.getNameUTF() == null ? null : this.getNameUTF().toString();
    }

    @Override
    public String getRequestId() {
        return this.getRequestIdUTF() == null ? null : this.getRequestIdUTF().toString();
    }

    @Override
    public String getSessionId() {
        return this.getSessionIdUTF() == null ? null : this.getSessionIdUTF().toString();
    }

    @Override
    public String getUser() {
        return this.getUserUTF() == null ? null : this.getUserUTF().toString();
    }

    public void setExitTimeStamp(long timeStamp) {
        this.timeStamp = timeStamp;
    }

    public long getTimeStamp() {
        return this.timeStamp;
    }

    public void setExitCpuUserTime(long cpuTime) {
        this.cpuUserTime = cpuTime;
    }

    public long getCpuUserTime() {
        return this.cpuUserTime;
    }

    public void setExitCpuSystemTime(long cpuTime) {
        this.cpuSystemTime = cpuTime;
    }

    public long getCpuSystemTime() {
        return this.cpuSystemTime;
    }

    public void setNrOfEntryEventTimes(int nr) {
        this.nrOfEntryEventTimes = nr;
    }

    public MethodParameterEntryEventImpl setEntryCpuTime(MappingInformation mapInfo, long cpuUserTime, long cpuSystemTime) {
        assert (this.nrOfEntryEventTimes > 0);
        this.cpuUserTime = cpuUserTime;
        this.cpuSystemTime = cpuSystemTime;
        --this.nrOfEntryEventTimes;
        return this.getEntryEventIfFinished(mapInfo);
    }

    public MethodParameterEntryEventImpl setEntryTimeStamp(MappingInformation mapInfo, long timeStamp) {
        assert (this.nrOfEntryEventTimes > 0);
        this.timeStamp = timeStamp;
        --this.nrOfEntryEventTimes;
        return this.getEntryEventIfFinished(mapInfo);
    }

    @Override
    public long getNameOrAnnotationChangeCount() {
        return this.changeCount;
    }

    @Override
    public long getParameterChangeCount() {
        return this.parameterChangeCount;
    }

    @Override
    public void hideTopEntryEvent() {
        assert (this.entryEvents.length > 0);
        assert (this.entryEventsTop >= 0);
        assert (this.entryStackFixup == 0);
        this.entryStackFixup = -1;
        ++this.parameterChangeCount;
    }

    @Override
    public void unhideLastPoppedEntryEvent() {
        assert (this.entryEvents.length > 0);
        assert (this.entryStackFixup == 0);
        this.entryStackFixup = 1;
        ++this.parameterChangeCount;
    }

    @Override
    public void undoEntryStackChanges() {
        if (this.entryStackFixup != 0) {
            this.entryStackFixup = 0;
            ++this.parameterChangeCount;
        }
    }

    public void setDead() {
        this.isDead = true;
    }

    @Override
    public boolean isDead() {
        return this.isDead;
    }

    @Override
    public boolean isValid() {
        return this.index != '\uffff' && !this.isDead;
    }
}

