/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.command;

import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.core.command.Command;
import com.sap.jvm.util.persistence.ProfilingCommandTags;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public abstract class CommandImpl
extends ProfilingCommandTags
implements Command {
    private static long nextId = 0L;
    protected long id = CommandImpl.getUniqueId();

    protected CommandImpl() {
    }

    @Override
    public final long getId() {
        return this.id;
    }

    public abstract void print(PrintStream var1);

    public final void writeToStream(DataOutputStream stream) throws IOException {
        if (this.needsRawWrite()) {
            this.writeToStreamRaw(stream);
            return;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        this.writeToStreamImpl(dos);
        dos.close();
        byte[] data = bos.toByteArray();
        stream.write(data, 0, 2);
        this.writeUint16(stream, data.length + 2);
        stream.write(data, 2, data.length - 2);
    }

    protected void writeToStreamRaw(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected abstract void writeToStreamImpl(DataOutputStream var1) throws IOException;

    protected final void writeUint16(DataOutputStream stream, int number) throws IOException {
        stream.write(number >>> 8 & 0xFF);
        stream.write(number & 0xFF);
    }

    protected final void writeClassFilter(DataOutputStream stream, String classFilter) throws IOException {
        stream.writeUTF(classFilter == null ? "**" : classFilter);
    }

    protected final int getClassFilterLength(String classFilter) {
        try {
            DataOutputStream stream = new DataOutputStream(new ByteArrayOutputStream());
            this.writeClassFilter(stream, classFilter);
            return stream.size();
        }
        catch (IOException e) {
            return 0;
        }
    }

    protected final void writeThreadFilter(DataOutputStream stream, ThreadFilter threadFilter) throws IOException {
        String userPattern;
        if (threadFilter != null && (userPattern = threadFilter.getUserFilter()) != null) {
            stream.writeUTF("user=");
            stream.writeInt(userPattern.length());
            stream.writeChars(userPattern);
            return;
        }
        stream.writeUTF("**");
    }

    protected final void writeNewThreadFilter(DataOutputStream stream, ThreadFilter threadFilter) throws IOException {
        if (threadFilter == null) {
            stream.writeUTF("**");
        } else {
            stream.writeUTF(threadFilter.asString());
        }
    }

    protected boolean needsRawWrite() {
        return false;
    }

    private static synchronized long getUniqueId() {
        return nextId++;
    }
}

