/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.command;

import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.core.command.SnapshotMarkerCommand;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import com.sap.jvm.tracing.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.zip.Deflater;

public final class SnapshotMarkerCommandImpl
extends CommandImpl
implements SnapshotMarkerCommand {
    private static final int COMPRESSION_LEVEL = 5;
    private ProfilingTraceType type;
    private boolean delta;
    private String name;

    public SnapshotMarkerCommandImpl(ProfilingTraceType type, String name, boolean delta) {
        this.type = type;
        this.name = name;
        this.delta = delta;
    }

    @Override
    public CommandType getType() {
        return CommandType.SNAPSHOT_MARKER;
    }

    @Override
    public byte[] asJdwpPacketResponse(long timeStamp) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream stream = new DataOutputStream(out);
        try {
            stream.writeShort(1034);
            stream.writeShort(0);
            stream.writeLong(this.getId());
            stream.writeLong(timeStamp);
            stream.writeBoolean(true);
            stream.write(this.type.getIndex());
            stream.writeBoolean(this.delta);
            stream.writeUTF(this.name);
        }
        catch (IOException ex) {
            Trace.warn((Throwable)ex, "I/O error during writing snapshot marker response packet");
        }
        byte[] packet = out.toByteArray();
        int length = packet.length;
        packet[2] = (byte)(length >>> 8 & 0xFF);
        packet[3] = (byte)(length >>> 0 & 0xFF);
        out = new ByteArrayOutputStream();
        stream = new DataOutputStream(out);
        try {
            stream.writeInt(0);
            stream.writeInt(0);
            stream.write(0);
            stream.write(128);
            stream.write(0);
            Deflater deflater = new Deflater(5);
            deflater.setInput(packet, 0, length);
            deflater.finish();
            int deflated = 0;
            byte[] deflaterBuffer = new byte[10240];
            while (!deflater.finished()) {
                deflated = deflater.deflate(deflaterBuffer);
                if (deflated <= 0) continue;
                stream.write(deflaterBuffer, 0, deflated);
            }
            deflater.end();
        }
        catch (IOException ex) {
            Trace.warn(() -> "I/O error during writing snapshot marker response packet: " + ex.getMessage());
        }
        packet = out.toByteArray();
        length = packet.length;
        packet[0] = (byte)(length >>> 24 & 0xFF);
        packet[1] = (byte)(length >>> 16 & 0xFF);
        packet[2] = (byte)(length >>> 8 & 0xFF);
        packet[3] = (byte)(length >>> 0 & 0xFF);
        return packet;
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Snapshot marker command (trace type=");
        stream.print(this.type.getIndex());
        stream.print(", name=");
        stream.print(this.name);
        stream.print(", delta=");
        stream.print(this.delta);
        stream.print(")");
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 35);
        stream.writeLong(this.getId());
        stream.writeByte(this.type.getIndex());
        stream.writeBoolean(this.delta);
        stream.writeUTF(this.name);
    }
}

