/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.HeartBeatEvent;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.event.HeartBeatGCStatisticImpl;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;

public final class HeartBeatEventImpl
extends ProfilingPacketImpl
implements HeartBeatEvent {
    private static final HeartBeatGCStatisticImpl[] emptyGcStatistic = new HeartBeatGCStatisticImpl[0];
    private static int[] expMapping = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 19, 20, 22, 23, 25, 27, 29, 31, 34, 36, 39, 42, 45, 49, 52, 56, 61, 65, 70, 75, 81, 87, 94, 101, 108, 116, 125, 134, 144, 155, 167, 179, 193, 207, 223, 239, 257, 276, 297, 319, 343, 369, 397, 426, 458, 492, 529, 569, 611, 657, 706, 758, 815, 876, 941, 1012, 1087, 1169, 1256, 1350, 1450, 1559, 1675, 1800, 1935, 2079, 2235, 2401, 2581, 2773, 2980, 3203, 3442, 3699, 3975, 4272, 4591, 4934, 5302, 5698, 6124, 6581, 7072, 7600, 8168, 8777, 9433, 10137, 10894, 11707, 12581, 13521, 14530, 15615, 16780, 18033, 19380, 20826, 22381, 24052, 25848, 27778, 29851, 32080, 34475, 37049, 39815, 42787, 45981, 49414, 53103, 57068, 61328, 65907, 70827, 76114, 81797, 87903, 94466, 101518, 109097, 117242, 125995, 135401, 145509, 156373, 168047, 180592, 194075, 208563, 224134, 240866, 258848, 278173, 298940, 321258, 345241, 371015, 398714, 428480, 460468, 494845, 531787, 571488, 614153, 660003, 709275, 762227, 819131, 880284, 946002, 1016626, 1092522, 1174085, 1261737, 1355932, 1457160, 1565944, 1682851, 1808484, 1943497, 2088590, 2244514, 2412079, 2592154, 2785672, 2993638, 3217129, 3457305, 3715411, 3992786, 4290869, 4611206, 4955457, 5325408, 5722978, 0x5DD855, 6609377, 7102802, 7633064, 8202913, 8815305, 9473414, 10180655, 10940696, 11757477, 12635236, 13578524, 14592233, 15681621, 16852338, 18110455, 19462498, 20915477, 22476929, 24154952, 25958249, 27896171, 29978769, 32216844, 34622004, 37206721, 39984402, 42969451, 46177351, 49624737, 53329488, 57310820, 61589379, 66187355, 71128595, 76438725, 82145284, 88277869, 94868283, 101950708, 109561873, 117741252, 126531266, 135977501, 146128948, 157038255, 168762000, 181360985, 194900552, 209450920, 225087550, 241891539, 259950035, 279356695, 300212165, 322624607, 346710258, 372594032, 400410168, 430302926, 462427340, 496950012};
    private final ProfilingSession session;
    private final long timeStamp;
    private final long time;
    private final long memSize;
    private final long memCapacity;
    private final int threadsCount;
    private final int runningThreads;
    private final int totalGCs;
    private final long millisSinceLastGC;
    private boolean gcActive;
    private long classesCount;
    private long classesSize;
    private long compileCount;
    private long compilerQueueLength;
    private long cpuUserTime;
    private long cpuSystemTime;
    private long cpuJitTime;
    private long cpuSystemEventTime;
    private long cpuUserEventTime;
    private long cpuJitEventTime;
    private long elapsedEventTime;
    private long fileReadBytes;
    private long fileEventReadBytes;
    private long fileWrittenBytes;
    private long fileEventWrittenBytes;
    private long netReadBytes;
    private long netEventReadBytes;
    private long netWrittenBytes;
    private long netEventWrittenBytes;
    private boolean missed_threads_io_update;
    private HeartBeatGCStatisticImpl[] gcStatistics;

    public static HeartBeatEventImpl read(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session, HeartBeatEventHandler[] handlers) throws IOException {
        HeartBeatEventImpl result = new HeartBeatEventImpl(prevEvent, reader, session);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public static HeartBeatEventImpl readSmallKey(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session, HeartBeatEventHandler[] handlers, ArrayList<GcStatistic> gcStatistics) throws IOException {
        long time = reader.readInt64();
        HeartBeatEventImpl result = new HeartBeatEventImpl(prevEvent, reader, session, time, gcStatistics);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public static HeartBeatEventImpl readSmallDiff(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session, HeartBeatEventHandler[] handlers, long interval, ArrayList<GcStatistic> gcStatistics) throws IOException {
        if (prevEvent == null) {
            return null;
        }
        short intervalDiff = reader.readUint8();
        long time = prevEvent.time + (long)intervalDiff + interval;
        HeartBeatEventImpl result = new HeartBeatEventImpl(prevEvent, reader, session, time, gcStatistics);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public static HeartBeatEventImpl readSmallDiff2(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session, HeartBeatEventHandler[] handlers, ArrayList<GcStatistic> gcStatistics) throws IOException {
        if (prevEvent == null) {
            return null;
        }
        char diff = reader.readUint16();
        long time = prevEvent.time + (long)diff;
        HeartBeatEventImpl result = new HeartBeatEventImpl(prevEvent, reader, session, time, gcStatistics);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    public HeartBeatEventImpl(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session, long time, ArrayList<GcStatistic> fullGcStatistics) throws IOException {
        short heapOccupancy = reader.readUint8();
        short cpuOccupancy = reader.readUint8();
        short jitCpuOccupancy = reader.readUint8();
        short fileIoIndex = reader.readUint8();
        short netIoIndex = reader.readUint8();
        this.session = session;
        SystemInfo info = session.getSystemInfo();
        long elapsed = prevEvent == null ? 0L : time - prevEvent.time;
        long max_cpu = elapsed * (long)info.getNrOfCpus();
        long cpu_tick = max_cpu * 5L;
        long elapsedCpuTime = cpu_tick * (long)cpuOccupancy;
        long elapsedJitCPuTime = (long)info.getNrOfCompileThreads() * elapsed * 5L * (long)jitCpuOccupancy;
        this.threadsCount = -1;
        this.runningThreads = -1;
        this.memCapacity = info.getMaxHeapCapacity();
        this.memSize = this.memCapacity / 255L * (long)heapOccupancy;
        this.totalGCs = -1;
        this.millisSinceLastGC = -1L;
        this.gcActive = false;
        this.classesCount = -1L;
        this.classesSize = -1L;
        this.cpuUserTime = prevEvent == null ? 0L : prevEvent.cpuUserTime + elapsedCpuTime;
        this.cpuSystemTime = 0L;
        this.timeStamp = info.getTimeStamp() + 1000000L * (time - info.getTimeMillis());
        this.time = time;
        this.compileCount = -1L;
        this.compilerQueueLength = -1L;
        if (fullGcStatistics.isEmpty()) {
            this.gcStatistics = emptyGcStatistic;
        } else {
            this.gcStatistics = new HeartBeatGCStatisticImpl[fullGcStatistics.size()];
            for (int i = 0; i < this.gcStatistics.length; ++i) {
                this.gcStatistics[i] = new HeartBeatGCStatisticImpl(fullGcStatistics.get(i));
            }
            fullGcStatistics.clear();
        }
        this.cpuJitTime = prevEvent == null ? 0L : prevEvent.cpuJitTime + elapsedJitCPuTime;
        long scale = elapsed / 10L;
        this.fileReadBytes = prevEvent == null ? 0L : prevEvent.fileReadBytes + scale * (long)expMapping[fileIoIndex];
        this.fileWrittenBytes = 0L;
        this.netReadBytes = prevEvent == null ? 0L : prevEvent.netReadBytes + scale * (long)expMapping[netIoIndex];
        this.netWrittenBytes = 0L;
        if (prevEvent == null) {
            this.cpuSystemEventTime = 0L;
            this.cpuUserEventTime = 0L;
            this.elapsedEventTime = 0L;
            this.fileEventReadBytes = 0L;
            this.fileEventWrittenBytes = 0L;
            this.netEventReadBytes = 0L;
            this.netEventWrittenBytes = 0L;
            this.cpuJitEventTime = 0L;
        } else {
            this.cpuSystemEventTime = 1000L * (this.cpuSystemTime - prevEvent.cpuSystemTime);
            this.cpuUserEventTime = 1000L * (this.cpuUserTime - prevEvent.cpuUserTime);
            this.elapsedEventTime = 1000000L * (time - prevEvent.time);
            this.fileEventReadBytes = this.fileReadBytes - prevEvent.getFileIOReadBytes();
            this.fileEventWrittenBytes = this.fileWrittenBytes - prevEvent.getFileIOWrittenBytes();
            this.netEventReadBytes = this.netReadBytes - prevEvent.getNetIOReadBytes();
            this.netEventWrittenBytes = this.netWrittenBytes - prevEvent.getNetIOWrittenBytes();
            this.cpuJitEventTime = 1000L * (this.cpuJitTime - prevEvent.cpuJitTime);
        }
    }

    public HeartBeatEventImpl(HeartBeatEventImpl prevEvent, ResourceReader reader, ProfilingSession session) throws IOException {
        int i;
        this.session = session;
        this.threadsCount = reader.readInt32();
        this.runningThreads = reader.readInt32();
        this.memSize = reader.readInt64();
        this.memCapacity = reader.readInt64();
        this.totalGCs = reader.readInt32();
        this.millisSinceLastGC = reader.readInt64();
        this.gcActive = reader.readBoolean();
        this.classesCount = reader.readInt64();
        this.classesSize = reader.readInt64();
        this.cpuUserTime = reader.readInt64();
        this.cpuSystemTime = reader.readInt64();
        this.timeStamp = reader.readInt64();
        this.time = reader.readInt64();
        if (prevEvent == null) {
            this.cpuSystemEventTime = 0L;
            this.cpuUserEventTime = 0L;
            this.elapsedEventTime = 0L;
        } else {
            this.cpuSystemEventTime = 1000L * (this.cpuSystemTime - prevEvent.cpuSystemTime);
            this.cpuUserEventTime = 1000L * (this.cpuUserTime - prevEvent.cpuUserTime);
            this.elapsedEventTime = this.timeStamp - prevEvent.timeStamp;
        }
        int nrOfGcStatistics = reader.readInt32();
        if (nrOfGcStatistics == 0) {
            this.gcStatistics = emptyGcStatistic;
        } else {
            this.gcStatistics = new HeartBeatGCStatisticImpl[nrOfGcStatistics];
            for (i = 0; i < this.gcStatistics.length; ++i) {
                this.gcStatistics[i] = new HeartBeatGCStatisticImpl(reader);
            }
        }
        this.compileCount = reader.readInt64();
        this.compilerQueueLength = reader.readInt64();
        if (reader.hasNext()) {
            for (i = 0; i < this.gcStatistics.length; ++i) {
                long memAfter = reader.readInt64();
                this.gcStatistics[i].updateMemAfter(memAfter);
            }
        }
        if (reader.hasNext()) {
            this.cpuJitTime = reader.readInt64();
        }
        if (reader.hasNext()) {
            this.fileReadBytes = reader.readInt64();
            this.fileWrittenBytes = reader.readInt64();
            this.netReadBytes = reader.readInt64();
            this.netWrittenBytes = reader.readInt64();
            this.missed_threads_io_update = reader.readBoolean();
            if (prevEvent == null) {
                this.fileEventReadBytes = 0L;
                this.fileEventWrittenBytes = 0L;
                this.netEventReadBytes = 0L;
                this.netEventWrittenBytes = 0L;
            } else {
                this.fileEventReadBytes = this.fileReadBytes - prevEvent.getFileIOReadBytes();
                this.fileEventWrittenBytes = this.fileWrittenBytes - prevEvent.getFileIOWrittenBytes();
                this.netEventReadBytes = this.netReadBytes - prevEvent.getNetIOReadBytes();
                this.netEventWrittenBytes = this.netWrittenBytes - prevEvent.getNetIOWrittenBytes();
            }
        }
        this.cpuJitEventTime = prevEvent == null ? 0L : 1000L * (this.cpuJitTime - prevEvent.cpuJitTime);
    }

    @Override
    public long getTimeMillis() {
        return this.time;
    }

    @Override
    public long getMemSize() {
        return this.memSize;
    }

    @Override
    public long getMemCapacity() {
        return this.memCapacity;
    }

    @Override
    public int getRunningThreads() {
        return this.runningThreads;
    }

    @Override
    public int getThreadsCount() {
        return this.threadsCount;
    }

    @Override
    public long getMillisSinceLastGC() {
        return this.millisSinceLastGC;
    }

    @Override
    public int getTotalGCs() {
        return this.totalGCs;
    }

    @Override
    public boolean isGCActive() {
        return this.gcActive;
    }

    @Override
    public long getLoadedClassesBytes() {
        return this.classesSize;
    }

    @Override
    public long getLoadedClassesCount() {
        return this.classesCount;
    }

    @Override
    public double getCPULoad() {
        if (this.getEventElapsedTime() == 0L) {
            return 0.0;
        }
        return Math.min(100.0, 100.0 * (double)this.getEventCpuTime() / (double)(this.getEventElapsedTime() * (long)this.session.getSystemInfo().getNrOfCpus()));
    }

    @Override
    public double getUserCPULoad() {
        if (this.getEventElapsedTime() == 0L) {
            return 0.0;
        }
        return 100.0 * (double)this.cpuUserEventTime / (double)(this.getEventElapsedTime() * (long)this.session.getSystemInfo().getNrOfCpus());
    }

    @Override
    public double getSystemCPULoad() {
        if (this.getEventElapsedTime() == 0L) {
            return 0.0;
        }
        return 100.0 * (double)this.cpuSystemEventTime / (double)(this.getEventElapsedTime() * (long)this.session.getSystemInfo().getNrOfCpus());
    }

    @Override
    public double getJitCPULoad() {
        if (this.getEventElapsedTime() == 0L) {
            return 0.0;
        }
        return 100.0 * (double)this.getEventJitCpuTime() / (double)(this.getEventElapsedTime() * (long)this.session.getSystemInfo().getNrOfCpus());
    }

    @Override
    public double getCompileThreadsLoad() {
        if (this.getEventElapsedTime() == 0L) {
            return 0.0;
        }
        SystemInfo sysInfo = this.session.getSystemInfo();
        int cores = sysInfo.getNrOfCompileThreads();
        if (cores <= 0) {
            cores = 2;
        }
        return Math.min(100.0 * (double)this.getEventJitCpuTime() / (double)(this.getEventElapsedTime() * (long)cores), 100.0);
    }

    @Override
    public long getCompileCount() {
        return this.compileCount;
    }

    @Override
    public long getCompilerQueueLength() {
        return this.compilerQueueLength;
    }

    @Override
    public long getEventCpuTime() {
        return this.cpuSystemEventTime + this.cpuUserEventTime;
    }

    @Override
    public long getEventJitCpuTime() {
        return this.cpuJitEventTime;
    }

    @Override
    public long getEventElapsedTime() {
        return this.elapsedEventTime;
    }

    @Override
    public HeartBeatGCStatistic[] getGCStatistics() {
        return this.gcStatistics;
    }

    @Override
    public long getConsumedCpuTime() {
        return this.getConsumedSystemTime() + this.getConsumedUserTime();
    }

    @Override
    public long getConsumedSystemTime() {
        return this.cpuSystemTime - this.session.getSystemInfo().getAccumulatedSystemTime();
    }

    @Override
    public long getConsumedUserTime() {
        return this.cpuUserTime - this.session.getSystemInfo().getAccumulatedUserTime();
    }

    @Override
    public long getFileIOReadBytes() {
        return this.fileReadBytes;
    }

    @Override
    public long getFileIOWrittenBytes() {
        return this.fileWrittenBytes;
    }

    @Override
    public long getNetIOReadBytes() {
        return this.netReadBytes;
    }

    @Override
    public long getNetIOWrittenBytes() {
        return this.netWrittenBytes;
    }

    @Override
    public long getEventFileIOReadBytes() {
        return this.fileEventReadBytes;
    }

    @Override
    public long getEventFileIOWrittenBytes() {
        return this.fileEventWrittenBytes;
    }

    @Override
    public long getEventNetIOReadBytes() {
        return this.netEventReadBytes;
    }

    @Override
    public long getEventNetIOWrittenBytes() {
        return this.netEventWrittenBytes;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.HEART_BEAT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Sampled at            : %*t", 1000L * this.timeStamp);
        stream.formatln("Nr. of threads        : %d threads", this.threadsCount);
        stream.formatln("Running threads       : %d threads", this.runningThreads);
        stream.formatln("Used memory           : %*B", this.memSize);
        stream.formatln("Capacity              : %*B", this.memCapacity);
        stream.formatln("Nr. of GCs            : %d", this.totalGCs);
        stream.formatln("Time since last GC    : %*D", this.millisSinceLastGC * 1000000L);
        stream.formatln("GC active             : %s ", this.gcActive);
        stream.formatln("Loaded classes        : %d classes", this.classesCount);
        stream.formatln("Loaded class size     : %*B", this.classesSize);
        stream.formatln("CPU load              : %.2f %%", this.getCPULoad());
        stream.formatln("CPU time              : %*D", this.getEventCpuTime());
        stream.formatln("User load             : %*D", this.getUserCPULoad());
        stream.formatln("system load           : %*D", this.getSystemCPULoad());
        stream.formatln("Compile count         : %d", this.compileCount);
        stream.formatln("Compile threads load  : %f", this.getCompileThreadsLoad());
        stream.formatln("File IO read bytes    : %d", this.fileReadBytes);
        stream.formatln("File IO written bytes : %d", this.fileWrittenBytes);
        stream.formatln("Net IO read bytes     : %d", this.netReadBytes);
        stream.formatln("Net IO written bytes  : %d", this.netWrittenBytes);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        int i;
        writer.initializePacket((short)535);
        writer.writeInt32(this.threadsCount);
        writer.writeInt32(this.runningThreads);
        writer.writeInt64(this.memSize);
        writer.writeInt64(this.memCapacity);
        writer.writeInt32(this.totalGCs);
        writer.writeInt64(this.millisSinceLastGC);
        writer.writeBoolean(this.gcActive);
        writer.writeInt64(this.classesCount);
        writer.writeInt64(this.classesSize);
        writer.writeInt64(this.cpuUserTime);
        writer.writeInt64(this.cpuSystemTime);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.time);
        writer.writeInt32(this.gcStatistics.length);
        for (i = 0; i < this.gcStatistics.length; ++i) {
            this.gcStatistics[i].write(writer);
        }
        writer.writeInt64(this.compileCount);
        writer.writeInt64(this.compilerQueueLength);
        for (i = 0; i < this.gcStatistics.length; ++i) {
            writer.writeInt64(this.gcStatistics[i].getMemSizeAfter());
        }
        writer.writeInt64(this.cpuJitTime);
        writer.writeInt64(this.fileReadBytes);
        writer.writeInt64(this.fileWrittenBytes);
        writer.writeInt64(this.netReadBytes);
        writer.writeInt64(this.netWrittenBytes);
        writer.writeBoolean(this.missed_threads_io_update);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "heart beat event";
    }
}

