/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.event.HeartBeatGCStatistic;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class HeartBeatGCStatisticImpl
implements HeartBeatGCStatistic {
    private long gcNumber;
    private boolean isFull;
    private long cpuTime;
    private long memSize;
    private long memSizeAfter;
    private long duration;
    private long time;
    private GcCause cause;

    public HeartBeatGCStatisticImpl(ResourceReader reader) throws IOException {
        this.gcNumber = reader.readInt64();
        this.time = reader.readInt64();
        this.memSizeAfter = this.memSize = reader.readInt64();
        this.isFull = reader.readBoolean();
        this.duration = reader.readInt64();
        this.cpuTime = reader.readInt64();
        this.cause = this.convertToCause(reader.readInt8());
    }

    public HeartBeatGCStatisticImpl(GcStatistic statistic) {
        this.gcNumber = statistic.getGcNr();
        this.time = statistic.getTimestamp();
        this.memSize = statistic.getBytesInNonPermBeforeGc();
        this.memSizeAfter = statistic.getBytesInNonPermAfterGc();
        this.memSize = statistic.getBytesInFromBeforeGc() + statistic.getBytesInToBeforeGc() + statistic.getBytesInEdenBeforeGc() + statistic.getBytesInOldBeforeGc();
        this.memSizeAfter = statistic.getBytesInFromAfterGc() + statistic.getBytesInToAfterGc() + statistic.getBytesInEdenAfterGc() + statistic.getBytesInOldAfterGc();
        this.isFull = statistic.isFullGc();
        this.duration = statistic.getDuration();
        this.cpuTime = statistic.getCpuTime();
        this.cause = statistic.getCause();
    }

    private GcCause convertToCause(int value) {
        switch (value) {
            case 0: {
                return GcCause.JAVA_LANG_SYSTEM_GC;
            }
            case 1: {
                return GcCause.FULL_GC_ALOT;
            }
            case 2: {
                return GcCause.SCAVENGE_ALOT;
            }
            case 3: {
                return GcCause.ALLOCATION_PROFILER;
            }
            case 4: {
                return GcCause.JVMTI_FORCE_GC;
            }
            case 5: {
                return GcCause.GC_LOCKER;
            }
            case 6: {
                return GcCause.HEAP_INSPECTION;
            }
            case 7: {
                return GcCause.HEAP_DUMP;
            }
            case 8: {
                return GcCause.NO_GC;
            }
            case 9: {
                return GcCause.NO_CAUSE_SPECIFIED;
            }
            case 10: {
                return GcCause.ALLOCATION_FAILURE;
            }
            case 11: {
                return GcCause.TENURED_GENERATION_FULL;
            }
            case 12: {
                return GcCause.PERMANENT_GENERATION_FULL;
            }
            case 13: {
                return GcCause.CMS_GENERATION_FULL;
            }
            case 14: {
                return GcCause.CMS_INTERNAL_MARK;
            }
            case 15: {
                return GcCause.CMS_FINAL_MARK;
            }
            case 16: {
                return GcCause.OLD_GEN_EXP_ON_LAST_SCAVENGE;
            }
            case 17: {
                return GcCause.OLD_GEN_TOO_FULL_TO_SCAVENGE;
            }
            case 18: {
                return GcCause.ADAPTIVE_SIZE_POLICY;
            }
            case 19: {
                return GcCause.LAST_DITCH_COLLECTION;
            }
            case 20: {
                return GcCause.FORCED_MAXIMUM_COMPACTION;
            }
            case 21: {
                return GcCause.ALLOCATION_STATISTIC_REQUESTED;
            }
            case 22: {
                return GcCause.CLASS_STATISTIC_REQUESTED;
            }
            case 23: {
                return GcCause.CMS_OLD_GENERATION_LOW_MEMORY;
            }
            case 24: {
                return GcCause.CMS_PERM_GENERATION_LOW_MEMORY;
            }
            case 25: {
                return GcCause.CMS_BOOTSTRAP_TIMERS;
            }
            case 26: {
                return GcCause.LAST_GC_CAUSE;
            }
            case 27: {
                return GcCause.G1_INC_COLLECTION_PAUSE;
            }
            case 28: {
                return GcCause.G1_JAVA_HEAP_LOW_MEMORY;
            }
            case 29: {
                return GcCause.G1_HUMONGOUS_ALLOCATION;
            }
            case 30: {
                return GcCause.METASPACE_FULL;
            }
            case 31: {
                return GcCause.CMS_METASPACE_LOW_MEMORY;
            }
            case 32: {
                return GcCause.CMS_CONCURRENT_MARK;
            }
            case 33: {
                return GcCause.WB_YOUNG_GC;
            }
            case 34: {
                return GcCause.WB_CONC_MARC;
            }
            case 35: {
                return GcCause.WB_FULL_GC;
            }
            case 36: {
                return GcCause.UPDATE_ALLOC_CONTEXT_STATS_INC;
            }
            case 37: {
                return GcCause.UPDATE_ALLOC_CONTEXT_STATS_FULL;
            }
            case 38: {
                return GcCause.METADATA_GC_CLEAR_SOFT_REFS;
            }
            case 39: {
                return GcCause.DCMD_GC_RUN;
            }
        }
        return GcCause.UNKNOWN_CAUSE;
    }

    private int convertToInt(GcCause value) {
        switch (value) {
            case JAVA_LANG_SYSTEM_GC: {
                return 0;
            }
            case FULL_GC_ALOT: {
                return 1;
            }
            case SCAVENGE_ALOT: {
                return 2;
            }
            case ALLOCATION_PROFILER: {
                return 3;
            }
            case JVMTI_FORCE_GC: {
                return 4;
            }
            case GC_LOCKER: {
                return 5;
            }
            case HEAP_INSPECTION: {
                return 6;
            }
            case HEAP_DUMP: {
                return 7;
            }
            case NO_GC: {
                return 8;
            }
            case NO_CAUSE_SPECIFIED: {
                return 9;
            }
            case ALLOCATION_FAILURE: {
                return 10;
            }
            case TENURED_GENERATION_FULL: {
                return 11;
            }
            case PERMANENT_GENERATION_FULL: {
                return 12;
            }
            case CMS_GENERATION_FULL: {
                return 13;
            }
            case CMS_INTERNAL_MARK: {
                return 14;
            }
            case CMS_FINAL_MARK: {
                return 15;
            }
            case OLD_GEN_EXP_ON_LAST_SCAVENGE: {
                return 16;
            }
            case OLD_GEN_TOO_FULL_TO_SCAVENGE: {
                return 17;
            }
            case ADAPTIVE_SIZE_POLICY: {
                return 18;
            }
            case LAST_DITCH_COLLECTION: {
                return 19;
            }
            case FORCED_MAXIMUM_COMPACTION: {
                return 20;
            }
            case ALLOCATION_STATISTIC_REQUESTED: {
                return 21;
            }
            case CLASS_STATISTIC_REQUESTED: {
                return 22;
            }
            case CMS_OLD_GENERATION_LOW_MEMORY: {
                return 23;
            }
            case CMS_PERM_GENERATION_LOW_MEMORY: {
                return 24;
            }
            case CMS_BOOTSTRAP_TIMERS: {
                return 25;
            }
            case LAST_GC_CAUSE: {
                return 26;
            }
            case G1_INC_COLLECTION_PAUSE: {
                return 27;
            }
            case G1_JAVA_HEAP_LOW_MEMORY: {
                return 28;
            }
            case G1_HUMONGOUS_ALLOCATION: {
                return 29;
            }
            case METASPACE_FULL: {
                return 30;
            }
            case CMS_METASPACE_LOW_MEMORY: {
                return 31;
            }
            case CMS_CONCURRENT_MARK: {
                return 32;
            }
            case WB_YOUNG_GC: {
                return 33;
            }
            case WB_CONC_MARC: {
                return 34;
            }
            case WB_FULL_GC: {
                return 35;
            }
            case UPDATE_ALLOC_CONTEXT_STATS_INC: {
                return 36;
            }
            case UPDATE_ALLOC_CONTEXT_STATS_FULL: {
                return 37;
            }
            case METADATA_GC_CLEAR_SOFT_REFS: {
                return 38;
            }
            case DCMD_GC_RUN: {
                return 39;
            }
        }
        return -1;
    }

    void updateMemAfter(long memAfter) {
        this.memSizeAfter = memAfter;
    }

    @Override
    public long getGcNr() {
        return this.gcNumber;
    }

    @Override
    public boolean isFullGc() {
        return this.isFull;
    }

    @Override
    public long getMemSizeBefore() {
        return this.memSize;
    }

    @Override
    public long getMemSizeAfter() {
        return this.memSizeAfter;
    }

    @Override
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Override
    public GcCause getCause() {
        return this.cause;
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public long getTimeMillis() {
        return this.time;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.gcNumber);
        writer.writeInt64(this.time);
        writer.writeInt64(this.memSize);
        writer.writeBoolean(this.isFull);
        writer.writeInt64(this.duration);
        writer.writeInt64(this.cpuTime);
        writer.writeInt8(this.convertToInt(this.cause));
    }
}

