/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ObjectIdentificationEvent;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.sync.event.SynchronizationEventHandler;
import java.io.IOException;

public final class ObjectIdentificationEventImpl
extends ProfilingPacketImpl
implements ObjectIdentificationEvent {
    private static final int OBJECT_ID_SHIFT = 26;
    private long objectId;
    private ClassObject classObject;

    public static ObjectIdentificationEventImpl read(ResourceReader reader, SynchronizationEventHandler[] handlers) throws IOException {
        ObjectIdentificationEventImpl retValue = new ObjectIdentificationEventImpl(reader);
        for (SynchronizationEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private ObjectIdentificationEventImpl(ResourceReader reader) throws IOException {
        this.objectId = ObjectIdentificationEventImpl.readObjectId(reader);
        this.classObject = reader.readClassObject();
    }

    @Override
    public long getObjectId() {
        return this.objectId;
    }

    @Override
    public ClassObject getClassObject() {
        return this.classObject;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.OBJECT_IDENTIFICATION_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Object Id    : %d", this.objectId);
        stream.formatln("Class        : %s", this.classObject.getFullName());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)603);
        ObjectIdentificationEventImpl.writeObjectId(writer, this.objectId);
        writer.writeInt32(this.classObject.getIndex());
        writer.finalizePacket();
    }

    public static long readObjectId(ResourceReader reader) throws IOException {
        long tmpId = reader.readInt64();
        long result = tmpId >> 26;
        assert (tmpId == result << 26);
        return result;
    }

    public static void writeObjectId(ResourceWriter writer, long id) throws IOException {
        writer.writeInt64(id << 26);
    }

    @Override
    public String getPacketName() {
        return "object identification event";
    }
}

