/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ProfilingBufferDumped;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ProfilingBufferDumpedImpl
extends ProfilingPacketImpl
implements ProfilingBufferDumped {
    private final long duration;

    public ProfilingBufferDumpedImpl(ResourceReader reader) throws IOException {
        this.duration = reader.readInt64();
    }

    @Override
    public long getDuration() {
        return this.duration;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.PROFILING_BUFFER_DUMPED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Duration : %*D", this.duration);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)501);
        writer.writeInt64(this.duration);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "profiling buffer dump event";
    }
}

