/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.event.StorableAlertSummary;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;
import java.io.PrintStream;
import java.sql.Date;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SystemInfoImpl
implements SystemInfo {
    private final ProfilingSession session;
    private final short majorVersion;
    private final short minorVersion;
    private final int microVersion;
    private final String hostName;
    private final int vmIndex;
    private final int vmUniqueId;
    private final short instanceNumber;
    private final String instanceName;
    private final long vmHeapSize;
    private final long maxHeapCapacity;
    private final long vmCommittedHeapSize;
    private final String userName;
    private final String clientName;
    private final long timeStamp;
    private final long time;
    private final long pid;
    private final long timeNanos;
    private final long accumulatedSystemTime;
    private final long accumulatedUserTime;
    private final long accumulatedProcessTime;
    private final int maxYoungGenAge;
    private final int maxOldGenAge;
    private final int maxPermGenAge;
    private final boolean allowMethodModifiers;
    private final String vmName;
    private final String vmRelease;
    private final String vmInfo;
    private final int nrOfCpus;
    private final String cpuFeatures;
    private final String memoryInfo;
    private final String osInfo;
    private final String libraryInfo;
    private final HashMap<String, String> envVars;
    private final String workingDirectory;
    private final HashMap<String, String> initProps;
    private final HashMap<String, String> currentProps;
    private final String timeZoneInfo1;
    private final String timeZoneInfo2;
    private final HashMap<String, String> flags;
    private final String[] vmArguments;
    private final long[] timeStamps;
    private final long[] overallUserTimes;
    private final long[] overallSystemTimes;
    private final long[] threadUserTimes;
    private final long[] threadSystemTimes;
    private final boolean timeStampIsMonotonic;
    private final long timeStampResolution;
    private final long timeStampOverhead;
    private final boolean overallCpuUserTimeIsMonotonic;
    private final long overallCpuUserTimeResolution;
    private final boolean overallCpuSystemTimeIsMonotonic;
    private final long overallCpuSystemTimeResolution;
    private final boolean overallCpuTimeIsMonotonic;
    private final long overallCpuTimeResolution;
    private final boolean threadCpuUserTimeIsMonotonic;
    private final long threadCpuUserTimeResolution;
    private final boolean threadCpuSystemTimeIsMonotonic;
    private final long threadCpuSystemTimeResolution;
    private final boolean threadCpuTimeIsMonotonic;
    private final long threadCpuTimeResolution;
    private final String vmArgs;
    private final String javaVmArgs;
    private final String debuggingClient;
    private final int debugPort;
    private final boolean canCombinedAllocMptTrace;
    private final boolean canCombinedPerfMptTrace;
    private final boolean hasIOTrace;
    private final boolean hasMethodTrace;
    private final boolean hasSynchronizationTrace;
    private final boolean hasNetworkTrace;
    private final boolean hasGcTrace;
    private final boolean hasStackTraceInThreadStartEvent;
    private final int patchLevel;
    private final long osCounterFrequency;
    private final double osCounterNanoFrequency;
    private final double osCounterPeriod;
    private final boolean tbsSupportsCpuTime;
    private final boolean tbsSupportsTierCompilationInfo;
    private final boolean supportsClassFilterV2;
    private final long startTime;
    private final boolean hasAlertTrace;
    private final boolean supportsHprofDump;
    private final int compilerThreadsCount;
    private final boolean supportsProfilingServer;
    private final boolean supportsJvmProfControl;
    private final boolean supportsJRubyInAllocTrace;
    private final boolean hasClassStatisticDumpTrace;
    private final boolean supportsThreadDump;
    private final int[] storedAlertCounts;
    private final double[] storedAlertFirstTimes;
    private final double[] storedAlertLastTimes;
    private final String[] storedAlertLastInfos;
    private final boolean supportsBasicMonitoringBoardTrace;
    private final boolean supportsFullMonitoringBoardTrace;
    private final boolean hasCorrectReferenceHandlingData;
    private final boolean supportsGcHistoryFileDump;
    private final String defaultTimeZone;
    private final boolean supportsStackAllocations;
    private final boolean hasReallyCorrectReferenceHandlingData;
    private final boolean hasMetaspace;
    private final byte logBytesPerWord;
    private int gcStatisticVersion;
    private final boolean use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle;
    private final boolean gcStatisticHasClassSpaceData;
    private final boolean gcStatisticHasG1SpecificDetails;

    public SystemInfoImpl(ResourceReader reader) throws IOException {
        this.session = reader.getSession();
        this.majorVersion = reader.readInt16();
        this.minorVersion = reader.readInt16();
        this.instanceNumber = reader.readInt16();
        this.vmIndex = reader.readInt32();
        this.vmUniqueId = reader.readInt32();
        this.vmHeapSize = reader.readInt64();
        this.vmCommittedHeapSize = reader.readInt64();
        this.timeNanos = reader.readInt64() * 100L;
        this.timeStamp = reader.readInt64();
        this.accumulatedUserTime = reader.readInt64();
        this.accumulatedSystemTime = reader.readInt64();
        this.accumulatedProcessTime = reader.readInt64();
        this.hostName = reader.readString();
        this.userName = reader.readString();
        this.clientName = reader.readString();
        this.instanceName = reader.readString();
        this.maxYoungGenAge = reader.readInt32();
        this.maxOldGenAge = reader.readInt32();
        this.maxPermGenAge = reader.readInt32();
        this.allowMethodModifiers = this.majorVersion == 1 && this.minorVersion >= 3 ? reader.readBoolean() : false;
        if (this.majorVersion == 1 && this.minorVersion >= 4) {
            int i;
            int i2;
            this.microVersion = reader.readInt32();
            this.vmName = reader.readString();
            this.vmRelease = reader.readString();
            this.vmInfo = reader.readString();
            this.nrOfCpus = reader.readInt32();
            this.cpuFeatures = reader.readString();
            this.memoryInfo = reader.readString();
            this.osInfo = reader.readString();
            this.libraryInfo = reader.readString();
            this.envVars = SystemInfoImpl.readStringHashMap(reader);
            this.workingDirectory = reader.readString();
            this.initProps = SystemInfoImpl.readStringHashMap(reader);
            this.currentProps = SystemInfoImpl.readStringHashMap(reader);
            this.timeZoneInfo1 = reader.readString();
            this.timeZoneInfo2 = reader.readString();
            this.flags = SystemInfoImpl.readStringHashMap(reader);
            this.vmArguments = new String[reader.readInt32()];
            for (i2 = 0; i2 < this.vmArguments.length; ++i2) {
                this.vmArguments[i2] = reader.readString();
            }
            this.timeStamps = new long[reader.readInt32()];
            for (i2 = 0; i2 < this.timeStamps.length; ++i2) {
                this.timeStamps[i2] = reader.readInt64();
            }
            this.overallUserTimes = new long[reader.readInt32()];
            this.overallSystemTimes = new long[this.overallUserTimes.length];
            long[] overallCpuTimes = new long[this.overallUserTimes.length];
            for (int i3 = 0; i3 < this.overallUserTimes.length; ++i3) {
                this.overallUserTimes[i3] = reader.readInt64();
                this.overallSystemTimes[i3] = reader.readInt64();
                overallCpuTimes[i3] = this.overallUserTimes[i3] + this.overallSystemTimes[i3];
            }
            this.threadUserTimes = new long[reader.readInt32()];
            this.threadSystemTimes = new long[this.threadUserTimes.length];
            long[] threadCpuTimes = new long[this.threadUserTimes.length];
            for (i = 0; i < this.threadUserTimes.length; ++i) {
                this.threadUserTimes[i] = reader.readInt64();
                this.threadSystemTimes[i] = reader.readInt64();
                threadCpuTimes[i] = this.threadUserTimes[i] + this.threadSystemTimes[i];
            }
            this.timeStampIsMonotonic = SystemInfoImpl.valuesAreMonotonic(this.timeStamps);
            this.timeStampOverhead = SystemInfoImpl.calcTimeStampOverhead(this.timeStamps);
            this.timeStampResolution = this.timeStampIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(this.timeStamps) : 0L;
            this.overallCpuUserTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(this.overallUserTimes);
            this.overallCpuUserTimeResolution = this.overallCpuUserTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(this.overallUserTimes) : 0L;
            this.overallCpuSystemTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(this.overallSystemTimes);
            this.overallCpuSystemTimeResolution = this.overallCpuSystemTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(this.overallSystemTimes) : 0L;
            this.overallCpuTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(overallCpuTimes);
            this.overallCpuTimeResolution = this.overallCpuTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(overallCpuTimes) : 0L;
            this.threadCpuUserTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(this.threadUserTimes);
            this.threadCpuUserTimeResolution = this.threadCpuUserTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(this.threadUserTimes) : 0L;
            this.threadCpuSystemTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(this.threadSystemTimes);
            this.threadCpuSystemTimeResolution = this.threadCpuSystemTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(this.threadSystemTimes) : 0L;
            this.threadCpuTimeIsMonotonic = SystemInfoImpl.valuesAreMonotonic(threadCpuTimes);
            this.threadCpuTimeResolution = this.threadCpuTimeIsMonotonic ? SystemInfoImpl.calcTimeStampResolution(threadCpuTimes) : 0L;
            if (reader.hasNext()) {
                this.time = reader.readInt64();
                this.pid = reader.readInt64();
            } else {
                this.time = this.timeNanos / 1000000L;
                this.pid = -1L;
            }
            if (reader.hasNext()) {
                this.vmArgs = reader.readString();
                this.javaVmArgs = reader.readString();
                this.debuggingClient = reader.readString();
                this.debugPort = reader.readInt32();
            } else {
                this.vmArgs = null;
                this.javaVmArgs = null;
                this.debuggingClient = null;
                this.debugPort = -1;
            }
            if (reader.hasNext()) {
                this.canCombinedAllocMptTrace = reader.readBoolean();
                this.canCombinedPerfMptTrace = reader.readBoolean();
            } else {
                this.canCombinedAllocMptTrace = false;
                this.canCombinedPerfMptTrace = false;
            }
            this.hasStackTraceInThreadStartEvent = reader.hasNext() ? reader.readBoolean() : false;
            this.patchLevel = reader.hasNext() ? reader.readInt32() : -1;
            this.hasIOTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.hasMethodTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.hasSynchronizationTrace = reader.hasNext() ? reader.readBoolean() : false;
            if (reader.hasNext()) {
                this.osCounterFrequency = reader.readInt64();
                this.osCounterNanoFrequency = (double)this.osCounterFrequency / 1.0E9;
                this.osCounterPeriod = 1.0E9 / (double)this.osCounterFrequency;
            } else {
                this.osCounterFrequency = -1L;
                this.osCounterNanoFrequency = -1.0;
                this.osCounterPeriod = -1.0;
            }
            this.tbsSupportsCpuTime = reader.hasNext() ? reader.readBoolean() : false;
            this.tbsSupportsTierCompilationInfo = reader.hasNext() ? reader.readBoolean() : false;
            this.hasNetworkTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsClassFilterV2 = reader.hasNext() ? reader.readBoolean() : false;
            this.startTime = reader.hasNext() ? reader.readInt64() : -1L;
            this.hasAlertTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsHprofDump = reader.hasNext() ? reader.readBoolean() : false;
            this.compilerThreadsCount = reader.hasNext() ? reader.readInt32() : -1;
            this.supportsProfilingServer = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsJvmProfControl = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsJRubyInAllocTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.hasClassStatisticDumpTrace = reader.hasNext() ? reader.readBoolean() : false;
            if (reader.hasNext()) {
                reader.readBoolean();
            }
            this.maxHeapCapacity = reader.hasNext() ? reader.readInt64() : this.vmHeapSize;
            this.hasGcTrace = this.minorVersion >= 6;
            this.storedAlertCounts = reader.hasNext() ? new int[reader.readInt32()] : new int[0];
            this.storedAlertFirstTimes = new double[this.storedAlertCounts.length];
            this.storedAlertLastTimes = new double[this.storedAlertCounts.length];
            this.storedAlertLastInfos = new String[this.storedAlertCounts.length];
            for (i = 0; i < this.storedAlertCounts.length; ++i) {
                this.storedAlertCounts[i] = reader.readInt32();
                if (this.storedAlertCounts[i] <= 0) continue;
                this.storedAlertFirstTimes[i] = reader.readDouble();
                this.storedAlertLastTimes[i] = reader.readDouble();
                this.storedAlertLastInfos[i] = reader.readString();
            }
            this.supportsBasicMonitoringBoardTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.hasCorrectReferenceHandlingData = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsFullMonitoringBoardTrace = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsGcHistoryFileDump = reader.hasNext() ? reader.readBoolean() : false;
            this.defaultTimeZone = reader.hasNext() ? reader.readString() : "";
            this.supportsStackAllocations = reader.hasNext() ? reader.readBoolean() : false;
            this.supportsThreadDump = reader.hasNext() ? reader.readBoolean() : false;
            this.hasReallyCorrectReferenceHandlingData = reader.hasNext() ? reader.readBoolean() : false;
            boolean bl = this.hasMetaspace = reader.hasNext() ? reader.readBoolean() : false;
            this.logBytesPerWord = (byte)(reader.hasNext() ? reader.readInt8() : (this.vmInfo.contains("x86") ? 2 : 3));
            this.gcStatisticVersion = reader.hasNext() ? reader.readUint16() : (char)'\u0000';
        } else {
            this.microVersion = 0;
            this.vmName = "<unknown>";
            this.vmRelease = "<unknown>";
            this.vmInfo = "<unknown>";
            this.nrOfCpus = 0;
            this.cpuFeatures = "<unknown>";
            this.memoryInfo = "<unknown>";
            this.osInfo = "<unknown>";
            this.libraryInfo = "<unknown>";
            this.envVars = new HashMap();
            this.workingDirectory = "<unknown>";
            this.initProps = new HashMap();
            this.currentProps = new HashMap();
            this.timeZoneInfo1 = "<unknown>";
            this.timeZoneInfo2 = "<unknown>";
            this.flags = new HashMap();
            this.vmArguments = new String[0];
            this.timeStamps = null;
            this.overallUserTimes = null;
            this.overallSystemTimes = null;
            this.threadUserTimes = null;
            this.threadSystemTimes = null;
            this.timeStampIsMonotonic = true;
            this.timeStampResolution = 0L;
            this.timeStampOverhead = 0L;
            this.overallCpuUserTimeIsMonotonic = true;
            this.overallCpuUserTimeResolution = 0L;
            this.overallCpuSystemTimeIsMonotonic = true;
            this.overallCpuSystemTimeResolution = 0L;
            this.overallCpuTimeIsMonotonic = true;
            this.overallCpuTimeResolution = 0L;
            this.threadCpuUserTimeIsMonotonic = true;
            this.threadCpuUserTimeResolution = 0L;
            this.threadCpuSystemTimeIsMonotonic = true;
            this.threadCpuSystemTimeResolution = 0L;
            this.threadCpuTimeIsMonotonic = true;
            this.threadCpuTimeResolution = 0L;
            this.time = this.timeNanos / 1000000L;
            this.pid = -1L;
            this.vmArgs = null;
            this.javaVmArgs = null;
            this.debuggingClient = null;
            this.debugPort = -1;
            this.canCombinedAllocMptTrace = false;
            this.canCombinedPerfMptTrace = false;
            this.hasIOTrace = false;
            this.hasMethodTrace = false;
            this.hasSynchronizationTrace = false;
            this.hasStackTraceInThreadStartEvent = false;
            this.patchLevel = -1;
            this.osCounterFrequency = -1L;
            this.osCounterNanoFrequency = -1.0;
            this.osCounterPeriod = -1.0;
            this.tbsSupportsCpuTime = false;
            this.tbsSupportsTierCompilationInfo = false;
            this.hasNetworkTrace = false;
            this.supportsClassFilterV2 = false;
            this.startTime = -1L;
            this.hasAlertTrace = false;
            this.supportsHprofDump = false;
            this.compilerThreadsCount = -1;
            this.hasGcTrace = false;
            this.supportsProfilingServer = false;
            this.supportsJvmProfControl = false;
            this.supportsJRubyInAllocTrace = false;
            this.hasClassStatisticDumpTrace = false;
            this.maxHeapCapacity = this.vmHeapSize;
            this.storedAlertCounts = new int[0];
            this.storedAlertFirstTimes = new double[0];
            this.storedAlertLastTimes = new double[0];
            this.storedAlertLastInfos = new String[0];
            this.supportsBasicMonitoringBoardTrace = false;
            this.supportsFullMonitoringBoardTrace = false;
            this.hasCorrectReferenceHandlingData = false;
            this.supportsGcHistoryFileDump = false;
            this.defaultTimeZone = "";
            this.supportsStackAllocations = false;
            this.supportsThreadDump = false;
            this.hasReallyCorrectReferenceHandlingData = false;
            this.hasMetaspace = false;
            this.logBytesPerWord = (byte)(this.vmInfo.contains("x86") ? 2 : 3);
            this.gcStatisticVersion = 0;
        }
        if (this.gcStatisticVersion > 0) {
            this.use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle = true;
            this.gcStatisticHasClassSpaceData = true;
            this.gcStatisticHasG1SpecificDetails = true;
        } else {
            int[] v = this.getVmReleaseMajorMinorPatch();
            boolean bl = this.use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle = v[0] == 5 && v[2] >= 116 || v[0] == 6 && v[2] >= 102 || v[0] == 7 && v[2] >= 50 || v[0] == 8 && v[2] >= 30 || v[0] >= 9 || v[2] == -1;
            this.gcStatisticHasClassSpaceData = !this.hasMetaspace ? false : v[0] == 5 && v[2] >= 100 || v[0] == 6 && v[2] >= 74 || v[0] == 7 && v[2] >= 28 || v[0] == 8 && v[2] >= 3 || v[0] >= 9 || v[2] == -1;
            this.gcStatisticHasG1SpecificDetails = v[0] == 5 && v[2] >= 98 || v[0] == 6 && v[2] >= 99 || v[0] == 7 && v[2] >= 49 || v[0] == 8 && v[2] >= 29 || v[0] >= 9 || v[2] == -1;
        }
    }

    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)407);
        writer.writeInt16(this.majorVersion);
        writer.writeInt16(this.minorVersion);
        writer.writeInt16(this.instanceNumber);
        writer.writeInt32(this.vmIndex);
        writer.writeInt32(this.vmUniqueId);
        writer.writeInt64(this.vmHeapSize);
        writer.writeInt64(this.vmCommittedHeapSize);
        writer.writeInt64(this.timeNanos / 100L);
        writer.writeInt64(this.timeStamp);
        writer.writeInt64(this.accumulatedUserTime);
        writer.writeInt64(this.accumulatedSystemTime);
        writer.writeInt64(this.accumulatedProcessTime);
        writer.writeString(this.hostName);
        writer.writeString(this.userName);
        writer.writeString(this.clientName);
        writer.writeString(this.instanceName);
        writer.writeInt32(this.maxYoungGenAge);
        writer.writeInt32(this.maxOldGenAge);
        writer.writeInt32(this.maxPermGenAge);
        if (this.majorVersion == 1 && this.minorVersion >= 3) {
            writer.writeBoolean(this.allowMethodModifiers);
        }
        if (this.majorVersion == 1 && this.minorVersion >= 4) {
            int i;
            writer.writeInt32(this.microVersion);
            writer.writeString(this.vmName);
            writer.writeString(this.vmRelease);
            writer.writeString(this.vmInfo);
            writer.writeInt32(this.nrOfCpus);
            writer.writeString(this.cpuFeatures);
            writer.writeString(this.memoryInfo);
            writer.writeString(this.osInfo);
            writer.writeString(this.libraryInfo);
            SystemInfoImpl.writeStringHashMap(this.envVars, writer);
            writer.writeString(this.workingDirectory);
            SystemInfoImpl.writeStringHashMap(this.initProps, writer);
            SystemInfoImpl.writeStringHashMap(this.currentProps, writer);
            writer.writeString(this.timeZoneInfo1);
            writer.writeString(this.timeZoneInfo2);
            SystemInfoImpl.writeStringHashMap(this.flags, writer);
            writer.writeInt32(this.vmArguments.length);
            for (String arg : this.vmArguments) {
                writer.writeString(arg);
            }
            writer.writeInt32(this.timeStamps.length);
            for (i = 0; i < this.timeStamps.length; ++i) {
                writer.writeInt64(this.timeStamps[i]);
            }
            writer.writeInt32(this.overallUserTimes.length);
            for (i = 0; i < this.overallUserTimes.length; ++i) {
                writer.writeInt64(this.overallUserTimes[i]);
                writer.writeInt64(this.overallSystemTimes[i]);
            }
            writer.writeInt32(this.threadUserTimes.length);
            for (i = 0; i < this.threadUserTimes.length; ++i) {
                writer.writeInt64(this.threadUserTimes[i]);
                writer.writeInt64(this.threadSystemTimes[i]);
            }
            writer.writeInt64(this.time);
            writer.writeInt64(this.pid);
            writer.writeString(SystemInfoImpl.toNonNullString(this.vmArgs));
            writer.writeString(SystemInfoImpl.toNonNullString(this.javaVmArgs));
            writer.writeString(SystemInfoImpl.toNonNullString(this.debuggingClient));
            writer.writeInt32(this.debugPort);
            writer.writeBoolean(this.canCombinedAllocMptTrace);
            writer.writeBoolean(this.canCombinedPerfMptTrace);
            writer.writeBoolean(this.hasStackTraceInThreadStartEvent);
            writer.writeInt32(this.patchLevel);
            writer.writeBoolean(this.hasIOTrace);
            writer.writeBoolean(this.hasMethodTrace);
            writer.writeBoolean(this.hasSynchronizationTrace);
            writer.writeInt64(this.osCounterFrequency);
            writer.writeBoolean(this.tbsSupportsCpuTime);
            writer.writeBoolean(this.tbsSupportsTierCompilationInfo);
            writer.writeBoolean(this.hasNetworkTrace);
            writer.writeBoolean(this.supportsClassFilterV2);
            writer.writeInt64(this.startTime);
            writer.writeBoolean(this.hasAlertTrace);
            writer.writeBoolean(this.supportsHprofDump);
            writer.writeInt32(this.compilerThreadsCount);
            writer.writeBoolean(this.supportsProfilingServer);
            writer.writeBoolean(this.supportsJvmProfControl);
            writer.writeBoolean(this.supportsJRubyInAllocTrace);
            writer.writeBoolean(this.hasClassStatisticDumpTrace);
            writer.writeBoolean(this.supportsThreadDump);
            writer.writeInt64(this.maxHeapCapacity);
            writer.writeInt32(this.storedAlertCounts.length);
            for (i = 0; i < this.storedAlertCounts.length; ++i) {
                writer.writeInt32(this.storedAlertCounts[i]);
                if (this.storedAlertCounts[i] <= 0) continue;
                writer.writeDouble(this.storedAlertFirstTimes[i]);
                writer.writeDouble(this.storedAlertLastTimes[i]);
                writer.writeString(this.storedAlertLastInfos[i]);
            }
            writer.writeBoolean(this.supportsBasicMonitoringBoardTrace);
            writer.writeBoolean(this.hasCorrectReferenceHandlingData);
            writer.writeBoolean(this.supportsFullMonitoringBoardTrace);
            writer.writeBoolean(this.supportsGcHistoryFileDump);
            writer.writeString(this.defaultTimeZone);
            writer.writeBoolean(this.supportsStackAllocations);
            writer.writeBoolean(this.supportsThreadDump);
            writer.writeBoolean(this.hasReallyCorrectReferenceHandlingData);
            writer.writeBoolean(this.hasMetaspace);
            writer.writeInt8(this.logBytesPerWord);
            writer.writeUint16((char)this.gcStatisticVersion);
        }
        writer.finalizePacket();
    }

    private static final HashMap<String, String> readStringHashMap(ResourceReader reader) throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        int size = reader.readInt32();
        for (int i = 0; i < size; ++i) {
            String key = reader.readString();
            String value = null;
            if (reader.readInt8() != 0) {
                value = reader.readString();
            }
            result.put(key, value);
        }
        return result;
    }

    private static final void writeStringHashMap(HashMap<String, String> map, ResourceWriter writer) throws IOException {
        writer.writeInt32(map.size());
        for (Map.Entry<String, String> entry : map.entrySet()) {
            writer.writeString(entry.getKey());
            writer.writeBoolean(entry.getValue() != null);
            if (entry.getValue() == null) continue;
            writer.writeString(entry.getValue());
        }
    }

    @Override
    public long getAccumulatedProcessTime() {
        return this.accumulatedProcessTime;
    }

    @Override
    public long getAccumulatedSystemTime() {
        return this.accumulatedSystemTime;
    }

    @Override
    public long getAccumulatedUserTime() {
        return this.accumulatedUserTime;
    }

    @Override
    public int getMajorVersion() {
        return this.majorVersion;
    }

    @Override
    public int getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public int getMicroVersion() {
        return this.microVersion;
    }

    @Override
    public long getTimeNanos() {
        return this.timeNanos;
    }

    @Override
    public int getVmIndex() {
        return this.vmIndex;
    }

    @Override
    public int getVmUniqueId() {
        return this.vmUniqueId;
    }

    @Override
    public boolean allowMethodModifiers() {
        return this.allowMethodModifiers;
    }

    @Override
    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getVmInfo() {
        return this.vmInfo;
    }

    @Override
    public String getVmName() {
        return this.vmName;
    }

    @Override
    public String getVmRelease() {
        return this.vmRelease;
    }

    @Override
    public int[] getVmReleaseMajorMinorPatch() {
        int J = -1;
        int M = -1;
        int P = -1;
        Matcher m = null;
        m = Pattern.compile("(\\d+)\\.(\\d).(\\d\\d\\d) .*").matcher(this.getVmRelease());
        if (m.find()) {
            J = Integer.parseInt(m.group(1));
            M = Integer.parseInt(m.group(2));
            P = Integer.parseInt(m.group(3));
        } else {
            m = Pattern.compile("(\\d+)\\.(\\d\\d\\d) .*").matcher(this.getVmRelease());
            if (m.find()) {
                J = Integer.parseInt(m.group(1));
                P = Integer.parseInt(m.group(2));
            } else {
                m = Pattern.compile("(\\d+)\\..*").matcher(this.getVmRelease());
                if (m.find()) {
                    J = Integer.parseInt(m.group(1));
                }
            }
        }
        int[] res = new int[]{J, M, P};
        return res;
    }

    @Override
    public int getNrOfCpus() {
        return this.nrOfCpus;
    }

    @Override
    public int getNrOfCompileThreads() {
        return this.compilerThreadsCount;
    }

    @Override
    public String getCPUFeatures() {
        return this.cpuFeatures;
    }

    @Override
    public String getMemoryInformation() {
        return this.memoryInfo;
    }

    @Override
    public String getOsInformation() {
        return this.osInfo;
    }

    @Override
    public String getLibraryInformation() {
        return this.libraryInfo;
    }

    @Override
    public HashMap<String, String> getEnvironment() {
        return this.envVars;
    }

    @Override
    public String getWorkingDirectory() {
        return this.workingDirectory;
    }

    @Override
    public HashMap<String, String> getInitialVmProperties() {
        return this.initProps;
    }

    @Override
    public HashMap<String, String> getProperties() {
        return this.currentProps;
    }

    @Override
    public String[] getNativeTimeZoneInfo() {
        return new String[]{this.timeZoneInfo1, this.timeZoneInfo2};
    }

    @Override
    public HashMap<String, String> getFlags() {
        return this.flags;
    }

    @Override
    public String[] getVmArguments() {
        return this.vmArguments;
    }

    @Override
    public int getInstanceNr() {
        return this.instanceNumber;
    }

    @Override
    public long getMaxHeapSize() {
        return this.vmHeapSize;
    }

    @Override
    public long getMaxHeapCapacity() {
        return this.maxHeapCapacity;
    }

    @Override
    public long getCommittedHeapSize() {
        return this.vmCommittedHeapSize;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public boolean hasAlertTrace() {
        return this.hasAlertTrace;
    }

    @Override
    public void print(PrintStream stream) {
        stream.println("Major version: " + this.getMajorVersion());
        stream.println("Minor version: " + this.getMinorVersion());
        stream.println("Micro version: " + this.getMicroVersion());
        stream.println("Instance nr: " + this.getInstanceNr());
        stream.println("VM index: " + this.getVmIndex());
        stream.println("VM Id: " + this.getVmUniqueId());
        stream.println("Max heap size (MB): " + (double)this.getMaxHeapSize() / 1024.0 / 1024.0);
        stream.println("Max heap capacity (MB): " + (double)this.getMaxHeapCapacity() / 1024.0 / 1024.0);
        stream.println("Committed heap size (MB): " + (double)this.getCommittedHeapSize() / 1024.0 / 1024.0);
        DateFormat df = DateFormat.getDateTimeInstance();
        stream.println("Profiling start time (in nanos): " + df.format(new Date(this.getTimeNanos() / 1000000L)));
        stream.println("Profiling start time (via currentTimeMillis): " + df.format(new Date(this.getTimeMillis())));
        stream.println("Profiling start time stamp: " + this.getTimeStamp());
        stream.println("Accumulated process time (ms): " + (double)this.getAccumulatedProcessTime() / 1000000.0);
        stream.println("Accumulated user time (ms): " + (double)this.getAccumulatedUserTime() / 1000000.0);
        stream.println("Accumulated system time (ms): " + (double)this.getAccumulatedSystemTime() / 1000000.0);
        stream.println("Host name: " + this.getHostName());
        stream.println("Allow method modifiers: " + this.allowMethodModifiers());
        stream.println("VM name: " + this.getVmName());
        stream.println("VM release: " + this.getVmRelease());
        stream.println("VM info: " + this.getVmInfo());
        stream.println("Nr of CPUs: " + this.getNrOfCpus());
        stream.println("CPU features: " + this.getCPUFeatures());
        this.printStringWithNewline(stream, "Memory information: ", this.getMemoryInformation());
        this.printStringWithNewline(stream, "OS information: ", this.getOsInformation());
        this.printStringWithNewline(stream, "Library information: ", this.getLibraryInformation());
        this.printMap(stream, "Environment variables: ", this.getEnvironment());
        stream.println("Working directory: " + this.getWorkingDirectory());
        this.printMap(stream, "Initial VM system properties: ", this.getInitialVmProperties());
        this.printMap(stream, "System properties: ", this.getProperties());
        this.printStrings(stream, "Native timezone: ", this.getNativeTimeZoneInfo());
        this.printMap(stream, "VM flags: ", this.getFlags());
        this.printStrings(stream, "VM arguments: ", this.getVmArguments());
        stream.println("Time stamp is monotonic: " + this.timeStampIsMonotonic());
        stream.println("Time stamp overhead: " + this.timeStampOverhead() + " ns");
        stream.println("Time stamp resolution: " + this.timeStampResolution() + " ns");
        stream.println("Overall CPU user time is monotonic: " + this.overallCpuUserTimeIsMonotonic());
        stream.println("Overall CPU user time resolution: " + this.overallCpuUserTimeResolution() + " us");
        stream.println("Overall CPU system time is monotonic: " + this.overallCpuSystemTimeIsMonotonic());
        stream.println("Overall CPU system time resolution: " + this.overallCpuSystemTimeResolution() + " us");
        stream.println("Overall CPU time is monotonic: " + this.overallCpuTimeIsMonotonic());
        stream.println("Overall CPU time resolution: " + this.overallCpuTimeResolution() + " us");
        stream.println("Thread CPU user time is monotonic: " + this.threadCpuUserTimeIsMonotonic());
        stream.println("Thread CPU user time resolution: " + this.threadCpuUserTimeResolution() + " us");
        stream.println("Thread CPU system time is monotonic: " + this.threadCpuSystemTimeIsMonotonic());
        stream.println("Thread CPU system time resolution: " + this.threadCpuSystemTimeResolution() + " us");
        stream.println("Thread CPU time is monotonic: " + this.threadCpuTimeIsMonotonic());
        stream.println("Thread CPU time resolution: " + this.threadCpuTimeResolution() + " us");
        stream.println("PID: " + this.pid);
        stream.println("Patch Level: " + this.patchLevel);
        stream.println("Supports TBS CPU time: " + this.tbsSupportsCpuTime);
        stream.println("Supports Network trace: " + this.hasNetworkTrace);
        stream.println("Supports version 2 class filters: " + this.supportsClassFilterV2);
        stream.println("Supports alert traces : " + this.hasAlertTrace);
        stream.println("Supports hprof dumps: " + this.supportsHprofDump);
        stream.println("Supports GC trace: " + this.hasGcTrace);
        stream.println("Number of compiler threads: " + this.compilerThreadsCount);
        stream.println("Supports JvmProf:" + this.supportsJvmProfControl);
        stream.println("Supports ProfilingServer:" + this.supportsProfilingServer);
        stream.println("VM start time (via currentTimeMillis): " + (this.getStartTimeMillis() == -1L ? "<unknown>" : df.format(new Date(this.getStartTimeMillis()))));
        stream.println("Supports Class Statistic Dumps:" + this.hasClassStatisticDumpTrace);
        stream.println("Supports thread dumps: " + this.supportsThreadDump);
        stream.println("Supports monitoring board trace: " + (this.supportsFullMonitoringBoardTrace ? "full" : (this.supportsBasicMonitoringBoardTrace ? "basic" : "none")));
        stream.println("Has correct reference handling data: " + this.hasCorrectReferenceHandlingData);
        stream.println("Has really correct reference handling data: " + this.hasReallyCorrectReferenceHandlingData);
        stream.println("Supports getting GC history file dumps : " + this.supportsGcHistoryFileDump);
        stream.println("Default Time Zone: " + this.defaultTimeZone);
        stream.println("Supports stack allocations: " + this.supportsStackAllocations);
        stream.println("Supports thread dumps: " + this.supportsThreadDump);
        stream.println("Has Metaspace: " + this.hasMetaspace);
        stream.println("Log of the word size in bytes: " + this.logBytesPerWord);
        stream.println("GC statistic version: " + this.gcStatisticVersion);
    }

    private void printStrings(PrintStream stream, String head, String[] data) {
        for (int i = 0; i < data.length; ++i) {
            if (i == 0) {
                stream.println(head + data[i]);
                continue;
            }
            for (int j = 0; j < head.length(); ++j) {
                stream.print(' ');
            }
            stream.println(data[i]);
        }
    }

    private void printStringWithNewline(PrintStream stream, String head, String data) {
        this.printStrings(stream, head, data.split("(\n)|(\n\r)"));
    }

    private void printMap(PrintStream stream, String head, HashMap<String, String> data) {
        StringBuilder indent = new StringBuilder();
        for (int i = 0; i < head.length(); ++i) {
            indent.append(' ');
        }
        boolean isFirst = true;
        ArrayList<Map.Entry<String, String>> entries = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, String> entry : data.entrySet()) {
            entries.add(entry);
        }
        Collections.sort(entries, new Comparator<Map.Entry<String, String>>(){

            @Override
            public int compare(Map.Entry<String, String> o1, Map.Entry<String, String> o2) {
                return o1.getKey().compareToIgnoreCase(o2.getKey());
            }
        });
        for (Map.Entry<String, String> entry : entries) {
            if (isFirst) {
                if (entry.getValue() == null) {
                    this.printStringWithNewline(stream, head + entry.getKey(), " is undefined");
                } else {
                    this.printStringWithNewline(stream, head + entry.getKey() + "=", entry.getValue());
                }
                isFirst = false;
                continue;
            }
            if (entry.getValue() == null) {
                this.printStringWithNewline(stream, indent + entry.getKey(), " is undefined");
                continue;
            }
            this.printStringWithNewline(stream, indent + entry.getKey() + "=", entry.getValue());
        }
    }

    private static long[] calcDifference(long[] values) {
        long[] diffs = new long[values.length - 1];
        for (int i = 1; i < values.length; ++i) {
            diffs[i - 1] = values[i] - values[i - 1];
        }
        return diffs;
    }

    private static boolean valuesAreMonotonic(long[] values) {
        for (long diff : SystemInfoImpl.calcDifference(values)) {
            if (diff >= 0L) continue;
            return false;
        }
        return true;
    }

    private static long calcTimeStampResolution(long[] timeStamps) {
        return SystemInfoImpl.calcTimeStampOverhead(timeStamps);
    }

    private static long calcTimeStampOverhead(long[] timeStamps) {
        long result = Long.MAX_VALUE;
        for (long value : SystemInfoImpl.calcDifference(timeStamps)) {
            if (value <= 0L) continue;
            result = Math.min(result, value);
        }
        if (result == Long.MAX_VALUE) {
            return 0L;
        }
        return result;
    }

    public static long lowestCommonDenominator(long[] values) {
        int i;
        int[] twos = new int[values.length];
        int[] threes = new int[values.length];
        int[] fives = new int[values.length];
        for (int i2 = 0; i2 < values.length; ++i2) {
            long value;
            for (value = values[i2]; value != 0L && (value & 1L) != 0L; value /= 2L) {
                int n = i2;
                twos[n] = twos[n] + 1;
            }
            while (value != 0L && value % 3L == 0L) {
                int n = i2;
                threes[n] = threes[n] + 1;
                value /= 3L;
            }
            while (value != 0L && value % 5L == 0L) {
                int n = i2;
                fives[n] = fives[n] + 1;
                value /= 5L;
            }
        }
        int min_twos = twos[0];
        int min_threes = threes[0];
        int min_fives = fives[0];
        for (int i3 = 1; i3 < values.length; ++i3) {
            min_twos = Math.min(min_twos, twos[i3]);
            min_threes = Math.min(min_threes, threes[i3]);
            min_fives = Math.min(min_fives, fives[i3]);
        }
        long result = 1L;
        for (i = 0; i < min_twos; ++i) {
            result *= 2L;
        }
        for (i = 0; i < min_threes; ++i) {
            result *= 3L;
        }
        for (i = 0; i < min_fives; ++i) {
            result *= 5L;
        }
        return result;
    }

    @Override
    public boolean timeStampIsMonotonic() {
        return this.timeStampIsMonotonic;
    }

    @Override
    public long timeStampOverhead() {
        return this.timeStampOverhead >= this.timeStampResolution ? this.timeStampOverhead : -1L;
    }

    @Override
    public long timeStampResolution() {
        return this.timeStampResolution;
    }

    @Override
    public boolean overallCpuSystemTimeIsMonotonic() {
        return this.overallCpuSystemTimeIsMonotonic;
    }

    @Override
    public long overallCpuSystemTimeResolution() {
        return this.overallCpuSystemTimeResolution;
    }

    @Override
    public boolean overallCpuTimeIsMonotonic() {
        return this.overallCpuTimeIsMonotonic;
    }

    @Override
    public long overallCpuTimeResolution() {
        return this.overallCpuTimeResolution;
    }

    @Override
    public boolean overallCpuUserTimeIsMonotonic() {
        return this.overallCpuUserTimeIsMonotonic;
    }

    @Override
    public long overallCpuUserTimeResolution() {
        return this.overallCpuUserTimeResolution;
    }

    @Override
    public boolean threadCpuSystemTimeIsMonotonic() {
        return this.threadCpuSystemTimeIsMonotonic;
    }

    @Override
    public long threadCpuSystemTimeResolution() {
        return this.threadCpuSystemTimeResolution;
    }

    @Override
    public boolean threadCpuTimeIsMonotonic() {
        return this.threadCpuTimeIsMonotonic;
    }

    @Override
    public long threadCpuTimeResolution() {
        return this.threadCpuTimeResolution;
    }

    @Override
    public boolean threadCpuUserTimeIsMonotonic() {
        return this.threadCpuUserTimeIsMonotonic;
    }

    @Override
    public long threadCpuUserTimeResolution() {
        return this.threadCpuUserTimeResolution;
    }

    @Override
    public long getPid() {
        return this.pid;
    }

    @Override
    public long getTimeMillis() {
        return this.time;
    }

    private static final String toNonNullString(String str) {
        if (str == null) {
            return "";
        }
        return str;
    }

    @Override
    public String getClassPath() {
        if (this.vmArgs == null) {
            return null;
        }
        String property = "-Djava.class.path=";
        int index = this.vmArgs.lastIndexOf(property);
        if (index == -1) {
            return null;
        }
        return this.vmArgs.substring(index + property.length());
    }

    @Override
    public String getDebugConnectionInfo() {
        return this.debuggingClient;
    }

    @Override
    public String getJavaArguments() {
        if (this.javaVmArgs == null) {
            return null;
        }
        int index = this.javaVmArgs.indexOf(32);
        if (index == -1) {
            return "";
        }
        return this.javaVmArgs.substring(index + 1);
    }

    @Override
    public String getMainClass() {
        if (this.javaVmArgs == null) {
            return null;
        }
        int index = this.javaVmArgs.indexOf(32);
        if (index == -1) {
            return this.javaVmArgs;
        }
        return this.javaVmArgs.substring(0, index);
    }

    @Override
    public int getDebuggingPort() {
        return this.debugPort;
    }

    @Override
    public boolean canCombinedAllocationMptTrace() {
        return this.canCombinedAllocMptTrace;
    }

    @Override
    public boolean canCombinedPerformanceMptTrace() {
        return this.canCombinedPerfMptTrace;
    }

    @Override
    public boolean hasIOTrace() {
        return this.hasIOTrace;
    }

    @Override
    public boolean hasMethodTrace() {
        return this.hasMethodTrace;
    }

    @Override
    public boolean hasSynchronizationTrace() {
        return this.hasSynchronizationTrace;
    }

    @Override
    public boolean hasGcTrace() {
        return this.hasGcTrace;
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public boolean hasStackTraceInThreadStartEvent() {
        return this.hasStackTraceInThreadStartEvent;
    }

    @Override
    public int getPatchLevel() {
        return this.patchLevel;
    }

    @Override
    public long getOSCounterFrequency() {
        return this.osCounterFrequency;
    }

    @Override
    public double getOSCounterNanoFrequency() {
        return this.osCounterNanoFrequency;
    }

    @Override
    public double getOSCounterPeriod() {
        return this.osCounterPeriod;
    }

    @Override
    public boolean tbsSupportsCpuTime() {
        return this.tbsSupportsCpuTime;
    }

    @Override
    public boolean tbsSupportsTierInformation() {
        return this.tbsSupportsTierCompilationInfo;
    }

    @Override
    public boolean mptSupportsTierInformation() {
        return this.tbsSupportsTierInformation();
    }

    @Override
    public boolean hasNetworkTrace() {
        return this.hasNetworkTrace;
    }

    @Override
    public boolean supportsClassFilterV2() {
        return this.supportsClassFilterV2;
    }

    @Override
    public long getStartTimeMillis() {
        return this.startTime;
    }

    @Override
    public boolean supportsHprofDump() {
        return this.supportsHprofDump;
    }

    @Override
    public boolean supportsJvmProfControl() {
        return this.supportsJvmProfControl;
    }

    @Override
    public boolean supportsJRubyInAllocTrace() {
        return this.supportsJRubyInAllocTrace;
    }

    @Override
    public boolean supportsClassStatisticDumps() {
        return this.hasClassStatisticDumpTrace;
    }

    @Override
    public boolean supportsThreadDump() {
        return this.supportsThreadDump;
    }

    @Override
    public StorableAlertSummary[] getStorableAlertSummaries() {
        StorableAlertSummary[] result = new StorableAlertSummary[this.storedAlertCounts.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new StorableAlertSummary(i, this.storedAlertCounts[i], this.storedAlertFirstTimes[i], this.storedAlertLastTimes[i], this.storedAlertLastInfos[i]);
        }
        return result;
    }

    @Override
    public boolean hasMonitoringBoardTrace() {
        return this.supportsBasicMonitoringBoardTrace;
    }

    @Override
    public boolean hasFullMonitoringBoardTrace() {
        return this.supportsFullMonitoringBoardTrace;
    }

    @Override
    public boolean supportsGcHistoryFileDump() {
        return this.supportsGcHistoryFileDump;
    }

    @Override
    public String getDefaultTimeZone() {
        return this.defaultTimeZone;
    }

    @Override
    public boolean supportsStackAllocations() {
        return this.supportsStackAllocations;
    }

    @Override
    public boolean supportsReallyAdvancedReferenceHandling() {
        return this.hasReallyCorrectReferenceHandlingData;
    }

    @Override
    public boolean hasMetaspace() {
        return this.hasMetaspace;
    }

    @Override
    public boolean supportsProfilingServer() {
        return this.supportsProfilingServer;
    }

    @Override
    public byte getLogBytesPerWord() {
        return this.logBytesPerWord;
    }

    @Override
    public int gcStatisticVersion() {
        return this.gcStatisticVersion;
    }

    @Override
    public boolean use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle() {
        return this.use2TimesMaxOldGenSizeAsMaximumForBytesPromotedDuringCmsCycle;
    }

    @Override
    public boolean gcStatisticHasClassSpaceData() {
        return this.gcStatisticHasClassSpaceData;
    }

    @Override
    public boolean gcStatisticHasG1SpecificDetails() {
        return this.gcStatisticHasG1SpecificDetails;
    }
}

