/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.TestContentEvent;
import com.sap.jvm.profiling.core.event.TestContentEventHandler;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.Arrays;

public class TestContentEventImpl
extends ProfilingPacketImpl
implements TestContentEvent {
    private byte[] bytes;

    public static TestContentEventImpl read(ResourceReader reader, TestContentEventHandler[] handlers) throws IOException {
        TestContentEventImpl newObj = new TestContentEventImpl(reader);
        for (TestContentEventHandler handler : handlers) {
            handler.handle(newObj);
        }
        return newObj;
    }

    private TestContentEventImpl(ResourceReader reader) throws IOException {
        int size = reader.readInt32();
        this.bytes = new byte[size];
        reader.readBytes(this.bytes);
    }

    public TestContentEventImpl(byte[] content) throws IOException {
        this.bytes = content;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.TEST_CONTENT_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.print("Contains " + this.bytes.length + " bytes ");
        stream.print(Arrays.toString(this.bytes));
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)756);
        writer.writeInt32(this.bytes.length);
        writer.writeBytes(this.bytes);
    }

    @Override
    public byte[] getBytes() {
        return this.bytes;
    }

    @Override
    public String getPacketName() {
        return "test content event";
    }
}

