/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadAnnotationChanged;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadAnnotationChangedImpl
extends ProfilingPacketImpl
implements ThreadAnnotationChanged {
    private final char threadIndex;
    private final short slot;
    private final UTF8String annotation;
    private final ThreadInfoImpl threadInfo;

    public static ThreadAnnotationChangedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] eventHandlers) throws IOException {
        ThreadAnnotationChangedImpl retValue = new ThreadAnnotationChangedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : eventHandlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadAnnotationChangedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.slot = reader.readInt16();
        this.annotation = reader.readUTF();
        this.threadInfo = mapInfo.getThreadInfo(this.threadIndex);
        this.threadInfo.changeAnnotation(this.slot, this.annotation);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_ANNOTATION_CHANGED_EVENT;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index    : %d", this.threadIndex);
        stream.formatln("Thread id       : %d", this.threadInfo.getThreadId());
        stream.formatln("Annotation slot : %s", this.slot);
        stream.formatln("New annotation  : %s", this.annotation.toString());
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)557);
        writer.writeUint16(this.threadIndex);
        writer.writeInt16(this.slot);
        writer.writeUTF(this.annotation);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread annotation changed event";
    }
}

