/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadNameChanged;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadNameChangedImpl
extends ProfilingPacketImpl
implements ThreadNameChanged {
    private final char threadIndex;
    private final UTF8String name;
    private final ThreadInfoImpl threadInfo;

    public static ThreadNameChangedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] eventHandlers) throws IOException {
        ThreadNameChangedImpl retValue = new ThreadNameChangedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : eventHandlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadNameChangedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.name = reader.readUTF();
        this.threadInfo = mapInfo.getThreadInfo(this.threadIndex);
        this.threadInfo.changeName(this.name);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_NAME_CHANGED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index    : %d", this.threadIndex);
        stream.formatln("Thread id       : %d", this.threadInfo.getThreadId());
        stream.formatln("New thread name : %s", this.name.toString());
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)525);
        writer.writeUint16(this.threadIndex);
        writer.writeUTF(this.name);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread name changed event";
    }
}

