/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadAnnotationImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadStartedImpl
extends ProfilingPacketImpl
implements ThreadStarted {
    private final char threadIndex;
    private final UTF8String name;
    private final UTF8String user;
    private final long javaId;
    private final ThreadInfoImpl threadInfo;

    public static ThreadStartedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] handlers) throws IOException {
        ThreadStartedImpl retValue = new ThreadStartedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : handlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadStartedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.name = reader.readUTF();
        this.user = reader.readUTF();
        this.javaId = reader.readInt64();
        ThreadAnnotationImpl[] annotations = new ThreadAnnotationImpl[]{new ThreadAnnotationImpl(0, this.user, mapInfo), new ThreadAnnotationImpl(1, UTF8Creator.create(""), mapInfo), new ThreadAnnotationImpl(2, UTF8Creator.create(""), mapInfo), new ThreadAnnotationImpl(3, UTF8Creator.create(""), mapInfo), new ThreadAnnotationImpl(4, UTF8Creator.create(""), mapInfo), new ThreadAnnotationImpl(5, UTF8Creator.create(""), mapInfo)};
        this.threadInfo = ThreadInfoImpl.createNew(this.threadIndex, this.javaId, this.name, annotations, mapInfo.getThreadChangeCount() + 1L);
        mapInfo.setThreadInfo(this.threadIndex, this.threadInfo);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_STARTED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index : %d", this.threadIndex);
        stream.formatln("Thread id    : %d", this.javaId);
        stream.formatln("Initial name : %s", this.name.toString());
        stream.formatln("Initial user : %s", this.user.toString());
    }

    @Override
    public long getJavaId() {
        return this.javaId;
    }

    @Override
    public UTF8String getName() {
        return this.name;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)523);
        writer.writeUint16(this.threadIndex);
        writer.writeUTF(this.name);
        writer.writeUTF(this.user);
        writer.writeInt64(this.javaId);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return 0;
    }

    @Override
    public String getPacketName() {
        return "thread started event";
    }
}

