/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadStopped;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadStoppedImpl
extends ProfilingPacketImpl
implements ThreadStopped {
    private final char threadIndex;
    private final ThreadInfoImpl threadInfo;

    public static ThreadStoppedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] handlers) throws IOException {
        ThreadStoppedImpl retValue = new ThreadStoppedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : handlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadStoppedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.threadInfo = mapInfo.getThreadInfo(this.threadIndex);
        this.threadInfo.setDead();
        mapInfo.setThreadChangeCount(Math.max(this.threadInfo.getNameOrAnnotationChangeCount(), this.threadInfo.getParameterChangeCount()));
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_STOPPED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index : %d", this.threadIndex);
        stream.formatln("Thread id    : %d", this.threadInfo.getThreadId());
        stream.formatln("Current name : %s", this.threadInfo.getName());
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)524);
        writer.writeUint16(this.threadIndex);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread stopped event";
    }
}

