/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadUserChanged;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadUserChangedImpl
extends ProfilingPacketImpl
implements ThreadUserChanged {
    private final char threadIndex;
    private final UTF8String user;
    private final ThreadInfoImpl threadInfo;

    public static ThreadUserChangedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] eventHandlers) throws IOException {
        ThreadUserChangedImpl retValue = new ThreadUserChangedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : eventHandlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadUserChangedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        this.threadIndex = reader.readUint16();
        this.user = reader.readUTF();
        this.threadInfo = mapInfo.getThreadInfo(this.threadIndex);
        this.threadInfo.changeUser(this.user, mapInfo);
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_USER_CHANGED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index : %d", this.threadIndex);
        stream.formatln("Thread id    : %d", this.threadInfo.getThreadId());
        stream.formatln("New  user    : %s", this.user.toString());
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public UTF8String getUser() {
        return this.user;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)526);
        writer.writeUint16(this.threadIndex);
        writer.writeUTF(this.user);
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "thread user changed event";
    }
}

