/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.core.event.ThreadEventHandler;
import com.sap.jvm.profiling.core.event.ThreadStarted;
import com.sap.jvm.profiling.core.type.ThreadManager;
import com.sap.jvm.profiling.core.type.UTF8Creator;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.ThreadAnnotationImpl;
import com.sap.jvm.profiling.impl.core.ThreadInfoImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ThreadWithAnnotationsStartedImpl
extends ProfilingPacketImpl
implements ThreadStarted {
    private final char threadIndex;
    private final UTF8String name;
    private final short[] annotationSlots;
    private final UTF8String[] annotationValues;
    private final long javaId;
    private final int stackTraceIndex;
    private final ThreadInfoImpl threadInfo;

    public static ThreadWithAnnotationsStartedImpl read(ResourceReader reader, MappingInformation mapInfo, ThreadEventHandler[] eventHandlers) throws IOException {
        ThreadWithAnnotationsStartedImpl retValue = new ThreadWithAnnotationsStartedImpl(reader, mapInfo);
        for (ThreadEventHandler handler : eventHandlers) {
            handler.handle(retValue, (ThreadManager)mapInfo);
        }
        return retValue;
    }

    private ThreadWithAnnotationsStartedImpl(ResourceReader reader, MappingInformation mapInfo) throws IOException {
        SystemInfo systemInfo;
        this.threadIndex = reader.readUint16();
        this.name = reader.readUTF();
        ThreadAnnotationImpl[] annotations = new ThreadAnnotationImpl[mapInfo.getNrOfAnnotationKeys()];
        for (int i = 0; i < annotations.length; ++i) {
            annotations[i] = new ThreadAnnotationImpl(i, UTF8Creator.create(""), mapInfo);
        }
        int nrOfAnnotations = reader.readInt16();
        this.annotationSlots = new short[nrOfAnnotations];
        this.annotationValues = new UTF8String[nrOfAnnotations];
        for (int i = 0; i < nrOfAnnotations; ++i) {
            this.annotationSlots[i] = reader.readInt16();
            this.annotationValues[i] = reader.readUTF();
            annotations[this.annotationSlots[i]].setValue(this.annotationValues[i]);
        }
        this.javaId = reader.readInt64();
        this.threadInfo = ThreadInfoImpl.createNew(this.threadIndex, this.javaId, this.name, annotations, mapInfo.getThreadChangeCount() + 1L);
        mapInfo.setThreadInfo(this.threadIndex, this.threadInfo);
        this.stackTraceIndex = reader.hasNext() ? ((systemInfo = reader.getSession().getSystemInfo()) == null || systemInfo.hasStackTraceInThreadStartEvent() ? reader.readStackTraceIndex() : 0) : 0;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.THREAD_STARTED_EVENT;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Thread index       : %d", this.threadIndex);
        stream.formatln("Thread id          : %d", this.javaId);
        stream.formatln("Initial name       : %s", this.name.toString());
        stream.formatln("Initial stack      : %*S", this.stackTraceIndex);
        if (this.annotationSlots.length > 0) {
            stream.formatln("Nr. of annotations : %d", this.annotationSlots.length);
            for (int i = 0; i < this.annotationSlots.length; ++i) {
                stream.formatln("Annotation slot    : %d", this.annotationSlots[i]);
                stream.formatln("Annotation value   : %s", this.annotationValues[i]);
            }
        }
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public long getJavaId() {
        return this.javaId;
    }

    @Override
    public UTF8String getName() {
        return this.name;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        ThreadWithAnnotationsStartedImpl.write(writer, this.threadIndex, this.javaId, this.name, this.annotationSlots, this.annotationValues, this.stackTraceIndex);
    }

    public static void write(PacketResourceWriter writer, ThreadInfoImpl threadInfoImpl) throws IOException {
        ThreadAnnotationImpl[] annotations = threadInfoImpl.getAnnotations();
        short[] annotationSlots = new short[annotations.length];
        UTF8String[] annotationValues = new UTF8String[annotations.length];
        for (int i = 0; i < annotations.length; ++i) {
            annotationSlots[i] = (short)i;
            annotationValues[i] = annotations[i].getValue();
        }
        ThreadWithAnnotationsStartedImpl.write(writer, threadInfoImpl.getIndex(), threadInfoImpl.getThreadId(), threadInfoImpl.getNameUTF(), annotationSlots, annotationValues, 0);
    }

    private static void write(PacketResourceWriter writer, char threadIndex, long javaId, UTF8String name, short[] annotationSlots, UTF8String[] annotationValues, int stackTraceIndex) throws IOException {
        writer.initializePacket((short)556);
        writer.writeUint16(threadIndex);
        writer.writeUTF(name);
        writer.writeInt16((short)annotationSlots.length);
        for (int i = 0; i < annotationSlots.length; ++i) {
            writer.writeInt16(annotationSlots[i]);
            writer.writeUTF(annotationValues[i]);
        }
        writer.writeInt64(javaId);
        writer.writeInt32(stackTraceIndex);
        writer.finalizePacket();
    }

    @Override
    public int getStackTraceIndex() {
        return this.stackTraceIndex;
    }

    @Override
    public String getPacketName() {
        return "thread started with annotation event";
    }
}

