/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.response.ChangeHeartBeatIntervalResponse;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ChangeHeartBeatIntervalResponseImpl
extends ResponseImpl
implements ChangeHeartBeatIntervalResponse {
    private long interval;

    public static ChangeHeartBeatIntervalResponseImpl read(ResourceReader reader, HeartBeatEventHandler[] handlers) throws IOException {
        ChangeHeartBeatIntervalResponseImpl retValue = new ChangeHeartBeatIntervalResponseImpl(reader);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private ChangeHeartBeatIntervalResponseImpl(ResourceReader reader) throws IOException {
        super("enable heart beat response", reader);
        this.interval = reader.readInt64();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.CHANGE_HEART_BEAT_INTERVAL_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.println("HeartBeat interval :" + this.interval);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1040);
        this.writeInternal(writer);
        writer.writeInt64(this.interval);
        writer.finalizePacket();
    }

    @Override
    public long getInterval() {
        return this.interval;
    }
}

