/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.event.HeartBeatEventHandler;
import com.sap.jvm.profiling.core.response.EnableHeartBeatResponse;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class EnableHeartBeatResponseImpl
extends ResponseImpl
implements EnableHeartBeatResponse {
    private long interval = 1000L;

    public static EnableHeartBeatResponseImpl read(ResourceReader reader, HeartBeatEventHandler[] handlers) throws IOException {
        EnableHeartBeatResponseImpl retValue = new EnableHeartBeatResponseImpl(reader);
        for (HeartBeatEventHandler handler : handlers) {
            handler.handle(retValue);
        }
        return retValue;
    }

    private EnableHeartBeatResponseImpl(ResourceReader reader) throws IOException {
        super("enable heart beat response", reader);
        if (reader.hasNext()) {
            this.interval = reader.readInt64();
        }
    }

    @Override
    public long getInterval() {
        return this.interval;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.ENABLE_HEART_BEAT_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.println("HeartBeat interval :" + this.interval);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1032);
        this.writeInternal(writer);
        writer.writeInt64(this.interval);
        writer.finalizePacket();
    }
}

