/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.response.ExtensionCommandResponse;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ExtensionCommandResponseImpl
extends ResponseImpl
implements ExtensionCommandResponse {
    private byte[] data;

    public ExtensionCommandResponseImpl(ResourceReader reader) throws IOException {
        super("extension command response", reader);
        int dataLength = reader.readInt32();
        this.data = new byte[dataLength];
        for (int i = 0; i < dataLength; ++i) {
            this.data[i] = reader.readInt8();
        }
    }

    @Override
    public byte[] getData() {
        return this.data;
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.EXTENSION_COMMAND_RESPONSE;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1015);
        this.writeInternal(writer);
        writer.writeInt32(this.data.length);
        for (int i = 0; i < this.data.length; ++i) {
            writer.writeBytes(this.data);
        }
        writer.finalizePacket();
    }
}

