/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.response;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.ProfilingTraceType;
import com.sap.jvm.profiling.core.event.SnapshotMarkerHandler;
import com.sap.jvm.profiling.core.response.SnapshotMarkerResponse;
import com.sap.jvm.profiling.impl.core.ResponseImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class SnapshotMarkerResponseImpl
extends ResponseImpl
implements SnapshotMarkerResponse {
    private final ProfilingTraceType type;
    private final String name;
    private final boolean delta;

    public static SnapshotMarkerResponseImpl read(ResourceReader reader, SnapshotMarkerHandler[] handlers) throws IOException {
        SnapshotMarkerResponseImpl marker = new SnapshotMarkerResponseImpl(reader);
        for (SnapshotMarkerHandler handler : handlers) {
            if (handler.handle(marker)) break;
        }
        return marker;
    }

    private SnapshotMarkerResponseImpl(ResourceReader reader) throws IOException {
        super("snapshot marker response", reader);
        this.type = ProfilingTraceType.get(reader.readInt8());
        this.delta = reader.readBoolean();
        this.name = reader.readString();
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.SNAPSHOT_MARKER_RESPONSE;
    }

    @Override
    public ProfilingTraceType getTraceType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long getCreationTimeStamp() {
        return this.getTime();
    }

    @Override
    public boolean isDelta() {
        return this.delta;
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnResponseHeader(this);
        stream.formatln("Type     : %d", this.type.getIndex());
        stream.formatln("Name     : %s", this.name);
        stream.formatln("Is delta : %s", this.delta);
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)1034);
        this.writeInternal(writer);
        writer.writeInt8(this.type.getIndex());
        writer.writeBoolean(this.delta);
        writer.writeString(this.name);
        writer.finalizePacket();
    }
}

