/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ArrayClassObject;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class ArrayClassObjectImpl
extends ClassObjectImpl
implements ArrayClassObject {
    private final NonArrayClassObjectImpl superClass;
    private final short arrayDepth;
    private final ClassObjectImpl baseClassObject;
    private final UTF8String name;
    private final short headerSize;
    private final short elementSize;

    public ArrayClassObjectImpl(ResourceReader reader, MappingInformation mapInfo, int index) throws IOException {
        super(reader, index);
        reader.readClassObject();
        this.superClass = mapInfo.getJavaLangObjectClassObject();
        assert (this.superClass != null);
        this.arrayDepth = reader.readUint8();
        assert (this.arrayDepth > 0);
        this.baseClassObject = (ClassObjectImpl)reader.readClassObject();
        assert (this.baseClassObject != null);
        this.name = mapInfo.intern(this.baseClassObject.getName() + ArrayClassObjectImpl.getArrayString(this.arrayDepth));
        this.headerSize = reader.readInt16();
        assert (this.headerSize >= 12);
        assert (this.headerSize <= 24);
        this.elementSize = reader.readInt16();
        assert (this.elementSize >= 1);
        assert (this.elementSize <= 8);
    }

    private static String getArrayString(int depth) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < depth; ++i) {
            result.append("[]");
        }
        return result.toString();
    }

    @Override
    public int getArrayDimension() {
        return this.arrayDepth;
    }

    @Override
    public ClassObjectImpl getBaseClass() {
        return this.baseClassObject;
    }

    @Override
    public ClassLoaderObject getClassLoader() {
        return this.baseClassObject.getClassLoader();
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public NonArrayClassObjectImpl getSuperClass() {
        return this.superClass;
    }

    @Override
    public boolean isInternalClass() {
        return this.baseClassObject.isInternalClass();
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public long getInstanceSize(int length) {
        long result = this.elementSize;
        result *= (long)length;
        result += (long)this.headerSize;
        result = result + 7L & 0xFFFFFFFFFFFFFFF8L;
        return result;
    }

    public int getAlignedHeaderSize() {
        return this.headerSize + 7 & 0xFFFFFFF8;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)401);
        writer.writeInt64(this.getId());
        writer.writeInt32(this.getSuperClass().getIndex());
        writer.writeInt8(this.getArrayDimension());
        writer.writeInt32(this.getBaseClass().getIndex());
        writer.writeInt16(this.headerSize);
        writer.writeInt16(this.elementSize);
        writer.finalizePacket();
    }

    @Override
    public ProfilingSession getSession() {
        return this.baseClassObject.getSession();
    }

    @Override
    public UTF8String getNameUTF() {
        return this.name;
    }

    @Override
    public UTF8String getPackageNameUTF() {
        return this.baseClassObject.getPackageNameUTF();
    }

    @Override
    public PackageName getPackage() {
        return this.baseClassObject.getPackage();
    }

    @Override
    public boolean isSyntheticJavaScriptClass() {
        return this.baseClassObject.isSyntheticJavaScriptClass();
    }
}

