/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Arrays;

public final class ClassLoaderObjectImpl
implements ClassLoaderObject {
    public static final int NO_CLASS_LOADER_ID = -1;
    public static final int INLINED_AWAY_ID = -2;
    public static final int NO_CLASS_LOADER_INDEX = 1;
    public static final int INLINED_AWAY_INDEX = 2;
    public static final int BOOTSTRAP_INDEX = 1024;
    private static final UTF8String[] NO_UTF8_STRINGS = new UTF8String[0];
    private static final ClassLoaderObjectImpl[] NO_PARENTS = new ClassLoaderObjectImpl[0];
    private ClassObject classLoaderClass;
    private final int classLoaderClassIndex;
    private final long id;
    private final ClassLoaderObjectImpl[] parents;
    private final UTF8String name;
    private final UTF8String[] urls;
    private final UTF8String[] dependencies;
    private final int index;
    private final AbstractProfilingSessionImpl session;
    private final long creationTime;

    public ClassLoaderObjectImpl(MappingInformation mapInfo, UTF8String name, long id, int index, AbstractProfilingSessionImpl session) {
        this.index = index;
        this.session = session;
        this.id = id;
        this.urls = NO_UTF8_STRINGS;
        this.dependencies = NO_UTF8_STRINGS;
        this.name = mapInfo.intern(name);
        this.creationTime = 0L;
        this.parents = NO_PARENTS;
        this.classLoaderClassIndex = 0;
        this.classLoaderClass = null;
    }

    public ClassLoaderObjectImpl(ResourceReader reader, MappingInformation mapInfo, int index, AbstractProfilingSessionImpl session, boolean resolveClasses) throws IOException {
        boolean assumeCreationTime;
        this.index = index;
        this.id = reader.readInt64();
        if (resolveClasses) {
            if (this.id != 0L) {
                this.classLoaderClass = reader.readClassObject();
                this.classLoaderClassIndex = this.classLoaderClass.getIndex();
            } else {
                this.classLoaderClassIndex = 0;
            }
        } else {
            this.classLoaderClassIndex = reader.readInt32();
        }
        int nrOfParents = reader.readInt32();
        if (nrOfParents == 0) {
            this.parents = NO_PARENTS;
        } else {
            ClassLoaderObjectImpl[] rawParents = new ClassLoaderObjectImpl[nrOfParents];
            int nrOfNulls = 0;
            for (int i = 0; i < nrOfParents; ++i) {
                rawParents[i] = (ClassLoaderObjectImpl)reader.readClassLoaderObject();
                if (rawParents[i] != null) continue;
                ++nrOfNulls;
            }
            if (nrOfNulls > 0) {
                this.parents = new ClassLoaderObjectImpl[nrOfParents - nrOfNulls];
                int off = 0;
                for (int i = 0; i < rawParents.length; ++i) {
                    if (rawParents[i] == null) continue;
                    this.parents[off] = rawParents[i];
                    ++off;
                }
                assert (off == this.parents.length);
            } else {
                this.parents = rawParents;
            }
        }
        this.name = mapInfo.intern(reader.readUTF());
        int nrOfURLs = reader.readUint16();
        if (nrOfURLs > 0) {
            this.urls = new UTF8String[nrOfURLs];
            for (int i = 0; i < nrOfURLs; ++i) {
                this.urls[i] = mapInfo.intern(reader.readUTF());
            }
        } else {
            this.urls = NO_UTF8_STRINGS;
        }
        UTF8String[] deps = NO_UTF8_STRINGS;
        reader.readBoolean();
        boolean bl = assumeCreationTime = session.getSystemInfo() == null && reader.hasNext();
        if (assumeCreationTime || session.getSystemInfo() != null && session.getCapabilities().hasCreationTimeOfLoaders()) {
            int nrOfDependencies;
            this.creationTime = reader.readInt64();
            if (reader.hasNext() && (nrOfDependencies = reader.readUint16()) > 0) {
                deps = new UTF8String[nrOfDependencies];
                for (int i = 0; i < nrOfDependencies; ++i) {
                    deps[i] = reader.readUTF();
                }
            }
        } else {
            this.creationTime = -1L;
        }
        this.dependencies = deps;
        this.session = session;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public ClassObject getClassObject() {
        return this.classLoaderClass;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public int getNrOfParents() {
        return this.parents.length;
    }

    @Override
    public ClassLoaderObjectImpl getParent(int parentIndex) {
        return this.parents[parentIndex];
    }

    @Override
    public boolean isBootstrapClassLoader() {
        return this.index == 1024;
    }

    @Override
    public boolean isNoStack() {
        return this.index == 1;
    }

    @Override
    public boolean isInlinedAway() {
        return this.index == 2;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public int getNrOfURLs() {
        return this.urls.length;
    }

    @Override
    public String getURLString(int urlIndex) {
        return this.urls[urlIndex].toString();
    }

    @Override
    public String getURLs() {
        Object[] asStrings = new String[this.urls.length];
        for (int i = 0; i < this.urls.length; ++i) {
            asStrings[i] = this.getURLString(i);
        }
        return Arrays.toString(asStrings);
    }

    @Override
    public boolean hasSameName(ClassLoaderObject other) {
        ClassLoaderObjectImpl otherImpl = (ClassLoaderObjectImpl)other;
        return this.name == otherImpl.name;
    }

    public void fixupReferences(MappingInformation mapInfo) {
        if (this.classLoaderClassIndex != 0) {
            this.classLoaderClass = mapInfo.getClassObject(this.classLoaderClassIndex);
            assert (this.classLoaderClass != null);
        }
    }

    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)404);
        writer.writeInt64(this.id);
        writer.writeInt32(this.classLoaderClassIndex);
        int nrOfParents = this.getNrOfParents();
        writer.writeInt32(nrOfParents);
        for (int i = 0; i < nrOfParents; ++i) {
            writer.writeInt32(this.getParent(i).getIndex());
        }
        writer.writeString(this.getName());
        int numberOfUrls = this.getNrOfURLs();
        writer.writeInt16((short)numberOfUrls);
        for (int i = 0; i < numberOfUrls; ++i) {
            writer.writeString(this.getURLString(i));
        }
        writer.writeBoolean(false);
        writer.writeInt64(this.creationTime);
        writer.writeInt16((short)this.getNrOfDependencies());
        for (UTF8String dependency : this.dependencies) {
            writer.writeUTF(dependency);
        }
        writer.finalizePacket();
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public String getDisplayName() {
        if (this.isBootstrapClassLoader()) {
            return "<bootstrap>";
        }
        if (!this.name.isEmpty()) {
            return this.getName();
        }
        StringBuilder result = new StringBuilder(this.getClassObject().getFullName());
        if (this.urls.length > 0) {
            result.append(" (");
            for (int i = 0; i < this.urls.length; ++i) {
                if (i != 0) {
                    result.append(", ");
                }
                result.append(this.getShortURLString(i));
            }
            result.append(")");
        }
        return result.toString();
    }

    @Override
    public String getShortURLString(int urlIndex) {
        String url;
        try {
            url = URLDecoder.decode(this.getURLString(urlIndex), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            url = this.getURLString(urlIndex);
        }
        int lastPart = url.lastIndexOf(47);
        if (lastPart == url.length() - 1) {
            lastPart = url.substring(0, lastPart).lastIndexOf(47);
        }
        if (lastPart != -1) {
            return url.substring(lastPart + 1);
        }
        return url;
    }

    @Override
    public int compareToIgnoreCase(ClassLoaderObject other) {
        return this.getDisplayName().compareToIgnoreCase(other.getDisplayName());
    }

    @Override
    public int compareByIndex(ClassLoaderObject other) {
        int otherIndex = other.getIndex();
        return this.index < otherIndex ? -1 : (this.index > otherIndex ? 1 : 0);
    }

    @Override
    public long getCreationTime() {
        return this.creationTime;
    }

    @Override
    public String getDependency(int dependencyIndex) {
        return this.dependencies[dependencyIndex].toString();
    }

    @Override
    public int getNrOfDependencies() {
        return this.dependencies.length;
    }
}

