/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public abstract class ClassObjectImpl
implements ClassObject {
    public static final int NO_CLASS_ID = -1;
    public static final int INLINED_AWAY_ID = -2;
    public static final int NO_CLASS_INDEX = 1;
    public static final int INLINED_AWAY_INDEX = 2;
    protected final long id;
    protected final int index;
    private ClassObjectImpl next;

    ClassObjectImpl(ResourceReader reader, int index) throws IOException {
        this.id = reader.readInt64();
        this.index = index;
    }

    ClassObjectImpl(long id, int index) {
        this.id = id;
        this.index = index;
    }

    @Override
    public abstract ClassLoaderObject getClassLoader();

    @Override
    public final String getFullName() {
        StringBuffer result = new StringBuffer(this.getPackageName());
        if (result.length() > 0) {
            result.append('.');
        }
        result.append(this.getName());
        return result.toString();
    }

    @Override
    public final long getId() {
        return this.id;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public final boolean isArrayClass() {
        return this.getArrayDimension() > 0;
    }

    @Override
    public abstract String getName();

    @Override
    public final String getPackageName() {
        return this.getPackageNameUTF().toString();
    }

    @Override
    public abstract UTF8String getPackageNameUTF();

    @Override
    public abstract NonArrayClassObjectImpl getSuperClass();

    @Override
    public final boolean isInSamePackage(ClassObject other) {
        return ((ClassObjectImpl)other).getPackageNameUTF().equals(this.getPackageNameUTF());
    }

    @Override
    public boolean isInternalClass() {
        return false;
    }

    public final ClassObjectImpl getNext() {
        return this.next;
    }

    public final void setNext(ClassObjectImpl classObject) {
        this.next = classObject;
    }

    public abstract void write(PacketResourceWriter var1) throws IOException;

    @Override
    public int compareByIndex(ClassObject other) {
        int otherIndex = other.getIndex();
        return this.index < otherIndex ? -1 : (this.index > otherIndex ? 1 : 0);
    }

    @Override
    public int getWordSize() {
        return 8;
    }

    @Override
    public boolean isNoStack() {
        return this.index == 1;
    }

    @Override
    public boolean isInlinedAway() {
        return this.index == 2;
    }

    @Override
    public final int compareTo(ClassObject other) {
        if (this == other) {
            return 0;
        }
        if (this.getPackageNameUTF().isEmpty() || other.getPackageNameUTF().isEmpty()) {
            int result = this.getFullName().compareTo(other.getFullName());
            if (result != 0) {
                return result;
            }
            return this.compareByIndex(other);
        }
        int result = this.getPackageNameUTF().compareTo(other.getPackageNameUTF());
        if (result != 0) {
            return result;
        }
        result = this.getNameUTF().compareTo(other.getNameUTF());
        if (result != 0) {
            return result;
        }
        return this.compareByIndex(other);
    }

    @Override
    public final int compareToIgnoreCase(ClassObject other) {
        if (this == other) {
            return 0;
        }
        if (this.getPackageNameUTF().isEmpty() || other.getPackageNameUTF().isEmpty()) {
            return this.getFullName().compareToIgnoreCase(other.getFullName());
        }
        int result = this.getPackageNameUTF().compareToIgnoreCase(other.getPackageNameUTF());
        if (result != 0) {
            return result;
        }
        return this.getNameUTF().compareToIgnoreCase(other.getNameUTF());
    }

    public final String getInternalFullName() {
        if (this.isSyntheticJavaScriptClass()) {
            return this.getFullName();
        }
        return this.getFullName().replace('.', '/');
    }

    public final String toString() {
        return this.getFullName();
    }
}

