/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.HostNameManager;
import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.net.event.HostLookupEventBase;
import com.sap.jvm.profiling.impl.net.event.HostLookupV4EventImpl;
import com.sap.jvm.profiling.impl.net.event.HostLookupV6EventImpl;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class HostNameManagerImpl
implements HostNameManager {
    private final Map<IpAddress, UTF8String> registry = new HashMap<IpAddress, UTF8String>();

    public HostNameManagerImpl() {
    }

    public HostNameManagerImpl(PacketResourceReader reader, ProgressReporter reporter, int nrOfMappings) throws IOException {
        for (int i = 0; i < nrOfMappings; ++i) {
            HostLookupEventBase event;
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            assert (reader.getType() == 415 || reader.getType() == 416);
            if (reader.getType() == 415) {
                event = new HostLookupV4EventImpl(reader);
            } else {
                assert (reader.getType() == 416);
                event = new HostLookupV6EventImpl(reader);
            }
            this.addMapping(event.getHostName(), event.getAddress());
            if (reporter == null) continue;
            reporter.reportNext();
        }
    }

    @Override
    public UTF8String getHostName(IpAddress address) {
        return this.registry.get(address);
    }

    @Override
    public int getNrOfHostNames() {
        return this.registry.size();
    }

    public void addMapping(UTF8String hostname, IpAddress address) {
        if (!this.registry.containsKey(address)) {
            this.registry.put(address, hostname);
        }
    }

    public void write(PacketResourceWriter writer, ProgressReporter reporter) throws IOException {
        for (Map.Entry<IpAddress, UTF8String> entry : this.registry.entrySet()) {
            if (entry.getKey().isIPv4()) {
                new HostLookupV4EventImpl(entry.getValue(), entry.getKey()).write(writer);
            } else {
                assert (entry.getKey().isIPv6());
                new HostLookupV6EventImpl(entry.getValue(), entry.getKey()).write(writer);
            }
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
    }

    @Override
    public void print(PrintStream stream) {
        for (Map.Entry<IpAddress, UTF8String> entry : this.registry.entrySet()) {
            if (entry.getKey().isIPv4()) {
                new HostLookupV4EventImpl(entry.getValue(), entry.getKey()).print(stream);
                continue;
            }
            assert (entry.getKey().isIPv6());
            new HostLookupV6EventImpl(entry.getValue(), entry.getKey()).print(stream);
        }
    }
}

