/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public final class InternalClassObjectImpl
extends ClassObjectImpl {
    private ClassLoaderObject classLoader;
    private final UTF8String name;
    private final PackageName packageName;
    private final AbstractProfilingSessionImpl session;

    public InternalClassObjectImpl(ResourceReader reader, MappingInformation mapInfo, int index, AbstractProfilingSessionImpl session) throws IOException {
        super(reader, index);
        this.classLoader = mapInfo.getClassLoaderObjectById(0L);
        assert (this.classLoader != null);
        this.name = mapInfo.intern(reader.readUTF());
        this.packageName = mapInfo.getPackageName(mapInfo.intern(""), false);
        this.session = session;
    }

    @Override
    public ClassLoaderObject getClassLoader() {
        return this.classLoader;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public NonArrayClassObjectImpl getSuperClass() {
        return null;
    }

    @Override
    public boolean isInternalClass() {
        return true;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public int getArrayDimension() {
        return 0;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)403);
        writer.writeInt64(this.getId());
        writer.writeUTF(this.getNameUTF());
        writer.finalizePacket();
    }

    @Override
    public ProfilingSession getSession() {
        return this.session;
    }

    @Override
    public UTF8String getNameUTF() {
        return this.name;
    }

    @Override
    public UTF8String getPackageNameUTF() {
        return this.packageName.getName();
    }

    @Override
    public PackageName getPackage() {
        return this.packageName;
    }

    @Override
    public boolean isSyntheticJavaScriptClass() {
        return false;
    }
}

