/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.impl.core.type.IpAddressV6Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpAddressV4Impl
implements IpAddress {
    public static final IpAddress UNKNOWN = new IpAddressV4Impl();
    private final int address;

    public static IpAddressV4Impl read(ResourceReader reader) throws IOException {
        return new IpAddressV4Impl(reader);
    }

    private IpAddressV4Impl(ResourceReader reader) throws IOException {
        this.address = reader.readInt32();
    }

    private IpAddressV4Impl() {
        this.address = 0;
    }

    public IpAddressV4Impl(int address) {
        this.address = address;
    }

    @Override
    public boolean isIPv4() {
        return true;
    }

    @Override
    public boolean isIPv6() {
        return false;
    }

    @Override
    public String getAddress() {
        return NetworkTraceUtils.getIPv4AddressText(this.address);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.address);
    }

    public int hashCode() {
        return this.address;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            if (obj instanceof IpAddressV6Impl && ((IpAddressV6Impl)obj).isIPv4MappedIPv6Address()) {
                return obj.equals(this);
            }
            return false;
        }
        IpAddressV4Impl other = (IpAddressV4Impl)obj;
        return this.address == other.address;
    }

    public String toString() {
        return this.getAddress();
    }

    public int compareTo(IpAddressV4Impl other) {
        return this.address < other.address ? -1 : (this.address > other.address ? 1 : 0);
    }

    @Override
    public String getHostname() {
        byte[] addr = new byte[]{(byte)(this.address >>> 24 & 0xFF), (byte)(this.address >>> 16 & 0xFF), (byte)(this.address >>> 8 & 0xFF), (byte)(this.address >>> 0 & 0xFF)};
        try {
            return InetAddress.getByAddress(addr).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            Trace.error((Throwable)e, "Impossible error while doing reverse DNS lookup");
            return this.getAddress();
        }
    }

    int getAddressValue() {
        return this.address;
    }
}

