/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.IpAddress;
import com.sap.jvm.profiling.impl.core.type.IpAddressV4Impl;
import com.sap.jvm.profiling.impl.net.event.NetworkTraceUtils;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class IpAddressV6Impl
implements IpAddress {
    public static final IpAddress UNKNOWN = new IpAddressV6Impl();
    private final long networkPrefix;
    private final long hostAddress;

    public static IpAddressV6Impl read(ResourceReader reader) throws IOException {
        return new IpAddressV6Impl(reader);
    }

    private IpAddressV6Impl(ResourceReader reader) throws IOException {
        this.networkPrefix = reader.readInt64();
        this.hostAddress = reader.readInt64();
    }

    private IpAddressV6Impl() {
        this.networkPrefix = 0L;
        this.hostAddress = 0L;
    }

    public IpAddressV6Impl(long networkPrefix, long hostAddress) {
        this.networkPrefix = networkPrefix;
        this.hostAddress = hostAddress;
    }

    @Override
    public boolean isIPv4() {
        return false;
    }

    @Override
    public boolean isIPv6() {
        return true;
    }

    @Override
    public String getAddress() {
        return NetworkTraceUtils.getIPv6AddressText(this.networkPrefix, this.hostAddress);
    }

    @Override
    public void write(ResourceWriter writer) throws IOException {
        writer.writeInt64(this.networkPrefix);
        writer.writeInt64(this.hostAddress);
    }

    public int hashCode() {
        if (this.isIPv4MappedIPv6Address()) {
            return (int)this.hostAddress;
        }
        return (int)(this.networkPrefix ^ this.networkPrefix >> 32 ^ this.hostAddress ^ this.hostAddress >> 32);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            if (obj instanceof IpAddressV4Impl && this.isIPv4MappedIPv6Address()) {
                return ((IpAddressV4Impl)obj).getAddressValue() == (int)this.hostAddress;
            }
            return false;
        }
        IpAddressV6Impl other = (IpAddressV6Impl)obj;
        return this.networkPrefix == other.networkPrefix && this.hostAddress == other.hostAddress;
    }

    public String toString() {
        return this.getAddress();
    }

    public int compareTo(IpAddressV6Impl other) {
        if (this.networkPrefix < other.networkPrefix) {
            return -1;
        }
        if (this.networkPrefix > other.networkPrefix) {
            return 1;
        }
        if (this.hostAddress < other.hostAddress) {
            return -1;
        }
        if (this.hostAddress > other.hostAddress) {
            return 1;
        }
        return 0;
    }

    @Override
    public String getHostname() {
        byte[] addr = new byte[]{(byte)(this.networkPrefix >>> 56 & 0xFFL), (byte)(this.networkPrefix >>> 48 & 0xFFL), (byte)(this.networkPrefix >>> 40 & 0xFFL), (byte)(this.networkPrefix >>> 32 & 0xFFL), (byte)(this.networkPrefix >>> 24 & 0xFFL), (byte)(this.networkPrefix >>> 16 & 0xFFL), (byte)(this.networkPrefix >>> 8 & 0xFFL), (byte)(this.networkPrefix >>> 0 & 0xFFL), (byte)(this.hostAddress >>> 56 & 0xFFL), (byte)(this.hostAddress >>> 48 & 0xFFL), (byte)(this.hostAddress >>> 40 & 0xFFL), (byte)(this.hostAddress >>> 32 & 0xFFL), (byte)(this.hostAddress >>> 24 & 0xFFL), (byte)(this.hostAddress >>> 16 & 0xFFL), (byte)(this.hostAddress >>> 8 & 0xFFL), (byte)(this.hostAddress >>> 0 & 0xFFL)};
        try {
            return InetAddress.getByAddress(addr).getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            Trace.error((Throwable)e, "Impossible error while doing reverse DNS lookup");
            return this.getAddress();
        }
    }

    public boolean isIPv4MappedIPv6Address() {
        return NetworkTraceUtils.isIPv4MappedIPv6Address(this.networkPrefix, this.hostAddress);
    }
}

