/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;

public final class MethodLocationImpl
implements MethodLocation {
    private final MethodObject method;
    private final int lineNr;
    private final int index;
    private final MethodLocationImpl locationWithoutLineNr;

    public MethodLocationImpl(MethodObject method, int index) {
        this.method = method;
        this.lineNr = 0;
        this.locationWithoutLineNr = this;
        this.index = index;
    }

    public MethodLocationImpl(MethodLocationImpl locationWithoutLineNr, int lineNr, int index) {
        this.method = locationWithoutLineNr.method;
        this.lineNr = lineNr;
        this.locationWithoutLineNr = locationWithoutLineNr;
        this.index = index;
    }

    @Override
    public int compareByMethodIndexAndLineNr(MethodLocation other) {
        int result = this.method.compareByIndex(other.getMethod());
        if (result != 0) {
            return result;
        }
        int otherLineNr = other.getLineNumber();
        return this.lineNr < otherLineNr ? -1 : (this.lineNr > otherLineNr ? 1 : 0);
    }

    @Override
    public int compareTo(MethodLocation other) {
        int result = this.method.compareTo(other.getMethod());
        if (result != 0) {
            return result;
        }
        if (other.getLineNumber() == this.lineNr) {
            return 0;
        }
        if (other.getLineNumber() > this.lineNr) {
            return -1;
        }
        return 1;
    }

    @Override
    public int compareToIgnoreCase(MethodLocation other) {
        int result = this.method.compareToIgnoreCase(other.getMethod());
        if (result != 0) {
            return result;
        }
        if (other.getLineNumber() == this.lineNr) {
            return 0;
        }
        if (other.getLineNumber() > this.lineNr) {
            return -1;
        }
        return 1;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public int getLineNumber() {
        return this.lineNr;
    }

    @Override
    public MethodObject getMethod() {
        return this.method;
    }

    @Override
    public MethodLocation getMethodLocationWithoutLineNr() {
        return this.locationWithoutLineNr;
    }

    @Override
    public ProfilingSession getSession() {
        return this.method.getSession();
    }

    public int hashCode() {
        int hash = this.method.hashCode() ^ 31 * this.lineNr;
        return hash;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(this.method.toString());
        if (this.lineNr != 0) {
            buffer.append(":");
            buffer.append(this.lineNr);
        }
        return buffer.toString();
    }

    @Override
    public boolean isNoStack() {
        return this.method.isNoStack();
    }

    @Override
    public boolean isInlinedAway() {
        return this.method.isInlinedAway();
    }
}

