/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingCapabilities;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.JRubyBoundMethodOracleImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.impl.util.InternalTypeConverterUTF;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;

public class MethodObjectImpl
implements MethodObject {
    public static final int NO_METHOD_ID = -1;
    public static final int INLINED_AWAY_ID = -2;
    public static final int NO_METHOD_INDEX = 1;
    public static final int INLINED_AWAY_INDEX = 2;
    public static final int IS_PUBLIC = 1;
    public static final int IS_PROTECTED = 2;
    public static final int IS_PRIVATE = 4;
    public static final int IS_ABSTRACT = 8;
    public static final int IS_SYNTHETIC = 16;
    public static final int IS_SYNCHRONIZED = 32;
    public static final int IS_STRICT = 64;
    public static final int IS_FINAL = 128;
    public static final int IS_NATIVE = 256;
    public static final int IS_EMPTY = 512;
    public static final int IS_VANILLA_CONSTRUCTOR = 1024;
    public static final int IS_STATICALLY_CALLABLE = 2048;
    public static final int HAS_LOOPS = 4096;
    public static final int HAS_JSRS = 8192;
    public static final int HAS_MONITORS = 16384;
    public static final int IS_ACCESSOR = 32768;
    public static final int IS_DELGATOR = 65536;
    public static final int IS_OVERWRITING = 131072;
    public static final int IS_STATIC = 262144;
    public static final int IS_PROFILING = 524288;
    public static final int IS_BOUND_JRUBY_METHOD = 0x100000;
    public static final int HAS_UNKNOWN_VISIBILITY = 0x200000;
    private final long id;
    private final int index;
    private final NonArrayClassObjectImpl classObject;
    private final UTF8String name;
    private final UTF8String signature;
    private final UTF8String returnType;
    private final int attributes;
    private MethodObjectImpl next;
    private MethodLocation location;
    private final UTF8String[] boundMethods;

    public static MethodObjectImpl createFromInternal(ResourceReader reader, JRubyBoundMethodOracleImpl oracle, MappingInformation mapInfo, int index) throws IOException {
        long id = reader.readInt64();
        NonArrayClassObjectImpl classObject = (NonArrayClassObjectImpl)reader.readClassObject();
        assert (classObject != null);
        UTF8String name = mapInfo.intern(reader.readUTF());
        assert (name.length() > 0);
        byte[] internalSig = reader.readUTF().getBytes();
        InternalTypeConverterUTF converter = new InternalTypeConverterUTF(internalSig);
        UTF8String signature = mapInfo.intern(MethodObjectImpl.convertSignatureToExternal(converter));
        UTF8String returnType = mapInfo.intern(converter.getType());
        int attributes = 0;
        if (reader.hasNext(4)) {
            attributes = reader.readInt32();
        } else if (reader.readBoolean()) {
            attributes |= 0x100;
        }
        if (mapInfo.isProfilingMethod(classObject, name, signature, returnType)) {
            attributes |= 0x80000;
        }
        UTF8String[] boundMethods = null;
        if ((attributes & 0x100000) != 0) {
            int len = reader.readUint8();
            if (len == 255) {
                len = reader.readInt32();
            }
            boundMethods = new UTF8String[len];
            for (int i = 0; i < len; ++i) {
                boundMethods[i] = reader.readUTF();
            }
        } else {
            boundMethods = oracle.getBoundMethods(classObject, name);
            if (boundMethods != null) {
                attributes |= 0x100000;
            }
        }
        char defLine = '\u0000';
        char defColumn = '\u0000';
        if (classObject.isSyntheticJavaScriptClass()) {
            defLine = reader.readUint16();
            defColumn = reader.readUint16();
            return new MethodObjectWithDefinition(id, index, classObject, name, signature, returnType, attributes, boundMethods, defLine, defColumn);
        }
        return new MethodObjectImpl(id, index, classObject, name, signature, returnType, attributes, boundMethods);
    }

    public static MethodObjectImpl createFromExternal(ResourceReader reader, MappingInformation mapInfo, ProfilingCapabilities capabilities, int index) throws IOException {
        long id = reader.readInt64();
        NonArrayClassObjectImpl classObject = (NonArrayClassObjectImpl)reader.readClassObject();
        assert (classObject != null);
        UTF8String name = mapInfo.intern(reader.readUTF());
        assert (name.length() > 0);
        UTF8String signature = mapInfo.intern(reader.readUTF());
        UTF8String returnType = mapInfo.intern(reader.readUTF());
        int attributes = 0;
        if (reader.hasNext(4)) {
            attributes = reader.readInt32();
        } else if (reader.readBoolean()) {
            attributes |= 0x100;
        }
        UTF8String[] boundMethods = null;
        if ((attributes & 0x100000) != 0) {
            int len = reader.readUint8();
            if (len == 255) {
                len = reader.readInt32();
            }
            boundMethods = new UTF8String[len];
            for (int i = 0; i < len; ++i) {
                boundMethods[i] = reader.readUTF();
            }
        }
        char defLine = '\u0000';
        char defColumn = '\u0000';
        if (classObject.isSyntheticJavaScriptClass()) {
            defLine = reader.readUint16();
            defColumn = reader.readUint16();
            return new MethodObjectWithDefinition(id, index, classObject, name, signature, returnType, attributes, boundMethods, defLine, defColumn);
        }
        return new MethodObjectImpl(id, index, classObject, name, signature, returnType, attributes, boundMethods);
    }

    public MethodObjectImpl(long id, int index, NonArrayClassObjectImpl classObject, UTF8String name, UTF8String signature, UTF8String returnType, int attributes, UTF8String[] boundMethods) {
        this.id = id;
        this.index = index;
        this.classObject = classObject;
        this.name = name;
        this.signature = signature;
        this.returnType = returnType;
        this.attributes = attributes;
        this.boundMethods = boundMethods;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public final int getIndex() {
        return this.index;
    }

    @Override
    public NonArrayClassObjectImpl getMethodClass() {
        return this.classObject;
    }

    @Override
    public String getName() {
        return this.name.toString();
    }

    @Override
    public String getFullName() {
        StringBuffer result = new StringBuffer(this.classObject.getFullName());
        result.append('.');
        result.append(this.getName());
        result.append('(');
        result.append(this.getSignature());
        result.append(')');
        result.append(this.getReturnType());
        return result.toString();
    }

    @Override
    public String getFullNameWithoutReturnType() {
        StringBuffer result = new StringBuffer(this.classObject.getFullName());
        result.append('.');
        result.append(this.getName());
        result.append('(');
        result.append(this.getSignature());
        result.append(')');
        return result.toString();
    }

    @Override
    public String getSignature() {
        return this.signature.toString();
    }

    @Override
    public String getReturnType() {
        return this.returnType.toString();
    }

    @Override
    public boolean hasJsrs() {
        return (this.attributes & 0x2000) != 0;
    }

    @Override
    public boolean hasLoops() {
        return (this.attributes & 0x1000) != 0;
    }

    @Override
    public boolean hasMonitors() {
        return (this.attributes & 0x4000) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.attributes & 8) != 0;
    }

    @Override
    public boolean isAccessor() {
        return (this.attributes & 0x8000) != 0;
    }

    @Override
    public boolean isDelegator() {
        return (this.attributes & 0x10000) != 0;
    }

    @Override
    public boolean isEmpty() {
        return (this.attributes & 0x200) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.attributes & 0x80) != 0;
    }

    @Override
    public boolean isOverwriting() {
        return (this.attributes & 0x20000) != 0;
    }

    @Override
    public boolean isPackagePrivate() {
        return !this.isPrivate() && !this.isPublic() && !this.isProtected();
    }

    @Override
    public boolean isPrivate() {
        return (this.attributes & 4) != 0;
    }

    @Override
    public boolean isProtected() {
        return (this.attributes & 2) != 0;
    }

    @Override
    public boolean isPublic() {
        return (this.attributes & 1) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.attributes & 0x40000) != 0;
    }

    @Override
    public boolean isStaticallyCallable() {
        return (this.attributes & 0x800) != 0;
    }

    @Override
    public boolean isStrict() {
        return (this.attributes & 0x40) != 0;
    }

    @Override
    public boolean isSynchronized() {
        return (this.attributes & 0x20) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.attributes & 0x10) != 0;
    }

    @Override
    public boolean isVanillaConstructor() {
        return (this.attributes & 0x400) != 0;
    }

    @Override
    public boolean isNative() {
        return (this.attributes & 0x100) != 0;
    }

    public int hashCode() {
        int hash = (int)(this.id >> 32) ^ (int)(this.id & 0xFFFFFFFFFFFFFFFFL);
        return hash;
    }

    public String toString() {
        return this.getFullName();
    }

    public MethodObjectImpl getNext() {
        return this.next;
    }

    public void setNext(MethodObjectImpl next) {
        this.next = next;
    }

    @Override
    public int compareTo(MethodObject other) {
        int dc2;
        int dl2;
        if (this == other) {
            return 0;
        }
        MethodObjectImpl otherMethod = (MethodObjectImpl)other;
        int result = this.classObject.compareTo(otherMethod.classObject);
        if (result != 0) {
            return result;
        }
        result = this.name.compareTo(otherMethod.name);
        if (result != 0) {
            return result;
        }
        result = this.signature.compareTo(otherMethod.signature);
        if (result != 0) {
            return result;
        }
        result = this.returnType.compareTo(otherMethod.returnType);
        if (result != 0) {
            return result;
        }
        int dl1 = this.getDefinitionLine();
        if (dl1 < (dl2 = otherMethod.getDefinitionLine())) {
            return -1;
        }
        if (dl1 > dl2) {
            return 1;
        }
        int dc1 = this.getDefinitionColumn();
        if (dc1 < (dc2 = otherMethod.getDefinitionColumn())) {
            return -1;
        }
        if (dc1 > dc2) {
            return 1;
        }
        return this.compareByIndex(otherMethod);
    }

    @Override
    public int compareToIgnoreCase(MethodObject other) {
        int dc2;
        int dl2;
        if (this == other) {
            return 0;
        }
        MethodObjectImpl otherMethod = (MethodObjectImpl)other;
        int result = this.classObject.compareToIgnoreCase(otherMethod.classObject);
        if (result != 0) {
            return result;
        }
        result = this.name.compareToIgnoreCase(otherMethod.name);
        if (result != 0) {
            return result;
        }
        result = this.signature.compareToIgnoreCase(otherMethod.signature);
        if (result != 0) {
            return result;
        }
        result = this.returnType.compareToIgnoreCase(otherMethod.returnType);
        if (result != 0) {
            return result;
        }
        int dl1 = this.getDefinitionLine();
        if (dl1 < (dl2 = otherMethod.getDefinitionLine())) {
            return -1;
        }
        if (dl1 > dl2) {
            return 1;
        }
        int dc1 = this.getDefinitionColumn();
        if (dc1 < (dc2 = otherMethod.getDefinitionColumn())) {
            return -1;
        }
        if (dc1 > dc2) {
            return 1;
        }
        return 0;
    }

    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)408);
        writer.writeInt64(this.getId());
        writer.writeInt32(this.classObject.getIndex());
        writer.writeString(this.getName());
        writer.writeUTF(this.signature);
        writer.writeUTF(this.returnType);
        writer.writeInt32(this.attributes);
        if (this.boundMethods != null) {
            if (this.boundMethods.length < 255) {
                writer.writeInt8(this.boundMethods.length);
            } else {
                writer.writeInt8(255);
                writer.writeInt32(this.boundMethods.length);
            }
            for (int i = 0; i < this.boundMethods.length; ++i) {
                writer.writeUTF(this.boundMethods[i]);
            }
        }
        if (this.classObject.isSyntheticJavaScriptClass()) {
            writer.writeUint16((char)this.getDefinitionLine());
            writer.writeUint16((char)this.getDefinitionColumn());
        }
        writer.finalizePacket();
    }

    public void print(PrintStream stream) {
        stream.print(this.getFullName());
        stream.print(":0");
    }

    @Override
    public ProfilingSession getSession() {
        return this.classObject.getSession();
    }

    private static byte[] convertSignatureToExternal(InternalTypeConverterUTF converter) {
        ArrayList<byte[]> params = new ArrayList<byte[]>();
        converter.skip(1);
        int length = 0;
        while (converter.get() != 41) {
            byte[] toAdd = converter.getType();
            params.add(toAdd);
            length += toAdd.length;
        }
        converter.skip(1);
        if (params.isEmpty()) {
            return new byte[0];
        }
        byte[] result = new byte[params.size() - 1 + length];
        int pos = 0;
        for (int i = 0; i < params.size(); ++i) {
            if (i != 0) {
                result[pos++] = 44;
            }
            byte[] param = (byte[])params.get(i);
            System.arraycopy(param, 0, result, pos, param.length);
            pos += param.length;
        }
        return result;
    }

    @Override
    public int compareByIndex(MethodObject other) {
        int otherIndex = other.getIndex();
        return this.index < otherIndex ? -1 : (this.index > otherIndex ? 1 : 0);
    }

    public void setMethodLocation(MethodLocation location) {
        assert (location.getMethod() == this);
        assert (location.getLineNumber() == 0);
        this.location = location;
    }

    @Override
    public MethodLocation asMethodLocation() {
        return this.location;
    }

    @Override
    public boolean isNoStack() {
        return this.index == 1;
    }

    @Override
    public boolean isInlinedAway() {
        return this.index == 2;
    }

    @Override
    public UTF8String getNameUTF() {
        return this.name;
    }

    @Override
    public UTF8String getReturnTypeUTF() {
        return this.returnType;
    }

    @Override
    public UTF8String getSignatureUTF() {
        return this.signature;
    }

    @Override
    public boolean isProfilingMethod() {
        return (this.attributes & 0x80000) != 0;
    }

    @Override
    public boolean isBoundJRubyMethod() {
        return (this.attributes & 0x100000) != 0;
    }

    @Override
    public UTF8String[] getBoundJRubyMethods() {
        assert (this.boundMethods != null);
        return this.boundMethods;
    }

    @Override
    public int getDefinitionLine() {
        return 0;
    }

    @Override
    public int getDefinitionColumn() {
        return 0;
    }

    @Override
    public boolean hasUnknownVisibility() {
        assert (!(this.isPrivate() || this.isProtected() || this.isPublic()));
        return (this.attributes & 0x200000) != 0;
    }

    private static class MethodObjectWithDefinition
    extends MethodObjectImpl {
        private final char defLine;
        private final char defColumn;

        public MethodObjectWithDefinition(long id, int index, NonArrayClassObjectImpl classObject, UTF8String name, UTF8String signature, UTF8String returnType, int attributes, UTF8String[] boundMethods, char defLine, char defColumn) {
            super(id, index, classObject, name, signature, returnType, attributes, boundMethods);
            this.defLine = defLine;
            this.defColumn = defColumn;
        }

        @Override
        public int getDefinitionLine() {
            return this.defLine;
        }

        @Override
        public int getDefinitionColumn() {
            return this.defColumn;
        }
    }
}

