/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.NetworkServiceNameManager;
import com.sap.jvm.profiling.impl.net.event.ServiceDiscoveryEventImpl;
import com.sap.jvm.profiling.net.event.ServiceDiscoveryEvent;
import com.sap.jvm.profiling.resource.PacketResourceReader;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;

public class NetworkServiceNameManagerImpl
implements NetworkServiceNameManager {
    private static final String[] tcpOfficialRegistry = new String[65535];
    private final HashMap<Character, String> tcpSpecialRegistry = new HashMap();
    private static final String[] udpOfficalRegistry = new String[65535];
    private final HashMap<Character, String> udpSpecialRegistry = new HashMap();

    public NetworkServiceNameManagerImpl() {
    }

    public NetworkServiceNameManagerImpl(PacketResourceReader reader, ProgressReporter reporter, int nrOfServices) throws IOException {
        this();
        for (int i = 0; i < nrOfServices; ++i) {
            boolean hasNext = reader.nextPacket();
            assert (hasNext);
            assert (reader.getType() == 417);
            this.addService(new ServiceDiscoveryEventImpl(reader));
            if (reporter == null) continue;
            reporter.reportNext();
        }
    }

    @Override
    public String getTcpServiceName(char port) {
        String result = this.tcpSpecialRegistry.get(Character.valueOf(port));
        return result == null ? tcpOfficialRegistry[port] : result;
    }

    @Override
    public String getUdpServiceName(char port) {
        String result = this.udpSpecialRegistry.get(Character.valueOf(port));
        return result == null ? udpOfficalRegistry[port] : result;
    }

    @Override
    public int getNrOfSpecialServices() {
        return this.tcpSpecialRegistry.size() + this.udpSpecialRegistry.size();
    }

    public void addService(ServiceDiscoveryEvent service) {
        if (service.isStream() && !this.tcpSpecialRegistry.containsKey(Character.valueOf(service.getPort()))) {
            this.tcpSpecialRegistry.put(Character.valueOf(service.getPort()), service.getServiceName());
        }
        if (service.isDatagram() && !this.udpSpecialRegistry.containsKey(Character.valueOf(service.getPort()))) {
            this.udpSpecialRegistry.put(Character.valueOf(service.getPort()), service.getServiceName());
        }
    }

    public void write(PacketResourceWriter writer, ProgressReporter reporter) throws IOException {
        for (Map.Entry<Character, String> entry : this.tcpSpecialRegistry.entrySet()) {
            reporter.reportNextOrThrow();
            new ServiceDiscoveryEventImpl(entry.getValue(), entry.getKey().charValue(), true).write(writer);
        }
        for (Map.Entry<Character, String> entry : this.udpSpecialRegistry.entrySet()) {
            reporter.reportNextOrThrow();
            new ServiceDiscoveryEventImpl(entry.getValue(), entry.getKey().charValue(), false).write(writer);
        }
    }

    @Override
    public void print(PrintStream stream) {
        for (Map.Entry<Character, String> entry : this.tcpSpecialRegistry.entrySet()) {
            new ServiceDiscoveryEventImpl(entry.getValue(), entry.getKey().charValue(), true).print(stream);
        }
        for (Map.Entry<Character, String> entry : this.udpSpecialRegistry.entrySet()) {
            new ServiceDiscoveryEventImpl(entry.getValue(), entry.getKey().charValue(), false).print(stream);
        }
    }

    private static void add2Registry(char port, String name, boolean isTcp, boolean isUdp) {
        assert (isTcp || isUdp);
        if (isTcp) {
            assert (tcpOfficialRegistry[port] == null);
            NetworkServiceNameManagerImpl.tcpOfficialRegistry[port] = name;
        }
        if (isUdp) {
            assert (udpOfficalRegistry[port] == null);
            NetworkServiceNameManagerImpl.udpOfficalRegistry[port] = name;
        }
    }

    private static void fillRegistry() {
        NetworkServiceNameManagerImpl.fillRegistry1();
        NetworkServiceNameManagerImpl.fillRegistry2();
    }

    /*
     * Opcode count of 14997 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void fillRegistry1() {
        NetworkServiceNameManagerImpl.add2Registry('\u0001', "tcpmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0002', "compressnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0003', "compressnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0005', "rje", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0007', "echo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\t', "discard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u000b', "systat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\r', "daytime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0011', "qotd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0012', "msp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0013', "chargen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0014', "ftp-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0015', "ftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0016', "ssh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0017', "telnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0019', "smtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u001b', "nsw-fe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u001d', "msg-icp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u001f', "msg-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('!', "dsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('%', "time", true, true);
        NetworkServiceNameManagerImpl.add2Registry('&', "rap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\'', "rlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry(')', "graphics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('*', "nameserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('+', "nicname", true, true);
        NetworkServiceNameManagerImpl.add2Registry(',', "mpm-flags", true, true);
        NetworkServiceNameManagerImpl.add2Registry('-', "mpm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('.', "mpm-snd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('/', "ni-ftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('0', "auditd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('1', "tacacs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('2', "re-mail-ck", true, true);
        NetworkServiceNameManagerImpl.add2Registry('3', "la-maint", true, true);
        NetworkServiceNameManagerImpl.add2Registry('4', "xns-time", true, true);
        NetworkServiceNameManagerImpl.add2Registry('5', "domain", true, true);
        NetworkServiceNameManagerImpl.add2Registry('6', "xns-ch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('7', "isi-gl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('8', "xns-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry(':', "xns-mail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('=', "ni-mail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('>', "acas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('?', "whoispp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('@', "covia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('A', "tacacs-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('B', "sql-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('C', "bootps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('D', "bootpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('E', "tftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('F', "gopher", true, true);
        NetworkServiceNameManagerImpl.add2Registry('G', "netrjs-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('H', "netrjs-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('I', "netrjs-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('J', "netrjs-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('L', "deos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('N', "vettcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('O', "finger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('P', "http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('R', "xfer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('S', "mit-ml-dev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('T', "ctf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('U', "mit-ml-dev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('V', "mfcobol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('X', "kerberos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('Y', "su-mit-tg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('Z', "dnsix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('[', "mit-dov", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\\', "npp", true, true);
        NetworkServiceNameManagerImpl.add2Registry(']', "dcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('^', "objcall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('_', "supdup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('`', "dixie", true, true);
        NetworkServiceNameManagerImpl.add2Registry('a', "swift-rvf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('b', "tacnews", true, true);
        NetworkServiceNameManagerImpl.add2Registry('c', "metagram", true, true);
        NetworkServiceNameManagerImpl.add2Registry('d', "newacct", true, false);
        NetworkServiceNameManagerImpl.add2Registry('e', "hostname", true, true);
        NetworkServiceNameManagerImpl.add2Registry('f', "iso-tsap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('g', "gppitnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('h', "acr-nema", true, true);
        NetworkServiceNameManagerImpl.add2Registry('i', "csnet-ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('j', "3com-tsmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('k', "rtelnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('l', "snagas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('m', "pop2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('n', "pop3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('o', "sunrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('p', "mcidas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('q', "auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('s', "sftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('t', "ansanotify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('u', "uucp-path", true, true);
        NetworkServiceNameManagerImpl.add2Registry('v', "sqlserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('w', "nntp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('x', "cfdptkt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('y', "erpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('z', "smakynet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('{', "ntp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('|', "ansatrader", true, true);
        NetworkServiceNameManagerImpl.add2Registry('}', "locus-map", true, true);
        NetworkServiceNameManagerImpl.add2Registry('~', "nxedit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u007f', "locus-con", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0080', "gss-xlicen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0081', "pwdgen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0082', "cisco-fna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0083', "cisco-tna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0084', "cisco-sys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0085', "statsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0086', "ingres-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0087', "epmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0088', "profile", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0089', "netbios-ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008a', "netbios-dgm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008b', "netbios-ssn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008c', "emfis-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008d', "emfis-cntl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008e', "bl-idm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u008f', "imap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0090', "uma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0091', "uaac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0092', "iso-tp0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0093', "iso-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0094', "jargon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0095', "aed-512", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0096', "sql-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0097', "hems", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0098', "bftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0099', "sgmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009a', "netsc-prod", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009b', "netsc-dev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009c', "sqlsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009d', "knet-cmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009e', "pcmail-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u009f', "nss-routing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a0', "sgmp-traps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a1', "snmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a2', "snmptrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a3', "cmip-man", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a4', "cmip-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a5', "xns-courier", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a6', "s-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a7', "namp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a8', "rsvd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00a9', "send", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00aa', "print-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ab', "multiplex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ac', "cl-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ad', "xyplex-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ae', "mailq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00af', "vmnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b0', "genrad-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b1', "xdmcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b2', "nextstep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b3', "bgp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b4', "ris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b5', "unify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b6', "audit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b7', "ocbinder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b8', "ocserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00b9', "remote-kis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ba', "kis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00bb', "aci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00bc', "mumps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00bd', "qft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00be', "gacp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00bf', "prospero", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c0', "osu-nms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c1', "srmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c2', "irc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c3', "dn6-nlm-aud", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c4', "dn6-smm-red", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c5', "dls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c6', "dls-mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c7', "smux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c8', "src", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00c9', "at-rtmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ca', "at-nbp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00cb', "at-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00cc', "at-echo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00cd', "at-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00ce', "at-zis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00cf', "at-7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d0', "at-8", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d1', "qmtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d2', "z39-50", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d3', "914c-g", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d4', "anet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d5', "ipx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d6', "vmpwscs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d7', "softpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d8', "CAIlic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00d9', "dbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00da', "mpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00db', "uarps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00dc', "imap3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00dd', "fln-spx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00de', "rsh-spx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00df', "cdc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00e0', "masqdialer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f2', "direct", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f3', "sur-meas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f4', "inbusiness", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f5', "link", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f6', "dsp3270", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f7', "subntbcst-tftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u00f8', "bhfhs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0100', "rap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0101', "set", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0103', "esro-gen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0104', "openport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0105', "nsiiops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0106', "arcisdms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0107', "hdap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0108', "bgmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0109', "x-bone-ctl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u010a', "sst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u010b', "td-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u010c', "td-replica", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u010d', "manet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u010e', "gist", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0118', "http-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0119', "personal-link", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u011a', "cableport-ax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u011b', "rescap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u011c', "corerjd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u011e', "fxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u011f', "k-block", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0134', "novastorbakcup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0135', "entrusttime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0136', "bhmds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0137', "asip-webadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0138', "vslmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0139', "magenta-logic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013a', "opalis-robot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013b', "dpsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013c', "decauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013d', "zannet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013e', "pkix-timestamp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u013f', "ptp-event", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0140', "ptp-general", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0141', "pip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0142', "rtsps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u014d', "texar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0158', "pdap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0159', "pawserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015a', "zserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015b', "fatserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015c', "csi-sgwp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015d', "mftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015e', "matip-type-a", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u015f', "matip-type-b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0160', "dtag-ste-sb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0161', "ndsauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0162', "bh611", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0163', "datex-asn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0164', "cloanto-net-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0165', "bhevent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0166', "shrinkwrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0167', "nsrmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0168', "scoi2odialog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0169', "semantix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016a', "srssend", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016b', "rsvp-tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016c', "aurora-cmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016d', "dtk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016e', "odmr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u016f', "mortgageware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0170', "qbikgdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0171', "rpc2portmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0172', "codaauth2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0173', "clearcase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0174', "ulistproc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0175', "legent-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0176', "legent-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0177', "hassle", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0178', "nip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0179', "tnETOS", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017a', "dsETOS", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017b', "is99c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017c', "is99s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017d', "hp-collector", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017e', "hp-managed-node", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u017f', "hp-alarm-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0180', "arns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0181', "ibm-app", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0182', "asa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0183', "aurp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0184', "unidata-ldm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0185', "ldap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0186', "uis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0187', "synotics-relay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0188', "synotics-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0189', "meta5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018a', "embl-ndt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018b', "netcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018c', "netware-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018d', "mptn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018e', "kryptolan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u018f', "iso-tsap-c2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0190', "osb-sd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0191', "ups", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0192', "genie", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0193', "decap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0194', "nced", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0195', "ncld", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0196', "imsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0197', "timbuktu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0198', "prm-sm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0199', "prm-nm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019a', "decladebug", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019b', "rmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019c', "synoptics-trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019d', "smsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019e', "infoseek", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u019f', "bnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a0', "silverplatter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a1', "onmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a2', "hyper-g", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a3', "ariel1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a4', "smpte", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a5', "ariel2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a6', "ariel3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a7', "opc-job-start", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a8', "opc-job-track", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01a9', "icad-el", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01aa', "smartsdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ab', "svrloc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ac', "ocs-cmu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ad', "ocs-amu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ae', "utmpsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01af', "utmpcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b0', "iasd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b1', "nnsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b2', "mobileip-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b3', "mobilip-mn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b4', "dna-cml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b5', "comscm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b6', "dsfgw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b7', "dasp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b8', "sgcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01b9', "decvms-sysmgt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ba', "cvc-hostd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01bb', "https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01bc', "snpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01bd', "microsoft-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01be', "ddm-rdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01bf', "ddm-dfm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c0', "ddm-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c1', "as-servermap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c2', "tserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c3', "sfs-smp-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c4', "sfs-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c5', "creativeserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c6', "contentserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c7', "creativepartnr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c8', "macon-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u01c8', "macon-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01c9', "scohelp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ca', "appleqtc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01cb', "ampr-rcmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01cc', "skronk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01cd', "datasurfsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ce', "datasurfsrvsec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01cf', "alpes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d0', "kpasswd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d1', "urd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u01d1', "igmpv3lite", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d2', "digital-vrc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d3', "mylex-mapd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d4', "photuris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d5', "rcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d6', "scx-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d7', "mondex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d8', "ljk-login", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01d9', "hybrid-pop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01da', "tn-tl-w1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u01da', "tn-tl-w2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01db', "tcpnethaspsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01dc', "tn-tl-fd1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01dd', "ss7ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01de', "spsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01df', "iafserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e0', "iafdbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e1', "ph", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e2', "bgs-nsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e3', "ulpnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e4', "integra-sme", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e5', "powerburst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e6', "avian", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e7', "saft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e8', "gss-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01e9', "nest-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ea', "micom-pfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01eb', "go-login", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ec', "ticf-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ed', "ticf-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ee', "pov-ray", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ef', "intecourier", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f0', "pim-rp-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f1', "retrospect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f2', "siam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f3', "iso-ill", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f4', "isakmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f5', "stmf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f6', "asa-appl-proto", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f7', "intrinsa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f8', "citadel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01f9', "mailbox-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01fa', "ohimsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01fb', "crs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01fc', "xvttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01fd', "snare", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01fe', "fcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u01ff', "passgo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0200', "exec", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0200', "biff", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0201', "login", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0201', "who", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0202', "shell", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0202', "syslog", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0203', "printer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0204', "videotex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0205', "talk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0206', "ntalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0207', "utime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0208', "efs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0208', "router", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0209', "ripng", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020a', "ulp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020b', "ibm-db2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020c', "ncp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020d', "timed", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020e', "tempo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u020f', "stx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0210', "custix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0211', "irc-serv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0212', "courier", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0213', "conference", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0214', "netnews", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0215', "netwall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0216', "windream", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0217', "iiop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0218', "opalis-rdv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0219', "nmsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021a', "gdomap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021b', "apertus-ldp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021c', "uucp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021d', "uucp-rlogin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021e', "commerce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u021f', "klogin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0220', "kshell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0221', "appleqtcsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0222', "dhcpv6-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0223', "dhcpv6-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0224', "afpovertcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0225', "idfp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0226', "new-rwho", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0227', "cybercash", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0228', "devshr-nts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0229', "pirp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022a', "rtsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022b', "dsf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022c', "remotefs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022d', "openvms-sysipc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022e', "sdnskmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u022f', "teedtap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0230', "rmonitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0231', "monitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0232', "chshell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0233', "nntps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0234', "9pfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0235', "whoami", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0236', "streettalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0237', "banyan-rpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0238', "ms-shuttle", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0239', "ms-rome", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023a', "meter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023b', "meter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023c', "sonar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023d', "banyan-vip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023e', "ftp-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u023f', "vemmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0240', "ipcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0241', "vnas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0242', "ipdd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0243', "decbsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0244', "sntp-heartbeat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0245', "bdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0246', "scc-security", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0247', "philips-vc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0248', "keyserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024a', "password-chg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024b', "submission", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024c', "cal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024d', "eyelink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024e', "tns-cml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u024f', "http-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0250', "eudora-set", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0251', "http-rpc-epmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0252', "tpip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0253', "cab-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0254', "smsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0255', "ptcnameservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0256', "sco-websrvrmg3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0257', "acp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0258', "ipcserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0259', "syslog-conn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025a', "xmlrpc-beep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025b', "idxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025c', "tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025d', "soap-beep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025e', "urm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u025f', "nqs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0260', "sift-uft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0261', "npmp-trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0262', "npmp-local", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0263', "npmp-gui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0264', "hmmp-ind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0265', "hmmp-op", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0266', "sshell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0267', "sco-inetmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0268', "sco-sysmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0269', "sco-dtmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026a', "dei-icda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026b', "compaq-evm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026c', "sco-websrvrmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026d', "escp-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026e', "collaborator", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u026f', "oob-ws-http", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u026f', "asf-rmcp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0270', "cryptoadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0271', "dec-dlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0272', "asia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0273', "passgo-tivoli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0274', "qmqp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0275', "3com-amp3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0276', "rda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0277', "ipp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0278', "bmpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0279', "servstat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027a', "ginad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027b', "rlzdbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027c', "ldaps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027d', "lanserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027e', "mcns-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u027f', "msdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0280', "entrust-sps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0281', "repcmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0282', "esro-emsdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0283', "sanity", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0284', "dwr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0285', "pssc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0286', "ldp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0287', "dhcp-failover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0288', "rrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0289', "cadview-3d", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028a', "obex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028b', "ieee-mms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028c', "hello-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028d', "repscmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028e', "aodv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u028f', "tinc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0290', "spmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0291', "rmc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0292', "tenfold", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0294', "mac-srvr-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0295', "hap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0296', "pftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0297', "purenoise", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0298', "oob-ws-https", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0298', "asf-secure-rmcp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0299', "sun-dr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029a', "doom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029b', "disclose", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029c', "mecomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029d', "meregister", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029e', "vacdsm-sws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u029f', "vacdsm-app", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a0', "vpps-qua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a1', "cimplex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a2', "acap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a3', "dctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a4', "vpps-via", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a5', "vpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a6', "ggf-ncp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a7', "mrm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a8', "entrust-aaas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02a9', "entrust-aams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02aa', "xfr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ab', "corba-iiop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ac', "corba-iiop-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ad', "mdc-portmapper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ae', "hcp-wismar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02af', "asipregistry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b0', "realm-rusd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b1', "nmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b2', "vatp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b3', "msexch-routing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b4', "hyperwave-isp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b5', "connendp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b6', "ha-cluster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b7', "ieee-mms-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b8', "rushd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02b9', "uuidgen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ba', "olsr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02bb', "accessnetwork", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02bc', "epp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02bd', "lmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02be', "iris-beep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c0', "elcsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c1', "agentx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c2', "silc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c3', "borland-dsj", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c5', "entrust-kmsh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c6', "entrust-ash", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c7', "cisco-tdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c8', "tbrpf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02c9', "iris-xpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ca', "iris-xpcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02cb', "iris-lwz", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02cc', "pana", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02d9', "netviewdm1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02da', "netviewdm2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02db', "netviewdm3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02e5', "netgw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02e6', "netrcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02e8', "flexlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02eb', "fujitsu-dev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ec', "ris-cm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ed', "kerberos-adm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ee', "rfile", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u02ee', "kerberos-iv", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ef', "pump", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f0', "qrh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f1', "rrh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f2', "tell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f6', "nlogin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f7', "con", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f8', "ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02f9', "rxe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02fa', "quotad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02fb', "cycleserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02fc', "omserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02fd', "webster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u02ff', "phonebook", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0301', "vid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0302', "cadlock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0303', "rtip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0304', "cycleserv2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0305', "submit", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0305', "notify", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0306', "rpasswd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0306', "acmaint-dbd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0307', "entomb", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0307', "acmaint-transd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0308', "wpages", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0309', "multiling-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u030c', "wpgs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0320', "mdbs-daemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0321', "device", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u032a', "fcp-udp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u033c', "itm-mcell-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u033d', "pkix-3-ca-ra", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u033e', "netconf-ssh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u033f', "netconf-beep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0340', "netconfsoaphttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0341', "netconfsoapbeep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u034f', "dhcp-failover2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0350', "gdoi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u035c', "iscsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u035d', "owamp-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u035e', "twamp-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0369', "rsync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0376', "iclcnet-locate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0377', "iclcnet-svinfo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0378', "accessbuilder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0384', "omginitialrefs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0385', "smpnameres", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0386', "ideafarm-door", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0387', "ideafarm-panic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u038e', "kink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u038f', "xact-backup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0390', "apex-mesh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0391', "apex-edge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03dd', "ftps-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03de', "ftps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03df', "nas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e0', "telnets", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e1', "imaps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e3', "pop3s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e4', "vsinet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e5', "maitrd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e6', "busboy", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u03e6', "puparp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e7', "puprouter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03e8', "cadlock2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03f2', "surf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03fd', "exp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u03fe', "exp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0401', "blackjack", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0402', "cap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0405', "solid-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0406', "iad1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0407', "iad2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0408', "iad3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0409', "netinfo-local", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040a', "activesync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040b', "mxxrlogin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040c', "nsstp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040d', "ams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040e', "mtqp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u040f', "sbl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0410', "netarx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0411', "danf-ak2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0412', "afrog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0413', "boinc-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0414', "dcutility", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0415', "fpitp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0416', "wfremotertm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0417', "neod1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0418', "neod2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0419', "td-postman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041a', "cma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041b', "optima-vnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041c', "ddt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041d', "remote-as", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041e', "brvread", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u041f', "ansyslmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0420', "vfo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0421', "startron", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0422', "nim", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0423', "nimreg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0424', "polestar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0425', "kiosk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0426', "veracity", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0427', "kyoceranetdev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0428', "jstel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0429', "syscomlan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042a', "fpo-fns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042b', "instl-boots", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042c', "instl-bootc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042d', "cognex-insight", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042e', "gmrupdateserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u042f', "bsquare-voip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0430', "cardax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0431', "bridgecontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0432', "warmspotMgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0433', "rdrmshc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0434', "dab-sti-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0435', "imgames", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0436', "avocent-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0437', "asprovatalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0438', "socks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0439', "pvuniwien", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043a', "amt-esd-prot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043b', "ansoft-lm-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043c', "ansoft-lm-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043d', "webobjects", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043e', "cplscrambler-lg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u043f', "cplscrambler-in", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0440', "cplscrambler-al", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0441', "ff-annunc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0442', "ff-fms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0443', "ff-sm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0444', "obrpd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0445', "proofd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0446', "rootd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0447', "nicelink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0448', "cnrprotocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0449', "sunclustermgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044a', "rmiactivation", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044b', "rmiregistry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044c', "mctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044d', "pt2-discover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044e', "adobeserver-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u044f', "adobeserver-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0450', "xrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0451', "ftranhc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0452', "isoipsigport-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0453', "isoipsigport-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0454', "ratio-adp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0456', "webadmstart", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0456', "nfsd-keepalive", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0457', "lmsocialserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0458', "icp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0459', "ltp-deepspace", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045a', "mini-sql", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045b', "ardus-trns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045c', "ardus-cntl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045d', "ardus-mtrns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045e', "sacred", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u045f', "bnetgame", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0460', "bnetfile", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0461', "rmpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0462', "availant-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0463', "murray", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0464', "hpvmmcontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0465', "hpvmmagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0466', "hpvmmdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0467', "kwdb-commn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0468', "saphostctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0469', "saphostctrls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046a', "casp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046b', "caspssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046c', "kvm-via-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046d', "dfn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046e', "aplx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u046f', "omnivision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0470', "hhb-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0471', "trim", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0472', "encrypted-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0473', "evm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0474', "autonoc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0475', "mxomss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0476', "edtools", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0477', "imyx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0478', "fuscript", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0479', "x9-icue", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047a', "audit-transfer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047b', "capioverlan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047c', "elfiq-repl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047d', "bvtsonar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047e', "blaze", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u047f', "unizensus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0480', "winpoplanmess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0481', "c1222-acse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0482', "resacommunity", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0483', "nfa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0484', "iascontrol-oms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0485', "iascontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0486', "dbcontrol-oms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0487', "oracle-oms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0488', "olsv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0489', "health-polling", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048a', "health-trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048b', "sddp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048c', "qsm-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048d', "qsm-gui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048e', "qsm-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u048f', "cisco-ipsla", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0490', "vchat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0491', "tripwire", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0492', "atc-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0493', "atc-appserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0494', "dnap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0495', "d-cinema-rrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0496', "fnet-remote-ui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0497', "dossier", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0498', "indigo-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0499', "dkmessenger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049a', "sgi-storman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049b', "b2n", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049c', "mc-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049d', "3comnetman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049e', "accelenet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u049e', "accelenet-data", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u049f', "llsurfup-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a0', "llsurfup-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a1', "catchpole", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a2', "mysql-cluster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a3', "alias", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a4', "hp-webadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a5', "unet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a6', "commlinx-avl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a7', "gpfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a8', "caids-sensor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04a9', "fiveacross", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04aa', "openvpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ab', "rsf-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ac', "netmagic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ad', "carrius-rshell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ae', "cajo-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04af', "dmidi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b0', "scol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b1', "nucleus-sand", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b2', "caiccipc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b3', "ssslic-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b4', "ssslog-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b5', "accord-mgc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b6', "anthony-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b7', "metasage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b8', "seagull-ais", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04b9', "ipcd3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ba', "eoss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04bb', "groove-dpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04bc', "lupa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04bd', "mpc-lifenet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04be', "kazaa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04bf', "scanstat-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c0', "etebac5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c1', "hpss-ndapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c2', "aeroflight-ads", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c3', "aeroflight-ret", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c4', "qt-serveradmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c5', "sweetware-apps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c6', "nerv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c7', "tgp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c8', "vpnz", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04c9', "slinkysearch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ca', "stgxfws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04cb', "dns2go", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04cc', "florence", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04cd', "zented", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ce', "periscope", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04cf', "menandmice-lpm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d1', "univ-appserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d2', "search-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d3', "mosaicsyssvc1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d4', "bvcontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d5', "tsdos390", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d6', "hacl-qs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d7', "nmsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d8', "instantia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04d9', "nessus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04da', "nmasoverip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04db', "serialgateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04dc', "isbconference1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04dd', "isbconference2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04de', "payrouter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04df', "visionpyramid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e0', "hermes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e1', "mesavistaco", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e2', "swldy-sias", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e3', "servergraph", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e4', "bspne-pcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e5', "q55-pcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e6', "de-noc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e7', "de-cache-query", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e8', "de-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04e9', "shockwave2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ea', "opennl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04eb', "opennl-voice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ec', "ibm-ssd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ed', "mpshrsv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ee', "qnts-orb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ef', "dka", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f0', "prat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f1', "dssiapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f2', "dellpwrappks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f3', "epc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f4', "propel-msgsys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f5', "watilapp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f6', "opsmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f7', "excw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f8', "cspmlockmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04f9', "emc-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04fa', "t1distproc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04fb', "ivcollector", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04fc', "ivmanager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04fd', "miva-mqs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04fe', "dellwebadmin-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u04ff', "dellwebadmin-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0500', "pictrography", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0501', "healthd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0502', "emperion", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0503', "productinfo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0504', "iee-qfx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0505', "neoiface", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0506', "netuitive", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0507', "routematch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0508', "navbuddy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0509', "jwalkserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050a', "winjaserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050b', "seagulllms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050c', "dsdn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050d', "pkt-krb-ipsec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050e', "cmmdriver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u050f', "ehtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0510', "dproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0511', "sdproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0512', "lpcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0513', "hp-sci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0514', "h323hostcallsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0515', "ci3-software-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0516', "ci3-software-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0517', "sftsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0518', "boomerang", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0519', "pe-mike", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051a', "re-conn-proto", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051b', "pacmand", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051c', "odsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051d', "jtag-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051e', "husky", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u051f', "rxmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0520', "sti-envision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0521', "bmc-patroldb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0522', "pdps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0523', "els", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0524', "exbit-escp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0525', "vrts-ipcserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0526', "krb5gatekeeper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0527', "amx-icsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0528', "amx-axbnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0529', "pip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052a', "novation", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052b', "brcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052c', "delta-mcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052d', "dx-instrument", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052e', "wimsic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u052f', "ultrex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0530', "ewall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0531', "netdb-export", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0532', "streetperfect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0533', "intersan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0534', "pcia-rxp-b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0535', "passwrd-policy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0536', "writesrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0537', "digital-notary", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0538', "ischat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0539', "menandmice-dns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053a', "wmc-log-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053b', "kjtsiteserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053c', "naap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053d', "qubes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053e', "esbroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u053f', "re101", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0540', "icap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0541', "vpjp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0542', "alta-ana-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0543', "bbn-mmc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0544', "bbn-mmx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0545', "sbook", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0546', "editbench", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0547', "equationbuilder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0548', "lotusnote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0549', "relief", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054a', "XSIP-network", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054b', "intuitive-edge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054c', "cuillamartin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054d', "pegboard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054e', "connlcli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u054f', "ftsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0550', "mimer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0551', "linx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0552', "timeflies", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0553', "ndm-requester", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0554', "ndm-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0555', "adapt-sna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0556', "netware-csp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0557', "dcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0558', "screencast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0559', "gv-us", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055a', "us-gv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055b', "fc-cli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055c', "fc-ser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055d', "chromagrafx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055e', "molly", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u055f', "bytex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0560', "ibm-pps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0561', "cichlid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0562', "elan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0563', "dbreporter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0564', "telesis-licman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0565', "apple-licman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0566', "udt-os", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0567', "gwha", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0568', "os-licman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0569', "atex-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056a', "checksum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056b', "cadsi-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056c', "objective-dbc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056d', "iclpv-dm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056e', "iclpv-sc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u056f', "iclpv-sas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0570', "iclpv-pm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0571', "iclpv-nls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0572', "iclpv-nlc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0573', "iclpv-wsm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0574', "dvl-activemail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0575', "audio-activmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0576', "video-activmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0577', "cadkey-licman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0578', "cadkey-tablet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0579', "goldleaf-licman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057a', "prm-sm-np", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057b', "prm-nm-np", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057c', "igi-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057d', "ibm-res", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057e', "netlabs-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u057f', "dbsa-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0580', "sophia-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0581', "here-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0582', "hiq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0583', "af", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0584', "innosys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0585', "innosys-acl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0586', "ibm-mqseries", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0587', "dbstar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0588', "novell-lu6-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0589', "timbuktu-srv1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058a', "timbuktu-srv2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058b', "timbuktu-srv3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058c', "timbuktu-srv4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058d', "gandalf-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058e', "autodesk-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u058f', "essbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0590', "hybrid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0591', "zion-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0592', "sais", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0593', "mloadd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0594', "informatik-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0595', "nms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0596', "tpdu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0597', "rgtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0598', "blueberry-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0599', "ms-sql-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059a', "ms-sql-m", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059b', "ibm-cics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059c', "saism", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059d', "tabula", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059e', "eicon-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u059f', "eicon-x25", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a0', "eicon-slp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a1', "cadis-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a2', "cadis-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a3', "ies-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a4', "marcam-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a5', "proxima-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a6', "ora-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a7', "apri-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a8', "oc-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05a9', "peport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05aa', "dwf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ab', "infoman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ac', "gtegsc-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ad', "genie-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ae', "interhdl-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05af', "esl-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b0', "dca", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b1', "valisys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b2', "nrcabq-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b3', "proshare1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b4', "proshare2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b5', "ibm-wrless-lan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b6', "world-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b7', "nucleus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b8', "msl-lmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05b9', "pipes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ba', "oceansoft-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05bb', "csdmbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05bc', "csdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05bd', "aal-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05be', "uaiact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05bf', "csdmbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c0', "csdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c1', "openmath", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c2', "telefinder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c3', "taligent-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c4', "clvm-cfg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c5', "ms-sna-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c6', "ms-sna-base", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c7', "dberegister", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c8', "pacerforum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05c9', "airs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ca', "miteksys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05cb', "afs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05cc', "confluent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05cd', "lansource", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ce', "nms-topo-serv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05cf', "localinfosrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d0', "docstor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d1', "dmdocbroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d2', "insitu-conf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d4', "stone-design-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d5', "netmap-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d6', "ica", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d7', "cvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d8', "liberty-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05d9', "rfx-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05da', "sybase-sqlany", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05db', "fhc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05dc', "vlsi-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05dd', "saiscm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05de', "shivadiscovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05df', "imtc-mcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e0', "evb-elm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e1', "funkproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e2', "utcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e3', "symplex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e4', "diagmond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e5', "robcad-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e6', "mvx-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e7', "3l-l1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e8', "wins", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05e9', "fujitsu-dtc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ea', "fujitsu-dtcns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05eb', "ifor-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ec', "vpad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ed', "vpac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ee', "vpvd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ef', "vpvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f0', "atm-zip-office", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f1', "ncube-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f2', "ricardo-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f3', "cichild-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f4', "ingreslock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f5', "orasrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f6', "pdap-np", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05f7', "tlisrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05fa', "rap-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05fb', "rap-listen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05fc', "miroconnect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05fd', "virtual-places", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05fe', "micromuse-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u05ff', "ampr-info", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0600', "ampr-inter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0601', "sdsc-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0602', "3ds-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0603', "intellistor-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0604', "rds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0605', "rds2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0606', "gridgen-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0607', "simba-cs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0608', "aspeclmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0609', "vistium-share", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060a', "abbaccuray", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060b', "laplink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060c', "axon-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060d', "shivahose", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u060d', "shivasound", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060e', "3m-image-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u060f', "hecmtl-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0610', "pciarray", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0611', "sna-cs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0612', "caci-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0613', "livelan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0614', "veritas-pbx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0615', "arbortext-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0616', "xingmpeg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0617', "web2host", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0618', "asci-val", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0619', "facilityview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061a', "pconnectmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061b', "cadabra-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061c', "pay-per-view", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061d', "winddlb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061e', "corelvideo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u061f', "jlicelmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0620', "tsspmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0621', "ets", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0622', "orbixd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0623', "rdb-dbs-disp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0624', "chip-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0625', "itscomm-ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0626', "mvel-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0627', "oraclenames", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0628', "moldflow-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0629', "hypercube-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062a', "jacobus-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062b', "ioc-sea-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062c', "tn-tl-r1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u062c', "tn-tl-r2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062d', "mil-2045-47001", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062e', "msims", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u062f', "simbaexpress", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0630', "tn-tl-fd2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0631', "intv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0632', "ibm-abtact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0633', "pra-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0634', "triquest-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0635', "vqp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0636', "gemini-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0637', "ncpm-pm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0638', "commonspace", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0639', "mainsoft-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063a', "sixtrak", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063b', "radio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063c', "radio-sm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u063c', "radio-bc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063d', "orbplus-iiop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063e', "picknfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u063f', "simbaservices", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0640', "issd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0641', "aas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0642', "inspect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0643', "picodbc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0644', "icabrowser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0645', "slp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0646', "slm-api", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0647', "stt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0648', "smart-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0649', "isysg-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064a', "taurus-wh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064b', "ill", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064c', "netbill-trans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064d', "netbill-keyrep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064e', "netbill-cred", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u064f', "netbill-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0650', "netbill-prod", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0651', "nimrod-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0652', "skytelnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0653', "xs-openstorage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0654', "faxportwinport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0655', "softdataphone", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0656', "ontime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0657', "jaleosnd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0658', "udp-sr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0659', "svs-omagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065a', "shockwave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065b', "t128-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065c', "lontalk-norm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065d', "lontalk-urgnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065e', "oraclenet8cman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u065f', "visitview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0660', "pammratc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0661', "pammrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0662', "loaprobe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0663', "edb-server1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0664', "isdc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0665', "islc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0666', "ismc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0667', "cert-initiator", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0668', "cert-responder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0669', "invision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u066a', "isis-am", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u066b', "isis-ambc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u066c', "saiseh", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u066d', "sightline", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u066e', "sa-msg-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u066f', "rsap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0670', "concurrent-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0671', "kermit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0672', "nkd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0673', "shiva-confsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0674', "xnmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0675', "alphatech-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0676', "stargatealerts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0677', "dec-mbadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0678', "dec-mbadmin-h", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0679', "fujitsu-mmpdc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067a', "sixnetudr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067b', "sg-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067c', "skip-mc-gikreq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067d', "netview-aix-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067e', "netview-aix-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u067f', "netview-aix-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0680', "netview-aix-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0681', "netview-aix-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0682', "netview-aix-6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0683', "netview-aix-7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0684', "netview-aix-8", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0685', "netview-aix-9", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0686', "netview-aix-10", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0687', "netview-aix-11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0688', "netview-aix-12", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0689', "proshare-mc-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068a', "proshare-mc-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068b', "pdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068c', "netcomm1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u068c', "netcomm2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068d', "groupwise", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068e', "prolink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u068f', "darcorp-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0690', "microcom-sbp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0691', "sd-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0692', "lanyon-lantern", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0693', "ncpm-hip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0694', "snaresecure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0695', "n2nremote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0696', "cvmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0697', "nsjtp-ctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0698', "nsjtp-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0699', "firefox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069a', "ng-umds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069b', "empire-empuma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069c', "sstsys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069d', "rrirtr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069e', "rrimwm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u069f', "rrilwm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a0', "rrifmm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a1', "rrisat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a2', "rsvp-encap-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a3', "rsvp-encap-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a4', "mps-raft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a5', "l2f", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a6', "deskshare", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a7', "hb-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a8', "bcs-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06a9', "slingshot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06aa', "jetform", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ab', "vdmplay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ac', "gat-lmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ad', "centra", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ae', "impera", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06af', "pptconference", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b0', "registrar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b1', "conferencetalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b2', "sesi-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b3', "houdini-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b4', "xmsg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b5', "fj-hdnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b6', "h323gatedisc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b7', "h323gatestat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b8', "h323hostcall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06b9', "caicci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ba', "hks-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06bb', "pptp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06bc', "csbphonemaster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06bd', "iden-ralp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06be', "iberiagames", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06bf', "winddx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c0', "telindus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c1', "citynl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c2', "roketz", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c3', "msiccp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c4', "proxim", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c5', "siipat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c6', "cambertx-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c7', "privatechat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c8', "street-stream", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06c9', "ultimad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ca', "gamegen1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06cb', "webaccess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06cc', "encore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06cd', "cisco-net-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ce', "3Com-nsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06cf', "cinegrfx-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d0', "ncpm-ft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d1', "remote-winsock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d2', "ftrapid-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d3', "ftrapid-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d4', "oracle-em1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d5', "aspen-services", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d6', "sslp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d7', "swiftnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d8', "lofr-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06d9', "predatar-comms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u06da', "oracle-em2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06db', "ms-streaming", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06dc', "capfast-lmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06dd', "cnhrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06de', "tftp-mcast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06df', "spss-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e0', "www-ldap-gw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e1', "cft-0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e2', "cft-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e3', "cft-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e4', "cft-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e5', "cft-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e6', "cft-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e7', "cft-6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e8', "cft-7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06e9', "bmc-net-adm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ea', "bmc-net-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06eb', "vaultbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ec', "essweb-gw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ed', "kmscontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ee', "global-dtserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ef', "-", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u06f0', "femis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f1', "powerguardian", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f2', "prodigy-intrnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f3', "pharmasoft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f4', "dpkeyserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f5', "answersoft-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f6', "hp-hcip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f8', "finle-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06f9', "windlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06fa', "funk-logger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06fb', "funk-license", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06fc', "psmond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06fd', "hello", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06fe', "nmsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u06ff', "ea1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0700', "ibm-dt-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0701', "rsc-robot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0702', "cera-bcm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0703', "dpi-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0704', "vocaltec-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0705', "uma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0706', "etp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0707', "netrisk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0708', "ansys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0709', "msmq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070a', "concomp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070b', "hp-hcip-gwy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070c', "enl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070d', "enl-name", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070e', "musiconline", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u070f', "fhsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0710', "oracle-vp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0711', "oracle-vp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0712', "jerand-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0713', "scientia-sdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0714', "radius", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0715', "radius-acct", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0716', "tdp-suite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0717', "mmpft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0718', "harp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0719', "rkb-oscs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071a', "etftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071b', "plato-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071c', "mcagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071d', "donnyworld", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071e', "es-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u071f', "unisys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0720', "metrics-pas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0721', "direcpc-video", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0722', "ardt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0723', "asi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0724', "itm-mcell-u", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0725', "optika-emedia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0726', "net8-cman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0727', "myrtle", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0728', "tht-treasure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0729', "udpradio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072a', "ardusuni", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072b', "ardusmul", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072c', "ste-smsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072d', "csoft1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072e', "talnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u072f', "netopia-vo1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0730', "netopia-vo2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0731', "netopia-vo3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0732', "netopia-vo4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0733', "netopia-vo5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0734', "direcpc-dll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0735', "altalink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0736', "tunstall-pnc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0737', "slp-notify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0738', "fjdocdist", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0739', "alpha-sms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073a', "gsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073b', "ctcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073c', "virtual-time", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073d', "vids-avtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073e', "buddy-draw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u073f', "fiorano-rtrsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0740', "fiorano-msgsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0741', "datacaptor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0742', "privateark", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0743', "gammafetchsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0744', "sunscalar-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0745', "lecroy-vicp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0746', "mysql-cm-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0747', "msnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0748', "paradym-31port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0749', "entp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074a', "swrmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074b', "udrive", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074c', "viziblebrowser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074d', "transact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074e', "sunscalar-dns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u074f', "canocentral0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0750', "canocentral1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0751', "fjmpjps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0752', "fjswapsnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0753', "westell-stats", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0754', "ewcappsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0755', "hp-webqosdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0756', "drmsmc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0757', "nettgain-nms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0758', "vsat-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0759', "ibm-mqseries2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075a', "ecsqdmn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075b', "ibm-mqisdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075c', "idmaps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075d', "vrtstrapserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075e', "leoip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u075f', "filex-lport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0760', "ncconfig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0761', "unify-adapter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0762', "wilkenlistener", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0763', "childkey-notif", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0764', "childkey-ctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0765', "elad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0766', "o2server-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0768', "b-novative-ls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0769', "metaagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076a', "cymtec-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076b', "mc2studios", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076c', "ssdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076d', "fjicl-tep-a", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076e', "fjicl-tep-b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u076f', "linkname", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0770', "fjicl-tep-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0771', "sugp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0772', "tpmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0773', "intrastar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0774', "dawn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0775', "global-wlink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0776', "ultrabac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0777', "mtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0778', "rhp-iibp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0779', "armadp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077a', "elm-momentum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077b', "facelink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077c', "persona", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077d', "noagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077e', "can-nds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u077f', "can-dch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0780', "can-ferret", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0781', "noadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0782', "tapestry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0783', "spice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0784', "xiip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0785', "discovery-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0786', "egs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0787', "videte-cipc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0788', "emsd-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0789', "bandwiz-system", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078a', "driveappserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078b', "amdsched", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078c', "ctt-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078d', "xmapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078e', "xaapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u078f', "macromedia-fcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0790', "jetcmeserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0791', "jwserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0792', "jwclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0793', "jvserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0794', "jvclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0795', "dic-aida", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0796', "res", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0797', "beeyond-media", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0798', "close-combat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0799', "dialogic-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079a', "tekpls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079b', "sentinelsrm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079c', "eye2eye", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079d', "ismaeasdaqlive", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079e', "ismaeasdaqtest", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u079f', "bcs-lmserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a0', "mpnjsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a1', "rapidbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a2', "abr-api", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a3', "abr-secure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a4', "vrtl-vmf-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a5', "unix-status", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a6', "dxadmind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a7', "simp-all", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a8', "nasmanager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07a9', "bts-appserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07aa', "biap-mp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ab', "webmachine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ac', "solid-e-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ad', "tivoli-npm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ae', "slush", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07af', "sns-quote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b0', "lipsinc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b1', "lipsinc1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b2', "netop-rc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b3', "netop-school", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b4', "intersys-cache", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b5', "dlsrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b6', "drp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b7', "tcoflashagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b8', "tcoregagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07b9', "tcoaddressbook", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ba', "unisql", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07bb', "unisql-java", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07bc', "pearldoc-xact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07bd', "p2pq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07be', "estamp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07bf', "lhtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c0', "bb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c1', "hsrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c2', "licensedaemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c3', "tr-rsrb-p1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c4', "tr-rsrb-p2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c5', "tr-rsrb-p3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c6', "stun-p1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c7', "stun-p2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c8', "stun-p3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07c9', "snmp-tcp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ca', "stun-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07cb', "perf-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07cc', "tr-rsrb-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07cd', "gdp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ce', "x25-svc-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07cf', "tcp-id-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d0', "cisco-sccp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d1', "dc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d1', "wizard", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d2', "globe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d3', "brutus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d4', "mailbox", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d4', "emce", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d5', "berknet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d5', "oracle", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d6', "invokator", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d6', "raid-cd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d7', "dectalk", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d7', "raid-am", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d8', "conf", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d8', "terminaldb", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07d9', "news", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07d9', "whosockami", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07da', "search", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07da', "pipe-server", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07db', "raid-cc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07db', "servserv", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07dc', "ttyinfo", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07dc', "raid-ac", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07dd', "raid-am", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07dd', "raid-cd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07de', "troff", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07de', "raid-sf", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07df', "cypress", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07df', "raid-cs", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e0', "bootserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e1', "cypress-stat", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e1', "bootclient", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e2', "terminaldb", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e2', "rellpack", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e3', "whosockami", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e3', "about", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e4', "xinupageserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e5', "servexec", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e5', "xinuexpansion1", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e6', "down", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e6', "xinuexpansion2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e7', "xinuexpansion3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e8', "xinuexpansion4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07e9', "ellpack", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u07e9', "xribs", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ea', "scrabble", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07eb', "shadowserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ec', "submitserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ed', "hsrpv6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ee', "device2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ef', "mobrien-chat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f0', "blackboard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f1', "glogger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f2', "scoremgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f3', "imsldoc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f4', "e-dpnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f5', "applus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f6', "objectmanager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f7', "prizma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f8', "lam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07f9', "interbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07fa', "isis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07fb', "isis-bcast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07fc', "rimsl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07fd', "cdfunc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07fe', "sdfunc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u07ff', "dls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0800', "dls-monitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0801', "nfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0802', "av-emb-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0803', "epnsdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0804', "clearvisn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0805', "lot105-ds-upd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0806', "weblogin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0807', "iop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0808', "omnisky", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0809', "rich-cp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080a', "newwavesearch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080b', "bmc-messaging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080c', "teleniumdaemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080d', "netmount", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080e', "icg-swp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u080f', "icg-bridge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0810', "icg-iprelay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0811', "dlsrpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0812', "aura", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0813', "dlswpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0814', "avauthsrvprtcl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0815', "event-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0816', "ah-esp-encap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0817', "acp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0818', "msync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0819', "gxs-data-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081a', "vrtl-vmf-sa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081b', "newlixengine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081c', "newlixconfig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081d', "tsrmagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081e', "tpcsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u081f', "idware-router", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0820', "autodesk-nlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0821', "kme-trap-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0822', "infowave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0823', "radsec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0824', "sunclustergeo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0825', "ada-cip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0826', "gnunet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0827', "eli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0828', "ip-blf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0829', "sep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082a', "lrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082b', "prp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082c', "descent3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082d', "nbx-cc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082e', "nbx-au", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u082f', "nbx-ser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0830', "nbx-dir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0831', "jetformpreview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0832', "dialog-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0833', "h2250-annex-g", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0834', "amiganetfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0835', "rtcm-sc104", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0836', "zephyr-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0837', "zephyr-clt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0838', "zephyr-hm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0839', "minipay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083a', "mzap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083b', "bintec-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083c', "comcam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083d', "ergolight", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083e', "umsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u083f', "dsatp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0840', "idonix-metanet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0841', "hsl-storm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0842', "newheights", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0843', "kdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0844', "ccowcmr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0845', "mentaclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0846', "mentaserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0847', "gsigatekeeper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0848', "qencp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0849', "scientia-ssdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084a', "caupc-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084b', "gtp-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084c', "elatelink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084d', "lockstep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084e', "pktcable-cops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u084f', "index-pc-wb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0850', "net-steward", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0851', "cs-live", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0852', "xds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0853', "avantageb2b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0854', "solera-epmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0855', "zymed-zpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0856', "avenue", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0857', "gris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0858', "appworxsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0859', "connect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085a', "unbind-cluster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085b', "ias-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085c', "ias-reg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085d', "ias-admind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085e', "tdmoip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u085f', "lv-jc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0860', "lv-ffx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0861', "lv-pici", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0862', "lv-not", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0863', "lv-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0864', "veritas-ucl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0865', "acptsys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0866', "dynamic3d", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0867', "docent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0868', "gtp-user", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0869', "ctlptc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086a', "stdptc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086b', "brdptc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086c', "trp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086d', "xnds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086e', "touchnetplus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u086f', "gdbremote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0870', "apc-2160", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0871', "apc-2161", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0872', "navisphere", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0873', "navisphere-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0874', "ddns-v3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0875', "x-bone-api", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0876', "iwserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0877', "raw-serial", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0878', "easy-soft-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0879', "brain", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087a', "eyetv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087b', "msfw-storage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087c', "msfw-s-storage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087d', "msfw-replica", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087e', "msfw-array", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u087f', "airsync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0880', "rapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0881', "qwave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0882', "bitspeer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0883', "vmrdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0884', "mc-gt-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0885', "eforward", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0886', "cgn-stat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0887', "cgn-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0888', "nvd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0889', "onbase-dds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u088a', "gtaua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u088b', "ssmc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u088b', "ssmd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u088c', "radware-rpm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u088d', "radware-rpm-s", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u088e', "tivoconnect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u088f', "tvbus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0890', "asdis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0891', "drwcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0895', "mnp-exchange", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0896', "onehome-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0897', "onehome-help", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0898', "ici", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0899', "ats", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089a', "imtc-map", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089b', "b2-runtime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089c', "b2-license", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089d', "jps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089e', "hpocbus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u089f', "hpssd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a0', "hpiod", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a1', "rimf-ps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a2', "noaaport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a3', "emwin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a4', "leecoposserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a5', "kali", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a6', "rpi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a7', "ipcore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a8', "vtu-comms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08a9', "gotodevice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08aa', "bounzza", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ab', "netiq-ncap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ac', "netiq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ad', "rockwell-csp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ae', "EtherNet-IP-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08af', "rockwell-csp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b0', "efi-mg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b1', "rcip-itu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u08b2', "di-drm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b3', "di-msg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b4', "ehome-ms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b5', "datalens", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b6', "queueadm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b7', "wimaxasncp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b8', "ivs-video", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08b9', "infocrypt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ba', "directplay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08bb', "sercomm-wlink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08bc', "nani", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08bd', "optech-port1-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08be', "aviva-sna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08bf', "imagequery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c0', "recipe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c1', "ivsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c2', "foliocorp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c3', "magicom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c4', "nmsserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c5', "hao", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c6', "pc-mta-addrmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c7', "antidotemgrsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c8', "ums", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08c9', "rfmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ca', "remote-collab", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08cb', "dif-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08cc', "njenet-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08cd', "dtv-chan-req", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ce', "seispoc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08cf', "vrtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d0', "pcc-mfp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d1', "simple-tx-rx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d2', "rcts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d4', "apc-2260", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d5', "comotionmaster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d6', "comotionback", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d7', "ecwcfg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d8', "apx500api-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08d9', "apx500api-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08da', "mfserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08db', "ontobroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08dc', "amt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08dd', "mikey", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08de', "starschool", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08df', "mmcals", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e0', "mmcal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e1', "mysql-im", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e2', "pcttunnell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e3', "ibridge-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e4', "ibridge-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e5', "bluectrlproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e6', "s3db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e7', "xmquery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e8', "lnvpoller", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08e9', "lnvconsole", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ea', "lnvalarm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08eb', "lnvstatus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ec', "lnvmaps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ed', "lnvmailmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ee', "nas-metering", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ef', "dna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f0', "netml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f1', "dict-lookup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f2', "sonus-logging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f3', "eapsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f4', "mib-streaming", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f5', "npdbgmngr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f6', "konshus-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f7', "advant-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f8', "theta-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08f9', "d2k-datamover1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08fa', "d2k-datamover2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08fb', "pc-telecommute", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08fc', "cvmmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08fd', "cpq-wbem", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08fe', "binderysupport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u08ff', "proxy-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0900', "attachmate-uts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0901', "mt-scaleserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0902', "tappi-boxnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0903', "pehelp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0904', "sdhelp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0905', "sdserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0906', "sdclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0907', "messageservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0908', "wanscaler", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0909', "iapp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090a', "cr-websystems", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090b', "precise-sft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090c', "sent-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090d', "attachmate-g32", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090e', "cadencecontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u090f', "infolibria", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0910', "siebel-ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0911', "rdlap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0912', "ofsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0913', "3d-nfsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0914', "cosmocall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0915', "ansysli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0916', "idcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0917', "xingcsm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0918', "netrix-sftm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0919', "nvd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091a', "tscchat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091b', "agentview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091c', "rcc-host", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091d', "snapp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091e', "ace-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u091f', "ace-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0920', "appleugcontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0921', "ideesrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0922', "norton-lambert", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0923', "3com-webview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0924', "wrs-registry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0925', "xiostatus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0926', "manage-exec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0927', "nati-logos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0928', "fcmsys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0929', "dbm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092a', "redstorm-join", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092b', "redstorm-find", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092c', "redstorm-info", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092d', "redstorm-diag", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092e', "psbserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u092f', "psrserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0930', "pslserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0931', "pspserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0932', "psprserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0933', "psdbserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0934', "gxtelmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0935', "unihub-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0936', "futrix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0937', "flukeserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0938', "nexstorindltd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0939', "tl1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093a', "digiman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093b', "mediacntrlnfsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093c', "oi-2000", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093d', "dbref", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093e', "qip-login", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u093f', "service-ctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0940', "opentable", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0942', "l3-hbmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0943', "worldwire", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0944', "lanmessenger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0945', "remographlm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0946', "hydra", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u094d', "compaq-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u094e', "ms-olap3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u094f', "ms-olap4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0950', "sd-request", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0950', "sd-capacity", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0951', "sd-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0952', "virtualtape", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0953', "vsamredirector", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0954', "mynahautostart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0955', "ovsessionmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0956', "rsmtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0957', "3com-net-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0958', "tacticalauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0959', "ms-olap1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095a', "ms-olap2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095b', "lan900-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095c', "wusage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095d', "ncl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095e', "orbiter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u095f', "fmpro-fdal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0960', "opequus-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0961', "cvspserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0962', "taskmaster2000", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0963', "taskmaster2000", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0964', "iec-104", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0965', "trc-netpoll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0966', "jediserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0967', "orion", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0968', "optimanet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0969', "sns-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096a', "vrts-registry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096b', "netwave-ap-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096c', "cdn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096d', "orion-rmi-reg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096e', "beeyond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u096f', "codima-rtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0970', "rmtserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0971', "composit-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0972', "cas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0973', "attachmate-s2s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0974', "dslremote-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0975', "g-talk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0976', "crmsbits", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0977', "rnrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0978', "kofax-svr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0979', "fjitsuappmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u097b', "mgcp-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u097c', "ott", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u097d', "ft-role", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u097e', "venus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u097f', "venus-se", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0980', "codasrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0981', "codasrv-se", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0982', "pxc-epmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0983', "optilogic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0984', "topx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0985', "unicontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0986', "msp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0987', "sybasedbsynch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0988', "spearway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0989', "pvsw-inet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098a', "netangel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098b', "powerclientcsf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098c', "btpp2sectrans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098d', "dtn1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098e', "bues-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u098f', "ovwdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0990', "hpppssvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0991', "ratl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0992', "netadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0993', "netchat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0994', "snifferclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0995', "madge-ltd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0996', "indx-dds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0997', "wago-io-system", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0998', "altav-remmgt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0999', "rapido-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099a', "griffin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099b', "community", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099c', "ms-theater", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099d', "qadmifoper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099e', "qadmifevent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u099f', "lsi-raid-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a0', "direcpc-si", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a1', "lbm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a2', "lbf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a3', "high-criteria", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a4', "qip-msgd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a5', "mti-tcs-comm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a6', "taskman-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a7', "seaodbc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a8', "c3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09a9', "aker-cdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09aa', "vitalanalysis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ab', "ace-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ac', "ace-svr-prop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ad', "ssm-cvs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ae', "ssm-cssps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09af', "ssm-els", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b0', "powerexchange", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b1', "giop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b2', "giop-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b3', "ttc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b4', "ttc-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b5', "netobjects1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b6', "netobjects2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b7', "pns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b8', "moy-corp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09b9', "tsilb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ba', "qip-qdhcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09bb', "conclave-cpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09bc', "groove", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09bd', "talarian-mqs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09be', "bmc-ar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09bf', "fast-rem-serv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c0', "dirgis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c1', "quaddb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c2', "odn-castraq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c3', "unicontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c4', "rtsserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c5', "rtsclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c6', "kentrox-prot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c7', "nms-dpnss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c8', "wlbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09c9', "ppcontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ca', "jbroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09cb', "spock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09cc', "jdatastore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09cd', "fjmpss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ce', "fjappmgrbulk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09cf', "metastorm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d0', "citrixima", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d1', "citrixadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d2', "facsys-ntp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d3', "facsys-router", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d4', "maincontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d5', "call-sig-trans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d6', "willy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d7', "globmsgsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d8', "pvsw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09d9', "adaptecmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09da', "windb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09db', "qke-llc-v3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09dc', "optiwave-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09dd', "ms-v-worlds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09de', "ema-sent-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09df', "iqserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e0', "ncr-ccl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e1', "utsftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e2', "vrcommerce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e3', "ito-e-gui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e4', "ovtopmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e5', "snifferserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e6', "combox-web-acc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e7', "madcap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e8', "btpp2audctr1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09e9', "upgrade", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ea', "vnwk-prapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09eb', "vsiadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ec', "lonworks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ed', "lonworks2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ee', "udrawgraph", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ef', "reftek", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f0', "novell-zen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f1', "sis-emt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f2', "vytalvaultbrtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f3', "vytalvaultvsmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f4', "vytalvaultpipe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f5', "ipass", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f6', "ads", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f7', "isg-uda-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f8', "call-logging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09f9', "efidiningport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09fa', "vcnet-link-v10", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09fb', "compaq-wcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09fc', "nicetec-nmsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09fd', "nicetec-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09fe', "pclemultimedia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u09ff', "lstp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a00', "labrat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a01', "mosaixcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a02', "delibo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a03', "cti-redwood", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a04', "hp-3000-telnet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0a05', "coord-svr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a06', "pcs-pcw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a07', "clp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a08', "spamtrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a09', "sonuscallsig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0a', "hs-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0b', "cecsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0c', "ibp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0d', "trustestablish", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0e', "blockade-bpsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a0f', "hl7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a10', "tclprodebugger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a11', "scipticslsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a12', "rvs-isdn-dcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a13', "mpfoncl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a14', "tributary", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a15', "argis-te", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a16', "argis-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a17', "mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a18', "cyaserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a19', "netx-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1a', "netx-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1b', "masc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1c', "privilege", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1d', "quartus-tcl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1e', "idotdist", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a1f', "maytagshuffle", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a20', "netrek", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a21', "mns-mail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a22', "dts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a23', "worldfusion1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a24', "worldfusion2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a25', "homesteadglory", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a26', "citriximaclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a27', "snapd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a28', "hpstgmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a29', "discp-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2a', "discp-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2b', "servicemeter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2c', "nsc-ccs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2d', "nsc-posa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2e', "netmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a2f', "connection", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a30', "wag-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a31', "system-monitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a32', "versa-tek", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a33', "lionhead", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a34', "qpasa-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a35', "smntubootstrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a36', "neveroffline", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a37', "firepower", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a38', "appswitch-emp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a39', "cmadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3a', "priority-e-com", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3b', "bruce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3c', "lpsrecommender", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3d', "miles-apart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3e', "metricadbc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a3f', "lmdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a40', "aria", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a41', "blwnkl-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a42', "gbjd816", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a43', "moshebeeri", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a44', "dict", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a45', "sitaraserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a46', "sitaramgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a47', "sitaradir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a48', "irdg-post", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a49', "interintelli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4a', "pk-electronics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4b', "backburner", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4c', "solve", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4d', "imdocsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4e', "sybaseanywhere", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a4f', "aminet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a50', "sai-sentlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a51', "hdl-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a52', "tragic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a53', "gte-samp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a54', "travsoft-ipx-t", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a55', "novell-ipx-cmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a56', "and-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a57', "syncserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a58', "upsnotifyprot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a59', "vpsipport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5a', "eristwoguns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5b', "ebinsite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5c', "interpathpanel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5d', "sonus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5e', "corel-vncadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a5f', "unglue", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a60', "kana", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a61', "sns-dispatcher", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a62', "sns-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a63', "sns-query", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a64', "gcmonitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a65', "olhost", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a66', "bintec-capi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a67', "bintec-tapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a68', "patrol-mq-gm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a69', "patrol-mq-nm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6a', "extensis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6b', "alarm-clock-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6c', "alarm-clock-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6d', "toad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6e', "tve-announce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a6f', "newlixreg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a70', "nhserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a71', "firstcall42", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a72', "ewnn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a73', "ttc-etap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a74', "simslink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a75', "gadgetgate1way", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a76', "gadgetgate2way", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a77', "syncserverssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a78', "pxc-sapxom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a79', "mpnjsomb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a7b', "ncdloadbalance", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a7c', "mpnjsosv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a7d', "mpnjsocl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a7e', "mpnjsomg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a7f', "pq-lic-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a80', "md-cg-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a81', "fastlynx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a82', "hp-nnm-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a83', "itinternet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a84', "admins-lms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a86', "pwrsevent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a87', "vspread", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a88', "unifyadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a89', "oce-snmp-trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8a', "mck-ivpip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8b', "csoft-plusclnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8c', "tqdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8d', "sms-rcinfo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8e', "sms-xfer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a8f', "sms-chat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a90', "sms-remctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a91', "sds-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a92', "ncdmirroring", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a93', "emcsymapiport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a94', "banyan-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a95', "supermon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a96', "sso-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a97', "sso-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a98', "aocp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a99', "raventbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9a', "raventdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9b', "hpstgmgr2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9c', "inova-ip-disco", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9d', "pn-requester", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9e', "pn-requester2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0a9f', "scan-change", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa0', "wkars", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa1', "smart-diagnose", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa2', "proactivesrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa3', "watchdog-nt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa4', "qotps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa5', "msolap-ptp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa6', "tams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa7', "mgcp-callagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa8', "sqdr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aa9', "tcim-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aaa', "nec-raidplus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aab', "fyre-messanger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aac', "g5m", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aad', "signet-ctf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aae', "ccs-software", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aaf', "netiq-mc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab0', "radwiz-nms-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab1', "srp-feedback", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab2', "ndl-tcp-ois-gw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab3', "tn-timing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab4', "alarm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab5', "tsb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab6', "tsb2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab7', "murx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab8', "honyaku", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ab9', "urbisnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aba', "cpudpencap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0abb', "fjippol-swrly", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0abc', "fjippol-polsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0abd', "fjippol-cnsl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0abe', "fjippol-port1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0abf', "fjippol-port2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac0', "rsisysaccess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac1', "de-spot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac2', "apollo-cc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac3', "expresspay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac4', "simplement-tie", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac5', "cnrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac6', "apollo-status", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac7', "apollo-gms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac8', "sabams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ac9', "dicom-iscl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aca', "dicom-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0acb', "desktop-dna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0acc', "data-insurance", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0acd', "qip-audup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ace', "compaq-scp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0acf', "uadtc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad0', "uacs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad1', "exce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad2', "veronica", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad3', "vergencecm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad4', "auris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad5', "rbakcup1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad6', "rbakcup2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad7', "smpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad8', "ridgeway1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ad9', "ridgeway2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ada', "gwen-sonya", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0adb', "lbc-sync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0adc', "lbc-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0add', "whosells", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ade', "everydayrc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0adf', "aises", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae0', "www-dev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae1', "aic-np", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae2', "aic-oncrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae3', "piccolo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae4', "fryeserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae5', "media-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae6', "plgproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae7', "mtport-regist", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae8', "f5-globalsite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ae9', "initlsmsad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aeb', "livestats", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aec', "ac-tech", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aed', "esp-encap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aee', "tmesis-upshot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aef', "icon-discover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af0', "acc-raid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af1', "igcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af2', "veritas-tcp1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0af2', "veritas-udp1", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af3', "btprjctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af4', "dvr-esm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af5', "wta-wsp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af6', "cspuni", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af7', "cspmulti", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af8', "j-lan-p", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0af9', "corbaloc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0afa', "netsteward", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0afb', "gsiftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0afc', "atmtcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0afd', "llm-pass", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0afe', "llm-csv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0aff', "lbc-measure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b00', "lbc-watchdog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b01', "nmsigport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b02', "rmlnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b03', "fc-faultnotify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b04', "univision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b05', "vrts-at-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b06', "ka0wuc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b07', "cqg-netlan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b08', "cqg-netlan-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0a', "slc-systemlog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0b', "slc-ctrlrloops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0c', "itm-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0d', "silkp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0e', "silkp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b0f', "silkp3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b10', "silkp4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b11', "glishd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b12', "evtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b13', "evtp-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b14', "catalyst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b15', "repliweb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b16', "starbot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b17', "nmsigport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b18', "l3-exprt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b19', "l3-ranger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1a', "l3-hawk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1b', "pdnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1c', "bpcp-poll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1d', "bpcp-trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1e', "aimpp-hello", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b1f', "aimpp-port-req", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b20', "amt-blc-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b21', "fxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b22', "metaconsole", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b23', "webemshttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b24', "bears-01", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b25', "ispipes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b26', "infomover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b27', "msrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b28', "cesdinv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b29', "simctlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2a', "ecnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2b', "activememory", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2c', "dialpad-voice1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2d', "dialpad-voice2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2e', "ttg-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b2f', "sonardata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b30', "astromed-main", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b31', "pit-vpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b32', "iwlistener", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b33', "esps-portal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b34', "npep-messaging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b35', "icslap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b36', "daishi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b37', "msi-selectplay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b38', "radix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3a', "dxmessagebase1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3b', "dxmessagebase2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3c', "sps-tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3d', "bluelance", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3e', "aap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b3f', "ucentric-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b40', "synapse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b41', "ndsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b42', "ndtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b43', "ndnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b44', "flashmsg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b45', "topflow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b46', "responselogic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b47', "aironetddp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b48', "spcsdlobby", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b49', "rsom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4a', "cspclmulti", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4b', "cinegrfx-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4c', "snifferdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4d', "vseconnector", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4e', "abacus-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b4f', "natuslink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b50', "ecovisiong6-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b51', "citrix-rtmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b52', "appliance-cfg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b53', "powergemplus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b54', "quicksuite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b55', "allstorcns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b56', "netaspi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b57', "suitcase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b58', "m2ua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b59', "m3ua", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5a', "caller9", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5b', "webmethods-b2b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5c', "mao", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5d', "funk-dialout", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5e', "tdaccess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b5f', "blockade", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b60', "epicon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b61', "boosterware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b62', "gamelobby", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b63', "tksocket", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b64', "elvin-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b65', "elvin-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b66', "kastenchasepad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b67', "roboer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b68', "roboeda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b69', "cesdcdman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b6a', "cesdcdtrn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b6b', "wta-wsp-wtp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b6c', "precise-vip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b6e', "mobile-file-dl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b6f', "unimobilectrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b70', "redstone-cpss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b71', "amx-webadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b72', "amx-weblinx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b73', "circle-x", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b74', "incp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b75', "4-tieropmgw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b76', "4-tieropmcli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b77', "qtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b78', "otpatch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b79', "pnaconsult-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7a', "sm-pas-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7b', "sm-pas-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7c', "sm-pas-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7d', "sm-pas-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7e', "sm-pas-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b7f', "ttnrepository", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b80', "megaco-h248", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b81', "h248-binary", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b82', "fjsvmpor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b83', "gpsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b84', "wap-push", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b85', "wap-pushsecure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b86', "esip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b87', "ottp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b88', "mpfwsas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b89', "ovalarmsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8a', "ovalarmsrv-cmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8b', "csnotify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8c', "ovrimosdbman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8d', "jmact5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8e', "jmact6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b8f', "rmopagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b90', "dfoxserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b91', "boldsoft-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b92', "iph-policy-cli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b93', "iph-policy-adm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b94', "bullant-srap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b95', "bullant-rap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b96', "idp-infotrieve", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b97', "ssc-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b98', "enpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b99', "essp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9a', "index-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9b', "netclip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9c', "pmsm-webrctl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9d', "svnetworks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9e', "signal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0b9f', "fjmpcm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba0', "cns-srv-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba1', "ttc-etap-ns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba2', "ttc-etap-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba3', "h263-video", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba4', "wimd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba5', "mylxamport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba6', "iwb-whiteboard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba7', "netplan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba8', "hpidsadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ba9', "hpidsagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0baa', "stonefalls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bab', "identify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bac', "hippad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bad', "zarkov", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bae', "boscap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0baf', "wkstn-mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb0', "avenyo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb1', "veritas-vis1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb2', "veritas-vis2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb3', "idrs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb4', "vsixml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb5', "rebol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb6', "realsecure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb7', "remoteware-un", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bb8', "hbci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bba', "exlm-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bbb', "cgms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bbc', "csoftragent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bbd', "geniuslm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bbe', "ii-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bbf', "lotusmtap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc0', "midnight-tech", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc1', "pxc-ntfy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc2', "gw", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc2', "ping-pong", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc3', "trusted-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc4', "twsdss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc5', "gilatskysurfer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc6', "broker-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc7', "nati-dstp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc8', "notify-srvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bc9', "event-listener", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bca', "srvc-registry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bcb', "resource-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bcc', "cifs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bcd', "agriserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bce', "csregagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bcf', "magicnotes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd0', "nds-sso", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd1', "arepa-raft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd2', "agri-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd3', "LiebDevMgmt-C", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd4', "LiebDevMgmt-DM", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd5', "LiebDevMgmt-A", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd6', "arepa-cas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd7', "eppc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd8', "redwood-chat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bd9', "pdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bda', "osmosis-aeea", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bdb', "fjsv-gssagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bdc', "hagel-dump", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bdd', "hp-san-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bde', "santak-ups", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bdf', "cogitate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be0', "tomato-springs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be1', "di-traceware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be2', "journee", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be3', "brp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be4', "epp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be5', "responsenet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be6', "di-ase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be7', "hlserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be8', "pctrader", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0be9', "nsws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bea', "gds-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0beb', "galaxy-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bec', "apc-3052", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bed', "dsom-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bee', "amt-cnf-prot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bef', "policyserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf0', "cdl-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf1', "goahead-fldup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf2', "videobeans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf3', "qsoft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf4', "interserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf5', "cautcpd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf6', "ncacn-ip-tcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf7', "ncadg-ip-udp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf8', "rprt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bf9', "slinterbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bfa', "netattachsdmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bfb', "fjhpjp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bfc', "ls3bcast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bfd', "ls3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bfe', "mgxswitch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0bff', "csd-mgmt-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c00', "csd-monitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c01', "vcrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c02', "xbox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c03', "orbix-locator", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c04', "orbix-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c05', "orbix-loc-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c06', "orbix-cfg-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c07', "lv-frontpanel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c08', "stm-pproc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c09', "tl1-lv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0a', "tl1-raw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0b', "tl1-telnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0c', "itm-mccs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0d', "pcihreq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0e', "jdl-dbkitchen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c0f', "asoki-sma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c10', "xdtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c11', "ptk-alink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c12', "stss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c13', "1ci-smcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c15', "rapidmq-center", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c16', "rapidmq-reg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c17', "panasas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c18', "ndl-aps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1a', "umm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1b', "chmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1c', "opcon-xps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1d', "hp-pxpib", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1e', "slslavemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c1f', "autocuesmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c20', "autocuelog", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0c20', "autocuetime", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c21', "cardbox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c22', "cardbox-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c23', "business", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c24', "geolocate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c25', "personnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c26', "sim-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c27', "wsynch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c28', "ksysguard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c29', "cs-auth-svr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2a', "ccmad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2b', "mctet-master", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2c', "mctet-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2d', "mctet-jserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2e', "pkagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c2f', "d2000kernel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c30', "d2000webserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c32', "vtr-emulator", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c33', "edix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c34', "beacon-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c35', "a13-an", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c37', "ctx-bridge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c38', "ndl-aas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c39', "netport-id", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3a', "icpv2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3b', "netbookmark", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3c', "ms-rule-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3d', "prism-deploy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3e', "ecp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c3f', "peerbook-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c40', "grubd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c41', "rtnt-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c42', "rtnt-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c43', "incognitorv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c44', "ariliamulti", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c45', "vmodem", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c46', "rdc-wh-eos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c47', "seaview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c48', "tarantella", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c49', "csi-lfap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4a', "bears-02", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4b', "rfio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4c', "nm-game-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4d', "nm-game-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4e', "nm-asses-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c4f', "nm-assessor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c50', "feitianrockey", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c51', "s8-client-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c52', "ccmrmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c53', "jpegmpeg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c54', "indura", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c55', "e3consultants", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c56', "stvp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c57', "navegaweb-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c58', "tip-app-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c59', "doc1lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5a', "sflm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5b', "res-sap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5c', "imprs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5d', "newgenpay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5e', "sossecollector", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c5f', "nowcontact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c60', "poweronnud", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c61', "serverview-as", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c62', "serverview-asn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c63', "serverview-gf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c64', "serverview-rm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c65', "serverview-icc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c66', "armi-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c67', "t1-e1-over-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c68', "ars-master", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c69', "phonex-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6a', "radclientport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6b', "h2gf-w-2m", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6c', "mc-brk-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6d', "bmcpatrolagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6e', "bmcpatrolrnvu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c6f', "cops-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c70', "apogeex-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c71', "smpppd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c72', "iiw-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c73', "odi-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c74', "brcm-comm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c75', "pcle-infex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c76', "csvr-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c77', "csvr-sslproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c78', "firemonrcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c79', "spandataport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7a', "magbind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7b', "ncu-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7c', "ncu-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7d', "embrace-dp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7e', "embrace-dp-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c7f', "dmod-workspace", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c80', "tick-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c81', "cpq-tasksmart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c82', "intraintra", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c83', "netwatcher-mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c84', "netwatcher-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c85', "isns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c86', "ironmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c87', "vx-auth-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c88', "pfu-prcallback", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c89', "netwkpathengine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8a', "flamenco-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8b', "avsecuremgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8c', "surveyinst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8d', "neon24x7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8e', "jmq-daemon-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c8f', "jmq-daemon-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c90', "ferrari-foam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c91', "unite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c92', "smartpackets", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c93', "wms-messenger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c94', "xnm-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c95', "xnm-clear-text", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c96', "glbp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c97', "digivote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c98', "aes-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c99', "fcip-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9a', "isi-irp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9b', "dwnmshttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9c', "dwmsgserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9d', "global-cd-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9e', "sftdst-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0c9f', "vidigo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca0', "mdtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca1', "whisker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca2', "alchemy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca3', "mdap-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca4', "apparenet-ts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca5', "apparenet-tps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca6', "apparenet-as", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca7', "apparenet-ui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca8', "triomotion", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ca9', "sysorb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0caa', "sdp-id-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cab', "timelot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cac', "onesaf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cad', "vieo-fe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cae', "dvt-system", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0caf', "dvt-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb0', "procos-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb1', "ssp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb2', "hicp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb3', "sysscanner", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb4', "dhe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb5', "pda-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb6', "pda-sys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb7', "semaphore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb8', "cpqrpm-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cb9', "cpqrpm-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cba', "ivecon-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cbb', "epncdp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cbc', "iscsi-target", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cbd', "winshadow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cbe', "necp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cbf', "ecolor-imager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc0', "ccmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc1', "altav-tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc2', "ns-cfg-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc3', "ibm-dial-out", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc4', "msft-gc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc5', "msft-gc-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc6', "verismart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc7', "csoft-prev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc8', "user-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cc9', "sxmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cca', "ordinox-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ccb', "samd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ccc', "maxim-asics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ccd', "awg-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cce', "lkcmserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ccf', "admind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd0', "vs-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd1', "sysopt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd2', "datusorb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd3', "net-assistant", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd4', "4talk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd5', "plato", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd6', "e-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd7', "directvdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd8', "cops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cd9', "enpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cda', "caps-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cdb', "sah-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cdc', "cart-o-rama", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cdd', "fg-fps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cde', "fg-gip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cdf', "dyniplookup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce0', "rib-slm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce1', "cytel-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce2', "deskview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce3', "pdrncs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce6', "mcs-fastmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce7', "opsession-clnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce8', "opsession-srvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ce9', "odette-ftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cea', "mysql", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ceb', "opsession-prxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cec', "tns-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ced', "tns-adv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cee', "dyna-access", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cef', "mcns-tel-ret", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf0', "appman-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf1', "uorb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf2', "uohost", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf3', "cdid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf4', "aicc-cmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf5', "vsaiport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf6', "ssrip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf7', "sdt-lmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf8', "officelink2000", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cf9', "vnsstr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cfa', "active-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cfb', "active-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cfc', "active-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cfd', "active-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cfe', "sftu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0cff', "bbars", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d00', "egptlm", true, true);
    }

    /*
     * Opcode count of 14817 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    private static void fillRegistry2() {
        NetworkServiceNameManagerImpl.add2Registry('\u0d01', "hp-device-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d02', "mcs-calypsoicf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d03', "mcs-messaging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d04', "mcs-mailsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d05', "dec-notes", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d06', "directv-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d07', "directv-soft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d08', "directv-tick", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d09', "directv-catlg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0a', "anet-b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0b', "anet-l", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0c', "anet-m", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0d', "anet-h", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0e', "webtie", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d0f', "ms-cluster-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d10', "bnt-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d11', "influence", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d12', "trnsprntproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d13', "phoenix-rpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d14', "pangolin-laser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d15', "chevinservices", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d16', "findviatv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d17', "btrieve", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d18', "ssql", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d19', "fatpipe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1a', "suitjd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1b', "ordinox-dbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1c', "upnotifyps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1d', "adtech-test", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1e', "mpsysrmsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d1f', "wg-netforce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d20', "kv-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d21', "kv-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d22', "dj-ilm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d23', "nati-vi-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d24', "creativeserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d25', "contentserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d26', "creativepartnr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d27', "satvid-datalnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d28', "satvid-datalnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d29', "satvid-datalnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2a', "satvid-datalnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2b', "satvid-datalnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2c', "tip2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2d', "lavenir-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2e', "cluster-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d2f', "vsnm-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d30', "cdbroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d31', "cogsys-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d32', "wsicopy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d33', "socorfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d34', "sns-channels", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d35', "geneous", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d36', "fujitsu-neat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d37', "esp-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d38', "hp-clic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d39', "qnxnetman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3a', "gprs-data", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3a', "gprs-sig", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3b', "backroomnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3c', "cbserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3d', "ms-wbt-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3e', "dsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d3f', "savant", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d40', "efi-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d41', "d2k-tapestry1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d42', "d2k-tapestry2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d43', "dyna-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d44', "printer-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d45', "cloanto-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d46', "mercantile", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d47', "csms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d48', "csms2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d49', "filecast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d4a', "fxaengine-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d4d', "nokia-ann-ch1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d4e', "nokia-ann-ch2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d4f', "ldap-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d50', "BESApi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d51', "networklens", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d52', "networklenss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d53', "biolink-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d54', "xmlblaster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d55', "svnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d56', "wip-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d57', "bcinameservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d58', "commandport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d59', "csvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5a', "rnmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5b', "softaudit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5c', "ifcp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5d', "bmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5e', "rusb-sys-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d5f', "xtrm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d60', "xtrms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d61', "agps-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d62', "arkivio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d63', "websphere-snmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d64', "twcss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d65', "gcsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d66', "ssdispatch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d67', "ndl-als", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d68', "osdcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d69', "opnet-smp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6a', "opencm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6b', "pacom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6c', "gc-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6d', "autocueds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6e', "spiral-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d6f', "hri-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d70', "ans-console", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d71', "connect-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d72', "connect-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d73', "ov-nnm-websrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d74', "denali-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d75', "monp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d76', "3comfaxrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d77', "directnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d78', "dnc-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d79', "hotu-chat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7a', "castorproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7b', "asam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7c', "sabp-signal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7d', "pscupd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7e', "mira", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0d7f', "prsvp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d80', "vat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d81', "vat-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d82', "d3winosfi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d83', "integral", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d84', "edm-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d85', "edm-stager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d86', "edm-std-notify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d87', "edm-adm-notify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d88', "edm-mgr-sync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d89', "edm-mgr-cntrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8a', "workflow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8b', "rcst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8c', "ttcmremotectrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8d', "pluribus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8e', "jt400", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d8f', "jt400-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d90', "jaugsremotec-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d91', "jaugsremotec-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d92', "ttntspauto", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d93', "genisar-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d94', "nppmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d95', "ecomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d96', "stun", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d97', "twrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d98', "plethora", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d99', "cleanerliverc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9a', "vulture", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9b', "slim-devices", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9c', "gbs-stp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9d', "celatalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9e', "ifsf-hb-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9f', "ltctcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0d9f', "ltcudp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da0', "fs-rh-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da1', "dtp-dia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da2', "colubris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da3', "swr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da4', "tvdumtray-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da5', "nut", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da6', "ibm3494", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da7', "seclayer-tcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da8', "seclayer-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0da9', "ipether232port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0daa', "dashpas-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dab', "sccip-media", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dac', "rtmp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dad', "isoft-p2p", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dae', "avinstalldisc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0daf', "lsp-ping", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db0', "ironstorm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db1', "ccmcomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db2', "apc-3506", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db3', "nesh-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db4', "interactionweb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db5', "vt-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db6', "xss-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db7', "webmail-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db8', "aztec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0db9', "arcpd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dba', "must-p2p", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbb', "must-backplane", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbc', "smartcard-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbd', "802-11-iapp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbe', "artifact-msg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbf', "nvmsgd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0dbf', "galileo", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc0', "galileolog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc1', "mc3ss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc2', "nssocketport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc3', "odeumservlink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc4', "ecmport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc5', "eisport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc6', "starquiz-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc7', "beserver-msg-q", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc8', "jboss-iiop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dc9', "jboss-iiop-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dca', "gf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dcb', "joltid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dcc', "raven-rmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dcd', "raven-rdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dce', "urld-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dcf', "ms-la", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd0', "snac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd1', "ni-visa-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd2', "ibm-diradm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd3', "ibm-diradm-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd4', "pnrp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd5', "voispeed-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd6', "hacl-monitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd7', "qftest-lookup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd8', "teredo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dd9', "camac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ddb', "symantec-sim", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ddc', "interworld", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ddd', "tellumat-nms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dde', "ssmpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ddf', "apcupsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de0', "taserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de1', "rbr-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de2', "questnotify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de3', "razor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de4', "sky-transport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de5', "personalos-001", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de6', "mcp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de7', "cctv-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de8', "iniserve-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0de9', "bmc-onekey", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dea', "sdbproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0deb', "watcomdebug", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dec', "esimport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ded', "m2pa", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0dee', "quest-data-hub", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0def', "oap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df0', "oap-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df1', "mbg-ctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df2', "mccwebsvr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df3', "megardsvr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df4', "megaregsvrport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df5', "tag-ups-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df6', "dmaf-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0df6', "dmaf-caster", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df7', "ccm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df8', "cmc-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0df9', "config-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dfa', "data-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dfb', "ttat3lb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dfc', "nati-svrloc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dfd', "kfxaclicensing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dfe', "press", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0dff', "canex-watch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e00', "u-dbap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e01', "emprise-lls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e02', "emprise-lsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e03', "p2pgroup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e04', "sentinel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e05', "isomair", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e06', "wv-csp-sms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e07', "gtrack-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e08', "gtrack-ne", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e09', "bpmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0a', "mediaspace", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0b', "shareapp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0c', "iw-mmogame", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0d', "a14", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0e', "a15", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e0f', "quasar-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e10', "trap-daemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e11', "visinet-gui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e12', "infiniswitchcl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e13', "int-rcv-cntrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e14', "bmc-jmx-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e15', "comcam-io", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e16', "splitlock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e17', "precise-i3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e18', "trendchip-dcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e19', "cpdi-pidas-cm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1a', "echonet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1b', "six-degrees", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1c', "hp-dataprotect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1d', "alaris-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1e', "sigma-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e1f', "start-network", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e20', "cd3o-protocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e21', "sharp-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e22', "aairnet-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e23', "aairnet-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e24', "ep-pcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e25', "ep-nsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e26', "ff-lr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e27', "haipe-discover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e28', "dist-upgrade", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e29', "volley", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2a', "bvcdaemon-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2b', "jamserverport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2c', "ept-machine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2d', "escvpnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2e', "cs-remote-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e2f', "cs-services", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e30', "distcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e31', "wacp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e32', "hlibmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e33', "sdo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e34', "servistaitsm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e35', "scservp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e36', "ehp-backup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e37', "xap-ha", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e38', "netplay-port1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e39', "netplay-port2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3a', "juxml-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3b', "audiojuggler", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3c', "ssowatch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3d', "cyc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3e', "xss-srv-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e3f', "splitlock-gw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e40', "fjcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e41', "nmmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e42', "prismiq-plugin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e43', "xrpc-registry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e44', "vxcrnbuport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e45', "tsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e46', "vaprtm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e47', "abatemgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e48', "abatjss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e49', "immedianet-bcn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4a', "ps-ams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4b', "apple-sasl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4c', "can-nds-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4d', "can-ferret-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4e', "pserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e4f', "dtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e50', "ups-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e51', "ent-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e52', "eserver-pap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e53', "infoexch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e54', "dell-rm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e55', "casanswmgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e56', "smile", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e57', "efcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e58', "lispworks-orb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e59', "mediavault-gui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5a', "wininstall-ipc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5b', "calltrax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5c', "va-pacbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5d', "roverlog", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5e', "ipr-dglt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e5f', "newton-dock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e60', "npds-tracker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e61', "bts-x73", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e62', "cas-mapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e63', "bmc-ea", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e64', "faxstfx-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e65', "dsx-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e66', "tnmpv2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e67', "simple-push", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e68', "simple-push-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e69', "daap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e6a', "svn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e6b', "magaya-network", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e6c', "intelsync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e6f', "bmc-data-coll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e70', "telnetcpcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e71', "nw-license", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e72', "sagectlpanel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e73', "kpn-icw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e74', "lrs-paging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e75', "netcelera", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e76', "ws-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e77', "adobeserver-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e78', "adobeserver-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e79', "adobeserver-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7a', "rt-event", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7b', "rt-event-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7c', "sun-as-iiops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7d', "ca-idms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7e', "portgate-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e7f', "edb-server2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e80', "sentinel-ent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e81', "tftps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e82', "delos-dms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e83', "anoto-rendezv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e84', "wv-csp-sms-cir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e85', "wv-csp-udp-cir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e86', "opus-services", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e87', "itelserverport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e88', "ufastro-instr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e89', "xsync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8a', "xserveraid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8b', "sychrond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8c', "blizwow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8d', "na-er-tip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8e', "array-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e8f', "e-mdu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e90', "e-woa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e91', "fksp-audit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e92', "client-ctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e93', "smap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e94', "m-wnn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e95', "multip-msg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e96', "synel-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e97', "pwdis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e98', "rs-rmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e99', "xpanel", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9a', "versatalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9b', "launchbird-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9c', "heartbeat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9d', "wysdma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9e', "cst-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0e9f', "ipcs-command", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea0', "sasg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea1', "gw-call-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea2', "linktest", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea3', "linktest-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea4', "webdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea5', "cimtrak", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea6', "cbos-ip-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea7', "gprs-cube", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea8', "vipremoteagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ea9', "nattyserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eaa', "timestenbroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eab', "sas-remote-hlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eac', "canon-capt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ead', "grf-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eae', "apw-registry", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eaf', "exapt-lmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb0', "adtempusclient", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb1', "gsakmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb2', "gbs-smp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb3', "xo-wave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb4', "mni-prot-rout", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb5', "rtraceroute", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb7', "listmgr-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb8', "rblcheckd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eb9', "haipe-otnk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eba', "cindycollab", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ebb', "paging-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ebc', "ctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ebd', "ctdhercules", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ebe', "zicom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ebf', "ispmmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec0', "dvcprov-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec1', "jibe-eb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec2', "c-h-it-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec3', "cognima", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec4', "nnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec5', "abcvoice-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec6', "iso-tp0s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec7', "bim-pem", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec8', "bfd-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ec9', "bfd-echo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eca', "upstriggervsw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ecb', "fintrx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ecc', "isrp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ecd', "remotedeploy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ece', "quickbooksrds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ecf', "tvnetworkvideo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed0', "sitewatch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed1', "dcsoftware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed2', "jaus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed3', "myblast", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed4', "spw-dialer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed5', "idps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed6', "minilock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed7', "radius-dynauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed8', "pwgpsi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ed9', "ibm-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eda', "vhd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0edb', "soniqsync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0edc', "iqnet-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0edd', "tcpdataserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ede', "wsmlb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0edf', "spugna", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee0', "sun-as-iiops-ca", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee1', "apocd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee2', "wlanauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee3', "amp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee4', "neto-wol-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee5', "rap-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee6', "neto-dcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee7', "lansurveyorxml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee8', "sunlps-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ee9', "tapeware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eea', "crinis-hb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eeb', "epl-slp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eec', "scp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eed', "pmcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eee', "acp-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eef', "acp-conduit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef0', "acp-policy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef1', "ffserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef2', "warmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef3', "netmpi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef4', "neteh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef5', "neteh-ext", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef6', "cernsysmgmtagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef7', "dvapps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef8', "xxnetserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ef9', "aipn-auth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0efa', "spectardata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0efb', "spectardb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0efc', "markem-dcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0efd', "mkm-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0efe', "sos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0eff', "amx-rms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f00', "flirtmitmir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f01', "zfirm-shiprush3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f02', "nhci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f03', "quest-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f04', "rnm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f05', "v-one-spp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f06', "an-pcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f07', "msfw-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f08', "item", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f09', "spw-dnspreload", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0a', "qtms-bootstrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0b', "spectraport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0c', "sse-app-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0d', "sscan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0e', "stryker-com", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f0f', "opentrac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f10', "informer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f11', "trap-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f12', "trap-port-mom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f13', "nav-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f14', "sasp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f15', "winshadow-hd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f16', "giga-pocket", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f17', "asap-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0f17', "asap-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f18', "asap-tcp-tls", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0f19', "xpl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1a', "dzdaemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1b', "dzoglserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1c', "diameter", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1d', "ovsam-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1e', "ovsam-d-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f1f', "avocent-adsap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f20', "oem-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f21', "fagordnc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f22', "sixxsconfig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f23', "pnbscada", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f24', "dl-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f25', "xmpcr-interface", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f26', "fotogcad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f27', "appss-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f28', "igrs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f29', "idac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2a', "msdts1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2b', "vrpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2c', "softrack-meter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2d', "topflow-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2e', "nei-management", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f2f', "ciphire-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f30', "ciphire-serv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f31', "dandv-tester", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f32', "ndsconnect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f33', "rtc-pm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f34', "pcc-image-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f35', "cgi-starapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f36', "syam-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f37', "syam-smc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f38', "sdo-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f39', "sdo-ssh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3a', "senip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3b', "itv-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3c', "udt-os", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3d', "nimsh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3e', "nimaux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f3f', "charsetmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f40', "omnilink-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f41', "mupdate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f42', "topovista-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f43', "imoguia-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f44', "hppronetman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f45', "surfcontrolcpa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f46', "prnrequest", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f47', "prnstatus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f48', "gbmt-stars", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f49', "listcrt-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4a', "listcrt-port-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4b', "agcat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4c', "wysdmc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4d', "aftmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4e', "pktcablemmcops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f4f', "hyperip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f50', "exasoftport1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f51', "herodotus-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f52', "sor-update", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f53', "symb-sb-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f54', "mpl-gprs-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f55', "zmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f56', "winport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f57', "natdataservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f58', "netboot-pxe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f59', "smauth-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5a', "syam-webserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5b', "msr-plugin-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5c', "dyn-site", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5d', "plbserve-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5e', "sunfm-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f5f', "sdp-portmapper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f60', "mailprox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f61', "dvbservdsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f62', "dbcontrol-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f63', "aamp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f64', "xecp-node", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f65', "homeportal-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f66', "srdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f67', "tig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f68', "sops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f69', "emcads", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6a', "backupedge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6b', "ccp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6c', "apdap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6d', "drip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6e', "namemunge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f6f', "pwgippfax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f70', "i3-sessionmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f71', "xmlink-connect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f72', "adrep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f73', "p2pcommunity", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f74', "gvcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f75', "mqe-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f76', "mqe-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f77', "treehopper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f78', "bess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f79', "proaxess", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7a', "sbi-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7b', "thrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7c', "sasggprs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7d', "ati-ip-to-ncpe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7e', "bflckmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f7f', "ppsms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f80', "ianywhere-dbns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f81', "landmarks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f82', "lanrevagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f83', "lanrevserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f84', "iconp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f85', "progistics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f86', "citysearch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f87', "airshot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f88', "opswagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f89', "opswmanager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8a', "secure-cfg-svr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8b', "smwan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8c', "acms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8d', "starfish", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8e', "eis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f8f', "eisp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f90', "mapper-nodemgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f91', "mapper-mapethd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f92', "mapper-ws-ethd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f93', "centerline", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f94', "dcs-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f95', "bv-queryengine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f96', "bv-is", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f97', "bv-smcsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f98', "bv-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f99', "bv-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f9b', "iss-mgmt-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f9c', "abcsoftware", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f9d', "agentsease-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f9e', "dnx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0f9f', "nvcnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa0', "terabase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa1', "newoak", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa2', "pxc-spvr-ft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa3', "pxc-splr-ft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa4', "pxc-roid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa5', "pxc-pin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa6', "pxc-spvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa7', "pxc-splr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa8', "netcheque", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fa9', "chimera-hwm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0faa', "samsung-unidex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fab', "altserviceboot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fac', "pda-gate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fad', "acl-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fae', "taiclock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0faf', "talarian-mcast1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb0', "talarian-mcast2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb1', "talarian-mcast3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb2', "talarian-mcast4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb3', "talarian-mcast5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb4', "trap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb5', "nexus-portal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb6', "dnox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb7', "esnm-zoning", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb8', "tnp1-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fb9', "partimage", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fba', "as-debug", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fbb', "bxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fbc', "dtserver-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fbd', "ip-qsig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fbe', "jdmn-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fbf', "suucp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc0', "vrts-auth-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc1', "sanavigator", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc2', "ubxd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc3', "wap-push-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc4', "wap-push-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc5', "ravehd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc6', "fazzt-ptp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc7', "fazzt-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc8', "yo-main", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fc9', "houston", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fca', "ldxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fcb', "nirp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fcc', "ltp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fcd', "npp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fce', "acp-proto", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fcf', "ctp-state", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd1', "wafs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd2', "cisco-wafs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd3', "cppdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd4', "interact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd5', "ccu-comm-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd6', "ccu-comm-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd7', "ccu-comm-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd8', "lms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fd9', "wfm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fda', "kingfisher", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fdb', "dlms-cosem", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fdc', "dsmeter-iatc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fdd', "ice-location", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fde', "ice-slocation", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fdf', "ice-router", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe0', "ice-srouter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe1', "avanti-cdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe2', "pmas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe3', "idp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe4', "ipfltbcst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe5', "minger", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe6', "tripe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe7', "aibkup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe8', "zieto-sock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fe9', "iRAPP", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fea', "cequint-cityid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0feb', "perimlan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fec', "seraph", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fed', "ascomalarm", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fee', "cssp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0fef', "santools", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff0', "lorica-in", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff1', "lorica-in-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff2', "lorica-out", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff3', "lorica-out-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff4', "fortisphere-vm", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff5', "ezmessagesrv", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff6', "ftsync", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff7', "applusservice", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff8', "npsp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u0ff9', "opencore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ffa', "omasgport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ffb', "ewinstaller", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ffc', "ewdgs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ffd', "pvxpluscs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0ffe', "sysrqd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u0fff', "xtgui", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1000', "bre", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1001', "patrolview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1002', "drmsfsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1003', "dpcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1004', "igo-incognito", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1005', "brlp-0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1006', "brlp-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1007', "brlp-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1008', "brlp-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1009', "shofarplayer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100a', "synchronite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100b', "j-ac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100c', "accel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100d', "izm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100e', "g2tag", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u100f', "xgrid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1010', "apple-vpns-rp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1011', "aipn-reg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1012', "jomamqmonitor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1013', "cds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1014', "smartcard-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1015', "hillrserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1016', "netscript", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1017', "assuria-slm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1019', "e-builder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101a', "fprams", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101b', "z-wave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101c', "tigv2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101d', "opsview-envoy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101e', "ddrepl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u101f', "unikeypro", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1020', "nufw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1021', "nuauth", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1022', "fronet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1023', "stars", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1024', "nuts-dem", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1025', "nuts-bootp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1026', "nifty-hmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1027', "cl-db-attach", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1028', "cl-db-request", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1029', "cl-db-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102a', "nettest", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102b', "thrtx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102c', "cedros-fds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102d', "oirtgsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102e', "oidocsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u102f', "oidsr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1031', "vvr-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1032', "tgcconnect", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1033', "vrxpservman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1034', "hhb-handheld", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1035', "agslb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1036', "PowerAlert-nsa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1037', "menandmice-noh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1038', "idig-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1039', "mbl-battd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103a', "atlinks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103b', "bzr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103c', "stat-results", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103d', "stat-scanner", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103e', "stat-cc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u103f', "nss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1040', "jini-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1041', "omscontact", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1042', "omstopology", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1043', "silverpeakpeer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1044', "silverpeakcomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1045', "altcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1046', "joost", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1047', "ddgn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1048', "pslicser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1049', "iadt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1049', "iadt-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u104a', "d-cinema-csp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u104b', "ml-svnet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u104c', "pcoip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u104d', "mma-discovery", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u104e', "smcluster", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u104e', "sm-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u104f', "bccp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1050', "tl-ipcproxy", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1051', "wello", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1052', "storman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1053', "MaxumSP", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1054', "httpx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1055', "macbak", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1056', "pcptcpservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1057', "gmmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1058', "universe-suite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1059', "wcpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u105a', "boxbackupstore", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u105b', "csc-proxy", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u105c', "vatata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u105d', "pcep", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u105e', "sieve", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u105f', "dsmipv6", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1060', "azeti", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1060', "azeti-bd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1061', "pvxplusio", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1067', "eims-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1068', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1069', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106a', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106b', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106c', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106d', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106e', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u106f', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1070', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1071', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1072', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1073', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1074', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1075', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1076', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1077', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1078', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1079', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107a', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107b', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107c', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107d', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107e', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u107f', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1080', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1081', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1082', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1083', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1084', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1085', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1086', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1087', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1088', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1089', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108a', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108b', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108c', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108d', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108e', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u108f', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1090', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1091', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1092', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1093', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1094', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1095', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1096', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1097', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1098', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1099', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109a', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109b', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109c', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109d', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109e', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u109f', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a0', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a1', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a2', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a3', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a4', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a5', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a6', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a7', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a8', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10a9', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10aa', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ab', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ac', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ad', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ae', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10af', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b0', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b1', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b2', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b3', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b4', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b5', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b6', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b7', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b8', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10b9', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ba', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10bb', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10bc', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10bd', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10be', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10bf', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c0', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c1', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c2', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c3', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c4', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c5', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c6', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c7', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c8', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10c9', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ca', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10cb', "vrml-multi-use", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10cc', "corelccam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10cd', "d-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ce', "d-data-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10cf', "srcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d0', "owserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d1', "batman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d2', "pinghgl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d3', "visicron-vs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d4', "compx-lockview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d5', "dserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d6', "mirrtex", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10d7', "p6ssmc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u10d8', "pscl-mgt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u10d9', "perrla", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u10e0', "fdt-rcatp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e1', "rwhois", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e2', "trim-event", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e3', "trim-ice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e4', "balour", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e5', "geognosisman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e6', "geognosis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e7', "jaxer-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e8', "jaxer-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10e9', "publiqare-sync", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u10f4', "gaia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10f5', "lisp-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10f6', "lisp-cons", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u10f6', "lisp-control", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10f7', "unicall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10f8', "vinainstall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10f9', "m4-network-as", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10fa', "elanlm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10fb', "lansurveyor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10fc', "itose", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10fd', "fsportmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10fe', "net-device", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u10ff', "plcy-net-svcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1100', "pjlink", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1101', "f5-iquery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1102', "qsnet-trans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1103', "qsnet-workst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1104', "qsnet-assist", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1105', "qsnet-cond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1106', "qsnet-nucl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1107', "omabcastltkm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1108', "matrix-vnet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1109', "nacnl", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u110a', "afore-vdp-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1110', "wxbrief", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1111', "epmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1112', "elpro-tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1113', "l2c-control", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1113', "l2c-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1114', "l2c-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1115', "remctl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1116', "psi-ptt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1117', "tolteces", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1118', "bip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1119', "cp-spxsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u111a', "cp-spxdpy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u111b', "ctdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1125', "xandros-cms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1126', "wiegand", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1127', "apwi-imserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1128', "apwi-rxserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1129', "apwi-rxspooler", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u112a', "apwi-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u112b', "omnivisionesx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u112c', "fly", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1130', "ds-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1131', "ds-srvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1132', "ds-clnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1133', "ds-user", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1134', "ds-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1135', "ds-mail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1136', "ds-slp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1137', "nacagent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1138', "slscc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1139', "netcabinet-com", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u113a', "itwo-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1149', "netrockey6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u114a', "beacon-port-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u114b', "drizzle", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u114c', "omviserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u114d', "omviagent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u114e', "rsqlserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u114f', "wspipe", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1151', "vop", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1159', "netblox", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115a', "saris", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115b', "pharos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115c', "krb524", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115d', "upnotifyp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115e', "n1-fwp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u115f', "n1-rmgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1160', "asc-slmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1161', "privatewire", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1162', "camp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1163', "ctisystemmsg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1164', "ctiprogramload", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1165', "nssalertmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1166', "nssagentmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1167', "prchat-user", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1168', "prchat-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1169', "prRegister", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u116a', "mcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1184', "hpssmgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1185', "assyst-dr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1186', "icms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1187', "prex-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1188', "awacs-ice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1194', "ipsec-nat-t", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11b7', "ehs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11b8', "ehs-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11b9', "wssauthsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11ba', "swx-gate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c1', "worldscores", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c2', "sf-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c3', "lanner-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c4', "synchromesh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c5', "aegate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c6', "gds-adppiw-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c7', "ieee-mih", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c8', "menandmice-mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11c9', "icshostsvc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u11ca', "msfrs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11cb', "rsip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11cc', "dtn-bundle-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u11cc', "dtn-bundle-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11cd', "mtcevrunqss", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11ce', "mtcevrunqman", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11cf', "hylafax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11d6', "kwtc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11d7', "tram", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11d8', "bmc-reporting", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11d9', "iax", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11ee', "rid", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u11ef', "l3t-at-an", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f0', "hrpd-ith-at-an", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f1', "ipt-anri-anri", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f2', "ias-session", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f3', "ias-paging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f4', "ias-neighbor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f5', "a21-an-1xbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f6', "a16-an-an", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f7', "a17-an-an", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f8', "piranha1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11f9', "piranha2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u11fa', "mtsserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u11fb', "menandmice-upg", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1232', "playsta2-app", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1233', "playsta2-lob", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1234', "smaclmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1235', "kar2ouche", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1236', "oms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1237', "noteit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1238', "ems", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1239', "contclientms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123a', "eportcomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123b', "mmacomm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123c', "mmaeds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123d', "eportcommdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123e', "light", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u123f', "acter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1240', "rfa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1241', "cxws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1242', "appiq-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1243', "dhct-status", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1244', "dhct-alerts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1245', "bcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1246', "traversal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1247', "mgesupervision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1248', "mgemanagement", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1249', "parliant", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124a', "finisar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124b', "spike", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124c', "rfid-rp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124d', "autopac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124e', "msp-os", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u124f', "nst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1250', "mobile-p2p", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1251', "altovacentral", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1252', "prelude", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1253', "mtn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1254', "conspiracy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u125c', "netxms-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u125d', "netxms-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u125e', "netxms-sync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u125f', "npqes-test", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1260', "assuria-ins", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1275', "truckstar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1276', "a26-fap-fgw", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1277', "fcis", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1277', "fcis-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1278', "capmux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1279', "gsmtap", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u127a', "gearman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u127b', "remcap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u127c', "ohmtrigger", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u127d', "resorcs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1281', "ipdr-sp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1282', "solera-lpn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1283', "ipfix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1284', "ipfixs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1285', "lumimgrd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1286', "sicct", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1286', "sicct-sdp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1287', "openhpid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1288', "ifsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1289', "fmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u128d', "profilemac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u128e', "ssad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u128f', "spocp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1290', "snap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12b0', "bfd-multi-ctl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12b1', "cncp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12b2', "smart-install", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u12b3', "sia-ctrl-plane", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u12b4', "xmcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u12c0', "iims", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12c1', "iwec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12c2', "ilss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12c3', "notateit", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u12c3', "notateit-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12c4', "aja-ntv4-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12db', "htcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12e5', "varadero-0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12e6', "varadero-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12e7', "varadero-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12e8', "opcua-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u12e8', "opcua-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12e9', "quosa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12ea', "gw-asv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12eb', "opcua-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12ec', "gw-log", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12ed', "wcr-remlib", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12ee', "contamac-icm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12ef', "wfc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12f0', "appserv-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12f1', "appserv-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12f2', "sun-as-nodeagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u12f3', "derby-repli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1303', "unify-debug", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1304', "phrelay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1305', "phrelaydbg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1306', "cc-tracking", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1307', "wired", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u130c', "tritium-can", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u130d', "lmcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u130e', "inst-discovery", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u130f', "wsdl-event", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1310', "hislip", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1311', "socp-t", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1312', "socp-c", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1313', "wmlserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1314', "hivestor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1315', "abbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u131e', "lyskom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1323', "radmin-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1324', "hfcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1325', "flr-agent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1326', "magiccontrol", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1330', "lutap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1331', "lutcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1332', "bones", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1333', "frcs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1349', "atsc-mh-ssc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u134c', "eq-office-4940", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u134d', "eq-office-4941", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u134e', "eq-office-4942", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1355', "munin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1356', "sybasesrvmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1357', "pwgwims", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1358', "sagxtsds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1359', "dbsyncarbiter", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1369', "ccss-qmm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u136a', "ccss-qsm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1378', "webyast", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1379', "gerhcs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u137a', "mrip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u137b', "smar-se-port1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u137c', "smar-se-port2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u137d', "parallel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u137e', "busycal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u137f', "vrt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1387', "hfcs-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1388', "commplex-main", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1389', "commplex-link", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138a', "rfe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138b', "fmpro-internal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138c', "avt-profile-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138d', "avt-profile-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138e', "wsm-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u138f', "wsm-server-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1390', "synapsis-edge", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1391', "winfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1392', "telelpathstart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1393', "telelpathattack", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1394', "nsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1395', "fmpro-v6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1396', "onpsocket", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1397', "fmwp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u139c', "zenginkyo-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u139d', "zenginkyo-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u139e', "mice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u139f', "htuilsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a0', "scpi-telnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a1', "scpi-raw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a2', "strexec-d", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a3', "strexec-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a4', "qvr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13a5', "infobright", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a6', "surfpass", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a7', "dmp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13a8', "signacert-agent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13b2', "asnaacceler8db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13b3', "swxadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13b4', "lxi-evntsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13b5', "osp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13b6', "vpm-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13b7', "iscape", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13b8', "texai", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13b9', "ivocalize", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ba', "mmcc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13bb', "ita-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13bc', "ita-manager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13bd', "rlm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13be', "rlm-admin", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13bf', "unot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c0', "intecom-ps1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c1', "intecom-ps2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c2', "locus-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c3', "sds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c4', "sip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c5', "sip-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c6', "na-localise", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c7', "csrpc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13c8', "ca-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13c9', "ca-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ca', "stanag-5066", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13cb', "authentx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13cc', "bitforestsrv", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13cd', "i-net-2000-npr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ce', "vtsas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13cf', "powerschool", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d0', "ayiya", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d1', "tag-pm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d2', "alesquery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d7', "cp-spxrpts", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d8', "onscreen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13d9', "sdl-ets", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13da', "qcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13db', "qfp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13dc', "llrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13dd', "encrypted-llrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13de', "aprigo-cs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13e4', "magpie", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13e5', "sentinel-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13e6', "hart-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13eb', "sentlm-srv2srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ec', "socalia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ed', "talarian-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13ed', "talarian-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ee', "oms-nonsecure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13ef', "actifio-c2c", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13f0', "tinymessage", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13f1', "hughes-ap", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13f7', "taep-as-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13f8', "pm-cmdsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13fa', "ev-services", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13fb', "autobuild", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u13fc', "emb-proj-cmd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u13fd', "gradecam", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u140d', "nbt-pc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u140e', "ppactivation", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u140f', "erp-scale", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1410', "minotaur-sa", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1411', "ctsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1419', "rmonitor-secure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u141a', "social-alarm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u141e', "atmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u141f', "esri-sde", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1420', "sde-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1421', "toruxserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1422', "bzflag", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1423', "asctrl-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1424', "rugameonline", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1425', "mediat", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1429', "snmpssh", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u142a', "snmpssh-trap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u142b', "sbackup", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u142c', "vpa", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u142c', "vpa-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u142d', "ife-icorp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u142e', "winpcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u142f', "scte104", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1430', "scte30", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1446', "aol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1447', "aol-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1448', "aol-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1449', "aol-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u144a', "cpscomm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1450', "targus-getdata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1451', "targus-getdata1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1452', "targus-getdata2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1453', "targus-getdata3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1465', "3exmp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1466', "xmpp-client", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1467', "hpvirtgrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1468', "hpvirtctrl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1469', "hp-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u146a', "hp-status", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u146b', "perfd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u146c', "hpvroom", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1470', "csedaemon", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1471', "enfs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1472', "eenet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1473', "galaxy-network", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1474', "padl2sim", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1475', "mnet-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u147d', "downtools", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u147d', "downtools-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u147e', "capwap-control", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u147f', "capwap-data", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1480', "caacws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1481', "caaclang2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1482', "soagateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1483', "caevms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1484', "movaz-ssc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1485', "kpdp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1490', "3com-njack-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1491', "3com-njack-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1495', "xmpp-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1496', "cartographerxmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1497', "cuelink", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1497', "cuelink-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1498', "pk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14a0', "xmpp-bosh", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14a1', "undo-lm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14a2', "transmit-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b2', "presence", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b3', "nlg-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b4', "hacl-hb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b5', "hacl-gs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b6', "hacl-cfg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b7', "hacl-probe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b8', "hacl-local", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14b9', "hacl-test", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ba', "sun-mc-grp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14bb', "sco-aip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14bc', "cfengine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14bd', "jprinter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14be', "outlaws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14c0', "permabit-cs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14c1', "rrdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14c2', "opalis-rbt-ipc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14c3', "hacl-poll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14c4', "hpbladems", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14c5', "hpdevms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14c6', "pkix-cmc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14c8', "bsfserver-zn", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14c9', "bsfsvr-zn-ssl", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u14df', "kfserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e0', "xkotodrcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e5', "stuns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e6', "nat-pmp-status", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e7', "nat-pmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e8', "dns-llq", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14e9', "mdns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ea', "mdnsresponder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14eb', "llmnr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ec', "ms-smlbiz", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ed', "wsdapi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ee', "wsdapi-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14ef', "ms-alerter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14f0', "ms-sideshow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14f1', "ms-s-sideshow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14f2', "serverwsd2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u14f3', "net-projection", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1515', "stresstester", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1516', "elektron-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1517', "securitychase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1518', "excerpt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1519', "excerpts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151a', "mftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151b', "hpoms-ci-lstn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151c', "hpoms-dps-lstn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151d', "netsupport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151e', "systemics-sox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u151f', "foresyte-clear", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1520', "foresyte-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1521', "salient-dtasrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1522', "salient-usrmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1523', "actnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1524', "continuus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1525', "wwiotalk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1526', "statusd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1527', "ns-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1528', "sns-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1529', "sns-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152a', "mcntp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152b', "dj-ice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152c', "cylink-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152d', "netsupport2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152e', "salient-mux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u152f', "virtualuser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1530', "beyond-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1531', "br-channel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1532', "devbasic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1533', "sco-peer-tta", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1534', "telaconsole", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1535', "base", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1536', "radec-corp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1537', "park-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1538', "postgresql", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1539', "pyrrho", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u153a', "sgi-arrayd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u153b', "sceanics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u153c', "pmip6-cntl", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u153d', "pmip6-data", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1543', "spss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u154d', "surebox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u154e', "apc-5454", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u154f', "apc-5455", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1550', "apc-5456", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1555', "silkmeter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1556', "ttl-publisher", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1557', "ttlpriceproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1558', "quailnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1559', "netops-broker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u157c', "fcp-addr-srvr1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u157d', "fcp-addr-srvr2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u157e', "fcp-srvr-inst1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u157f', "fcp-srvr-inst2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1580', "fcp-cics-gw1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1581', "checkoutdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1582', "amc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15b1', "sgi-eventmond", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15b2', "sgi-esphttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15b3', "personal-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15b4', "freeciv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15b5', "farenet", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u15be', "westec-connect", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u15bf', "m-oap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15c0', "sdt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15c5', "sdmmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15c6', "lsi-bobcat", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u15c7', "ora-oap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u15cb', "fdtracks", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u15cc', "tmosms0", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15cd', "tmosms1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15ce', "fac-restore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15cf', "tmo-icon-sync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15d0', "bis-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15d1', "bis-sync", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15dd', "ininmessaging", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15de', "mctfeed", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15df', "esinstall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e0', "esmmanager", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e1', "esmagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e2', "a1-msc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e3', "a1-bs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e4', "a3-sdunode", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15e5', "a4-sdunode", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15fb', "ninaf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15fc', "htrust", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15fd', "symantec-sfdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15fe', "precise-comm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u15ff', "pcanywheredata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1600', "pcanywherestat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1601', "beorl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1602', "xprtld", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1603', "sfmsso", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1604', "sfm-db-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1605', "cssc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1606', "flcrs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u160e', "vfmobile", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1627', "amqps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1628', "amqp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1629', "jms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162a', "hyperscsi-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162b', "v5ua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162c', "raadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162d', "questdb2-lnchr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162e', "rrac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u162f', "dccm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1630', "auriga-router", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1631', "ncxcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1632', "brightcore", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1633', "coap", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1638', "ggz", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1639', "qmvideo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u163d', "rbsystem", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1640', "kmip", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1651', "proshareaudio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1652', "prosharevideo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1653', "prosharedata", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1654', "prosharerequest", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1655', "prosharenotify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1656', "dpm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1657', "dpm-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1658', "ms-licensing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1659', "dtpt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u165a', "msdfsr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u165b', "omhs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u165c', "omsdk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u165d', "ms-ilm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u165e', "ms-ilm-sts", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u165f', "asgenf", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1660', "io-dist-data", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1660', "io-dist-group", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1661', "openmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1662', "unieng", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u166d', "ida-discover1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u166e', "ida-discover2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u166f', "watchdoc-pod", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1670', "watchdoc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1671', "fcopy-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1672', "fcopys-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1673', "tunatic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1674', "tunalyzer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1676', "rscd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u167b', "openmailg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u167d', "x500ms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1686', "openmailns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1687', "s-openmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1688', "openmailpxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1689', "spramsca", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u168a', "spramsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u168b', "netagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1691', "dali-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1694', "vts-rpc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1695', "3par-evts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1696', "3par-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1697', "3par-mgmt-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1698', "ibar", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1699', "3par-rcopy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u169a', "cisco-redu", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u169b', "waascluster", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16a1', "xtreamx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16a2', "spdp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16b5', "icmpd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16b6', "spt-automation", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16d2', "reversion", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u16e3', "wherehoo", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16e7', "ppsuitemsg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u16fb', "jute", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u170c', "rfb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1716', "cm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1717', "cpdlc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1718', "fis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1719', "ads-c", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u174b', "indy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1750', "mppolicy-v5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1751', "mppolicy-mgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1760', "couchdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1761', "wsman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1762', "wsmans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1763', "wbem-rmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1764', "wbem-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1765', "wbem-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1766', "wbem-exp-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1767', "nuxsl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1768', "consul-insight", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u176f', "cvsup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1770', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1771', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1772', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1773', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1774', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1775', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1776', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1777', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1778', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1779', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177a', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177b', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177c', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177d', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177e', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u177f', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1780', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1781', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1782', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1783', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1784', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1785', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1786', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1787', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1788', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1789', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178a', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178b', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178c', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178d', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178e', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u178f', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1790', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1791', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1792', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1793', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1794', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1795', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1796', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1797', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1798', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1799', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179a', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179b', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179c', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179d', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179e', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u179f', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a0', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a1', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a2', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a3', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a4', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a5', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a6', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a7', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a8', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17a9', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17aa', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ab', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ac', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ad', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ae', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17af', "x11", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b0', "ndl-ahp-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b1', "winpharaoh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b2', "ewctsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b4', "gsmp-ancp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17b5', "trip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b6', "messageasap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b7', "ssdtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b8', "diagnose-proc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17b9', "directplay8", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ba', "max", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17bb', "dpm-acm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17bc', "msft-dpm-cert", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17c2', "p25cai", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17c3', "miami-bcast", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17c4', "p2p-sip", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17c5', "konspire2b", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17c6', "pdtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17c7', "ldss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d3', "raxa-mgmt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17d4', "synchronet-db", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d5', "synchronet-rtc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d6', "synchronet-upd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d7', "rets", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d8', "dbdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17d9', "primaserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17da', "mpsserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17db', "etc-control", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17dc', "sercomm-scadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17dd', "globecast-id", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17de', "softcm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17df', "spc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17e0', "dtspcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17e1', "dayliteserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17e2', "wrspice", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17e3', "xic", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17e4', "xtlserv", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17e5', "daylitetouch", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17e9', "spdy", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u17ea', "bex-webadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17eb', "backup-express", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ec', "pnbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17f5', "nbt-wol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17fc', "pulsonixnls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17fd', "meta-corp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17fe', "aspentec-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u17ff', "watershed-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1800', "statsci1-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1801', "statsci2-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1802', "lonewolf-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1803', "montage-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1804', "ricardo-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1805', "tal-pod", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u180f', "efb-aci", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1810', "ecmp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1810', "ecmp-data", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1811', "patrol-ism", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1812', "patrol-coll", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1813', "pscribe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1838', "lm-x", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u184e', "radmind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1861', "jeol-nsdtp-1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1861', "jeol-nsddp-1", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1862', "jeol-nsdtp-2", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1862', "jeol-nsddp-2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1863', "jeol-nsdtp-3", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1863', "jeol-nsddp-3", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1864', "jeol-nsdtp-4", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1864', "jeol-nsddp-4", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u186b', "tl1-raw-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u186c', "tl1-ssh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u186d', "crip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u187b', "gld", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u187c', "grid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u187d', "grid-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u189c', "bmc-grx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u189d', "bmc-ctd-ldap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18a2', "ufmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18ab', "scup", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u18ab', "scup-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18ac', "abb-escp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18b0', "repsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18b1', "emp-server1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18b2', "emp-server2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18b4', "hrd-ncs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u18b4', "hrd-ns-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18c7', "sflow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18ca', "gnutella-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18cb', "gnutella-rtr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18ce', "adap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18d3', "pmcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18d8', "metaedit-mu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18e2', "metaedit-se", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18ee', "metatude-mds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18f5', "clariion-evr01", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u18f6', "metaedit-ws", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1900', "boe-cms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1901', "boe-was", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1902', "boe-eventsrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1903', "boe-cachesvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1904', "boe-filesvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1905', "boe-pagesvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1906', "boe-processsvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1907', "boe-resssvr1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1908', "boe-resssvr2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1909', "boe-resssvr3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u190a', "boe-resssvr4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1911', "faxcomservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1912', "syserverremote", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1913', "svdrp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1914', "nim-vdrshell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1915', "nim-wan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1920', "pgbouncer", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u192b', "sun-sr-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u192c', "sge-qmaster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u192d', "sge-execd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u192e', "mysql-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1937', "skip-cert-recv", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1938', "skip-cert-send", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1947', "lvision-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1950', "sun-sr-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1951', "servicetags", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1952', "ldoms-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1953', "SunVTS-RMI", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1954', "sun-sr-jms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1955', "sun-sr-iiop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1956', "sun-sr-iiops", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1957', "sun-sr-iiop-aut", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1958', "sun-sr-jmx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1959', "sun-sr-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1964', "boks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1965', "boks-servc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1966', "boks-servm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1967', "boks-clntd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1969', "badm-priv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u196a', "badm-pub", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u196b', "bdir-priv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u196c', "bdir-pub", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u196d', "mgcs-mfp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u196e', "mcer-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1971', "netconf-tls", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1972', "syslog-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1973', "elipse-rec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u198f', "lds-distrib", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1990', "lds-dump", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1993', "apc-6547", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1994', "apc-6548", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1995', "apc-6549", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1996', "fg-sysupdate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1997', "sum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u199e', "xdsxdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19a6', "sane-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19a8', "canit-store", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19a8', "rp-reputation", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19b3', "affiliate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19b4', "parsec-master", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19b5', "parsec-peer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19b6', "parsec-game", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19b7', "joaJewelSuite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19c8', "mshvlm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19c9', "mstmg-sstp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19ca', "wsscomfrmwk", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19db', "odette-ftps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19dc', "kftp-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19dd', "kftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19de', "mcftp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19df', "ktelnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19e0', "datascaler-db", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19e1', "datascaler-ctl", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19e2', "wago-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19e3', "nexgen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19e4', "afesc-mc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u19e8', "mxodbc-connect", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u19ff', "pcs-sf-ui-man", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a00', "emgmsg", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a01', "palcom-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a09', "ircu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0a', "ircu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0b', "ircu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0c', "ircu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0d', "ircu", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0e', "vocaltec-gold", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a0f', "p4p-portal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a10', "vision-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a11', "vision-elmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a16', "vfbp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a16', "vfbp-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a17', "osaut", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a1f', "clever-ctrace", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a20', "clever-tcpip", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1a21', "tsa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a28', "babel", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a2d', "kti-icad-srvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a2e', "e-design-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a2f', "e-design-web", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a3a', "ibprotocol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a3b', "fibotrader-com", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a6f', "bmc-perf-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a70', "bmc-perf-mgrd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a71', "adi-gxp-srvprt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a72', "plysrv-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a73', "plysrv-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a81', "dgpf-exchg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a82', "smc-jmx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a83', "smc-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a84', "smc-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a85', "smc-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a86', "hnmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a87', "hnm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1a91', "acnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1aa1', "pentbox-sim", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1aaf', "ambit-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ab9', "netmo-default", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1aba', "netmo-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ac2', "iccrushmore", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ad4', "acctopus-cc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ad4', "acctopus-st", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ae8', "muse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1af5', "jetstream", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1b17', "ethoscan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b18', "xsmsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b22', "bioserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b27', "otlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b31', "jmact3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b32', "jmevt2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b33', "swismgr1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b34', "swismgr2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b35', "swistrap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b36', "swispol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b39', "acmsoda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b55', "MobilitySrv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b56', "iatp-highpri", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b57', "iatp-normalpri", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b58', "afs3-fileserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b59', "afs3-callback", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5a', "afs3-prserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5b', "afs3-vlserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5c', "afs3-kaserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5d', "afs3-volser", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5e', "afs3-errors", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b5f', "afs3-bos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b60', "afs3-update", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b61', "afs3-rmtsys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b62', "ups-onlinet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b63', "talon-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b64', "talon-engine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b65', "microtalon-dis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b66', "microtalon-com", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b67', "talon-webserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6a', "fisa-svc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6b', "doceri-ctl", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6b', "doceri-view", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6c', "dpserve", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6d', "dpserveadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6e', "ctdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b6f', "ct2nmcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b70', "vmsvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b71', "vmsvc-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b76', "op-probe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b9e', "arcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1b9f', "iwg1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ba8', "empowerid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bbb', "lazy-ptop", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bbc', "font-service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bbd', "elcn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bc3', "aes-x170", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bd1', "virprot-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bd8', "scenidm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bd9', "scenccs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bf9', "cabsm-comm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bfa', "caistoragemgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bfb', "cacsambroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bfc', "fsr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bfd', "doc-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bfe', "aruba-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1bff', "casrmagent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c00', "cnckadserver", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c01', "ccag-pib", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c02', "nsrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c03', "drm-production", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c05', "zsecure", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c06', "clutild", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c20', "fodms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c21', "dlip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c3b', "ramp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c3c', "citrixupp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c3d', "citrixuppg", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c45', "pads", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c5e', "cnap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c68', "watchme-7272", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c69', "oma-rlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6a', "oma-rlp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6b', "oma-ulp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6c', "oma-ilp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6d', "oma-ilp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6e', "oma-dcdocbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c6f', "ctxlic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c70', "itactionserver1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c71', "itactionserver2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c72', "mzca-action", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c72', "mzca-alert", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c73', "genstat", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1c84', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c85', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c86', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c87', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c88', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c89', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8a', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8b', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8c', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8d', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8e', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c8f', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c90', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c91', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c92', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c93', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c94', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c95', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c96', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c97', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c98', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c99', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9a', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9b', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9c', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9d', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9e', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1c9f', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca0', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca1', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca2', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca3', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca4', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca5', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca6', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca7', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca8', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ca9', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1caa', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cab', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cac', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cad', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cae', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1caf', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb0', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb1', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb2', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb3', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb4', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb5', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb6', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb7', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb8', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cb9', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cba', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cbb', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cbc', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cbd', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cbe', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cbf', "swx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cc5', "lcm-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cdf', "mindfilesys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce0', "mrssrendezvous", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce1', "nfoldman", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce2', "fse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce3', "winqedit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce5', "hexarc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce8', "rtps-discovery", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ce9', "rtps-dd-ut", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cea', "rtps-dd-mt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cf2', "ionixnetmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1cfd', "mtportmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d02', "pmdmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d03', "oveadmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d04', "ovladmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d05', "opi-sock", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d06', "xmpv7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d07', "pmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d0d', "faximum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d13', "oracleas-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d31', "rise", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d43', "telops-lmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d4c', "silhouette", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d4d', "ovbus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d54', "adcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1d55', "acplt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1d56', "ovhpas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d57', "pafec-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d76', "saratoga", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d77', "atul", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d78', "nta-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d79', "nta-us", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d7a', "cfs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d7b', "cwmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d7c', "tidp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d7d', "nls-tl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d7e', "cloudsignaling", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d88', "sncp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d8b', "cfw", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1d8e', "vsi-omega", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1d91', "dell-eql-asm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1d92', "aries-kfinder", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1da4', "sun-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dc8', "indi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dca', "simco", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1dcb', "soap-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dcc', "zen-pawn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dcd', "xdas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dce', "hawk", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1dcf', "tesla-sys-msg", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1dd1', "pmdfmgt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1de0', "cuseeme", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1df8', "imqstomp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1df9', "imqstomps", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1dfa', "imqtunnels", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dfb', "imqtunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dfc', "imqbrokerd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1dfd', "sun-user-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e00', "pando-pub", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e09', "collaber", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e11', "klio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e14', "em7-secom", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1e1b', "sync-em7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e1c', "scinet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e28', "medimageportal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e2c', "nsdeepfreezectl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e2d', "nitrogen", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e2e', "freezexservice", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e2f', "trident-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e36', "smip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e3a', "aiagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e3d', "scriptview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e3e', "msss", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1e3f', "sstp-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e40', "raqmon-pdu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e43', "prgp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e61', "cbt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e62', "interwise", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e63', "vstat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e65', "accu-lmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e6a', "minivend", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e6b', "popup-reminders", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e6d', "office-tools", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e72', "q3ade", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e75', "pnet-conn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e76', "pnet-enc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e77', "altbsdp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e78', "asr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e79', "ssp-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1e82', "rbt-wanopt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ea5', "apc-7845", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ea6', "apc-7846", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ebd', "mobileanalyzer", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ebe', "rbt-smc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ebf', "mdm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ec8', "pss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ecf', "ubroker", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1edc', "mevent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1edd', "tnos-sp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ede', "tnos-dp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1edf', "tnos-dps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ee9', "qo-secure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1efc', "t2-drm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1efd', "t2-brm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f1f', "supercell", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f2b', "micromuse-ncps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f2c', "quest-vista", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f2d', "sossd-collect", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f2e', "sossd-agent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f2e', "sossd-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f3d', "pushns", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f3e', "usicontentpush", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f3f', "irdmi2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f40', "irdmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f41', "vcom-tunnel", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f42', "teradataordbms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f43', "mcreport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f45', "mxi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f48', "http-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f53', "qbdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f54', "intu-ec-svcdisc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f55', "intu-ec-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f56', "oa-system", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f59', "ca-audit-da", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f5a', "ca-audit-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f60', "pro-ed", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f61', "mindprint", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f62', "vantronix-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f68', "ampify", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f6a', "fs-agent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f6b', "fs-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f6c', "fs-mgmt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f73', "rocrail", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1f74', "senomix01", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f75', "senomix02", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f76', "senomix03", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f77', "senomix04", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f78', "senomix05", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f79', "senomix06", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f7a', "senomix07", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f7b', "senomix08", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f8a', "gadugadu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f90', "http-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f91', "sunproxyadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f92', "us-cli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f93', "us-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f96', "d-s-n", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f97', "simplifymedia", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f98', "radan-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1f9b', "jamlink", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1fa1', "sac", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fa4', "xprint-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fa5', "ldoms-migr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1fb3', "mtl8000-matrix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fb4', "cp-cluster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fb6', "privoxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fb9', "apollo-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fba', "apollo-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fc0', "paycash-online", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fc1', "paycash-wbp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fc2', "indigo-vrmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fc3', "indigo-vbcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fc4', "dbabble", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fd4', "isdd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fd5', "eor-game", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fe0', "patrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1fe1', "patrol-snmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ff5', "intermapper", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ff6', "vmware-fdm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u1ff7', "proremote", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u1ff8', "itach", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2000', "spytechphone", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2002', "blp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2003', "blp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2007', "vvr-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2008', "trivnet1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2009', "trivnet2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u200a', "aesop", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u200c', "lm-perfworks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u200d', "lm-instmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u200e', "lm-dta", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u200f', "lm-sserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2010', "lm-webwatcher", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2026', "rexecj", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2033', "synapse-nhttps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2054', "pando-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2058', "synapse-nhttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2064', "blp3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2065', "hiperscan-id", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2066', "blp4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u206c', "tmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u206d', "amberon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2080', "tnp-discover", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2081', "tnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u209f', "server-find", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20b8', "cruise-enum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20b9', "cruise-swroute", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20ba', "cruise-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20bb', "cruise-diags", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20bc', "cruise-update", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20bf', "m2mservices", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20d0', "cvd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20d1', "sabarsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20d2', "abarsd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20d3', "admind", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20d4', "svcloud", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u20d5', "svbackup", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u20e0', "espeech", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20e1', "espeech-rtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20fa', "cybro-a-bus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20fb', "pcsync-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u20fc', "pcsync-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2102', "npmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2116', "cisco-avp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2117', "pim-port", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2118', "otv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2119', "vp2p", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u211a', "noteshare", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2134', "fmtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2135', "cmtp-mgt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2135', "cmtp-av", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u216a', "rtsp-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u216b', "d-fence", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2177', "oap-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2198', "asterix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a2', "canon-mfnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a3', "canon-bjnp1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a4', "canon-bjnp2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a5', "canon-bjnp3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a6', "canon-bjnp4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21a7', "imink", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u21ee', "sun-as-jmxrmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u21fb', "vnyx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u221c', "dtp-net", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u221d', "ibus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u223b', "mc-appserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u223c', "openqueue", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u223d', "ultraseek-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2242', "dpap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2252', "msgclnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2253', "msgsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2259', "acd-pm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2260', "sunwebadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2264', "truecm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22a9', "dxspider", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22b0', "cddbp-alt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22b3', "secure-mqtt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22b8', "ddi-tcp-1", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22b8', "ddi-udp-1", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22b9', "ddi-tcp-2", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22b9', "ddi-udp-2", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22ba', "ddi-tcp-3", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22ba', "ddi-udp-3", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22bb', "ddi-tcp-4", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22bb', "ddi-udp-4", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22bc', "ddi-tcp-5", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22bc', "ddi-udp-5", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22bd', "ddi-tcp-6", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22bd', "ddi-udp-6", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22be', "ddi-tcp-7", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22be', "ddi-udp-7", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22c3', "ospf-lite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22c4', "jmb-cds1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22c5', "jmb-cds2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22ce', "manyone-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22cf', "manyone-xml", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22d0', "wcbackup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22d1', "dragonfly", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u22e9', "twds", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22f9', "ub-dns-control", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u22fa', "cumulus-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u231d', "sunwebadmins", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u231e', "http-wmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u231f', "https-wmap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2327', "bctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2328', "cslistener", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2329', "etlservicemgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u232a', "dynamid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u232f', "ogs-client", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2330', "ogs-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2331', "pichat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2332', "sdr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u233c', "tambora", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u233d', "panagolin-ident", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u233e', "paragent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u233f', "swa-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2340', "swa-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2341', "swa-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2342', "swa-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u235a', "versiera", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u235b', "fio-cmgmt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2378', "glrpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u237b', "emc-pp-mgmtsvc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u237c', "aurora", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u237d', "ibm-rsyscon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u237e', "net2display", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u237f', "classic", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2380', "sqlexec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2381', "sqlexec-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2382', "websm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2383', "xmltec-xmlmail", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2384', "XmlIpcRegSvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u238c', "hp-pdl-datastr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u238d', "bacula-dir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u238e', "bacula-fd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u238f', "bacula-sd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2390', "peerwire", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2391', "xadmin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2392', "astergate", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2392', "astergate-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2393', "astergatefax", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u239f', "mxit", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23ab', "dddp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23c8', "apani1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23c9', "apani2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23ca', "apani3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23cb', "apani4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23cc', "apani5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23e7', "sun-as-jpda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f0', "wap-wsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f1', "wap-wsp-wtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f2', "wap-wsp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f3', "wap-wsp-wtp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f4', "wap-vcard", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f5', "wap-vcal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f6', "wap-vcard-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f7', "wap-vcal-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f8', "rjcdb-vcards", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23f9', "almobile-system", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23fa', "oma-mlp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23fb', "oma-mlp-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23fc', "serverviewdbms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23fd', "serverstart", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23fe', "ipdcesgbs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u23ff', "insis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2400', "acme", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2401', "fsc-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2406', "teamcoherence", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2427', "mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u243e', "pegasus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u243f', "pegasus-ctl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2440', "pgps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2441', "swtp-port1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2442', "swtp-port2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2443', "callwaveiam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2444', "visd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2445', "n2h2server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2446', "n2receive", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2447', "cumulus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u244c', "armtechdaemon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u244d', "storview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u244e', "armcenterhttp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u244f', "armcenterhttps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2454', "vrace", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u245a', "sphinxql", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2460', "sphinxapi", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2466', "secure-ts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2469', "guibase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u247f', "mpidcmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2480', "mphlpdmc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2482', "ctechlicensing", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u249e', "fjdmimgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24a4', "boxp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24ab', "d2dconfig", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u24ac', "d2ddatatrans", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u24ad', "adws", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u24ae', "otp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u24b4', "fjinvmgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24b5', "mpidcagt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24b8', "sec-t4net-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24b9', "sec-t4net-clt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24ba', "sec-pc2fax-srv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24ca', "git", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24e3', "tungsten-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24e4', "wso2esb-console", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u24e5', "mindarray-ca", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u24ea', "sntlkeyssrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u251c', "ismserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2532', "sma-spw", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u253f', "mngsuite", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2540', "laes-bf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2553', "trispen-sra", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2578', "ldgateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2579', "cba8", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257a', "msgsys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257b', "pds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257c', "mercury-disc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257d', "pd-admin", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257e', "vscp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u257f', "robix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2580', "micromuse-ncpw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u258c', "streamcomm-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u258e', "iadt-tls", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2590', "erunbook-agent", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2591', "erunbook-server", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2592', "condor", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u259c', "odbcpathway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u259d', "uniport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u259e', "peoctlr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u259f', "peocoll", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u25a0', "mc-comm", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u25a8', "pqsflows", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u25c3', "xmms2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u25c4', "tec5-sdctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u25de', "client-wakeup", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u25df', "ccnx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u25e4', "board-roar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2613', "l5nas-parchan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2616', "board-voip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2619', "rasadv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2622', "tungsten-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2648', "davsrc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2649', "sstp-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u264a', "davsrcs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2693', "sapv1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2694', "sd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26a0', "cyborg-systems", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26a1', "gt-proxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26aa', "monkeycom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26ab', "sctp-tunneling", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26ac', "iua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26ad', "enrp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26af', "multicast-ping", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26b5', "domaintime", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26b7', "sype-transport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26de', "apc-9950", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26df', "apc-9951", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26e0', "apc-9952", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26e1', "acis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26e4', "alljoyn", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u26ee', "odnsp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2703', "dsm-scm-target", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2704', "nsesrvr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2706', "osm-appsrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2707', "osm-oev", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2708', "palace-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2709', "palace-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270a', "palace-3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270b', "palace-4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270c', "palace-5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270d', "palace-6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270e', "distinct32", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u270f', "distinct", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2710', "ndmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2711', "scp-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2712', "documentum", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2713', "documentum-s", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2714', "emcrmirccd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2715', "emcrmird", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2717', "mvs-capacity", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2718', "octopus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2719', "swdtp-sv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u271a', "rxapi", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2742', "zabbix-agent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2743', "zabbix-trapper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2747', "qptlmd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2760', "amanda", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2761', "famdc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2774', "itap-ddtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2775', "ezmeeting-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2776', "ezproxy-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2777', "ezrelay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2778', "swdtp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u277b', "bctp-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u277e', "nmea-0183", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u277f', "nmea-onenet", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2781', "netiq-endpoint", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2782', "netiq-qcheck", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2783', "netiq-endpt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2784', "netiq-voipa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2785', "iqrm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2790', "bmc-perf-sd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2791', "bmc-gms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u27b0', "qb-db-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u27b1', "snmptls", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u27b1', "snmpdtls", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u27b2', "snmptls-trap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u27b2', "snmpdtls-trap", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u27d8', "trisoap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u27d9', "rsms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u27d9', "rscs", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u280c', "apollo-relay", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2814', "axis-wimp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2830', "blocks", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2851', "cosir", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2904', "hip-nat-t", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u292c', "MOS-lower", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u292d', "MOS-upper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u292e', "MOS-aux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u292f', "MOS-soap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2930', "MOS-soap-opt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2987', "printopia", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2a30', "gap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2a35', "lpdg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2a39', "nbd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2a3a', "nmc-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2a6c', "helix", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2aee', "rmiaux", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2af8', "irisa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2af9', "metasys", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b60', "netapp-icmgmt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2b61', "netapp-icdata", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2b62', "sgi-lk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b67', "vce", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b68', "dicom", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b99', "suncacao-snmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b9a', "suncacao-jmxmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b9b', "suncacao-rmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b9c', "suncacao-csa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2b9d', "suncacao-websvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ba3', "snss", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ba4', "oemcacao-jmxmp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2ba6', "oemcacao-rmi", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2ba7', "oemcacao-websvc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2bc1', "smsqp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2bc8', "wifree", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2bcb', "memcache", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2c37', "imip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2c38', "imip-channels", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2c39', "arena-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2c67', "atm-uhas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2c6b', "hkp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ce1', "asgcypresstcps", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2d50', "tempest-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2dc8', "h323callsigalt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2de7', "intrepid-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2e64', "xoraya", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2e65', "x2e-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ebf', "sysinfo-sp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee0', "entextxid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee1', "entextnetwk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee2', "entexthigh", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee3', "entextmed", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee4', "entextlow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee5', "dbisamserver1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee6', "dbisamserver2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee7', "accuracer", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2ee8', "accuracer-dbms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2eea', "edbsrvr", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u2eec', "vipera", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2eed', "vipera-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2f4d', "rets-ssl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2f59', "nupaper-ss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2f88', "cawas", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u2f8c', "hivep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u300c', "linogridengine", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3021', "warehouse-sss", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3022', "warehouse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3039', "italk", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u31d1', "tsaf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3368', "i-zipqd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u33a0', "bcslogc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u33a1', "rs-pias", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u33a2', "emc-vcas-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u33a2', "emc-vcas-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u33a7', "powwow-client", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u33a8', "powwow-server", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3458', "doip-data", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3458', "doip-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3598', "bprd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3599', "bpdbm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u359a', "bpjava-msvc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u359c', "vnetd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35d6', "bpcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35d7', "vopied", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35d9', "nbdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35da', "nomdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35fa', "dsmcc-config", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35fb', "dsmcc-session", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35fc', "dsmcc-passthru", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35fd', "dsmcc-download", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35fe', "dsmcc-ccp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u35ff', "bmdss", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3669', "dta-systems", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u366a', "medevolve", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u36b0', "scotty-ft", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u36b1', "sua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u36d1', "sage-best-com1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u36d2', "sage-best-com2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u373d', "vcs-app", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u373e', "icpp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3741', "gcm-app", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3745', "vrts-tdd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3746', "vcscmd", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u374a', "vad", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u37aa', "cps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u384e', "ca-web-update", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3a58', "hde-lcesrvr-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3a59', "hde-lcesrvr-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3a98', "hydap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3b0e', "v2g-secc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3bf1', "xpilot", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3c03', "3link", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3cc3', "cisco-snat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3d2c', "bex-xr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3d7c', "ptp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3e7e', "2ping", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3e7f', "programmar", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3e80', "fmsas", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3e81', "fmsascon", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3e82', "gsms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3e83', "alfin", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3e94', "jwpc", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3e95', "jwpc-bin", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3f21', "sun-sea-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3f22', "solaris-audit", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u3fb5', "etb4j", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3fb6', "pduncs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3fb7', "pdefmns", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3fe8', "netserialext1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3fe9', "netserialext2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3fef', "netserialext3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u3ff0', "netserialext4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4000', "connected", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u40eb', "xoms", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u411a', "vtp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4204', "newbay-snc-mc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4236', "sgcip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u425f', "intel-rci-mp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4260', "amt-soap-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4261', "amt-soap-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4262', "amt-redir-tcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4263', "amt-redir-tls", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u426f', "isode-dua", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4321', "soundsvirtual", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4343', "chipper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4345', "avdecc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4346', "cpsp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4352', "integrius-stp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4353', "ssh-mgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u445c', "db-lsp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u445c', "db-lsp-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4541', "ea", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u455a', "zep", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u455b', "zigbee-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u455c', "zigbee-ips", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4571', "sw-orion", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u4650', "biimenu", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u46b8', "radpdf", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u46d8', "racf", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u4705', "opsec-cvp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4706', "opsec-ufp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4707', "opsec-sam", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4708', "opsec-lea", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4709', "opsec-omi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u470a', "ohsc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u470b', "opsec-ela", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4741', "checkpoint-rtm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4756', "gv-pf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u481f', "ac-cluster", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u48ca', "rds-ib", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u48cb', "rds-ip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4951', "ique", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u49c1', "infotos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u49c8', "apc-necmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4a38', "igrid", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4a4c', "j-link", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u4af7', "opsec-uaa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4afa', "ua-secureagent", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4b53', "keysrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4b73', "keyshadow", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4bc6', "mtrgtrans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4bd2', "hp-sco", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4bd3', "hp-sca", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4bd4', "hp-sessmon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4c53', "fxuptp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4c54', "sxuptp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4c55', "jcp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e1e', "iec-104-sec", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u4e1f', "dnp-sec", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e20', "dnp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e21', "microsan", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e22', "commtact-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e23', "commtact-https", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e25', "openwebnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e2c', "ss-idi-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e2d', "ss-idi", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u4e2e', "opendeploy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e42', "nburn-id", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e4e', "tmophl7mts", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e50', "mountd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4e51', "nfsrdma", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4ec7', "tolfab", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4eea', "ipdtp-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u4efe', "ipulse-ics", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5000', "emwavemsg", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u50be', "track", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5207', "athand-mmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5208', "irtrans", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5431', "rdm-tfs", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u5432', "dfserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5456', "vofr-gateway", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5528', "tvpm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5555', "webphone", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5556', "netspeak-is", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5557', "netspeak-cs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5558', "netspeak-acd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5559', "netspeak-cps", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f0', "snapenetio", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f1', "optocontrol", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f2', "optohost002", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f3', "optohost003", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f4', "optohost004", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u55f5', "optohost004", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u566d', "dcap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u5670', "gsidcap", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u5701', "wnn6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5721', "cis", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5747', "cis-secure", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u574b', "WibuKey", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u574e', "CodeMeter", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5809', "caldsoft-backup", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u581b', "vocaltec-wconf", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u581b', "vocaltec-phone", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u58eb', "talikaserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5910', "aws-brf", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59a7', "brf-gw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59d8', "inovaport1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59d9', "inovaport2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59da', "inovaport3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59db', "inovaport4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59dc', "inovaport5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u59dd', "inovaport6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5ae8', "s102", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5b25', "elxmgmt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5b68', "novar-dbase", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5b69', "novar-alarm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5b6a', "novar-global", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5ba0', "aequus", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u5ba1', "aequus-alt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc0', "med-ltp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc1', "med-fsp-rx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc2', "med-fsp-tx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc3', "med-supp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc4', "med-ovw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc5', "med-ci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5dc6', "med-net-svc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5eb2', "filesphere", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5eb9', "vista-4gl", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5f01', "ild", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5f42', "intel-rci", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5f91', "tonidods", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u5fea', "binkp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6064', "canditv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6065', "flashfiler", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6066', "proactivate", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6068', "tcc-http", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u60b2', "cslg", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u615a', "find", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61a8', "icl-twobase1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61a9', "icl-twobase2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61aa', "icl-twobase3", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61ab', "icl-twobase4", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61ac', "icl-twobase5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61ad', "icl-twobase6", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61ae', "icl-twobase7", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61af', "icl-twobase8", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61b0', "icl-twobase9", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u61b1', "icl-twobase10", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u63e8', "sauterdongle", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u6404', "idtp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u64c1', "vocaltec-hos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u652c', "tasp-net", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u652d', "niobserver", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u652e', "nilinkanalyst", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u652f', "niprobe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6590', "quake", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6615', "scscp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6660', "wnn6-ds", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6694', "ezproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6695', "ezmeeting", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6696', "k3software-svr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6697', "k3software-cli", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6776', "exoline-tcp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u6776', "exoline-udp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6777', "exoconfig", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6779', "exonet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6978', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6979', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697a', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697b', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697c', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697d', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697e', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u697f', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6980', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6981', "flex-lm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6ad1', "imagepump", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6b32', "jesmsjc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6b70', "kopek-httphead", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6c86', "ars-vista", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6d5f', "tw-auth-key", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6d60', "nxlmd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u6d61', "pqsp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u6e50', "siemensgsm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u71ef', "otmp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7531', "pago-services1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7532', "pago-services2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7634', "kingdomsonline", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7917', "ovobs", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u792c', "autotrac-acp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u7935', "yawn", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7ab8', "xqosd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7ae1', "tetrinet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7b84', "lm-mon", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7bc5', "dsx-monitor", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u7c15', "gamesmith-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7ccc', "iceedcp-tx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7ccd', "iceedcp-rx", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7d22', "iracinghelper", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7df9', "t1distproc60", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7ee3', "apm-link", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7f7b', "sec-ntb-clnt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u7f7c', "DMExpress", true, true);
        NetworkServiceNameManagerImpl.add2Registry(Short.MAX_VALUE, "filenet-powsrm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8000', "filenet-tms", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8001', "filenet-rpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8002', "filenet-nch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8003', "filenet-rmi", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8004', "filenet-pa", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8005', "filenet-cm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8006', "filenet-re", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8007', "filenet-pch", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8008', "filenet-peior", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8009', "filenet-obrok", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8021', "mlsn", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u802b', "retp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8080', "idmgratm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8163', "aurora-balaena", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8233', "diamondport", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8235', "dgi-serv", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8236', "speedtrace", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8236', "speedtrace-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u829a', "traceroute", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8378', "snip-slave", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u85c9', "turbonote-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u864a', "p-net-local", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u864b', "p-net-remote", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8707', "dhanalakshmi", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8892', "profinet-rt", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8893', "profinet-rtm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8894', "profinet-cm", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u88a4', "ethercat", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8a1a', "kitim", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8a1b', "altova-lm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8a1b', "altova-lm-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8a1c', "guttersnex", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8a1d', "openstack-id", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u8ca1', "allpeers", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u8eac', "febooti-aw", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\u9001', "kastenxpipe", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9263', "neckar", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9316', "unisys-eportal", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9539', "galaxy7-data", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u953a', "fairview", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u953b', "agpolicy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9b01', "turbonote-1", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9c40', "safetynetp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9f89', "cscp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9f8a', "csccredir", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9f8b', "csccfirewall", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\u9f95', "ortec-disc", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua097', "fs-qos", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua0a1', "tentacle", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ua342', "crestron-cip", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua343', "crestron-ctp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua60c', "candp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua60d', "candrp", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua60e', "caerpc", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua8b4', "reachout", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua8b5', "ndm-agent-port", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua8b6', "ip-provision", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua8b7', "noit-transport", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ua9b0', "ew-mgmt", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ua9b0', "ew-disc-cmd", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\ua9b1', "ciscocsdb", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uad21', "pmcd", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uad22', "pmcdproxy", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uad23', "pcp", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\uae00', "domiq", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\uae09', "rbr-debug", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uae38', "asihpi", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\uaf12', "EtherNet-IP-2", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uafc8', "asmp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\uafc8', "asmp-mon", false, true);
        NetworkServiceNameManagerImpl.add2Registry('\uafc9', "asmps", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\uaffe', "invision-ag", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub26e', "eba", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub301', "qdb2service", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub38e', "ssr-servermgr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub797', "mediabox", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub798', "mbus", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ub799', "winrm", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ub9c5', "dbbrowse", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\uba08', "directplaysrvr", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubabe', "ap", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubac0', "bacnet", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubb80', "nimcontroller", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubb81', "nimspooler", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubb82', "nimhub", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubb83', "nimgtw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubb84', "nimbusdb", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ubb85', "nimbusdbctrl", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ubbb1', "3gpp-cbsp", true, false);
        NetworkServiceNameManagerImpl.add2Registry('\ubc00', "isnetserv", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubc01', "blp5", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubdac', "com-bardac-dw", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubdeb', "iqobject", true, true);
        NetworkServiceNameManagerImpl.add2Registry('\ubf68', "matahari", true, false);
    }

    static {
        NetworkServiceNameManagerImpl.fillRegistry();
    }
}

