/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.ProtectionType;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.core.type.ClassLoaderObjectImpl;
import com.sap.jvm.profiling.impl.core.type.ClassObjectImpl;
import com.sap.jvm.profiling.impl.session.AbstractProfilingSessionImpl;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.util.misc.UTF8Util;
import java.io.IOException;

public class NonArrayClassObjectImpl
extends ClassObjectImpl
implements NonArrayClassObject {
    private static final int IS_PUBLIC = 1;
    private static final int IS_PROTECTED = 2;
    private static final int IS_PRIVATE = 4;
    private static final int IS_ABSTRACT = 8;
    private static final int IS_FINAL = 16;
    private static final int IS_SYNTHETIC = 32;
    private static final int HAS_FINALIZER = 64;
    private static final int IS_ENUM = 128;
    private static final int IS_ANNOTATION = 256;
    private static final int IS_INTERFACE = 512;
    private static final int IS_STATIC = 1024;
    private static final int IS_SYNTHETIC_JRUBY = 2048;
    private static final int IS_SYNTHETIC_JAVA_SCRIPT = 4096;
    private static final char[] EMPTY_CHAR_ARRAY = new char[0];
    private static final byte[][] EMPTY_UTF8_ARRAY = new byte[0][];
    private static final NonArrayClassObjectImpl[] NO_CLASSES = new NonArrayClassObjectImpl[0];
    private final UTF8String className;
    private final PackageName packageName;
    protected final NonArrayClassObjectImpl superClass;
    protected final ClassLoaderObjectImpl classLoader;
    protected final NonArrayClassObjectImpl[] interfaces;
    private final char[] staticFieldOffset;
    private final byte[][] staticFieldName;
    private final char[] instanceFieldOffset;
    private final byte[][] instanceFieldName;
    private final int attributes;
    private final int size;
    private final UTF8String filename;
    private final String source;

    public NonArrayClassObjectImpl(MappingInformation mapInfo, UTF8String name, UTF8String filename, long id, int index, ClassLoaderObjectImpl classLoader, AbstractProfilingSessionImpl session) {
        super(id, index);
        this.classLoader = classLoader;
        this.className = mapInfo.intern(name);
        this.filename = filename;
        this.packageName = mapInfo.getPackageName(this.className, false);
        this.superClass = null;
        this.interfaces = NO_CLASSES;
        this.staticFieldOffset = EMPTY_CHAR_ARRAY;
        this.staticFieldName = EMPTY_UTF8_ARRAY;
        this.size = 0;
        this.instanceFieldOffset = EMPTY_CHAR_ARRAY;
        this.instanceFieldName = EMPTY_UTF8_ARRAY;
        this.attributes = 0;
        this.source = null;
    }

    public NonArrayClassObjectImpl(ResourceReader reader, MappingInformation mapInfo, int index) throws IOException {
        super(reader, index);
        this.classLoader = (ClassLoaderObjectImpl)reader.readClassLoaderObject();
        assert (this.classLoader != null);
        this.superClass = (NonArrayClassObjectImpl)reader.readClassObject();
        char nrOfInterfaces = reader.readUint16();
        if (nrOfInterfaces > '\u0000') {
            this.interfaces = new NonArrayClassObjectImpl[nrOfInterfaces];
            for (int i = 0; i < this.interfaces.length; ++i) {
                this.interfaces[i] = (NonArrayClassObjectImpl)reader.readClassObject();
                assert (this.interfaces[i].isInterface());
            }
        } else {
            this.interfaces = NO_CLASSES;
        }
        char nrOfStaticFields = reader.readUint16();
        char nrOfInstanceFields = reader.readUint16();
        UTF8String name = mapInfo.intern(reader.readUTF());
        if (nrOfStaticFields == '\u0000') {
            this.staticFieldOffset = EMPTY_CHAR_ARRAY;
            this.staticFieldName = EMPTY_UTF8_ARRAY;
        } else {
            this.staticFieldOffset = new char[nrOfStaticFields];
            this.staticFieldName = new byte[nrOfStaticFields][];
            this.readOffsetsAndNames(this.staticFieldOffset, this.staticFieldName, mapInfo, reader);
        }
        if (nrOfInstanceFields == '\u0000') {
            this.instanceFieldOffset = EMPTY_CHAR_ARRAY;
            this.instanceFieldName = EMPTY_UTF8_ARRAY;
        } else {
            this.instanceFieldOffset = new char[nrOfInstanceFields];
            this.instanceFieldName = new byte[nrOfInstanceFields][];
            this.readOffsetsAndNames(this.instanceFieldOffset, this.instanceFieldName, mapInfo, reader);
        }
        this.attributes = reader.readInt32();
        if (this.isSyntheticJavaScriptClass()) {
            this.className = mapInfo.intern(name);
            this.packageName = mapInfo.getPackageName(mapInfo.intern(""), false);
        } else {
            int lastDotPosition = name.lastIndexOf((byte)47);
            UTF8String tmpClassName = name.substring(lastDotPosition + 1, name.length());
            if (lastDotPosition == -1) {
                this.packageName = mapInfo.getPackageName(mapInfo.intern(""), false);
            } else {
                UTF8String tmpPackageName = name.substring(0, lastDotPosition);
                this.packageName = mapInfo.getPackageName(mapInfo.intern(tmpPackageName.replace((byte)47, (byte)46)), false);
            }
            this.className = mapInfo.intern(tmpClassName);
        }
        this.size = reader.readInt32();
        if (reader.hasNext(2)) {
            boolean hasSource;
            this.filename = reader.readUTF();
            boolean bl = hasSource = reader.hasNext() && reader.readBoolean();
            this.source = hasSource ? reader.readBigString() : null;
        } else {
            this.filename = null;
            this.source = null;
        }
    }

    @Override
    public final String getInstanceFieldName(int fieldIndex) {
        return UTF8Util.asString(this.instanceFieldName[fieldIndex]);
    }

    @Override
    public final NonArrayClassObjectImpl getInterface(int interIndex) {
        return this.interfaces[interIndex];
    }

    @Override
    public final int getNrOfDeclaredInstanceFields() {
        return this.instanceFieldName.length;
    }

    @Override
    public final int getNrOfInterfaces() {
        return this.interfaces.length;
    }

    @Override
    public final int getNrOfStaticFields() {
        return this.staticFieldName.length;
    }

    @Override
    public final String getStaticFieldName(int fieldIndex) {
        return UTF8Util.asString(this.staticFieldName[fieldIndex]);
    }

    @Override
    public final boolean isInterface() {
        return (this.attributes & 0x200) != 0;
    }

    @Override
    public boolean isPrimitive() {
        return false;
    }

    @Override
    public final int getArrayDimension() {
        return 0;
    }

    @Override
    public final ClassLoaderObjectImpl getClassLoader() {
        return this.classLoader;
    }

    @Override
    public final String getName() {
        return this.className.toString();
    }

    @Override
    public final NonArrayClassObjectImpl getSuperClass() {
        return this.superClass;
    }

    @Override
    public final boolean isInternalClass() {
        return false;
    }

    @Override
    public int getInstanceSize() {
        return this.size;
    }

    private void readOffsetsAndNames(char[] offsets, byte[][] names, MappingInformation mapInfo, ResourceReader reader) throws IOException {
        int i;
        int length = offsets.length;
        boolean isSorted = true;
        for (i = 0; i < length; ++i) {
            offsets[i] = reader.readUint16();
            byte[] byArray = names[i] = mapInfo.useGlobalStringTable() ? mapInfo.intern(reader.readUTF()).getBytes() : reader.readUTF().getBytes();
            if (i <= 0 || offsets[i - 1] <= offsets[i]) continue;
            isSorted = false;
        }
        if (!isSorted) {
            for (i = 0; i < length; ++i) {
                for (int j = i + 1; j < length; ++j) {
                    if (offsets[i] <= offsets[j]) continue;
                    char tmpOffset = offsets[i];
                    offsets[i] = offsets[j];
                    offsets[j] = tmpOffset;
                    byte[] tmpName = names[i];
                    names[i] = names[j];
                    names[j] = tmpName;
                }
            }
        }
    }

    @Override
    public ProtectionType getProtection() {
        if ((this.attributes & 1) != 0) {
            return ProtectionType.IS_PUBLIC;
        }
        if ((this.attributes & 2) != 0) {
            return ProtectionType.IS_PROTECTED;
        }
        if ((this.attributes & 4) != 0) {
            return ProtectionType.IS_PRIVATE;
        }
        return ProtectionType.IS_PACKAGE_PRIVATE;
    }

    @Override
    public boolean isSyntheticJRubyClass() {
        return (this.attributes & 0x800) != 0;
    }

    @Override
    public boolean hasFinalizer() {
        return (this.attributes & 0x40) != 0;
    }

    @Override
    public boolean isAbstract() {
        return (this.attributes & 8) != 0;
    }

    @Override
    public boolean isAnnotation() {
        return (this.attributes & 0x100) != 0;
    }

    @Override
    public boolean isEnum() {
        return (this.attributes & 0x80) != 0;
    }

    @Override
    public boolean isFinal() {
        return (this.attributes & 0x10) != 0;
    }

    @Override
    public boolean isStatic() {
        return (this.attributes & 0x400) != 0;
    }

    @Override
    public boolean isSynthetic() {
        return (this.attributes & 0x20) != 0;
    }

    @Override
    public boolean isSyntheticJavaScriptClass() {
        return (this.attributes & 0x1000) != 0;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)400);
        this.writeInternal(writer);
        writer.finalizePacket();
    }

    protected void writeInternal(ResourceWriter writer) throws IOException {
        int i;
        writer.writeInt64(this.getId());
        writer.writeInt32(this.getClassLoader().getIndex());
        int superClassId = this.getSuperClass() != null ? this.getSuperClass().getIndex() : 0;
        writer.writeInt32(superClassId);
        int numberOfInterfaces = this.getNrOfInterfaces();
        writer.writeInt16((short)numberOfInterfaces);
        for (int i2 = 0; i2 < numberOfInterfaces; ++i2) {
            writer.writeInt32(this.getInterface(i2).getIndex());
        }
        int numberOfStaticFields = this.getNrOfStaticFields();
        writer.writeInt16((short)numberOfStaticFields);
        int numberOfInstanceFields = this.getNrOfDeclaredInstanceFields();
        writer.writeInt16((short)numberOfInstanceFields);
        writer.writeString(this.getInternalFullName());
        for (i = 0; i < numberOfStaticFields; ++i) {
            writer.writeUint16(this.staticFieldOffset[i]);
            writer.writeString(this.getStaticFieldName(i));
        }
        for (i = 0; i < numberOfInstanceFields; ++i) {
            writer.writeUint16(this.instanceFieldOffset[i]);
            writer.writeString(this.getInstanceFieldName(i));
        }
        writer.writeInt32(this.attributes);
        writer.writeInt32(this.size);
        if (this.filename != null) {
            writer.writeUTF(this.filename);
            if (this.source != null) {
                writer.writeBoolean(true);
                writer.writeBigString(this.source);
            }
        }
    }

    @Override
    public ProfilingSession getSession() {
        return this.classLoader.getSession();
    }

    @Override
    public UTF8String getNameUTF() {
        return this.className;
    }

    @Override
    public UTF8String getPackageNameUTF() {
        return this.packageName.getName();
    }

    @Override
    public PackageName getPackage() {
        return this.packageName;
    }

    @Override
    public UTF8String getFilenameUTF() {
        return this.filename;
    }

    @Override
    public String getFilename() {
        if (this.filename == null) {
            return null;
        }
        return this.filename.toString();
    }

    @Override
    public String getSourceCode() {
        return this.source;
    }
}

