/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.PackageName;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.impl.util.MappingInformation;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class PackageNameImpl
implements PackageName {
    public static final byte GENERIC = 0;
    public static final byte ROOT = 1;
    public static final byte DEFAULT = 2;
    public static final byte NO_STACK = 3;
    public static final byte INLINED_AWAY = 4;
    public final UTF8String name;
    private final boolean includesSubPackages;
    private final byte type;
    private final PackageName packageIncludingSubPackages;
    private final PackageName parent;

    public PackageNameImpl(UTF8String name, boolean includesSubPackages, byte type, MappingInformation mapInfo) {
        this.name = name;
        this.includesSubPackages = includesSubPackages;
        this.type = type;
        this.packageIncludingSubPackages = includesSubPackages ? this : mapInfo.getPackageName(name, true, type);
        int lastDot = name.lastIndexOf((byte)46);
        if (lastDot < 0) {
            UTF8String rootName = mapInfo.getRootPackage();
            this.parent = name.equals(rootName) ? null : mapInfo.getPackageName(rootName, includesSubPackages, (byte)1);
        } else {
            UTF8String parentName = mapInfo.intern(name.substring(0, lastDot));
            this.parent = mapInfo.getPackageName(parentName, includesSubPackages, (byte)0);
        }
    }

    @Override
    public UTF8String getName() {
        return this.name;
    }

    @Override
    public boolean includesSubPackages() {
        return this.includesSubPackages;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeUTF(this.name);
        writer.writeBoolean(this.includesSubPackages);
    }

    public boolean equals(Object obj) {
        if (obj instanceof PackageNameImpl) {
            return this.equals((PackageNameImpl)obj);
        }
        return false;
    }

    public boolean equals(PackageNameImpl other) {
        return this.name.equals(other.name) && this.includesSubPackages == other.includesSubPackages;
    }

    public int hashCode() {
        return this.name.hashCode() ^ (this.includesSubPackages ? 1 : 0);
    }

    @Override
    public int compareTo(PackageName other) {
        int result = this.name.compareTo(other.getName());
        if (result == 0) {
            if (this.includesSubPackages == other.includesSubPackages()) {
                return 0;
            }
            return this.includesSubPackages ? -1 : 1;
        }
        return result;
    }

    public String toString() {
        if (this.includesSubPackages && this.isRootPackage()) {
            return "*";
        }
        if (this.includesSubPackages && this.type == 2) {
            return this.name + ".*";
        }
        return this.name.toString();
    }

    @Override
    public PackageName asPackageWithSubPackages() {
        return this.packageIncludingSubPackages;
    }

    @Override
    public PackageName getParentPackage() {
        return this.parent;
    }

    @Override
    public boolean isDefaultPackage() {
        return this.type == 2;
    }

    @Override
    public boolean isInlinedAway() {
        return this.type == 4;
    }

    @Override
    public boolean isNoStack() {
        return this.type == 3;
    }

    @Override
    public boolean isRootPackage() {
        return this.type == 1;
    }

    @Override
    public boolean matches(PackageName other) {
        UTF8String otherName = other.getName();
        if (!other.includesSubPackages()) {
            return this.name.equals(otherName);
        }
        if (other.isRootPackage()) {
            return true;
        }
        if (this.name.startsWith(otherName)) {
            if (this.name.length() == otherName.length()) {
                return true;
            }
            return this.name.get(otherName.length()) == 46;
        }
        return false;
    }
}

