/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.impl.core.type.MethodLocationImpl;
import com.sap.jvm.profiling.impl.core.type.StackFrameCache;
import com.sap.jvm.profiling.impl.core.type.StackTraceManagerImpl;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class StackFramesImpl
implements StackFrames {
    private static final int INITIAL_CAPACITY = 512;
    private int deferredStackTraceIndex;
    private MethodLocation[] locations;
    private MethodLocation[] cachedLocations;
    private StackFrameCache cache;
    private int[] indices;
    private int nrOfFrames;
    private int currStackTraceIndex;
    private final StackTraceManagerImpl stackManager;

    public StackFramesImpl(StackTraceManagerImpl stackManager, StackFrameCache cache) {
        assert (cache == null || cache.manager == stackManager);
        this.stackManager = stackManager;
        this.cache = cache;
        this.locations = new MethodLocation[512];
        this.indices = new int[512];
        this.nrOfFrames = 0;
    }

    @Override
    public void fillIn(int stackTraceIndex) {
        this.deferredStackTraceIndex = stackTraceIndex;
    }

    @Override
    public void fillIn(MethodLocation[] newLocations, int newNrOfFrames) {
        if (this.cachedLocations == null) {
            this.cachedLocations = new MethodLocationImpl[newNrOfFrames];
        }
        if (this.cachedLocations.length < newNrOfFrames) {
            this.cachedLocations = new MethodLocationImpl[Math.max(newNrOfFrames, this.cachedLocations.length * 2)];
        }
        System.arraycopy(newLocations, 0, this.cachedLocations, 0, newNrOfFrames);
        this.nrOfFrames = newNrOfFrames;
        this.deferredStackTraceIndex = -1;
    }

    @Override
    public void fillAndAddNoLocation(int stackTraceIndex) {
        this.deferredStackTraceIndex = stackTraceIndex;
        if (stackTraceIndex == 0) {
            this.locations[0] = this.stackManager.getNoStackMethodLocation();
            this.indices[0] = this.locations[0].getIndex();
            this.nrOfFrames = 1;
            this.cachedLocations = null;
            this.currStackTraceIndex = 0;
            this.deferredStackTraceIndex = -1;
        }
    }

    private void fillInImpl(int stackTraceIndex) {
        if (this.cache != null) {
            this.cachedLocations = this.getCachedLocations(stackTraceIndex);
            if (this.cachedLocations != null) {
                this.nrOfFrames = this.cachedLocations.length;
                return;
            }
        }
        this.nrOfFrames = this.stackManager.getNrOfFrames(stackTraceIndex);
        if (this.locations.length < this.nrOfFrames) {
            this.resize(this.nrOfFrames);
        }
        int newLocationStart = this.stackManager.copyToArray(stackTraceIndex, this.currStackTraceIndex, this.indices);
        Arrays.fill(this.locations, newLocationStart, this.nrOfFrames, null);
        this.currStackTraceIndex = stackTraceIndex;
    }

    private void resize(int size) {
        MethodLocation[] newLocations = new MethodLocation[size];
        int[] newIndices = new int[size];
        System.arraycopy(this.locations, 0, newLocations, 0, this.locations.length);
        System.arraycopy(this.indices, 0, newIndices, 0, this.indices.length);
        this.locations = newLocations;
        this.indices = newIndices;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MethodLocation[] getCachedLocations(int stackTraceIndex) {
        byte newHitCount;
        AtomicReferenceArray<MethodLocation[]> locationsCache = this.cache.locations;
        if (stackTraceIndex >= locationsCache.length()) {
            return null;
        }
        MethodLocation[] result = locationsCache.get(stackTraceIndex);
        if (result != null) {
            return result;
        }
        byte[] hitCounts = this.cache.hitCounts;
        hitCounts[stackTraceIndex] = newHitCount = (byte)(hitCounts[stackTraceIndex] + 1);
        if (newHitCount != this.cache.hitCountToInclude) {
            return null;
        }
        this.nrOfFrames = this.stackManager.getNrOfFrames(stackTraceIndex);
        if (this.locations.length < this.nrOfFrames) {
            this.resize(this.nrOfFrames);
        }
        int newLocationStart = this.stackManager.copyToArray(stackTraceIndex, this.currStackTraceIndex, this.indices);
        Arrays.fill(this.locations, newLocationStart, this.nrOfFrames, null);
        this.currStackTraceIndex = stackTraceIndex;
        MethodLocation[] stack = new MethodLocation[this.nrOfFrames];
        for (int i = 0; i < stack.length; ++i) {
            stack[i] = this.stackManager.getLocation(this.indices[i]);
        }
        int cost = stack.length + 3;
        StackFrameCache stackFrameCache = this.cache;
        synchronized (stackFrameCache) {
            result = locationsCache.get(stackTraceIndex);
            if (result != null) {
                return result;
            }
            this.cache.slotsLeft -= cost;
            if (this.cache.slotsLeft < 0) {
                for (int i = locationsCache.length() - 1; i >= 0; --i) {
                    locationsCache.set(i, null);
                }
                Arrays.fill(hitCounts, (byte)0);
                this.cache.slotsLeft = this.cache.maxSlots;
                this.cache.hitCountToInclude = (byte)(this.cache.hitCountToInclude * 2);
            }
            locationsCache.set(stackTraceIndex, stack);
            result = stack;
        }
        return result;
    }

    @Override
    public int getNrOfFrames() {
        if (this.deferredStackTraceIndex >= 0) {
            this.fillInImpl(this.deferredStackTraceIndex);
            this.deferredStackTraceIndex = -1;
        }
        return this.nrOfFrames;
    }

    @Override
    public MethodLocation getMethodLocation(int index) {
        assert (index < this.nrOfFrames);
        assert (this.deferredStackTraceIndex == -1);
        if (this.cachedLocations != null) {
            assert (this.cachedLocations[index] != null);
            return this.cachedLocations[index];
        }
        if (this.locations[index] == null) {
            this.locations[index] = this.stackManager.getLocation(this.indices[index]);
        }
        assert (this.locations[index] != null);
        return this.locations[index];
    }

    @Override
    public int getMethodLocationIndex(int index) {
        assert (index < this.nrOfFrames);
        assert (this.deferredStackTraceIndex == -1);
        if (this.cachedLocations != null) {
            assert (this.cachedLocations[index] != null);
            return this.cachedLocations[index].getIndex();
        }
        return this.indices[index];
    }

    @Override
    public MethodObject getMethod(int index) {
        assert (index < this.nrOfFrames);
        return this.getMethodLocation(index).getMethod();
    }

    @Override
    public MethodObject getTopMethod() {
        return this.getMethodLocation(this.getNrOfFrames() - 1).getMethod();
    }

    @Override
    public int getLineNr(int index) {
        assert (index < this.nrOfFrames);
        return this.getMethodLocation(index).getLineNumber();
    }

    @Override
    public void print(PrintStream stream, boolean addIndex) {
        for (int i = this.getNrOfFrames() - 1; i >= 0; --i) {
            if (addIndex) {
                String index = "     " + i;
                stream.print(index.substring(index.length() - 5) + " ");
            }
            stream.println(this.getMethodLocation(i));
        }
    }

    @Override
    public boolean matchesPath(int bottom, int top, MethodLocation[] path, int pathLength) {
        if (bottom + pathLength > top) {
            return false;
        }
        assert (this.deferredStackTraceIndex == -1);
        if (this.cachedLocations != null) {
            for (int i = 0; i < pathLength; ++i) {
                MethodLocation location = this.cachedLocations[i + bottom];
                if (!(path[i].getLineNumber() == 0 ? location.getMethod() != path[i].getMethod() : location != path[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < pathLength; ++i) {
            MethodLocation location = this.getMethodLocation(i + bottom);
            if (!(path[i].getLineNumber() == 0 ? location.getMethod() != path[i].getMethod() : location != path[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matchesReversePath(int bottom, int top, MethodLocation[] path, int pathLength) {
        if (top - pathLength < bottom) {
            return false;
        }
        assert (this.deferredStackTraceIndex == -1);
        if (this.cachedLocations != null) {
            for (int i = 0; i < pathLength; ++i) {
                MethodLocation location = this.cachedLocations[top - i - 1];
                if (!(path[i].getLineNumber() == 0 ? location.getMethod() != path[i].getMethod() : location != path[i])) continue;
                return false;
            }
            return true;
        }
        for (int i = 0; i < pathLength; ++i) {
            MethodLocation location = this.getMethodLocation(top - i - 1);
            if (!(path[i].getLineNumber() == 0 ? location.getMethod() != path[i].getMethod() : location != path[i])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(bos);
        this.print(ps, true);
        ps.close();
        return "Nr. of frames:" + this.getNrOfFrames() + "\n" + new String(bos.toByteArray());
    }
}

