/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.core.type.MethodLocationManager;
import com.sap.jvm.profiling.core.type.MethodObject;
import com.sap.jvm.profiling.core.type.MethodObjectManager;
import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.core.type.StackTraceManager;
import com.sap.jvm.profiling.impl.core.type.MethodLocationImpl;
import com.sap.jvm.profiling.impl.core.type.StackFrameCache;
import com.sap.jvm.profiling.impl.core.type.StackFramesImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.util.BitUtil;
import com.sap.jvm.profiling.util.splitarray.SplitArray24;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray48;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.profiling.util.splitarray.SplitArray8;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.ref.WeakReference;

public final class StackTraceManagerImpl
implements StackTraceManager,
MethodLocationManager {
    private static final String STACK_TRACE_ID_2_INDEX_FILENAME_PREFIX = "id2index";
    private static final String STACK_TRACE_ID_2_INDEX_FILENAME_SUFFIX = "map";
    private static final boolean usePresentLocationsInCopy = StackTraceManagerImpl.shouldUsePresentLocations();
    private static final boolean shouldCheckLocations = StackTraceManagerImpl.shouldCheckLocations();
    private static final int ONE_FRAME_STACK_TRACE = 0;
    private static final int TWO_FRAME_STACK_TRACE = 1;
    private static final int THREE_FRAME_STACK_TRACE = 2;
    private static final int FOUR_FRAME_STACK_TRACE = 3;
    private static final int FIVE_FRAME_STACK_TRACE = 4;
    private static final int SIX_FRAME_STACK_TRACE = 5;
    private static final int N_FRAME_STACK_TRACE = 6;
    private static final int BIG_STACK_TRACE = 7;
    private static final double RESIZE_LIMIT = 5.0;
    private static final int LOG_ID_TO_INDEX_SIZE = 20;
    private static final int ID_TO_INDEX_SIZE = 0x100000;
    private static final int ID_TO_INDEX_SAVE_SIZE = 262144;
    private static final int INITIAL_BUCKET_SIZE = 1024;
    private static final int MAX_INDEX = Integer.MAX_VALUE;
    private final SplitArray64 stacks;
    private int nextStackIndex;
    private SplitArray32 stackNext;
    private SplitArray32 stackBuckets;
    private int stackResizeLimit;
    private int stackMask;
    private int[] idToIndex;
    private int idToIndexOffset;
    private int idToIndexSavePoint;
    private RandomAccessFile idBackupFile;
    private File idTempFile;
    private final SplitArray48 fourFramesLoc;
    private final SplitArray8 fourFramesNrShared;
    private int nextFourFrameIndex;
    private final SplitArray48 fiveFramesLoc;
    private final SplitArray8 fiveFramesNrShared;
    private int nextFiveFrameIndex;
    private final SplitArray48 sixFramesLoc;
    private final SplitArray8 sixFramesNrShared;
    private int nextSixFrameIndex;
    private final SplitArray24 nFrames;
    private int nextNFrameIndex;
    private int nrOfNFrames;
    private SplitArray32 bigFrames;
    private long nextBigFrameIndex;
    private int nrOfBigFrames;
    private final SplitArrayObject<MethodLocationImpl> locationMethodLocations;
    private final MethodObjectManager methodManager;
    private SplitArray24 locationNext;
    private SplitArray24 locationBuckets;
    private int nextLocationIndex;
    private int locationResizeLimit;
    private int locationMask;
    private final SplitArray24 pairFirst;
    private final SplitArray24 pairSecond;
    private SplitArray24 pairNext;
    private SplitArray24 pairBuckets;
    private int nextPairIndex;
    private int pairResizeLimit;
    private int pairMask;
    private final SplitArray24 tripleFirst;
    private final SplitArray24 tripleThird;
    private ProfilingSession session;
    private SplitArray24 tripleNext;
    private SplitArray24 tripleBuckets;
    private int nextTripleIndex;
    private int tripleResizeLimit;
    private int tripleMask;
    private int lastStackIndex;
    private int[] lastLocations;
    private MethodLocation noStackMethodLocation;
    private MethodLocation inlinedAwayMethodLocation;
    private int nrOfOneFrames;
    private int nrOfTwoFrames;
    private int nrOfThreeFrames;
    private int nrOfFourFrames;
    private int nrOfFiveFrames;
    private int nrOfSixFrames;
    private WeakReference<StackFrameCache> cacheRef;

    public StackTraceManagerImpl(MethodObjectManager methodManager, boolean needsIds, ProfilingSession session) {
        this(methodManager, 1, session);
        if (needsIds) {
            this.idToIndex = new int[0x100000];
            this.idToIndexOffset = 0;
            this.idToIndexSavePoint = 0;
            this.stackNext = new SplitArray32();
            this.stackBuckets = new SplitArray32(1024L);
            this.stackResizeLimit = 5120;
            this.stackMask = 1023;
        }
    }

    public StackTraceManagerImpl(MethodObjectManager methodManager, int nrOfStackTraces, ProfilingSession session) {
        this.methodManager = methodManager;
        this.session = session;
        this.stacks = new SplitArray64(nrOfStackTraces);
        this.fourFramesLoc = new SplitArray48();
        this.fourFramesNrShared = new SplitArray8();
        this.nextFourFrameIndex = 0;
        this.fiveFramesLoc = new SplitArray48();
        this.fiveFramesNrShared = new SplitArray8();
        this.nextFiveFrameIndex = 0;
        this.sixFramesLoc = new SplitArray48();
        this.sixFramesNrShared = new SplitArray8();
        this.nextSixFrameIndex = 0;
        this.nFrames = new SplitArray24();
        this.nextNFrameIndex = 0;
        this.bigFrames = new SplitArray32();
        this.nextBigFrameIndex = 0L;
        this.nrOfBigFrames = 0;
        this.locationMethodLocations = new SplitArrayObject();
        this.nextLocationIndex = 1;
        this.locationNext = new SplitArray24();
        this.locationBuckets = new SplitArray24(1024L);
        this.locationResizeLimit = 5120;
        this.locationMask = 1023;
        this.pairFirst = new SplitArray24();
        this.pairSecond = new SplitArray24();
        this.nextPairIndex = 1;
        this.pairNext = new SplitArray24();
        this.pairBuckets = new SplitArray24(1024L);
        this.pairResizeLimit = 5120;
        this.pairMask = 1023;
        this.tripleFirst = new SplitArray24();
        this.tripleThird = new SplitArray24();
        this.nextTripleIndex = 1;
        this.tripleNext = new SplitArray24();
        this.tripleBuckets = new SplitArray24(1024L);
        this.tripleResizeLimit = 5120;
        this.tripleMask = 1023;
        this.lastLocations = new int[512];
    }

    public synchronized int addStackTrace(int sharedTraceId, int stackTraceId, int nrOfSharedFrames, MethodObject[] nonSharedMethods, int[] nonSharedLineNrs) {
        int nrOfFrames;
        int sharedTraceIndex = this.getIndexForId(sharedTraceId);
        this.stacks.resize(this.nextStackIndex + 1);
        assert (nonSharedMethods.length == nonSharedLineNrs.length);
        int[] nonSharedFrames = new int[nonSharedMethods.length];
        for (int i = 0; i < nonSharedFrames.length; ++i) {
            nonSharedFrames[i] = this.locationAddToHashSet(nonSharedMethods[i].getIndex(), nonSharedLineNrs[i]);
        }
        if (stackTraceId - this.idToIndexOffset >= 0x100000) {
            if (this.idToIndexOffset == this.idToIndexSavePoint) {
                this.saveIdToIndexMapping();
            }
            assert (this.idToIndexOffset < this.idToIndexSavePoint);
            ++this.idToIndexOffset;
            assert (stackTraceId - this.idToIndexOffset < 0x100000);
        }
        if (this.lastLocations.length < (nrOfFrames = nrOfSharedFrames + nonSharedFrames.length)) {
            int[] newLastLocations = new int[nrOfFrames];
            System.arraycopy(this.lastLocations, 0, newLastLocations, 0, this.lastLocations.length);
            this.lastLocations = newLastLocations;
        }
        this.copyToArray(sharedTraceIndex, this.lastStackIndex, this.lastLocations);
        for (int i = 0; i < nonSharedFrames.length; ++i) {
            this.lastLocations[nrOfSharedFrames + i] = nonSharedFrames[i];
        }
        int hashCode = this.getStackTraceHashCode(this.lastLocations, nrOfFrames);
        int bucket = hashCode & this.stackMask;
        int index = this.stackBuckets.get(bucket);
        while (index != 0) {
            if (this.equals(index, this.lastLocations, nrOfFrames)) {
                this.idToIndex[stackTraceId & 0xFFFFF] = index;
                this.lastStackIndex = index;
                return index;
            }
            index = this.stackNext.get(index);
        }
        this.addStackTraceInternal(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
        if (this.stackResizeLimit <= this.nextStackIndex) {
            this.stackDoubleHashSet();
            assert (this.stackResizeLimit > this.nextStackIndex);
        }
        this.stackNext.resize(this.nextStackIndex + 1);
        bucket = hashCode & this.stackMask;
        int next = this.stackBuckets.get(bucket);
        this.stackNext.set(this.nextStackIndex, next);
        this.stackBuckets.set(bucket, this.nextStackIndex);
        this.lastStackIndex = this.nextStackIndex;
        this.idToIndex[stackTraceId & 0xFFFFF] = this.nextStackIndex;
        return this.nextStackIndex++;
    }

    public synchronized void addIndexedStackTrace(int sharedTraceIndex, int stackTraceIndex, int nrOfSharedFrames, int[] locations) {
        this.addStackTraceInternal(sharedTraceIndex, nrOfSharedFrames, locations);
        ++this.nextStackIndex;
    }

    private int[] addStackTraceInternal(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        if (BitUtil.usesMoreBits(sharedTraceIndex, 24) || BitUtil.usesMoreBits(nrOfSharedFrames, 9) || BitUtil.usesMoreBits(nonSharedFrames.length, 16)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
        } else {
            switch (nonSharedFrames.length) {
                case 1: {
                    this.oneFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                case 2: {
                    this.twoFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                case 3: {
                    this.threeFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                case 4: {
                    this.fourFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                case 5: {
                    this.fiveFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                case 6: {
                    this.sixFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                    break;
                }
                default: {
                    this.nFrameAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
                }
            }
        }
        return nonSharedFrames;
    }

    public int getIndexForId(int stackTraceId) {
        if (stackTraceId == 0) {
            return 0;
        }
        StackTraceManagerImpl stackTraceManagerImpl = this;
        synchronized (stackTraceManagerImpl) {
            if (stackTraceId >= this.idToIndexOffset) {
                int result = this.idToIndex[stackTraceId & 0xFFFFF];
                assert (result != 0);
                return result;
            }
            try {
                if (this.idBackupFile == null) {
                    ResourceManager resourceManager = this.session.getResourceManager();
                    this.idBackupFile = resourceManager == null ? this.getStackTraceIdFile() : resourceManager.getStackTraceIdFile();
                }
                this.idBackupFile.seek(4L * (long)stackTraceId);
                return this.idBackupFile.readInt();
            }
            catch (IOException e) {
                throw new RuntimeException("Cannot read the backup file for the id to index mapping", e);
            }
        }
    }

    @Override
    public synchronized StackFrames getStackFramesObject(boolean useCache) {
        StackFrameCache cache = null;
        if (useCache) {
            if (this.cacheRef != null) {
                cache = (StackFrameCache)this.cacheRef.get();
            }
            if (cache == null) {
                cache = new StackFrameCache(this);
                this.cacheRef = new WeakReference<StackFrameCache>(cache);
            }
        }
        return new StackFramesImpl(this, cache);
    }

    void copyToArray(int index, int[] locations) {
        if (index == 0) {
            return;
        }
        int currStackIndex = index;
        int type = this.getType(currStackIndex);
        int nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
        int sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        int frameTop = nonSharedFrames + sharedFrames;
        assert (frameTop > 0);
        while (true) {
            int toCopy;
            if ((toCopy = frameTop - sharedFrames) > 0) {
                this.copyNonSharedLocations(currStackIndex, type, locations, frameTop - toCopy, toCopy);
                if ((frameTop -= toCopy) <= 0) {
                    assert (frameTop == 0);
                    return;
                }
            }
            currStackIndex = this.getSharedStackTrace(currStackIndex, type);
            type = this.getType(currStackIndex);
            nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
            sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        }
    }

    int copyToArray(int index, int presentIndex, int[] locations) {
        if (index == 0) {
            return 0;
        }
        if (!usePresentLocationsInCopy || presentIndex == 0) {
            this.copyToArray(index, locations);
            return 0;
        }
        int currStackIndex = index;
        int type = this.getType(currStackIndex);
        int nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
        int sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        int frameTop = nonSharedFrames + sharedFrames;
        int otherIndex = presentIndex;
        int lastOtherIndex = -1;
        int otherType = this.getType(otherIndex);
        int otherShared = this.getNrOfSharedFrames(otherIndex, otherType);
        int otherNonShared = this.getNrOfNonSharedFrames(otherIndex, otherType);
        int otherTop = otherNonShared + otherShared;
        assert (frameTop > 0);
        while (true) {
            if (otherTop >= frameTop) {
                lastOtherIndex = otherIndex;
                otherIndex = this.getSharedStackTrace(otherIndex, otherType);
                otherType = this.getType(otherIndex);
                otherTop = otherShared;
                otherShared = this.getNrOfSharedFrames(otherIndex, otherType);
                continue;
            }
            int toCopy = frameTop - sharedFrames;
            if (toCopy > 0) {
                this.copyNonSharedLocations(currStackIndex, type, locations, frameTop - toCopy, toCopy);
                if ((frameTop -= toCopy) <= 0) {
                    assert (frameTop == 0);
                    return 0;
                }
            }
            if (lastOtherIndex == currStackIndex && toCopy > 0 && frameTop == otherTop) {
                assert (!shouldCheckLocations || this.checkLocations(index, locations));
                return frameTop;
            }
            currStackIndex = this.getSharedStackTrace(currStackIndex, type);
            type = this.getType(currStackIndex);
            nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
            sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        }
    }

    @Override
    public MethodLocationImpl getLocation(int locationIndex) {
        return this.locationGetMethodLocation(locationIndex);
    }

    @Override
    public MethodLocation getNoStackMethodLocation() {
        return this.noStackMethodLocation;
    }

    public void setNoStackMethodLocation(MethodLocation noStackMethodLocation) {
        this.noStackMethodLocation = noStackMethodLocation;
    }

    @Override
    public MethodLocation getInlinedAwayMethodLocation() {
        return this.inlinedAwayMethodLocation;
    }

    public void setInlinedAwayMethodLocation(MethodLocation inlinedAwayMethodLocation) {
        this.inlinedAwayMethodLocation = inlinedAwayMethodLocation;
    }

    private static boolean shouldUsePresentLocations() {
        return !"false".equals(System.getProperty("sapjvm.shouldUsePresentLocations"));
    }

    private static boolean shouldCheckLocations() {
        return "true".equals(System.getProperty("sapjvm.shouldCheckLocations"));
    }

    private boolean checkLocations(int index, int[] locations) {
        int[] realIndices = new int[this.getNrOfFrames(index)];
        this.copyToArray(index, realIndices);
        for (int i = 0; i < realIndices.length; ++i) {
            if (realIndices[i] == locations[i]) continue;
            assert (false);
            return false;
        }
        return true;
    }

    private void stackDoubleHashSet() {
        int nrOfBuckets = (int)this.stackBuckets.size() * 2;
        this.stackBuckets.resizeAndClear(nrOfBuckets);
        this.stackResizeLimit = (int)((double)nrOfBuckets * 5.0);
        this.stackMask = nrOfBuckets - 1;
        int[] locations = new int[512];
        int lastIndex = 0;
        int i = 1;
        while (i < this.nextStackIndex) {
            int nrOfFrames = this.getNrOfFrames(i);
            if (nrOfFrames > locations.length) {
                int[] newLocations = new int[nrOfFrames];
                System.arraycopy(locations, 0, newLocations, 0, locations.length);
                locations = newLocations;
            }
            this.copyToArray(i, lastIndex, locations);
            int hash = this.getStackTraceHashCode(locations, nrOfFrames);
            int bucket = hash & this.stackMask;
            int newNext = this.stackBuckets.get(bucket);
            this.stackNext.set(i, newNext);
            this.stackBuckets.set(bucket, i);
            lastIndex = i++;
        }
    }

    private void saveIdToIndexMapping() {
        byte[] buffer = new byte[65536];
        int off = 0;
        try {
            if (this.idBackupFile == null) {
                ResourceManager resourceManager = this.session.getResourceManager();
                this.idBackupFile = resourceManager == null ? this.getStackTraceIdFile() : resourceManager.getStackTraceIdFile();
            }
            this.idBackupFile.seek((long)this.idToIndexOffset * 4L);
            for (int i = 0; i < 262144; ++i) {
                int val = this.idToIndex[i + this.idToIndexOffset & 0xFFFFF];
                buffer[off] = (byte)(val >>> 24 & 0xFF);
                buffer[off + 1] = (byte)(val >>> 16 & 0xFF);
                buffer[off + 2] = (byte)(val >>> 8 & 0xFF);
                buffer[off + 3] = (byte)(val >>> 0 & 0xFF);
                if ((off += 4) + 4 <= buffer.length) continue;
                this.idBackupFile.write(buffer, 0, off);
                off = 0;
            }
            this.idBackupFile.write(buffer, 0, off);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not dump ids to file", e);
        }
        this.idToIndexSavePoint += 262144;
    }

    private int getStackTraceHashCode(int[] locations, int length) {
        int result = 0;
        for (int i = 0; i < length; ++i) {
            result = result * 31 + locations[i];
        }
        return result;
    }

    private boolean equals(int index, int[] locations, int nrOfFrames) {
        if (this.getNrOfFrames(index) != nrOfFrames) {
            return false;
        }
        int[] otherLocations = new int[10];
        int currStackIndex = index;
        int type = this.getType(currStackIndex);
        int nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
        int sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        int frameTop = nonSharedFrames + sharedFrames;
        while (true) {
            int toCopy;
            if ((toCopy = frameTop - sharedFrames) > 0) {
                if (otherLocations.length < toCopy) {
                    otherLocations = new int[toCopy];
                }
                this.copyNonSharedLocations(currStackIndex, type, otherLocations, 0, toCopy);
                frameTop -= toCopy;
                for (int i = 0; i < toCopy; ++i) {
                    if (otherLocations[i] == locations[i + frameTop]) continue;
                    return false;
                }
            }
            if (frameTop == 0) {
                return true;
            }
            assert (frameTop > 0);
            currStackIndex = this.getSharedStackTrace(currStackIndex, type);
            type = this.getType(currStackIndex);
            nonSharedFrames = this.getNrOfNonSharedFrames(currStackIndex, type);
            sharedFrames = this.getNrOfSharedFrames(currStackIndex, type);
        }
    }

    private int getType(int index) {
        return (int)this.stacks.get(index) & 7;
    }

    private void copyNonSharedLocations(int index, int type, int[] locations, int off, int len) {
        assert (this.getNrOfNonSharedFrames(index, type) >= len);
        assert (off + len <= locations.length);
        if (len < 1) {
            return;
        }
        switch (type) {
            case 0: {
                this.oneFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 1: {
                this.twoFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 2: {
                this.threeFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 3: {
                this.fourFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 4: {
                this.fiveFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 5: {
                this.sixFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 6: {
                this.nFrameCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            case 7: {
                this.bigStackCopyNonSharedLocations(index, locations, off, len);
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    private int getSharedStackTrace(int index, int type) {
        assert (type == this.getType(index));
        switch (type) {
            case 0: {
                return this.oneFrameGetSharedStackTrace(index);
            }
            case 1: {
                return this.twoFrameGetSharedStackTrace(index);
            }
            case 2: {
                return this.threeFrameGetSharedStackTrace(index);
            }
            case 3: {
                return this.fourFrameGetSharedStackTrace(index);
            }
            case 4: {
                return this.fiveFrameGetSharedStackTrace(index);
            }
            case 5: {
                return this.sixFrameGetSharedStackTrace(index);
            }
            case 6: {
                return this.nFrameGetSharedStackTrace(index);
            }
            case 7: {
                return this.bigStackGetSharedStackTrace(index);
            }
        }
        assert (false);
        return 0;
    }

    private int getNrOfSharedFrames(int index, int type) {
        assert (this.getType(index) == type);
        switch (type) {
            case 0: {
                return this.oneFrameGetNrOfSharedFrames(index);
            }
            case 1: {
                return this.twoFrameGetNrOfSharedFrames(index);
            }
            case 2: {
                return this.threeFrameGetNrOfSharedFrames(index);
            }
            case 3: {
                return this.fourFrameGetNrOfSharedFrames(index);
            }
            case 4: {
                return this.fiveFrameGetNrOfSharedFrames(index);
            }
            case 5: {
                return this.sixFrameGetNrOfSharedFrames(index);
            }
            case 6: {
                return this.nFrameGetNrOfSharedFrames(index);
            }
            case 7: {
                return this.bigStackGetNrOfSharedFrames(index);
            }
        }
        assert (false);
        return 0;
    }

    private int getNrOfNonSharedFrames(int index, int type) {
        assert (this.getType(index) == type);
        if (type <= 5) {
            return type + 1;
        }
        switch (type) {
            case 6: {
                return this.nFrameGetNrOfNonSharedFrames(index);
            }
            case 7: {
                return this.bigStackGetNrOfNonSharedFrames(index);
            }
        }
        assert (false);
        return 0;
    }

    @Override
    public int getMaxLocationIndex() {
        return this.nextLocationIndex - 1;
    }

    @Override
    public int getMaxStackIndex() {
        return this.nextStackIndex - 1;
    }

    @Override
    public int getNrOfStackTraces() {
        return this.nextStackIndex;
    }

    public int getNrOfFrames(int index) {
        return this.getNrOfFrames(index, this.getType(index));
    }

    private int getNrOfFrames(int index, int type) {
        return this.getNrOfSharedFrames(index, type) + this.getNrOfNonSharedFrames(index, type);
    }

    private void oneFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 1);
        if (BitUtil.usesMoreBits(nonSharedFrames[0], 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.stacks.set(this.nextStackIndex, 0L | (long)nrOfSharedFrames << 4 | (long)sharedTraceIndex << 14 | (long)nonSharedFrames[0] << 40);
        ++this.nrOfOneFrames;
    }

    private int oneFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 0);
        return (int)(this.stacks.get(index) >>> 4 & 0x3FFL);
    }

    private int oneFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 0);
        return (int)(this.stacks.get(index) >>> 14 & 0x3FFFFFFL);
    }

    private void oneFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 0);
        assert (len == 1);
        locations[off] = (int)(this.stacks.get(index) >>> 40 & 0xFFFFFFL);
    }

    private void twoFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 2);
        int pairIndex = this.pairAddToHashSet(nonSharedFrames[0], nonSharedFrames[1]);
        if (BitUtil.usesMoreBits(pairIndex, 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.stacks.set(this.nextStackIndex, 1L | (long)nrOfSharedFrames << 4 | (long)sharedTraceIndex << 14 | (long)pairIndex << 40);
        ++this.nrOfTwoFrames;
    }

    private int twoFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 1);
        return (int)(this.stacks.get(index) >>> 4 & 0x3FFL);
    }

    private int twoFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 1);
        return (int)(this.stacks.get(index) >>> 14 & 0x3FFFFFFL);
    }

    private void twoFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 1);
        assert (len == 1 || len == 2);
        int pairIndex = (int)(this.stacks.get(index) >>> 40 & 0xFFFFFFL);
        locations[off] = this.pairGetFirstLocation(pairIndex);
        if (len == 2) {
            locations[off + 1] = this.pairGetSecondLocation(pairIndex);
        }
    }

    private void threeFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 3);
        int pairIndex = this.pairAddToHashSet(nonSharedFrames[0], nonSharedFrames[1]);
        int tripleIndex = this.tripleAddToHashSet(pairIndex, nonSharedFrames[2]);
        if (BitUtil.usesMoreBits(tripleIndex, 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.stacks.set(this.nextStackIndex, 2L | (long)nrOfSharedFrames << 4 | (long)sharedTraceIndex << 14 | (long)tripleIndex << 40);
        ++this.nrOfThreeFrames;
    }

    private int threeFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 2);
        return (int)(this.stacks.get(index) >>> 4 & 0x3FFL);
    }

    private int threeFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 2);
        return (int)(this.stacks.get(index) >>> 14 & 0x3FFFFFFL);
    }

    private void threeFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 2);
        assert (len >= 1 && len <= 3);
        int tripleIndex = (int)(this.stacks.get(index) >>> 40 & 0xFFFFFFL);
        int pairIndex = this.tripleGetPairIndex(tripleIndex);
        locations[off] = this.pairGetFirstLocation(pairIndex);
        if (len >= 2) {
            locations[off + 1] = this.pairGetSecondLocation(pairIndex);
            if (len == 3) {
                locations[off + 2] = this.tripleGetLocationIndex(tripleIndex);
            }
        }
    }

    private void fourFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 4);
        int pairIndex1 = this.pairAddToHashSet(nonSharedFrames[0], nonSharedFrames[1]);
        int pairIndex2 = this.pairAddToHashSet(nonSharedFrames[2], nonSharedFrames[3]);
        if (BitUtil.usesMoreBits(pairIndex1, 24) || BitUtil.usesMoreBits(pairIndex2, 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.fourFramesLoc.resize(this.nextFourFrameIndex + 1);
        this.fourFramesNrShared.resize(this.nextFourFrameIndex + 1);
        this.stacks.set(this.nextStackIndex, 3L | (long)this.nextFourFrameIndex << 4 | (long)(nrOfSharedFrames & 3) << 35 | (long)sharedTraceIndex << 37);
        this.fourFramesLoc.set(this.nextFourFrameIndex, (long)pairIndex1, 0, 24);
        this.fourFramesLoc.set(this.nextFourFrameIndex, (long)pairIndex2, 24, 24);
        this.fourFramesNrShared.set(this.nextFourFrameIndex, nrOfSharedFrames >> 2);
        ++this.nextFourFrameIndex;
        ++this.nrOfFourFrames;
    }

    private int fourFrameGetIndexForArray(int index) {
        assert (this.getType(index) == 3);
        return (int)(this.stacks.get(index) >>> 4 & Integer.MAX_VALUE);
    }

    private int fourFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 3);
        int arrayIndex = this.fourFrameGetIndexForArray(index);
        return this.fourFramesNrShared.get(arrayIndex) << 2 | (int)(this.stacks.get(index) >>> 35 & 3L);
    }

    private int fourFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 3);
        return (int)(this.stacks.get(index) >>> 37 & 0x3FFFFFFL);
    }

    private void fourFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 3);
        assert (len >= 1 && len <= 4);
        int arrayIndex = this.fourFrameGetIndexForArray(index);
        int pairIndex1 = (int)this.fourFramesLoc.get(arrayIndex, 0, 24);
        locations[off] = this.pairGetFirstLocation(pairIndex1);
        if (len >= 2) {
            locations[off + 1] = this.pairGetSecondLocation(pairIndex1);
            if (len >= 3) {
                int pairIndex2 = (int)this.fourFramesLoc.get(arrayIndex, 24, 24);
                locations[off + 2] = this.pairGetFirstLocation(pairIndex2);
                if (len >= 4) {
                    locations[off + 3] = this.pairGetSecondLocation(pairIndex2);
                }
            }
        }
    }

    private void fiveFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 5);
        int pairIndex1 = this.pairAddToHashSet(nonSharedFrames[0], nonSharedFrames[1]);
        int pairIndex2 = this.pairAddToHashSet(nonSharedFrames[2], nonSharedFrames[3]);
        int tripleIndex = this.tripleAddToHashSet(pairIndex2, nonSharedFrames[4]);
        if (BitUtil.usesMoreBits(pairIndex1, 24) || BitUtil.usesMoreBits(tripleIndex, 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.fiveFramesLoc.resize(this.nextFiveFrameIndex + 1);
        this.fiveFramesNrShared.resize(this.nextFiveFrameIndex + 1);
        this.stacks.set(this.nextStackIndex, 4L | (long)this.nextFiveFrameIndex << 4 | (long)(nrOfSharedFrames & 3) << 35 | (long)sharedTraceIndex << 37);
        this.fiveFramesLoc.set(this.nextFiveFrameIndex, (long)pairIndex1, 0, 24);
        this.fiveFramesLoc.set(this.nextFiveFrameIndex, (long)tripleIndex, 24, 24);
        this.fiveFramesNrShared.set(this.nextFiveFrameIndex, nrOfSharedFrames >> 2);
        ++this.nextFiveFrameIndex;
        ++this.nrOfFiveFrames;
    }

    private int fiveFrameGetIndexForArray(int index) {
        assert (this.getType(index) == 4);
        return (int)(this.stacks.get(index) >>> 4 & Integer.MAX_VALUE);
    }

    private int fiveFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 4);
        int arrayIndex = this.fiveFrameGetIndexForArray(index);
        return this.fiveFramesNrShared.get(arrayIndex) << 2 | (int)(this.stacks.get(index) >>> 35 & 3L);
    }

    private int fiveFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 4);
        return (int)(this.stacks.get(index) >>> 37 & 0x3FFFFFFL);
    }

    private void fiveFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 4);
        assert (len >= 1 && len <= 5);
        int arrayIndex = this.fiveFrameGetIndexForArray(index);
        int pairIndex1 = (int)this.fiveFramesLoc.get(arrayIndex, 0, 24);
        locations[off] = this.pairGetFirstLocation(pairIndex1);
        if (len >= 2) {
            locations[off + 1] = this.pairGetSecondLocation(pairIndex1);
            if (len >= 3) {
                int tripleIndex1 = (int)this.fiveFramesLoc.get(arrayIndex, 24, 24);
                int pairIndex2 = this.tripleGetPairIndex(tripleIndex1);
                locations[off + 2] = this.pairGetFirstLocation(pairIndex2);
                if (len >= 4) {
                    locations[off + 3] = this.pairGetSecondLocation(pairIndex2);
                    if (len >= 5) {
                        locations[off + 4] = this.tripleGetLocationIndex(tripleIndex1);
                    }
                }
            }
        }
    }

    private void sixFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        assert (nonSharedFrames.length == 6);
        int pairIndex1 = this.pairAddToHashSet(nonSharedFrames[0], nonSharedFrames[1]);
        int tripleIndex1 = this.tripleAddToHashSet(pairIndex1, nonSharedFrames[2]);
        int pairIndex2 = this.pairAddToHashSet(nonSharedFrames[3], nonSharedFrames[4]);
        int tripleIndex2 = this.tripleAddToHashSet(pairIndex2, nonSharedFrames[5]);
        if (BitUtil.usesMoreBits(tripleIndex1, 24) || BitUtil.usesMoreBits(tripleIndex2, 24)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.sixFramesLoc.resize(this.nextSixFrameIndex + 1);
        this.sixFramesNrShared.resize(this.nextSixFrameIndex + 1);
        this.stacks.set(this.nextStackIndex, 5L | (long)this.nextSixFrameIndex << 4 | (long)(nrOfSharedFrames & 3) << 35 | (long)sharedTraceIndex << 37);
        this.sixFramesLoc.set(this.nextSixFrameIndex, (long)tripleIndex1, 0, 24);
        this.sixFramesLoc.set(this.nextSixFrameIndex, (long)tripleIndex2, 24, 24);
        this.sixFramesNrShared.set(this.nextSixFrameIndex, nrOfSharedFrames >> 2);
        ++this.nextSixFrameIndex;
        ++this.nrOfSixFrames;
    }

    private int sixFrameGetIndexForArray(int index) {
        assert (this.getType(index) == 5);
        return (int)(this.stacks.get(index) >>> 4 & Integer.MAX_VALUE);
    }

    private int sixFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 5);
        int arrayIndex = this.sixFrameGetIndexForArray(index);
        return this.sixFramesNrShared.get(arrayIndex) << 2 | (int)(this.stacks.get(index) >>> 35 & 3L);
    }

    private int sixFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 5);
        return (int)(this.stacks.get(index) >>> 37 & 0x3FFFFFFL);
    }

    private void sixFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 5);
        assert (len >= 1 && len <= 6);
        int arrayIndex = this.sixFrameGetIndexForArray(index);
        int tripleIndex1 = (int)this.sixFramesLoc.get(arrayIndex, 0, 24);
        int pairIndex1 = this.tripleGetPairIndex(tripleIndex1);
        locations[off] = this.pairGetFirstLocation(pairIndex1);
        if (len >= 2) {
            locations[off + 1] = this.pairGetSecondLocation(pairIndex1);
            if (len >= 3) {
                locations[off + 2] = this.tripleGetLocationIndex(tripleIndex1);
                if (len >= 4) {
                    int tripleIndex2 = (int)this.sixFramesLoc.get(arrayIndex, 24, 24);
                    int pairIndex2 = this.tripleGetPairIndex(tripleIndex2);
                    locations[off + 3] = this.pairGetFirstLocation(pairIndex2);
                    if (len >= 5) {
                        locations[off + 4] = this.pairGetSecondLocation(pairIndex2);
                        if (len >= 6) {
                            locations[off + 5] = this.tripleGetLocationIndex(tripleIndex2);
                        }
                    }
                }
            }
        }
    }

    private void nFrameAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        for (int i = 0; i < nonSharedFrames.length; ++i) {
            if (!BitUtil.usesMoreBits(nonSharedFrames[i], 24)) continue;
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        if (BitUtil.usesMoreBits(nrOfSharedFrames, 12) || BitUtil.usesMoreBits(nonSharedFrames.length, 14)) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        int nextIndex = this.nextNFrameIndex + nonSharedFrames.length + 1;
        if (nextIndex > Integer.MAX_VALUE || nextIndex < 0) {
            this.bigStackAddStackTrace(sharedTraceIndex, nrOfSharedFrames, nonSharedFrames);
            return;
        }
        this.nFrames.resize(nextIndex);
        this.stacks.set(this.nextStackIndex, 6L | (long)this.nextNFrameIndex << 4 | (long)(nrOfSharedFrames & 3) << 35 | (long)sharedTraceIndex << 37);
        this.nFrames.set(this.nextNFrameIndex, nrOfSharedFrames >>> 2 | nonSharedFrames.length << 10);
        for (int i = 0; i < nonSharedFrames.length; ++i) {
            this.nFrames.set(this.nextNFrameIndex + i + 1, nonSharedFrames[i]);
        }
        this.nextNFrameIndex += nonSharedFrames.length + 1;
        ++this.nrOfNFrames;
    }

    private int nFrameGetIndexForArray(int index) {
        assert (this.getType(index) == 6);
        return (int)(this.stacks.get(index) >> 4 & Integer.MAX_VALUE);
    }

    private int nFrameGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 6);
        int arrayIndex = this.nFrameGetIndexForArray(index);
        return (int)(this.stacks.get(index) >>> 35 & 3L | (long)(this.nFrames.get(arrayIndex, 0, 10) << 2));
    }

    private int nFrameGetNrOfNonSharedFrames(int index) {
        int arrayIndex = this.nFrameGetIndexForArray(index);
        return this.nFrames.get(arrayIndex, 10, 14);
    }

    private int nFrameGetSharedStackTrace(int index) {
        assert (this.getType(index) == 6);
        return (int)(this.stacks.get(index) >>> 37);
    }

    private void nFrameCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 6);
        int arrayIndex = this.nFrameGetIndexForArray(index);
        for (int i = 0; i < len; ++i) {
            locations[off + i] = this.nFrames.get(arrayIndex + i + 1);
        }
    }

    private void bigStackAddStackTrace(int sharedTraceIndex, int nrOfSharedFrames, int[] nonSharedFrames) {
        this.bigFrames.resize(this.nextBigFrameIndex + 3L + (long)nonSharedFrames.length);
        this.stacks.set(this.nextStackIndex, 7L | this.nextBigFrameIndex << 4);
        this.bigFrames.set(this.nextBigFrameIndex, sharedTraceIndex);
        this.bigFrames.set(this.nextBigFrameIndex + 1L, nrOfSharedFrames);
        this.bigFrames.set(this.nextBigFrameIndex + 2L, nonSharedFrames.length);
        for (int i = 0; i < nonSharedFrames.length; ++i) {
            this.bigFrames.set(this.nextBigFrameIndex + (long)i + 3L, nonSharedFrames[i]);
        }
        this.nextBigFrameIndex += (long)(nonSharedFrames.length + 3);
        ++this.nrOfBigFrames;
    }

    private long bigStackGetIndexForArray(int index) {
        assert (this.getType(index) == 7);
        return this.stacks.get(index) >>> 4;
    }

    private int bigStackGetNrOfSharedFrames(int index) {
        assert (this.getType(index) == 7);
        long arrayIndex = this.bigStackGetIndexForArray(index);
        return this.bigFrames.get(arrayIndex + 1L);
    }

    private int bigStackGetNrOfNonSharedFrames(int index) {
        assert (this.getType(index) == 7);
        long arrayIndex = this.bigStackGetIndexForArray(index);
        return this.bigFrames.get(arrayIndex + 2L);
    }

    private int bigStackGetSharedStackTrace(int index) {
        assert (this.getType(index) == 7);
        long arrayIndex = this.bigStackGetIndexForArray(index);
        return this.bigFrames.get(arrayIndex);
    }

    private void bigStackCopyNonSharedLocations(int index, int[] locations, int off, int len) {
        assert (this.getType(index) == 7);
        long arrayIndex = this.bigStackGetIndexForArray(index);
        for (int i = 0; i < len; ++i) {
            locations[off + i] = this.bigFrames.get(arrayIndex + (long)i + 3L);
        }
    }

    public void notifyStackTracesFinished() {
        this.stackNext = null;
        this.stackBuckets = null;
        this.idToIndex = null;
        ResourceManager resourceManager = this.session.getResourceManager();
        if (resourceManager == null) {
            this.removeStackTraceIdFile();
        } else {
            resourceManager.removeStackTraceIdFile();
        }
        this.locationNext = null;
        this.locationBuckets = null;
        this.pairNext = null;
        this.pairBuckets = null;
        this.tripleNext = null;
        this.tripleBuckets = null;
    }

    public void write(PacketResourceWriter writer, ProgressReporter reporter) throws IOException {
        int i;
        writer.initializePacket((short)411);
        writer.writeInt32(this.nextLocationIndex - 1);
        for (i = 1; i < this.nextLocationIndex; ++i) {
            MethodLocationImpl location = this.locationGetMethodLocation(i);
            writer.writeInt32(location.getMethod().getIndex());
            writer.writeInt16((short)location.getLineNumber());
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
        writer.finalizePacket();
        for (i = 0; i <= this.getMaxStackIndex(); ++i) {
            int nrOfNonSharedFrames;
            writer.initializePacket((short)409);
            writer.writeInt32(i);
            int type = this.getType(i);
            int nrOfFrames = this.getNrOfFrames(i, type);
            writer.writeInt32(nrOfFrames);
            int nrOfSharedFrames = this.getNrOfSharedFrames(i, type);
            writer.writeInt32(nrOfSharedFrames);
            if (nrOfSharedFrames > 0) {
                writer.writeInt32(this.getSharedStackTrace(i, type));
            }
            if ((nrOfNonSharedFrames = nrOfFrames - nrOfSharedFrames) > 0) {
                int[] locations = new int[nrOfNonSharedFrames];
                this.copyNonSharedLocations(i, type, locations, 0, nrOfNonSharedFrames);
                for (int j = locations.length - 1; j >= 0; --j) {
                    writer.writeInt32(locations[j]);
                }
            }
            writer.finalizePacket();
            if (reporter == null || reporter.reportNext()) continue;
            return;
        }
    }

    private RandomAccessFile getStackTraceIdFile() {
        try {
            this.idTempFile = File.createTempFile(STACK_TRACE_ID_2_INDEX_FILENAME_PREFIX, STACK_TRACE_ID_2_INDEX_FILENAME_SUFFIX);
            this.idTempFile.deleteOnExit();
            return new RandomAccessFile(this.idTempFile.getAbsolutePath(), "rw");
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, "Cannot create the stack trace id2index file.");
            throw new RuntimeException("Cannot create the stack trace id2index file");
        }
    }

    private void removeStackTraceIdFile() {
        if (this.idBackupFile != null) {
            try {
                this.idBackupFile.close();
            }
            catch (IOException ex) {
                Trace.warn((Throwable)ex, "Error during closing stack trace id2index file.");
            }
        }
        if (this.idTempFile != null) {
            this.idTempFile.delete();
        }
    }

    private MethodLocationImpl locationGetMethodLocation(int index) {
        return this.locationMethodLocations.get(index);
    }

    private int locationGetFromHashSet(int methodIndex, int lineNr) {
        int hash = this.locationGetHash(methodIndex, lineNr);
        int index = this.locationBuckets.get(hash);
        while (index != 0) {
            MethodLocationImpl location = this.locationGetMethodLocation(index);
            if (location.getMethod().getIndex() == methodIndex && location.getLineNumber() == lineNr) {
                return index;
            }
            index = this.locationNext.get(index);
        }
        return index;
    }

    public int locationAddToHashSet(int methodIndex, int lineNr) {
        assert (!BitUtil.usesMoreBits(methodIndex, 24));
        assert (!BitUtil.usesMoreBits(lineNr, 16));
        int index = this.locationGetFromHashSet(methodIndex, lineNr);
        if (index != 0) {
            return index;
        }
        MethodLocationImpl baseLocation = null;
        if (lineNr > 0) {
            int noLineNrLoc = this.locationAddToHashSet(methodIndex, 0);
            assert (noLineNrLoc > 0);
            baseLocation = this.locationGetMethodLocation(noLineNrLoc);
        }
        if (this.locationResizeLimit < this.nextLocationIndex) {
            this.locationDoubleHashSet();
            assert (this.locationResizeLimit > this.nextLocationIndex);
        }
        this.locationNext.resize(this.nextLocationIndex + 1);
        this.locationMethodLocations.resize(this.nextLocationIndex + 1);
        int hash = this.locationGetHash(methodIndex, lineNr);
        int next = this.locationBuckets.get(hash);
        if (lineNr > 0) {
            MethodLocationImpl newLoc = new MethodLocationImpl(baseLocation, lineNr, this.nextLocationIndex);
            this.locationMethodLocations.set(this.nextLocationIndex, newLoc);
        } else {
            MethodLocationImpl newLoc = new MethodLocationImpl(this.methodManager.getMethodObject(methodIndex), this.nextLocationIndex);
            this.locationMethodLocations.set(this.nextLocationIndex, newLoc);
        }
        this.locationNext.set(this.nextLocationIndex, next);
        this.locationBuckets.set(hash, this.nextLocationIndex);
        return this.nextLocationIndex++;
    }

    private void locationDoubleHashSet() {
        int nrOfBuckets = (int)this.locationBuckets.size() * 2;
        this.locationBuckets.resizeAndClear(nrOfBuckets);
        this.locationResizeLimit = (int)((double)nrOfBuckets * 5.0);
        this.locationMask = nrOfBuckets - 1;
        for (int i = 1; i < this.nextLocationIndex; ++i) {
            int hash = this.locationGetHash(i);
            int newNext = this.locationBuckets.get(hash);
            this.locationNext.set(i, newNext);
            this.locationBuckets.set(hash, i);
        }
    }

    private int locationGetHash(int methodIndex, int lineNr) {
        assert (lineNr >= 0 && lineNr <= 65535);
        return (methodIndex ^ lineNr) & this.locationMask;
    }

    private int locationGetHash(int index) {
        MethodLocationImpl location = this.locationMethodLocations.get(index);
        int methodIndex = location.getMethod().getIndex();
        int lineNr = location.getLineNumber();
        return this.locationGetHash(methodIndex, lineNr);
    }

    private int pairGetFirstLocation(int index) {
        return this.pairFirst.get(index);
    }

    private int pairGetSecondLocation(int index) {
        return this.pairSecond.get(index);
    }

    private int pairGetFromHashSet(int first, int second) {
        int hash = this.pairGetHash(first, second);
        int index = this.pairBuckets.get(hash);
        while (index != 0) {
            if (this.pairGetFirstLocation(index) == first && this.pairGetSecondLocation(index) == second) {
                return index;
            }
            index = this.pairNext.get(index);
        }
        return index;
    }

    private int pairAddToHashSet(int first, int second) {
        assert (!BitUtil.usesMoreBits(first, 24));
        assert (!BitUtil.usesMoreBits(second, 24));
        int index = this.pairGetFromHashSet(first, second);
        if (index != 0) {
            return index;
        }
        if (BitUtil.usesMoreBits(this.nextPairIndex, 24)) {
            return Integer.MAX_VALUE;
        }
        if (this.pairResizeLimit < this.nextPairIndex) {
            this.pairDoubleHashSet();
            assert (this.pairResizeLimit > this.nextPairIndex);
        }
        this.pairNext.resize(this.nextPairIndex + 1);
        this.pairFirst.resize(this.nextPairIndex + 1);
        this.pairSecond.resize(this.nextPairIndex + 1);
        int hash = this.pairGetHash(first, second);
        int next = this.pairBuckets.get(hash);
        this.pairNext.set(this.nextPairIndex, next);
        this.pairFirst.set(this.nextPairIndex, first);
        this.pairSecond.set(this.nextPairIndex, second);
        this.pairBuckets.set(hash, this.nextPairIndex);
        return this.nextPairIndex++;
    }

    private void pairDoubleHashSet() {
        int nrOfBuckets = (int)this.pairBuckets.size() * 2;
        this.pairBuckets.resizeAndClear(nrOfBuckets);
        this.pairResizeLimit = (int)((double)nrOfBuckets * 5.0);
        this.pairMask = nrOfBuckets - 1;
        for (int i = 0; i < this.nextPairIndex; ++i) {
            int hash = this.pairGetHash(i);
            int newNext = this.pairBuckets.get(hash);
            this.pairNext.set(i, newNext);
            this.pairBuckets.set(hash, i);
        }
    }

    private int pairGetHash(int first, int second) {
        return (first ^ 31 * second) & this.pairMask;
    }

    private int pairGetHash(int index) {
        int index1 = this.pairFirst.get(index);
        int index2 = this.pairSecond.get(index);
        return this.pairGetHash(index1, index2);
    }

    private int tripleGetPairIndex(int index) {
        return this.tripleFirst.get(index);
    }

    private int tripleGetLocationIndex(int index) {
        return this.tripleThird.get(index);
    }

    private int tripleGetFromHashSet(int first, int third) {
        int hash = this.tripleGetHash(first, third);
        int index = this.tripleBuckets.get(hash);
        while (index != 0) {
            if (this.tripleGetPairIndex(index) == first && this.tripleGetLocationIndex(index) == third) {
                return index;
            }
            index = this.tripleNext.get(index);
        }
        return index;
    }

    private int tripleAddToHashSet(int first, int third) {
        assert (!BitUtil.usesMoreBits(first, 24));
        assert (!BitUtil.usesMoreBits(third, 24));
        int index = this.tripleGetFromHashSet(first, third);
        if (index != 0) {
            return index;
        }
        if (BitUtil.usesMoreBits(this.nextPairIndex, 24)) {
            return Integer.MAX_VALUE;
        }
        if (this.tripleResizeLimit < this.nextTripleIndex) {
            this.tripleDoubleHashSet();
            assert (this.tripleResizeLimit > this.nextTripleIndex);
        }
        this.tripleNext.resize(this.nextTripleIndex + 1);
        this.tripleFirst.resize(this.nextTripleIndex + 1);
        this.tripleThird.resize(this.nextTripleIndex + 1);
        int hash = this.tripleGetHash(first, third);
        int next = this.tripleBuckets.get(hash);
        this.tripleNext.set(this.nextTripleIndex, next);
        this.tripleFirst.set(this.nextTripleIndex, first);
        this.tripleThird.set(this.nextTripleIndex, third);
        this.tripleBuckets.set(hash, this.nextTripleIndex);
        return this.nextTripleIndex++;
    }

    private void tripleDoubleHashSet() {
        int nrOfBuckets = (int)this.tripleBuckets.size() * 2;
        this.tripleBuckets.resizeAndClear(nrOfBuckets);
        this.tripleResizeLimit = (int)((double)nrOfBuckets * 5.0);
        this.tripleMask = nrOfBuckets - 1;
        for (int i = 0; i < this.nextTripleIndex; ++i) {
            int hash = this.tripleGetHash(i);
            int newNext = this.tripleBuckets.get(hash);
            this.tripleNext.set(i, newNext);
            this.tripleBuckets.set(hash, i);
        }
    }

    private int tripleGetHash(int first, int third) {
        return (first ^ third) & this.tripleMask;
    }

    private int tripleGetHash(int index) {
        int index1 = this.tripleFirst.get(index);
        int index2 = this.tripleThird.get(index);
        return this.tripleGetHash(index1, index2);
    }

    @Override
    public synchronized int getAverageStackHeight() {
        long sum = 0L;
        for (int i = 0; i < this.nextStackIndex; ++i) {
            sum += (long)this.getNrOfFrames(i);
        }
        return (int)(sum / (long)this.nextStackIndex);
    }

    @Override
    public synchronized double getAverageUnsharedFrames() {
        long sum = 0L;
        for (int i = 0; i < this.nextStackIndex; ++i) {
            sum += (long)this.getNrOfNonSharedFrames(i, this.getType(i));
        }
        return (double)(sum * 100L / (long)this.nextStackIndex) * 0.01;
    }

    @Override
    public synchronized int getMaxStackHeight() {
        int max = 0;
        for (int i = 0; i < this.nextStackIndex; ++i) {
            max = Math.max(max, this.getNrOfFrames(i));
        }
        return max;
    }

    @Override
    public int getNrOfBigStackTraces() {
        return this.nrOfBigFrames;
    }

    @Override
    public int getNrOfFiveFrameStackTraces() {
        return this.nrOfFiveFrames;
    }

    @Override
    public int getNrOfFourFrameStackTraces() {
        return this.nrOfFourFrames;
    }

    @Override
    public int getNrOfNFrameStackTraces() {
        return this.nrOfNFrames;
    }

    @Override
    public int getNrOfOneFrameStackTraces() {
        return this.nrOfOneFrames;
    }

    @Override
    public int getNrOfSixFrameStackTraces() {
        return this.nrOfSixFrames;
    }

    @Override
    public int getNrOfThreeFrameStackTraces() {
        return this.nrOfThreeFrames;
    }

    @Override
    public int getNrOfTwoFrameStackTraces() {
        return this.nrOfTwoFrames;
    }

    @Override
    public int getNrOfLocationPairs() {
        return this.nextPairIndex;
    }

    @Override
    public int getNrOfLocationTriples() {
        return this.nextTripleIndex;
    }

    @Override
    public int getNrOfLocations() {
        return this.nextLocationIndex;
    }
}

