/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.core.type;

import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.util.misc.UTF8Util;
import java.util.Arrays;

public class UTF8StringImpl
implements UTF8String {
    protected final byte[] string;
    protected int hash;

    public UTF8StringImpl(byte[] string) {
        assert (string != null);
        this.string = string;
    }

    @Override
    public byte[] getBytes() {
        return this.string;
    }

    @Override
    public int length() {
        return this.string.length;
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = Arrays.hashCode(this.string);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        if (obj instanceof UTF8StringImpl) {
            UTF8StringImpl other = (UTF8StringImpl)obj;
            if (this.hash != 0 && other.hash != 0 && this.hash != other.hash) {
                return false;
            }
            return Arrays.equals(this.string, other.string);
        }
        return false;
    }

    public String toString() {
        return UTF8Util.asString(this.string);
    }

    @Override
    public int compareTo(UTF8String o) {
        UTF8StringImpl other = (UTF8StringImpl)o;
        if (this.string == other.string) {
            return 0;
        }
        return UTF8Util.compare(this.string, other.string);
    }

    @Override
    public int compareToIgnoreCase(UTF8String o) {
        UTF8StringImpl other = (UTF8StringImpl)o;
        if (this.string == other.string) {
            return 0;
        }
        return UTF8Util.compareIgnoreCase(this.string, other.string);
    }

    @Override
    public int compareForCaseInsenstiveOrder(UTF8String o) {
        UTF8StringImpl other = (UTF8StringImpl)o;
        if (this.string == other.string) {
            return 0;
        }
        int result = UTF8Util.compareIgnoreCase(this.string, other.string);
        if (result == 0) {
            result = UTF8Util.compare(this.string, other.string);
        }
        return result;
    }

    @Override
    public byte get(int index) {
        return this.string[index];
    }

    @Override
    public int indexOf(byte toSearch) {
        return this.indexOf(toSearch, 0);
    }

    @Override
    public int indexOf(byte toSearch, int startIndex) {
        for (int i = startIndex; i < this.string.length; ++i) {
            if (this.string[i] != toSearch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(byte toSearch) {
        return this.lastIndexOf(toSearch, this.string.length - 1);
    }

    @Override
    public int lastIndexOf(byte toSearch, int startIndex) {
        for (int i = startIndex; i >= 0; --i) {
            if (this.string[i] != toSearch) continue;
            return i;
        }
        return -1;
    }

    @Override
    public UTF8String substring(int start, int end) {
        byte[] newString = new byte[end - start];
        System.arraycopy(this.string, start, newString, 0, end - start);
        return new UTF8StringImpl(newString);
    }

    @Override
    public UTF8String replace(byte toReplace, byte replacement) {
        byte[] newString = new byte[this.string.length];
        for (int i = 0; i < this.string.length; ++i) {
            newString[i] = this.string[i] == toReplace ? replacement : this.string[i];
        }
        return new UTF8StringImpl(newString);
    }

    @Override
    public boolean isEmpty() {
        return this.string.length == 0;
    }

    @Override
    public boolean startsWith(UTF8String other) {
        if (other.length() > this.length()) {
            return false;
        }
        for (int i = 0; i < other.length(); ++i) {
            if (this.get(i) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean endsWith(UTF8String other) {
        if (other.length() > this.length()) {
            return false;
        }
        int offset = this.length() - other.length();
        for (int i = 0; i < other.length(); ++i) {
            if (this.get(i + offset) == other.get(i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean contains(UTF8String toSearch) {
        boolean found;
        if (toSearch.isEmpty()) {
            return true;
        }
        int len = toSearch.length();
        int start = 0;
        byte first = toSearch.get(0);
        block0: do {
            int index;
            if ((index = this.indexOf(first, start)) == -1) {
                return false;
            }
            if (len + start > this.string.length) {
                return false;
            }
            found = true;
            for (int i = 1; i < len; ++i) {
                if (this.string[i + start] == toSearch.get(i)) continue;
                ++start;
                found = false;
                continue block0;
            }
        } while (!found);
        return true;
    }

    @Override
    public boolean isNonAscii() {
        int ored = 0;
        for (byte b : this.string) {
            ored = (byte)(ored | b);
        }
        return ored < 0;
    }
}

