/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.exception.command;

import com.sap.jvm.profiling.core.command.CommandType;
import com.sap.jvm.profiling.exception.command.EnableExceptionTraceCommand;
import com.sap.jvm.profiling.exception.command.ExceptionTraceConfiguration;
import com.sap.jvm.profiling.impl.core.command.CommandImpl;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public final class EnableExceptionTraceCommandImpl
extends CommandImpl
implements EnableExceptionTraceCommand {
    private final ExceptionTraceConfiguration config;

    EnableExceptionTraceCommandImpl(ExceptionTraceConfiguration config) {
        this.config = config.copy();
    }

    @Override
    public void print(PrintStream stream) {
        stream.print("Enable exception (" + this.config + ")");
    }

    @Override
    protected void writeToStreamImpl(DataOutputStream stream) throws IOException {
        this.writeUint16(stream, 53);
        stream.writeLong(this.getId());
        stream.writeBoolean(this.config.getIncludeLineNrs());
        stream.writeBoolean(this.config.getIncludeCauses());
        stream.writeBoolean(this.config.getIncludeThrowStackTrace());
        stream.writeUTF(this.config.getExceptionClassFilter() == null ? "" : this.config.getExceptionClassFilter());
        stream.writeUTF(this.config.getExceptionStackTraceClassFilter() == null ? "" : this.config.getExceptionStackTraceClassFilter());
        stream.writeUTF(this.config.getExceptionStackTraceMethodFilter() == null ? "" : this.config.getExceptionStackTraceMethodFilter());
    }

    @Override
    public CommandType getType() {
        return CommandType.ENABLE_EXCEPTION_TRACE;
    }
}

