/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.impl.exception.event;

import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingPrintStream;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.UTF8String;
import com.sap.jvm.profiling.exception.event.ExceptionEventHandler;
import com.sap.jvm.profiling.exception.event.ExceptionThrownEvent;
import com.sap.jvm.profiling.impl.core.ProfilingPacketImpl;
import com.sap.jvm.profiling.impl.core.type.NonArrayClassObjectImpl;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;

public class ExceptionThrownEventImpl
extends ProfilingPacketImpl
implements ExceptionThrownEvent {
    private final long timeStamp;
    private final char threadIndex;
    private final NonArrayClassObjectImpl exceptionClass;
    private final int throwStackTraceIndex;
    private final int exceptionStackTraceIndex;
    private final UTF8String message;
    private final NonArrayClassObjectImpl[] causeClasses;
    private final int[] causeStackTraceIndices;
    private final UTF8String[] causeMessages;

    public static ExceptionThrownEventImpl read(ResourceReader reader, ExceptionEventHandler[] handlers) throws IOException {
        ExceptionThrownEventImpl result = new ExceptionThrownEventImpl(reader);
        for (ExceptionEventHandler handler : handlers) {
            handler.handle(result);
        }
        return result;
    }

    private ExceptionThrownEventImpl(ResourceReader reader) throws IOException {
        this.timeStamp = reader.readInt64();
        this.threadIndex = reader.readUint16();
        this.throwStackTraceIndex = reader.readStackTraceIndex();
        this.exceptionClass = (NonArrayClassObjectImpl)reader.readClassObject();
        this.message = reader.readUTF();
        this.exceptionStackTraceIndex = reader.readStackTraceIndex();
        int nrOfCauses = reader.readInt8();
        if (nrOfCauses == 0) {
            this.causeClasses = null;
            this.causeMessages = null;
            this.causeStackTraceIndices = null;
        } else {
            this.causeClasses = new NonArrayClassObjectImpl[nrOfCauses];
            this.causeMessages = new UTF8String[nrOfCauses];
            this.causeStackTraceIndices = new int[nrOfCauses];
            for (int i = 0; i < nrOfCauses; ++i) {
                this.causeClasses[i] = (NonArrayClassObjectImpl)reader.readClassObject();
                this.causeMessages[i] = reader.readUTF();
                this.causeStackTraceIndices[i] = reader.readStackTraceIndex();
            }
        }
    }

    @Override
    public ProfilingPacketType getType() {
        return ProfilingPacketType.EXCEPTION_THROWN_EVENT;
    }

    @Override
    public long getTimeStamp() {
        return this.timeStamp;
    }

    @Override
    public char getThreadIndex() {
        return this.threadIndex;
    }

    @Override
    public int getThrowStackTraceIndex() {
        return this.throwStackTraceIndex;
    }

    @Override
    public ClassObject getExceptionClass() {
        return this.exceptionClass;
    }

    @Override
    public UTF8String getExceptionMessage() {
        return this.message;
    }

    @Override
    public int getExceptionStackTraceIndex() {
        return this.exceptionStackTraceIndex;
    }

    @Override
    public int getNrOfCauses() {
        return this.causeClasses == null ? 0 : this.causeClasses.length;
    }

    @Override
    public ClassObject getCauseClass(int index) {
        return this.causeClasses[index];
    }

    @Override
    public UTF8String getCauseMessage(int index) {
        return this.causeMessages[index];
    }

    @Override
    public int getCauseStackTraceIndex(int index) {
        return this.causeStackTraceIndices[index];
    }

    @Override
    public void print(ProfilingPrintStream stream) {
        stream.printlnPacketHeader(this);
        stream.formatln("Timestamp             : %*t", this.timeStamp);
        stream.formatln("Thread                : %*T", Character.valueOf(this.threadIndex));
        stream.formatln("Exception             : %*C", this.exceptionClass);
        stream.formatln("Message               : %s", this.message.toString());
        if (this.throwStackTraceIndex == this.exceptionStackTraceIndex) {
            stream.formatln("Stack trace           : %*S", this.exceptionStackTraceIndex);
        } else {
            stream.formatln("Throw Stack trace     : %*S", this.exceptionStackTraceIndex);
            stream.formatln("Exception Stack trace : %*S", this.exceptionStackTraceIndex);
        }
        for (int i = 0; i < this.getNrOfCauses(); ++i) {
            stream.formatln("  Caused by", new Object[0]);
            stream.formatln("    Exception         : %*C", this.causeClasses[i]);
            stream.formatln("    Message           : %s", this.causeMessages[i].toString());
            stream.formatln("    Stack trace       : %*S", this.causeStackTraceIndices[i]);
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.initializePacket((short)651);
        writer.writeInt64(this.timeStamp);
        writer.writeUint16(this.threadIndex);
        writer.writeInt32(this.throwStackTraceIndex);
        writer.writeClassObject(this.exceptionClass);
        writer.writeUTF(this.message);
        writer.writeInt32(this.exceptionStackTraceIndex);
        if (this.causeClasses == null) {
            writer.writeInt8(0);
        } else {
            writer.writeInt8((byte)this.causeClasses.length);
            for (int i = 0; i < this.causeClasses.length; ++i) {
                writer.writeClassObject(this.causeClasses[i]);
                writer.writeUTF(this.causeMessages[i]);
                writer.writeInt32(this.causeStackTraceIndices[i]);
            }
        }
        writer.finalizePacket();
    }

    @Override
    public String getPacketName() {
        return "exception thrown event";
    }
}

